/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.io.CRC32OutputStream;
import htsjdk.samtools.cram.io.CramInt;
import htsjdk.samtools.cram.io.CramIntArray;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.io.LTF8;
import htsjdk.samtools.cram.structure.Container;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ContainerHeaderIO {
    ContainerHeaderIO() {
    }

    public boolean readContainerHeader(Container container, InputStream inputStream) throws IOException {
        return this.readContainerHeader(2, container, inputStream);
    }

    public boolean readContainerHeader(int major, Container container, InputStream inputStream) throws IOException {
        byte[] peek = new byte[4];
        int character = inputStream.read();
        if (character == -1) {
            return false;
        }
        peek[0] = (byte)character;
        for (int i = 1; i < peek.length; ++i) {
            character = inputStream.read();
            if (character == -1) {
                throw new RuntimeException("Incomplete or broken stream.");
            }
            peek[i] = (byte)character;
        }
        container.containerByteSize = CramInt.readInt32(peek);
        container.sequenceId = ITF8.readUnsignedITF8(inputStream);
        container.alignmentStart = ITF8.readUnsignedITF8(inputStream);
        container.alignmentSpan = ITF8.readUnsignedITF8(inputStream);
        container.nofRecords = ITF8.readUnsignedITF8(inputStream);
        container.globalRecordCounter = LTF8.readUnsignedLTF8(inputStream);
        container.bases = LTF8.readUnsignedLTF8(inputStream);
        container.blockCount = ITF8.readUnsignedITF8(inputStream);
        container.landmarks = CramIntArray.array(inputStream);
        if (major >= 3) {
            container.checksum = CramInt.readInt32(inputStream);
        }
        return true;
    }

    public int writeContainerHeader(int major, Container container, OutputStream outputStream) throws IOException {
        CRC32OutputStream crc32OutputStream = new CRC32OutputStream(outputStream);
        int length = (CramInt.writeInt32(container.containerByteSize, crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(container.sequenceId, crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(container.alignmentStart, crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(container.alignmentSpan, crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(container.nofRecords, crc32OutputStream) + 7) / 8;
        length += (LTF8.writeUnsignedLTF8(container.globalRecordCounter, crc32OutputStream) + 7) / 8;
        length += (LTF8.writeUnsignedLTF8(container.bases, crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(container.blockCount, crc32OutputStream) + 7) / 8;
        length += (CramIntArray.write(container.landmarks, crc32OutputStream) + 7) / 8;
        if (major >= 3) {
            outputStream.write(crc32OutputStream.getCrc32_LittleEndian());
            length += 4;
        }
        return length;
    }
}

