/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.SignedAsBlobJarFile;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.EnhancedJarVerifier;
import com.sun.deploy.security.JarAsBLOBVerifier;
import com.sun.deploy.security.SimpleJarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.BlackList;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.CryptoPrimitive;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import sun.misc.JavaUtilJarAccess;
import sun.misc.SharedSecrets;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.timestamp.TimestampToken;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.KeyUtil;
import sun.security.util.SignatureFileVerifier;
import sun.security.x509.AlgorithmId;

public abstract class JarVerifier {
    public static final String WEAK_ALGORITHM_CTX_KEY = "jarverifier.weak.ctx_key";
    public static final String PROPERTY_JAR_DISABLED_ALGS = "jdk.jar.disabledAlgorithms";
    protected File jarFile;
    protected File nativePath;
    protected URL jarLocation;
    protected String jarVersion;
    protected boolean hasSingleCodeSource = false;
    protected boolean hasOnlySignedEntries = false;
    protected boolean hasOnlyUnsignedEntries = true;
    protected boolean hasMissingSignedEntries = false;
    protected Manifest manifest;
    protected Map signerMapCert = new HashMap();
    protected Map codeSourceCertCache = new HashMap();
    protected int[] singleSignerIndicesCert;
    protected List signerCerts = new ArrayList();
    protected Map signerMap = new HashMap();
    protected Map codeSourceCache = new HashMap();
    protected List signersCS = new ArrayList();
    protected int[] singleSignerIndicesCS;
    private String signingInfoMessage;
    private static boolean TEST_INJECT_HAS_UNSIGNED = false;

    protected JarVerifier(URL uRL, String string, File file, File file2) {
        this.jarFile = file;
        this.nativePath = file2;
        this.jarLocation = uRL;
        this.jarVersion = string;
    }

    public URL getJarLocation() {
        return this.jarLocation;
    }

    public String getJarVersion() {
        return this.jarVersion;
    }

    public abstract void validate(DownloadDelegate var1) throws IOException, JARSigningException;

    public Manifest getManifest() {
        return this.manifest;
    }

    public Map getSignerMapCert() {
        return this.signerMapCert;
    }

    public Map getCodeSourceCertCache() {
        return this.codeSourceCertCache;
    }

    public Map getSignerMap() {
        return this.signerMap;
    }

    public Map getCodeSourceCache() {
        return this.codeSourceCache;
    }

    public List getSignerCerts() {
        return this.signerCerts;
    }

    public List getSignersCS() {
        return this.signersCS;
    }

    public int[] getSingleSignerIndicesCert() {
        return this.singleSignerIndicesCert;
    }

    public int[] getSingleSignerIndicesCS() {
        return this.singleSignerIndicesCS;
    }

    public boolean hasOnlySignedEntries() {
        if (TEST_INJECT_HAS_UNSIGNED) {
            return false;
        }
        return this.hasOnlySignedEntries;
    }

    public boolean hasSingleCodeSource() {
        return this.hasSingleCodeSource;
    }

    public boolean hasMissingSignedEntries() {
        return this.hasMissingSignedEntries;
    }

    public static JarVerifier create(URL uRL, String string, File file, File file2) {
        JarVerifier jarVerifier = JarAsBLOBVerifier.create(uRL, string, file, file2);
        if (jarVerifier == null && (jarVerifier = EnhancedJarVerifier.create(uRL, string, file, file2)) == null) {
            jarVerifier = SimpleJarVerifier.create(uRL, string, file, file2);
        }
        return jarVerifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readAndMaybeSaveStreamTo(InputStream inputStream, boolean bl, String string, File file) throws IOException {
        FilterOutputStream filterOutputStream = null;
        byte[] byArray = new byte[16384];
        try {
            int n;
            File file2;
            if (bl && file != null && (file2 = new File(file, string).getCanonicalFile()).getParentFile().equals(file)) {
                file2.getParentFile().mkdirs();
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            }
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                if (filterOutputStream == null) continue;
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
                filterOutputStream = null;
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    protected void processCertificates(JarFile jarFile, JarEntry jarEntry, String string) throws MalformedURLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Certificate[] certificateArray = null;
        if (this.hasSingleCodeSource) {
            this.signerMapCert.put(string, this.singleSignerIndicesCert);
        } else {
            Object object;
            if (jarEntry != null) {
                certificateArray = jarEntry.getCertificates();
            } else {
                object = null;
                JavaUtilJarAccess javaUtilJarAccess = SharedSecrets.javaUtilJarAccess();
                object = javaUtilJarAccess.getCodeSource(jarFile, this.jarLocation, string);
                Certificate[] certificateArray2 = certificateArray = object != null ? ((CodeSource)object).getCertificates() : null;
            }
            if (certificateArray != null && certificateArray.length > 0) {
                int n;
                object = new int[certificateArray.length];
                for (int i = 0; i < certificateArray.length; ++i) {
                    n = this.signerCerts.indexOf(certificateArray[i]);
                    if (n == -1) {
                        n = this.signerCerts.size();
                        this.signerCerts.add(certificateArray[i]);
                    }
                    object[i] = n;
                }
                String string2 = String.valueOf(((Object)object).length);
                for (n = 0; n < ((Object)object).length; ++n) {
                    string2 = string2 + " " + (int)object[n];
                }
                int[] nArray = (int[])hashMap.get(string2);
                if (nArray == null) {
                    hashMap.put(string2, object);
                    CodeSource codeSource = new CodeSource(this.jarLocation, certificateArray);
                    this.codeSourceCertCache.put(object, codeSource);
                } else {
                    object = nArray;
                }
                this.signerMapCert.put(string, object);
            }
        }
    }

    protected void processSigners(JarFile jarFile, JarEntry jarEntry, String string) throws MalformedURLException {
        if (!Config.isJavaVersionAtLeast15()) {
            return;
        }
        CodeSigner[] codeSignerArray = null;
        HashMap<String, JavaUtilJarAccess> hashMap = new HashMap<String, JavaUtilJarAccess>();
        if (this.hasSingleCodeSource) {
            this.signerMap.put(string, this.singleSignerIndicesCS);
        } else {
            Object object;
            if (jarEntry != null) {
                codeSignerArray = jarEntry.getCodeSigners();
            } else {
                object = SharedSecrets.javaUtilJarAccess();
                CodeSource codeSource = object.getCodeSource(jarFile, this.jarLocation, string);
                CodeSigner[] codeSignerArray2 = codeSignerArray = codeSource != null ? codeSource.getCodeSigners() : null;
            }
            if (codeSignerArray != null && codeSignerArray.length > 0) {
                int n;
                object = new int[codeSignerArray.length];
                for (int i = 0; i < codeSignerArray.length; ++i) {
                    n = this.signersCS.indexOf(codeSignerArray[i]);
                    if (n == -1) {
                        n = this.signersCS.size();
                        this.signersCS.add(codeSignerArray[i]);
                    }
                    object[i] = (JavaUtilJarAccess)n;
                }
                String string2 = String.valueOf(((JavaUtilJarAccess)object).length);
                for (n = 0; n < ((JavaUtilJarAccess)object).length; ++n) {
                    string2 = string2 + " " + (int)object[n];
                }
                int[] nArray = (int[])hashMap.get(string2);
                if (nArray == null) {
                    hashMap.put(string2, (JavaUtilJarAccess)object);
                    CodeSource codeSource = new CodeSource(this.jarLocation, codeSignerArray);
                    this.codeSourceCache.put(object, codeSource);
                } else {
                    object = nArray;
                }
                this.signerMap.put(string, object);
            }
        }
    }

    protected void authenticateJarEntry(JarFile jarFile, JarEntry jarEntry) throws IOException, JARSigningException {
        if (jarEntry == null) {
            return;
        }
        String string = jarEntry.getName();
        boolean bl = this.nativePath != null && string.indexOf("/") == -1 && string.indexOf("\\") == -1;
        try {
            JarVerifier.readAndMaybeSaveStreamTo(jarFile.getInputStream(jarEntry), bl, string, this.nativePath);
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(this.jarLocation, this.jarVersion, 2, securityException);
        }
    }

    public static JarFile getValidatedJarFile(File file, URL uRL, URL uRL2, String string, DownloadDelegate downloadDelegate) throws IOException {
        boolean bl = false;
        JarVerifier jarVerifier = JarVerifier.create(uRL2, string, file, null);
        JarFile jarFile = new JarFile(file);
        if (downloadDelegate != null) {
            downloadDelegate.validating(uRL, 0, jarFile.size());
        }
        try {
            jarVerifier.validate(downloadDelegate);
            if (jarVerifier instanceof JarAsBLOBVerifier) {
                jarFile = new SignedAsBlobJarFile(file, (JarAsBLOBVerifier)jarVerifier);
            }
            if (BlackList.getInstance().checkJarFile(jarFile)) {
                JarFile jarFile2 = null;
                return jarFile2;
            }
            bl = true;
        }
        catch (ZipException zipException) {
            throw new JARSigningException(uRL, string, 2, zipException);
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(uRL, string, 2, securityException);
        }
        finally {
            if (!bl) {
                jarFile.close();
            }
        }
        return bl ? jarFile : null;
    }

    protected void warnIfUnsigned() {
        try {
            if (this.signersCS.isEmpty() && this.isJarWeaklySigned()) {
                String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return Security.getProperty(JarVerifier.PROPERTY_JAR_DISABLED_ALGS);
                    }
                });
                String string2 = "jdk.jar.disabledAlgorithms=" + string;
                String string3 = ResourceManager.getString("deployment.console.weak.text", this.signingInfoMessage, string2, this.jarFile.getAbsolutePath());
                Trace.println(string3, TraceLevel.SECURITY);
                ToolkitStore.get().getAppContext().put(WEAK_ALGORITHM_CTX_KEY, this.signingInfoMessage);
            }
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isJarWeaklySigned() {
        String string;
        Object object;
        Object object2;
        Object object3;
        DisabledAlgorithmConstraints disabledAlgorithmConstraints = new DisabledAlgorithmConstraints(PROPERTY_JAR_DISABLED_ALGS);
        Set<CryptoPrimitive> set = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.MESSAGE_DIGEST));
        Set<CryptoPrimitive> set2 = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, PKCS7> hashMap2 = new HashMap<String, PKCS7>();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(this.jarFile, true);
            byte[] byArray = new byte[8192];
            object3 = jarFile.entries();
            block15: while (object3.hasMoreElements()) {
                JarEntry jarEntry = (JarEntry)object3.nextElement();
                try {
                    Object object4 = jarFile.getInputStream(jarEntry);
                    object2 = jarEntry.getName();
                    if (!SignatureFileVerifier.isSigningRelated((String)object2) || !SignatureFileVerifier.isBlockOrSF((String)object2)) continue;
                    String string2 = ((String)object2).substring(((String)object2).lastIndexOf(47) + 1, ((String)object2).lastIndexOf(46));
                    if (((String)object2).endsWith(".SF")) {
                        object = new Manifest((InputStream)object4);
                        for (Object string3 : ((Manifest)object).getMainAttributes().keySet()) {
                            string = string3.toString();
                            if (!string.endsWith("-Digest-Manifest")) continue;
                            hashMap.put(string2, string.substring(0, string.length() - 16));
                            continue block15;
                        }
                        continue;
                    }
                    hashMap2.put(string2, new PKCS7((InputStream)object4));
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
        }
        boolean bl = false;
        object3 = this.jarLocation.toString();
        for (Object object4 : hashMap.keySet()) {
            object2 = (PKCS7)hashMap2.get(object4);
            if (object2 == null) continue;
            try {
                object = ((PKCS7)object2).getSignerInfos()[0];
                X509Certificate x509Certificate = ((SignerInfo)object).getCertificate((PKCS7)object2);
                String string2 = (String)hashMap.get(object4);
                string = AlgorithmId.makeSigAlg((String)((SignerInfo)object).getDigestAlgorithmId().getName(), (String)((SignerInfo)object).getDigestEncryptionAlgorithmId().getName());
                PublicKey publicKey = x509Certificate.getPublicKey();
                if (!disabledAlgorithmConstraints.permits(set, string2, null)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.digest", string2, (String)object3);
                    bl = true;
                    break;
                }
                if (!disabledAlgorithmConstraints.permits(set2, string, null)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.signature", string, (String)object3);
                    bl = true;
                    break;
                }
                if (!disabledAlgorithmConstraints.permits(set2, publicKey)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.key", string, KeyUtil.getKeySize(publicKey), (String)object3);
                    bl = true;
                    break;
                }
                PKCS7 pKCS7 = ((SignerInfo)object).getTsToken();
                if (pKCS7 == null) continue;
                SignerInfo signerInfo = pKCS7.getSignerInfos()[0];
                X509Certificate x509Certificate2 = signerInfo.getCertificate(pKCS7);
                byte[] byArray = pKCS7.getContentInfo().getData();
                TimestampToken timestampToken = new TimestampToken(byArray);
                PublicKey publicKey2 = x509Certificate2.getPublicKey();
                String string3 = timestampToken.getHashAlgorithm().getName();
                String string4 = AlgorithmId.makeSigAlg((String)signerInfo.getDigestAlgorithmId().getName(), (String)signerInfo.getDigestEncryptionAlgorithmId().getName());
                if (!disabledAlgorithmConstraints.permits(set, string3, null)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.ts.digest", string, (String)object3);
                    bl = true;
                    break;
                }
                if (!disabledAlgorithmConstraints.permits(set2, string4, null)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.ts.signature", string, (String)object3);
                    bl = true;
                    break;
                }
                if (disabledAlgorithmConstraints.permits(set2, publicKey2)) continue;
                this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.ts.key", string, KeyUtil.getKeySize(publicKey), (String)object3);
                bl = true;
                break;
            }
            catch (Throwable throwable) {
                Trace.ignored(throwable);
            }
        }
        return bl;
    }
}

