/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.Iterator;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Convert a VCF file to a BCF file, or BCF to VCF.\nInput and output formats are determined by file extension.", usageShort="Converts a VCF file to a BCF file, or BCF to VCF", programGroup=VcfOrBcf.class)
public class VcfFormatConverter
extends CommandLineProgram {
    public static final Log LOG = Log.getInstance(VcfFormatConverter.class);
    @Option(doc="The BCF or VCF input file. The file format is determined by file extension.", shortName="I")
    public File INPUT;
    @Option(doc="The BCF or VCF output file. The file format is determined by file extension.", shortName="O")
    public File OUTPUT;
    @Option(doc="Fail if an index is not available for the input VCF/BCF")
    public Boolean REQUIRE_INDEX = true;

    public static void main(String[] argv) {
        new VcfFormatConverter().instanceMainWithExit(argv);
    }

    public VcfFormatConverter() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        ProgressLogger progress = new ProgressLogger(LOG, 10000);
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        VCFFileReader reader = new VCFFileReader(this.INPUT, (boolean)this.REQUIRE_INDEX);
        VCFHeader header = new VCFHeader(reader.getFileHeader());
        SAMSequenceDictionary sequenceDictionary = header.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available in the input file when creating indexed output.");
        }
        VariantContextWriterBuilder builder = new VariantContextWriterBuilder().setOutputFile(this.OUTPUT).setReferenceDictionary(sequenceDictionary);
        if (this.CREATE_INDEX.booleanValue()) {
            builder.setOption(Options.INDEX_ON_THE_FLY);
        } else {
            builder.unsetOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter writer = builder.build();
        writer.writeHeader(header);
        Iterator iterator = reader.iterator();
        while (iterator.hasNext()) {
            VariantContext context = (VariantContext)iterator.next();
            writer.add(context);
            progress.record(context.getChr(), context.getStart());
        }
        CloserUtil.close(iterator);
        CloserUtil.close(reader);
        writer.close();
        return 0;
    }
}

