/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BigWigSectionHeader;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.bbfile.WigItem;
import org.broad.igv.util.LittleEndianInputStream;

public class BigWigSection {
    private static Logger log = Logger.getLogger(BigWigSection.class);
    private boolean isLowToHigh;
    private LittleEndianInputStream lbdis;
    private DataInputStream dis;
    private RPTreeLeafNodeItem leafHitItem;
    private int sectionDataSize;
    private Map<Integer, String> chromosomeMap;
    private BigWigSectionHeader wigSectionHeader;

    public BigWigSection(byte[] sectionBuffer, Map<Integer, String> chromosomeMap, boolean isLowToHigh, RPTreeLeafNodeItem leafHitItem) {
        this.chromosomeMap = chromosomeMap;
        this.isLowToHigh = isLowToHigh;
        this.leafHitItem = leafHitItem;
        if (this.isLowToHigh) {
            this.lbdis = new LittleEndianInputStream(new ByteArrayInputStream(sectionBuffer));
            this.wigSectionHeader = new BigWigSectionHeader(this.lbdis);
        } else {
            this.dis = new DataInputStream(new ByteArrayInputStream(sectionBuffer));
            this.wigSectionHeader = new BigWigSectionHeader(this.dis);
        }
        if (this.wigSectionHeader.getItemType() == BigWigSectionHeader.WigItemType.Unknown) {
            throw new RuntimeException("Read error on wig section leaf index ");
        }
        this.sectionDataSize = 24;
    }

    public boolean isValidSectionType() {
        return this.wigSectionHeader.IsValidType();
    }

    public int getItemCount() {
        return this.wigSectionHeader.getItemCount();
    }

    public BigWigSectionHeader getSectionHeader() {
        return this.wigSectionHeader;
    }

    public int getSectionDataSize() {
        return this.sectionDataSize;
    }

    public int getSectionData(RPChromosomeRegion selectionRegion, boolean contained, ArrayList<WigItem> wigItemList) {
        int chromID = this.wigSectionHeader.getChromID();
        String chromosome = this.chromosomeMap.get(chromID);
        int itemCount = this.wigSectionHeader.getItemCount();
        int chromStart = this.wigSectionHeader.getChromosomeStart();
        int chromEnd = this.wigSectionHeader.getChromosomeEnd();
        int itemStep = this.wigSectionHeader.getItemStep();
        int itemSpan = this.wigSectionHeader.getItemSpan();
        int itemIndex = 0;
        int startBase = 0;
        int endBase = 0;
        float value = 0.0f;
        BigWigSectionHeader.WigItemType itemType = this.wigSectionHeader.getItemType();
        RPChromosomeRegion itemRegion = new RPChromosomeRegion(chromID, chromStart, chromID, chromEnd);
        int leafHitValue = itemRegion.compareRegions(selectionRegion);
        try {
            for (int index = 0; index < itemCount; ++index) {
                ++itemIndex;
                if (this.isLowToHigh) {
                    if (itemType == BigWigSectionHeader.WigItemType.FixedStep) {
                        startBase = chromStart;
                        endBase = startBase + itemSpan;
                        value = this.lbdis.readFloat();
                        chromStart = startBase + itemStep;
                        this.sectionDataSize += 4;
                    } else if (itemType == BigWigSectionHeader.WigItemType.VarStep) {
                        startBase = this.lbdis.readInt();
                        endBase = startBase + itemSpan;
                        value = this.lbdis.readFloat();
                        this.sectionDataSize += 8;
                    } else if (itemType == BigWigSectionHeader.WigItemType.BedGraph) {
                        startBase = this.lbdis.readInt();
                        endBase = this.lbdis.readInt();
                        value = this.lbdis.readFloat();
                        this.sectionDataSize += 12;
                    }
                } else if (itemType == BigWigSectionHeader.WigItemType.FixedStep) {
                    startBase = chromStart;
                    endBase = startBase + itemSpan;
                    value = this.dis.readFloat();
                    chromStart = startBase + itemStep;
                    this.sectionDataSize += 4;
                } else if (itemType == BigWigSectionHeader.WigItemType.VarStep) {
                    startBase = this.dis.readInt();
                    endBase = startBase + itemSpan;
                    value = this.dis.readFloat();
                    this.sectionDataSize += 8;
                } else if (itemType == BigWigSectionHeader.WigItemType.BedGraph) {
                    startBase = this.dis.readInt();
                    endBase = this.dis.readInt();
                    value = this.dis.readFloat();
                    this.sectionDataSize += 12;
                }
                if (leafHitValue == 0) {
                    WigItem bbItem = new WigItem(itemIndex, chromosome, startBase, endBase, value);
                    wigItemList.add(bbItem);
                    continue;
                }
                itemRegion = new RPChromosomeRegion(chromID, startBase, chromID, endBase);
                int itemHitValue = itemRegion.compareRegions(selectionRegion);
                if (itemHitValue != 0 && (contained || Math.abs(itemHitValue) >= 2)) continue;
                WigItem bbItem = new WigItem(itemIndex, chromosome, startBase, endBase, value);
                wigItemList.add(bbItem);
            }
        }
        catch (IOException ex) {
            log.error("Read error for Wig section item " + itemIndex);
            throw new RuntimeException("Read error for Wig section item " + itemIndex);
        }
        return this.sectionDataSize;
    }

    public void print() {
        log.debug("Wig section for leaf item  has a data size = " + this.sectionDataSize);
        this.wigSectionHeader.print();
    }
}

