/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram;

import htsjdk.samtools.cram.CRAIIndex;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;

public class CRAIEntry
implements Comparable<CRAIEntry> {
    private final int sequenceId;
    private final int alignmentStart;
    private final int alignmentSpan;
    private final long containerStartByteOffset;
    private final int sliceByteOffset;
    private final int sliceByteSize;
    private static final int CRAI_INDEX_COLUMNS = 6;
    private static final String ENTRY_FORMAT = "%d\t%d\t%d\t%d\t%d\t%d";
    public static Comparator<CRAIEntry> byEnd = new Comparator<CRAIEntry>(){

        @Override
        public int compare(CRAIEntry o1, CRAIEntry o2) {
            if (o1.sequenceId != o2.sequenceId) {
                return o2.sequenceId - o1.sequenceId;
            }
            if (o1.alignmentStart + o1.alignmentSpan != o2.alignmentStart + o2.alignmentSpan) {
                return o1.alignmentStart + o1.alignmentSpan - o2.alignmentStart - o2.alignmentSpan;
            }
            return (int)(o1.containerStartByteOffset - o2.containerStartByteOffset);
        }
    };
    public static final Comparator<CRAIEntry> byStart = new Comparator<CRAIEntry>(){

        @Override
        public int compare(CRAIEntry o1, CRAIEntry o2) {
            if (o1.sequenceId != o2.sequenceId) {
                return o2.sequenceId - o1.sequenceId;
            }
            if (o1.alignmentStart != o2.alignmentStart) {
                return o1.alignmentStart - o2.alignmentStart;
            }
            return (int)(o1.containerStartByteOffset - o2.containerStartByteOffset);
        }
    };
    public static Comparator<CRAIEntry> byStartDesc = new Comparator<CRAIEntry>(){

        @Override
        public int compare(CRAIEntry o1, CRAIEntry o2) {
            if (o1.sequenceId != o2.sequenceId) {
                if (o1.sequenceId == -1) {
                    return 1;
                }
                if (o2.sequenceId == -1) {
                    return -1;
                }
                return -o2.sequenceId + o1.sequenceId;
            }
            if (o1.alignmentStart != o2.alignmentStart) {
                return o1.alignmentStart - o2.alignmentStart;
            }
            return (int)(o1.containerStartByteOffset - o2.containerStartByteOffset);
        }
    };

    public CRAIEntry(int sequenceId, int alignmentStart, int alignmentSpan, long containerStartByteOffset, int sliceByteOffset, int sliceByteSize) {
        this.sequenceId = sequenceId;
        this.alignmentStart = alignmentStart;
        this.alignmentSpan = alignmentSpan;
        this.containerStartByteOffset = containerStartByteOffset;
        this.sliceByteOffset = sliceByteOffset;
        this.sliceByteSize = sliceByteSize;
    }

    public CRAIEntry(String line) {
        String[] chunks = line.split("\t");
        if (chunks.length != 6) {
            throw new CRAIIndex.CRAIIndexException("Malformed CRAI index entry: expecting 6 columns but got " + chunks.length);
        }
        try {
            this.sequenceId = Integer.parseInt(chunks[0]);
            this.alignmentStart = Integer.parseInt(chunks[1]);
            this.alignmentSpan = Integer.parseInt(chunks[2]);
            this.containerStartByteOffset = Long.parseLong(chunks[3]);
            this.sliceByteOffset = Integer.parseInt(chunks[4]);
            this.sliceByteSize = Integer.parseInt(chunks[5]);
        }
        catch (NumberFormatException e) {
            throw new CRAIIndex.CRAIIndexException(e);
        }
    }

    public void writeToStream(OutputStream os) {
        try {
            os.write(this.serializeToString().getBytes());
            os.write(10);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private String serializeToString() {
        return String.format(ENTRY_FORMAT, this.sequenceId, this.alignmentStart, this.alignmentSpan, this.containerStartByteOffset, this.sliceByteOffset, this.sliceByteSize);
    }

    public String toString() {
        return this.serializeToString();
    }

    @Override
    public int compareTo(CRAIEntry o) {
        if (o == null) {
            return 1;
        }
        if (this.sequenceId != o.sequenceId) {
            return this.sequenceId - o.sequenceId;
        }
        if (this.alignmentStart != o.alignmentStart) {
            return this.alignmentStart - o.alignmentStart;
        }
        return (int)(this.containerStartByteOffset - o.containerStartByteOffset);
    }

    public static boolean intersect(CRAIEntry e0, CRAIEntry e1) {
        if (e0.sequenceId != e1.sequenceId) {
            return false;
        }
        if (e0.sequenceId < 0) {
            return false;
        }
        int a0 = e0.alignmentStart;
        int b0 = a0 + e0.alignmentSpan;
        int a1 = e1.alignmentStart;
        int b1 = a1 + e1.alignmentSpan;
        return Math.abs(a0 + b0 - a1 - b1) < e0.alignmentSpan + e1.alignmentSpan;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    public int getAlignmentSpan() {
        return this.alignmentSpan;
    }

    public long getContainerStartByteOffset() {
        return this.containerStartByteOffset;
    }

    public int getSliceByteOffset() {
        return this.sliceByteOffset;
    }

    public int getSliceByteSize() {
        return this.sliceByteSize;
    }
}

