/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.apache.log4j.Logger;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.TrackPanelScrollPane;

public class IGVPanel
extends JPanel
implements Paintable {
    Logger log = Logger.getLogger(IGVPanel.class);
    MainPanel mainPanel;

    public IGVPanel(MainPanel mainPanel) {
        this.setLayout(null);
        this.mainPanel = mainPanel;
    }

    public int getViewportHeight() {
        Container parent = this.getParent();
        return parent == null ? 0 : parent.getHeight();
    }

    public TrackPanelScrollPane getScrollPane() {
        TrackPanelScrollPane scollpane = null;
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            scollpane = (TrackPanelScrollPane)((JViewport)parent).getParent();
        }
        return scollpane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.log.trace("Layout: " + this.toString());
            int h = this.getHeight();
            Component[] children = this.getComponents();
            int nw = this.mainPanel.getNamePanelWidth();
            int grabBarWidth = nw - 10;
            int idx = 0;
            if (children.length > 3) {
                children[idx++].setBounds(this.mainPanel.getNamePanelX(), 0, 10, h);
                children[idx++].setBounds(this.mainPanel.getNamePanelX() + 10, 0, nw - 10, h);
            } else {
                children[idx++].setBounds(this.mainPanel.getNamePanelX(), 0, nw, h);
            }
            children[idx++].setBounds(this.mainPanel.getAttributePanelX(), 0, this.mainPanel.getAttributePanelWidth(), h);
            children[idx].setBounds(this.mainPanel.getDataPanelX(), 0, this.mainPanel.getDataPanelWidth(), h);
            children[idx].doLayout();
        }
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect) {
        int h = rect.height;
        Component[] children = this.getComponents();
        g.translate(this.mainPanel.getNamePanelX(), 0);
        Rectangle nameRect = new Rectangle(children[0].getBounds());
        nameRect.height = h;
        Graphics2D nameGraphics = (Graphics2D)g.create();
        nameGraphics.setClip(nameRect);
        ((Paintable)((Object)children[0])).paintOffscreen(nameGraphics, nameRect);
        nameGraphics.dispose();
        int dx = this.mainPanel.getAttributePanelX() - this.mainPanel.getNamePanelX();
        g.translate(dx, 0);
        Rectangle attRect = new Rectangle(0, 0, children[1].getWidth(), h);
        Graphics2D attributeGraphics = (Graphics2D)g.create();
        attributeGraphics.setClip(attRect);
        ((Paintable)((Object)children[1])).paintOffscreen(attributeGraphics, attRect);
        attributeGraphics.dispose();
        dx = this.mainPanel.getDataPanelX() - this.mainPanel.getAttributePanelX();
        g.translate(dx, 0);
        Rectangle dataRect = new Rectangle(0, 0, this.mainPanel.getDataPanelWidth(), h);
        Graphics2D dataGraphics = (Graphics2D)g.create();
        g.setClip(dataRect);
        ((Paintable)((Object)children[2])).paintOffscreen(dataGraphics, dataRect);
        dataGraphics.dispose();
    }
}

