/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.GisticScore;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.GisticTrackRenderer;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

public class GisticTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(GisticTrack.class);
    private static final int DEFAULT_HEIGHT = 50;
    private double maxQValue = 0.0;
    private double maxGScore = 0.0;
    private boolean hasScores = false;
    Map<String, List<GisticScore>> ampScoreMap;
    Map<String, List<GisticScore>> delScoreMap;
    GisticTrackRenderer renderer;
    double dataMax = -1.0;

    public GisticTrack(ResourceLocator locator) {
        super(locator);
        this.ampScoreMap = new HashMap<String, List<GisticScore>>();
        this.delScoreMap = new HashMap<String, List<GisticScore>>();
        this.renderer = new GisticTrackRenderer();
        this.setHeight(50);
        this.renderer = new GisticTrackRenderer();
        this.setSortable(false);
    }

    public GisticTrack() {
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        return this.hasScores;
    }

    @Override
    public void load(ReferenceFrame referenceFrame) {
    }

    @Override
    public int getMinimumHeight() {
        return 25;
    }

    public void setScores(List<GisticScore> scores) {
        this.hasScores = true;
        for (GisticScore score : scores) {
            String chr = score.getChromosome();
            if (score.getType() == GisticScore.Type.AMP) {
                this.addScore(score, chr, this.ampScoreMap);
                continue;
            }
            this.addScore(score, chr, this.delScoreMap);
        }
        this.updateMaxValues(scores);
    }

    protected void addScore(GisticScore score, String chr, Map<String, List<GisticScore>> map) {
        List<GisticScore> scoreList = map.get(chr);
        if (scoreList == null) {
            scoreList = new ArrayList<GisticScore>();
            map.put(chr, scoreList);
        }
        scoreList.add(score);
    }

    private void updateMaxValues(List<GisticScore> scores) {
        for (GisticScore score : scores) {
            if (!Double.isInfinite(this.maxGScore) && score.getGScore() > this.maxGScore) {
                this.maxGScore = score.getGScore();
            }
            if (Double.isInfinite(this.maxQValue) || !(score.getQValue() > this.maxQValue)) continue;
            this.maxQValue = score.getQValue();
        }
        this.setDataRange(new DataRange(0.0f, 0.0f, (float)this.maxQValue));
    }

    public List<GisticScore> getAmpScores(String chr) {
        return this.ampScoreMap.get(chr);
    }

    public List<GisticScore> getDelScores(String chr) {
        return this.delScoreMap.get(chr);
    }

    public GisticScore getMaxForRegion(String chr, long start, long end) {
        List<GisticScore> scores = this.ampScoreMap.get(chr);
        if (scores == null || scores.isEmpty()) {
            return null;
        }
        GisticScore maxScore = null;
        for (GisticScore score : scores) {
            if (maxScore == null) {
                if ((long)score.getStart() < start && (start < (long)score.getStart() || start > (long)score.getEnd())) continue;
                maxScore = score;
                continue;
            }
            if ((long)score.getStart() > end) break;
            if (!(score.getGScore() > maxScore.getGScore())) continue;
            maxScore = score;
        }
        return maxScore == null ? scores.get(scores.size() - 1) : maxScore;
    }

    public double getMaxQValue() {
        return this.maxQValue;
    }

    public double getMaxGScore() {
        return this.maxGScore;
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        if (this.renderer == null) {
            log.error("Null renderer !!");
        } else {
            this.renderer.render(this, context, rect);
        }
    }

    public double getDataMax() {
        if (this.dataMax < 0.0) {
            this.dataMax = this.getMaxGScore();
        }
        return this.dataMax;
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return WindowFunction.median;
    }

    public double getMedian(String chr) {
        return 1.0;
    }

    @Override
    public boolean isLogNormalized() {
        return true;
    }

    public List<IGVFeature> getFeatures(String chr, int startLocation, int endLocation) {
        return null;
    }

    public List<LocusScore> getSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        List<GisticScore> delScores;
        ArrayList<LocusScore> ss = new ArrayList<LocusScore>();
        List<GisticScore> ampScores = this.ampScoreMap.get(chr);
        if (ampScores != null) {
            ss.addAll(ampScores);
        }
        if ((delScores = this.delScoreMap.get(chr)) != null) {
            ss.addAll(delScores);
        }
        return ss;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int ignore, ReferenceFrame frame) {
        double bpPerPixel = frame.getScale();
        double minWidth = 2.0 * bpPerPixel;
        LocusScore amp = null;
        List<GisticScore> ampScores = this.ampScoreMap.get(chr);
        if (ampScores != null) {
            amp = FeatureUtils.getFeatureAt(position, 0, ampScores);
        }
        LocusScore del = null;
        List<GisticScore> delScores = this.delScoreMap.get(chr);
        if (delScores != null) {
            del = FeatureUtils.getFeatureAt(position, 0, delScores);
        }
        if (amp == null && del == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (amp != null) {
            buf.append("Amplification score: " + amp.getScore());
        }
        if (del != null) {
            buf.append("<br>Deletion score: " + del.getScore());
        }
        return buf.toString();
    }

    public List<List<IGVFeature>> getFeaturesByLevels(String chr, int startLocation, int endLocation) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getNumberOfFeatureLevels() {
        return 1;
    }

    public void setMultiLevelFeatures(boolean isMultiLevel) {
    }

    public boolean isMuliLevelFeatures() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Color getColor() {
        return null;
    }

    @Override
    public void setColor(Color color) {
    }

    @Override
    public Color getAltColor() {
        return null;
    }

    @Override
    public void setAltColor(Color color) {
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }
}

