/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.Random;
import org.apache.commons.math.stat.StatUtils;
import org.broad.igv.sam.Alignment;
import org.broad.igv.util.collections.DoubleArrayList;

public class ReadStats {
    private int readCount = 0;
    private int indelCount = 0;
    private int nCount = 0;
    private DoubleArrayList readLengths = new DoubleArrayList(10000);
    private DoubleArrayList refToReadRatios = new DoubleArrayList(10000);
    public double medianReadLength = 0.0;
    public double readLengthStdDev = 0.0;
    public double medianRefToReadRatio = 0.0;
    public double fracReadsWithIndels;
    public double fracReadsWithNs;
    private static final Random RAND = new Random();

    public void addAlignment(Alignment alignment) {
        if (alignment.isMapped()) {
            ++this.readCount;
            int readLength = alignment.getReadSequence().length();
            char[] cigarString = alignment.getCigarString().toCharArray();
            this.readLengths.add(readLength);
            if (this.containsChar(cigarString, 'N')) {
                ++this.nCount;
                this.refToReadRatios.add((double)(alignment.getAlignmentEnd() - alignment.getAlignmentStart()) / (double)readLength);
            }
            if (this.containsChar(cigarString, 'D') || this.containsChar(cigarString, 'I')) {
                ++this.indelCount;
            }
        }
    }

    public void compute() {
        if (this.readLengths.size() > 0) {
            double[] downsampled = this.downsample(this.readLengths, 10000);
            this.medianReadLength = StatUtils.percentile(downsampled, 50.0);
            this.readLengthStdDev = Math.sqrt(StatUtils.variance(downsampled));
        }
        if (this.refToReadRatios.size() > 0) {
            this.medianRefToReadRatio = StatUtils.percentile(this.downsample(this.refToReadRatios, 10000), 50.0);
        }
        this.fracReadsWithIndels = (double)this.indelCount / (double)this.readCount;
        this.fracReadsWithNs = (double)this.nCount / (double)this.readCount;
    }

    private boolean containsChar(char[] charArray, char c) {
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] != c) continue;
            return true;
        }
        return false;
    }

    private double[] downsample(DoubleArrayList list, int size) {
        if (list.size() < size) {
            return list.toArray();
        }
        double[] ds = list.toArray(0, size);
        for (int i = size; i < list.size(); ++i) {
            double samplingProb = (double)size / (double)(size + (i - size) + 1);
            if (!(RAND.nextDouble() < samplingProb)) continue;
            int idx = (int)(RAND.nextDouble() * (double)(size - 1));
            ds[idx] = list.get(i);
        }
        return ds;
    }
}

