/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.text.DecimalFormat;
import java.util.List;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;

public abstract class XYPlotRenderer
extends DataRenderer {
    private double marginFraction = 0.2;
    static DecimalFormat formatter = new DecimalFormat();

    protected void drawDataPoint(Color graphColor, int dx, int pX, int baseY, int pY, RenderContext context) {
        context.getGraphic2DForColor(graphColor).fillRect(pX, pY, dx, 2);
    }

    @Override
    public synchronized void renderScores(Track track, List<LocusScore> locusScores, RenderContext context, Rectangle arect) {
        Rectangle adjustedRect = this.calculateDrawingRect(arect);
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Color posColor = track.getColor();
        Color negColor = track.getAltColor();
        DataRange dataRange = track.getDataRange();
        float maxValue = dataRange.getMaximum();
        float baseValue = dataRange.getBaseline();
        float minValue = dataRange.getMinimum();
        boolean isLog = dataRange.isLog();
        if (isLog) {
            minValue = (float)(minValue == 0.0f ? 0.0 : Math.log10(minValue));
            maxValue = (float)Math.log10(maxValue);
        }
        double delta = maxValue - minValue;
        double yScaleFactor = adjustedRect.getHeight() / delta;
        double baseDelta = maxValue - baseValue;
        int baseY = (int)(adjustedRect.getY() + baseDelta * yScaleFactor);
        if (baseY < adjustedRect.y) {
            baseY = adjustedRect.y;
        } else if (baseY > adjustedRect.y + adjustedRect.height) {
            baseY = adjustedRect.y + adjustedRect.height;
        }
        for (LocusScore score : locusScores) {
            double dx;
            double pX = ((double)score.getStart() - origin) / locScale;
            if (pX + (dx = Math.ceil((double)Math.max(1, score.getEnd() - score.getStart()) / locScale) + 1.0) < 0.0) continue;
            if (pX > adjustedRect.getMaxX()) break;
            float dataY = score.getScore();
            if (isLog && dataY <= 0.0f || Float.isNaN(dataY)) continue;
            double dy = isLog ? Math.log10(dataY) - (double)baseValue : (double)(dataY - baseValue);
            int pY = baseY - (int)(dy * yScaleFactor);
            if (pY < adjustedRect.y) {
                pY = adjustedRect.y;
            } else if (pY > adjustedRect.y + adjustedRect.height) {
                pY = adjustedRect.y + adjustedRect.height;
            }
            Color color = dataY >= baseValue ? posColor : negColor;
            this.drawDataPoint(color, (int)dx, (int)pX, baseY, pY, context);
        }
    }

    @Override
    public void renderAxis(Track track, RenderContext context, Rectangle arect) {
        if (context.getChr().equals("All") || context.multiframe) {
            return;
        }
        super.renderAxis(track, context, arect);
        Rectangle drawingRect = this.calculateDrawingRect(arect);
        IGVPreferences prefs = PreferencesManager.getPreferences();
        Color labelColor = prefs.getAsBoolean("CHART.COLOR_TRACK_NAME") ? track.getColor() : Color.black;
        Graphics2D labelGraphics = context.getGraphic2DForColor(labelColor);
        labelGraphics.setFont(FontManager.getFont(8));
        if (prefs.getAsBoolean("CHART.DRAW_TRACK_NAME") && arect.getHeight() > 25.0) {
            Rectangle labelRect = new Rectangle(arect.x, arect.y + 10, arect.width, 10);
            labelGraphics.setFont(FontManager.getFont(10));
            GraphicUtils.drawCenteredText(track.getName(), labelRect, labelGraphics);
        }
        if (prefs.getAsBoolean("CHART.DRAW_AXIS")) {
            Rectangle axisRect = new Rectangle(arect.x, arect.y + 1, 60, arect.height);
            DataRange axisDefinition = track.getDataRange();
            float maxValue = axisDefinition.getMaximum();
            float baseValue = axisDefinition.getBaseline();
            float minValue = axisDefinition.getMinimum();
            int pY = this.computeYPixelValue(drawingRect, axisDefinition, minValue);
            labelGraphics.drawLine(axisRect.x + 60 - 10, pY, axisRect.x + 60 - 5, pY);
            GraphicUtils.drawRightJustifiedText(formatter.format(minValue), axisRect.x + 60 - 15, pY, labelGraphics);
            int topPY = this.computeYPixelValue(drawingRect, axisDefinition, maxValue);
            labelGraphics.drawLine(axisRect.x + 60 - 10, topPY, axisRect.x + 60 - 5, topPY);
            GraphicUtils.drawRightJustifiedText(formatter.format(maxValue), axisRect.x + 60 - 15, topPY + 4, labelGraphics);
            labelGraphics.drawLine(axisRect.x + 60 - 10, topPY, axisRect.x + 60 - 10, pY);
            int midPY = this.computeYPixelValue(drawingRect, axisDefinition, baseValue);
            if (midPY < pY - 15 && midPY > topPY + 15) {
                labelGraphics.drawLine(axisRect.x + 60 - 10, midPY, axisRect.x + 60 - 5, midPY);
                GraphicUtils.drawRightJustifiedText(formatter.format(baseValue), axisRect.x + 60 - 15, midPY + 4, labelGraphics);
            }
        } else if (track.isShowDataRange() && arect.height > 20) {
            XYPlotRenderer.drawScale(track.getDataRange(), context, arect);
        }
    }

    @Override
    public void renderBorder(Track track, RenderContext context, Rectangle arect) {
        Rectangle adjustedRect = this.calculateDrawingRect(arect);
        if (adjustedRect.getHeight() >= 10.0) {
            DataRange axisDefinition = track.getDataRange();
            float maxValue = axisDefinition.getMaximum();
            float baseValue = axisDefinition.getBaseline();
            float minValue = axisDefinition.getMinimum();
            double maxX = adjustedRect.getMaxX();
            double x = adjustedRect.getX();
            double y = adjustedRect.getY();
            if (baseValue > minValue && baseValue < maxValue) {
                int baseY = this.computeYPixelValue(adjustedRect, axisDefinition, baseValue);
                XYPlotRenderer.getBaselineGraphics(context).drawLine((int)x, baseY, (int)maxX, baseY);
            }
            IGVPreferences prefs = PreferencesManager.getPreferences();
            Color altColor = track.getAltColor();
            Color borderColor = prefs.getAsBoolean("CHART.COLOR_BORDERS") && altColor != null && altColor.equals(track.getColor()) ? track.getColor() : Color.lightGray;
            Graphics2D borderGraphics = context.getGraphic2DForColor(borderColor);
            double zeroValue = axisDefinition.getBaseline();
            int zeroY = this.computeYPixelValue(adjustedRect, axisDefinition, zeroValue);
            borderGraphics.drawLine(adjustedRect.x, zeroY, adjustedRect.x + adjustedRect.width, zeroY);
            if (track.isDrawYLine()) {
                Graphics2D yLineGraphics = context.getGraphic2DForColor(Color.gray);
                int yLine = this.computeYPixelValue(adjustedRect, axisDefinition, track.getYLine());
                GraphicUtils.drawDashedLine(borderGraphics, adjustedRect.x, yLine, adjustedRect.x + adjustedRect.width, yLine);
            }
            boolean drawBorders = true;
            if (minValue * maxValue < 0.0f) {
                boolean bl = drawBorders = prefs.getAsBoolean("CHART.DRAW_BOTTOM_BORDER") && prefs.getAsBoolean("CHART.DRAW_TOP_BORDER");
            }
            if (drawBorders && prefs.getAsBoolean("CHART.DRAW_TOP_BORDER")) {
                borderGraphics.drawLine(adjustedRect.x, adjustedRect.y, adjustedRect.x + adjustedRect.width, adjustedRect.y);
            }
            if (drawBorders && prefs.getAsBoolean("CHART.DRAW_BOTTOM_BORDER")) {
                borderGraphics.drawLine(adjustedRect.x, adjustedRect.y + adjustedRect.height, adjustedRect.x + adjustedRect.width, adjustedRect.y + adjustedRect.height);
            }
        }
    }

    private static Graphics2D getBaselineGraphics(RenderContext context) {
        Graphics2D baselineGraphics = (Graphics2D)context.getGraphic2DForColor(Color.lightGray).create();
        baselineGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return baselineGraphics;
    }

    public String getDisplayName() {
        return "Scatter Plot";
    }

    protected int computeYPixelValue(Rectangle drawingRect, DataRange axisDefinition, double dataY) {
        double maxValue = axisDefinition.getMaximum();
        double minValue = axisDefinition.getMinimum();
        double yScaleFactor = drawingRect.getHeight() / (maxValue - minValue);
        double delta = (maxValue - dataY) * yScaleFactor;
        double pY = drawingRect.getY() + delta;
        return (int)Math.max(drawingRect.getMinY(), Math.min(drawingRect.getMaxY(), pY));
    }

    protected Rectangle calculateDrawingRect(Rectangle arect) {
        double buffer = Math.min(arect.getHeight() * this.marginFraction, 10.0);
        Rectangle adjustedRect = new Rectangle(arect);
        adjustedRect.y = (int)(arect.getY() + buffer);
        adjustedRect.height = (int)((double)arect.height - ((double)adjustedRect.y - arect.getY()));
        return adjustedRect;
    }

    public void setMarginFraction(double marginFraction) {
        this.marginFraction = marginFraction;
    }
}

