/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.apache.log4j.Logger;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;

public class DataPanelLayout
implements LayoutManager {
    private static Logger log = Logger.getLogger(DataPanelLayout.class);
    static final int default_hgap = 6;
    static Border panelBorder = BorderFactory.createLineBorder(Color.gray);

    @Override
    public void addLayoutComponent(String s, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                dim.height = Math.max(dim.height, d.height);
                dim.width += d.width;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            return new Dimension(0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] children = container.getComponents();
            List<ReferenceFrame> frames = FrameManager.getFrames();
            int h = container.getHeight();
            int hgap = 6;
            if (frames.size() > 10) {
                hgap = 1 + 20 / frames.size();
            }
            try {
                for (int i = 0; i < Math.min(children.length, frames.size()); ++i) {
                    Component c = children[i];
                    ReferenceFrame frame = frames.get(i);
                    int leftGap = i == 0 ? hgap / 2 : hgap;
                    c.setBounds(frame.pixelX + leftGap, 0, frame.getWidthInPixels() - hgap, h);
                    if (c instanceof JComponent) {
                        if (frame.getWidthInPixels() > 5) {
                            ((JComponent)c).setBorder(panelBorder);
                        } else {
                            ((JComponent)c).setBorder(null);
                        }
                    }
                    log.trace("Layout: " + frame.getName() + "  x=" + frame.pixelX + "  w=" + frame.getWidthInPixels());
                }
            }
            catch (Exception e) {
                log.error("Error laying out data panel", e);
            }
        }
    }
}

