/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import picard.util.VariantType;

public class DbSnpBitSetUtil {
    private final Map<String, BitSet> sequenceToBitSet = new HashMap<String, BitSet>();

    private DbSnpBitSetUtil() {
    }

    public DbSnpBitSetUtil(File dbSnpFile, SAMSequenceDictionary sequenceDictionary) {
        this(dbSnpFile, sequenceDictionary, EnumSet.noneOf(VariantType.class));
    }

    public DbSnpBitSetUtil(File dbSnpFile, SAMSequenceDictionary sequenceDictionary, Collection<VariantType> variantsToMatch) {
        if (dbSnpFile == null) {
            throw new IllegalArgumentException("null dbSnpFile");
        }
        HashMap<DbSnpBitSetUtil, Set<VariantType>> tmp = new HashMap<DbSnpBitSetUtil, Set<VariantType>>();
        tmp.put(this, EnumSet.copyOf(variantsToMatch));
        DbSnpBitSetUtil.loadVcf(dbSnpFile, sequenceDictionary, tmp);
    }

    public static DbSnpBitSets createSnpAndIndelBitSets(File dbSnpFile, SAMSequenceDictionary sequenceDictionary) {
        DbSnpBitSets sets = new DbSnpBitSets();
        sets.snps = new DbSnpBitSetUtil();
        sets.indels = new DbSnpBitSetUtil();
        HashMap<DbSnpBitSetUtil, Set<VariantType>> map = new HashMap<DbSnpBitSetUtil, Set<VariantType>>();
        map.put(sets.snps, EnumSet.of(VariantType.SNP));
        map.put(sets.indels, EnumSet.of(VariantType.insertion, VariantType.deletion));
        DbSnpBitSetUtil.loadVcf(dbSnpFile, sequenceDictionary, map);
        return sets;
    }

    private static void loadVcf(File dbSnpFile, SAMSequenceDictionary sequenceDictionary, Map<DbSnpBitSetUtil, Set<VariantType>> bitSetsToVariantTypes) {
        VCFFileReader variantReader = new VCFFileReader(dbSnpFile);
        Iterator variantIterator = variantReader.iterator();
        while (variantIterator.hasNext()) {
            VariantContext kv = (VariantContext)variantIterator.next();
            for (Map.Entry<DbSnpBitSetUtil, Set<VariantType>> tuple : bitSetsToVariantTypes.entrySet()) {
                DbSnpBitSetUtil bitset = tuple.getKey();
                Set<VariantType> variantsToMatch = tuple.getValue();
                BitSet bits = bitset.sequenceToBitSet.get(kv.getChr());
                if (bits == null) {
                    int nBits = sequenceDictionary == null ? kv.getEnd() + 1 : sequenceDictionary.getSequence(kv.getChr()).getSequenceLength() + 1;
                    bits = new BitSet(nBits);
                    bitset.sequenceToBitSet.put(kv.getChr(), bits);
                }
                if (!(variantsToMatch.isEmpty() || kv.isSNP() && variantsToMatch.contains((Object)VariantType.SNP) || kv.isIndel() && variantsToMatch.contains((Object)VariantType.insertion)) && (!kv.isIndel() || !variantsToMatch.contains((Object)VariantType.deletion))) continue;
                for (int i = kv.getStart(); i <= kv.getEnd(); ++i) {
                    bits.set(i, true);
                }
            }
        }
        CloserUtil.close(variantIterator);
        CloserUtil.close(variantReader);
    }

    public boolean isDbSnpSite(String sequenceName, int pos) {
        if (this.sequenceToBitSet.get(sequenceName) == null) {
            return false;
        }
        if (pos > this.sequenceToBitSet.get(sequenceName).length()) {
            return false;
        }
        return this.sequenceToBitSet.get(sequenceName).get(pos);
    }

    public static class DbSnpBitSets {
        public DbSnpBitSetUtil snps;
        public DbSnpBitSetUtil indels;
    }
}

