/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.prefs;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.UIUtilities;

public class PreferenceEditorFX {
    public static void main(String[] args) throws IOException {
        PreferenceEditorFX.open(null);
    }

    public static void open(Frame parent) throws IOException {
        List<PreferencesManager.PreferenceGroup> preferenceGroups = PreferencesManager.loadPreferenceList();
        SwingUtilities.invokeLater(() -> {
            JDialog frame = new JDialog(parent, "Preferences", true);
            JFXPanel fxPanel = new JFXPanel();
            Platform.runLater(() -> PreferenceEditorFX.initFX(frame, fxPanel, preferenceGroups));
            frame.add((Component)fxPanel);
            frame.pack();
            frame.setSize(800, 600);
            frame.setLocationRelativeTo(parent);
            frame.setVisible(true);
            frame.setDefaultCloseOperation(2);
        });
    }

    private static void initFX(JDialog parent, JFXPanel fxPanel, List<PreferencesManager.PreferenceGroup> preferenceGroups) {
        TabPane tabPane = new TabPane();
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter((Node)tabPane);
        Scene scene = new Scene((Parent)borderPane);
        HashMap updatedPreferencesMap = new HashMap();
        for (PreferencesManager.PreferenceGroup entry : preferenceGroups) {
            Button moveButton;
            Label currentDirectoryLabel;
            String currentDirectory;
            if (entry.tabLabel.equals("Hidden")) continue;
            IGVPreferences preferences = PreferencesManager.getPreferences(entry.category);
            HashMap updatedPrefs = updatedPreferencesMap.containsKey(entry.category) ? (Map)updatedPreferencesMap.get(entry.category) : new HashMap();
            updatedPreferencesMap.put(entry.category, updatedPrefs);
            String tabLabel = entry.tabLabel;
            Tab tab = new Tab(tabLabel);
            tab.setClosable(false);
            tabPane.getTabs().add((Object)tab);
            ScrollPane scrollPane = new ScrollPane();
            tab.setContent((Node)scrollPane);
            VBox vBox = new VBox();
            vBox.setFillWidth(true);
            scrollPane.setContent((Node)vBox);
            GridPane gridPane = new GridPane();
            gridPane.setHgap(5.0);
            gridPane.setVgap(5.0);
            vBox.getChildren().add((Object)gridPane);
            String currentGroup = null;
            int row = 1;
            for (PreferencesManager.Preference pref : entry.preferences) {
                try {
                    Label label;
                    Tooltip tooltip;
                    Tooltip tooltip2 = tooltip = pref.getComment() == null ? null : new Tooltip(pref.getComment());
                    if (pref.getKey().equals("---")) {
                        Separator sep = new Separator();
                        GridPane.setColumnSpan((Node)sep, (Integer)4);
                        gridPane.add((Node)sep, 1, row);
                        ++row;
                        continue;
                    }
                    if (pref.getKey().equals("info")) {
                        label = new Label(pref.getLabel());
                        label.setStyle("-fx-font-size:16");
                        label.setStyle("-fx-font-weight: bold");
                        GridPane.setColumnSpan((Node)label, (Integer)4);
                        gridPane.add((Node)label, 1, ++row);
                        row += 2;
                        continue;
                    }
                    if (pref.group != null && !pref.group.equals(currentGroup)) {
                        row = 0;
                        currentGroup = pref.group;
                        gridPane = new GridPane();
                        gridPane.setHgap(5.0);
                        gridPane.setVgap(5.0);
                        vBox.getChildren().add((Object)gridPane);
                        TitledPane tp = new TitledPane(currentGroup, (Node)gridPane);
                        tp.setCollapsible(false);
                        vBox.getChildren().add((Object)tp);
                        VBox.setMargin((Node)tp, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
                    }
                    if (pref.getType().equals("boolean")) {
                        CheckBox cb = new CheckBox(pref.getLabel());
                        cb.setSelected(preferences.getAsBoolean(pref.getKey()));
                        cb.setOnAction(event -> {
                            updatedPrefs.put(pref.getKey(), Boolean.toString(cb.isSelected()));
                            System.out.println("Set " + pref.getLabel() + ": " + cb.isSelected());
                        });
                        GridPane.setColumnSpan((Node)cb, (Integer)2);
                        gridPane.add((Node)cb, 1, row);
                        if (tooltip != null) {
                            cb.setTooltip(tooltip);
                        }
                    } else if (pref.getType().startsWith("select")) {
                        label = new Label(pref.getLabel());
                        String[] selections = Globals.whitespacePattern.split(pref.getType())[1].split("\\|");
                        ComboBox comboBox = new ComboBox(FXCollections.observableArrayList(Arrays.asList(selections)));
                        comboBox.valueProperty().setValue((Object)pref.getDefaultValue());
                        comboBox.valueProperty().addListener((ov, t, t1) -> System.out.println("Set " + pref.getLabel() + " " + comboBox.valueProperty().toString()));
                        gridPane.add((Node)label, 1, row);
                        GridPane.setColumnSpan((Node)comboBox, (Integer)3);
                        gridPane.add((Node)comboBox, 2, row);
                        if (tooltip != null) {
                            label.setTooltip(tooltip);
                            comboBox.setTooltip(tooltip);
                        }
                    } else {
                        label = new Label(pref.getLabel());
                        TextField field = new TextField(preferences.get(pref.getKey()));
                        field.setPrefWidth(500.0);
                        field.setOnAction(event -> {
                            String text = field.getText();
                            if (PreferenceEditorFX.validate(text, pref.getType())) {
                                updatedPrefs.put(pref.getKey(), text);
                            } else {
                                field.setText(preferences.get(pref.getKey()));
                            }
                        });
                        field.focusedProperty().addListener((observable, oldValue, newValue) -> {
                            if (!newValue.booleanValue()) {
                                String text = field.getText();
                                if (PreferenceEditorFX.validate(text, pref.getType())) {
                                    updatedPrefs.put(pref.getKey(), text);
                                } else {
                                    field.setText(preferences.get(pref.getKey()));
                                }
                            }
                        });
                        gridPane.add((Node)label, 1, row);
                        gridPane.add((Node)field, 2, row);
                        if (tooltip != null) {
                            label.setTooltip(tooltip);
                            field.setTooltip(tooltip);
                        }
                    }
                    ++row;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (tabLabel.equalsIgnoreCase("Cram")) {
                currentDirectory = DirectoryManager.getFastaCacheDirectory().getAbsolutePath();
                currentDirectoryLabel = new Label("Cache directory: " + currentDirectory);
                moveButton = new Button("Move...");
                gridPane.add((Node)currentDirectoryLabel, 1, ++row);
                GridPane.setHalignment((Node)moveButton, (HPos)HPos.LEFT);
                gridPane.add((Node)moveButton, 2, row);
                moveButton.setOnAction(event -> UIUtilities.invokeOnEventThread(() -> {
                    File directory = DirectoryManager.getFastaCacheDirectory();
                    File newDirectory = FileDialogUtils.chooseDirectory("Select cache directory", DirectoryManager.getUserDirectory());
                    if (newDirectory != null && !newDirectory.equals(directory)) {
                        DirectoryManager.moveDirectoryContents(directory, newDirectory);
                        Platform.runLater(() -> currentDirectoryLabel.setText(newDirectory.getAbsolutePath()));
                    }
                }));
            }
            if (!tabLabel.equalsIgnoreCase("Advanced")) continue;
            currentDirectory = DirectoryManager.getIgvDirectory().getAbsolutePath();
            currentDirectoryLabel = new Label("IGV Directory: " + currentDirectory);
            moveButton = new Button("Move...");
            gridPane.add((Node)currentDirectoryLabel, 1, ++row);
            GridPane.setHalignment((Node)moveButton, (HPos)HPos.RIGHT);
            gridPane.add((Node)moveButton, 2, row);
            moveButton.setOnAction(event -> UIUtilities.invokeOnEventThread(() -> {
                File igvDirectory = DirectoryManager.getIgvDirectory();
                File newDirectory = FileDialogUtils.chooseDirectory("Select IGV directory", DirectoryManager.getUserDirectory());
                if (newDirectory != null && !newDirectory.equals(igvDirectory)) {
                    DirectoryManager.moveIGVDirectory(newDirectory);
                    Platform.runLater(() -> currentDirectoryLabel.setText(newDirectory.getAbsolutePath()));
                }
            }));
        }
        HBox hbox = new HBox();
        hbox.setAlignment(Pos.CENTER_RIGHT);
        hbox.setPadding(new Insets(15.0, 12.0, 15.0, 12.0));
        hbox.setSpacing(5.0);
        hbox.setStyle("-fx-background-color: #336699;");
        Button cancelBUtton = new Button("Cancel");
        cancelBUtton.setPrefSize(100.0, 20.0);
        cancelBUtton.setOnAction(event -> SwingUtilities.invokeLater(() -> parent.setVisible(false)));
        Button saveButton = new Button("Save");
        saveButton.setPrefSize(100.0, 20.0);
        saveButton.setDefaultButton(true);
        saveButton.setOnAction(event -> {
            PreferencesManager.updateAll(updatedPreferencesMap);
            SwingUtilities.invokeLater(() -> parent.setVisible(false));
            if (IGV.hasInstance()) {
                IGV.getInstance().doRefresh();
            }
        });
        hbox.getChildren().addAll((Object[])new Node[]{cancelBUtton, saveButton});
        borderPane.setBottom((Node)hbox);
        fxPanel.setScene(scene);
    }

    private static boolean validate(String text, String type) {
        if (type.equals("integer")) {
            try {
                Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (type.equals("float")) {
            try {
                Double.parseDouble(text);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }
}

