/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.file;

import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.file.FileURLConnection;

public class Handler
extends URLStreamHandler {
    private String getHost(URL uRL) {
        String string = uRL.getHost();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    protected void parseURL(URL uRL, String string, int n, int n2) {
        super.parseURL(uRL, string.replace(File.separatorChar, '/'), n, n2);
    }

    @Override
    public synchronized URLConnection openConnection(URL uRL) throws IOException {
        return this.openConnection(uRL, null);
    }

    @Override
    public synchronized URLConnection openConnection(URL uRL, Proxy proxy) throws IOException {
        URLConnection uRLConnection;
        String string = uRL.getFile();
        String string2 = uRL.getHost();
        String string3 = ParseUtil.decode(string);
        string3 = string3.replace('/', '\\');
        string3 = string3.replace('|', ':');
        if (string2 == null || string2.equals("") || string2.equalsIgnoreCase("localhost") || string2.equals("~")) {
            return this.createFileURLConnection(uRL, new File(string3));
        }
        string3 = "\\\\" + string2 + string3;
        File file = new File(string3);
        if (file.exists()) {
            return this.createFileURLConnection(uRL, file);
        }
        try {
            URL uRL2 = new URL("ftp", string2, string + (uRL.getRef() == null ? "" : "#" + uRL.getRef()));
            uRLConnection = proxy != null ? uRL2.openConnection(proxy) : uRL2.openConnection();
        }
        catch (IOException iOException) {
            uRLConnection = null;
        }
        if (uRLConnection == null) {
            throw new IOException("Unable to connect to: " + uRL.toExternalForm());
        }
        return uRLConnection;
    }

    protected URLConnection createFileURLConnection(URL uRL, File file) {
        return new FileURLConnection(uRL, file);
    }

    @Override
    protected boolean hostsEqual(URL uRL, URL uRL2) {
        String string = uRL.getHost();
        String string2 = uRL2.getHost();
        if ("localhost".equalsIgnoreCase(string) && (string2 == null || "".equals(string2))) {
            return true;
        }
        if ("localhost".equalsIgnoreCase(string2) && (string == null || "".equals(string))) {
            return true;
        }
        return super.hostsEqual(uRL, uRL2);
    }
}

