/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.fakers.FileFaker;

public class PerTileFileUtil
extends ParameterizedFileUtil {
    private final IlluminaFileMap fileMap;

    public PerTileFileUtil(String extension, File base, FileFaker faker, int lane) {
        super(true, extension, base, faker, lane);
        this.fileMap = this.getTiledFiles(base, this.matchPattern);
        this.tiles = this.fileMap.size() > 0 ? Collections.unmodifiableList(new ArrayList(this.fileMap.keySet())) : new ArrayList();
    }

    @Override
    public boolean filesAvailable() {
        return !this.fileMap.isEmpty();
    }

    public IlluminaFileMap getFiles() {
        return this.fileMap;
    }

    public IlluminaFileMap getFiles(List<Integer> tiles) {
        return this.fileMap.keep(tiles);
    }

    @Override
    public List<String> verify(List<Integer> expectedTiles, int[] expectedCycles) {
        LinkedList<String> failures = new LinkedList<String>();
        if (!this.base.exists()) {
            failures.add("Base directory(" + this.base.getAbsolutePath() + ") does not exist!");
        } else if (!this.tiles.containsAll(expectedTiles)) {
            ArrayList<Integer> missing = new ArrayList<Integer>(expectedTiles);
            missing.removeAll(this.tiles);
            failures.add("Missing tile " + missing + " for file type " + this.extension + ".");
        }
        return failures;
    }

    @Override
    public List<String> fakeFiles(List<Integer> expectedTiles, int[] cycles, IlluminaFileUtil.SupportedIlluminaFormat format) {
        LinkedList<String> failures = new LinkedList<String>();
        if (!this.base.exists()) {
            failures.add("Base directory(" + this.base.getAbsolutePath() + ") does not exist!");
        } else {
            for (Integer tile : expectedTiles) {
                if (this.tiles.contains(tile) && ((File)this.fileMap.get(tile)).length() != 0L) continue;
                try {
                    this.faker.fakeFile(this.base, tile, this.lane, this.extension);
                }
                catch (IOException e2) {
                    failures.add(String.format("Could not create fake file %s: %s", this.fileMap.get(tile), e2.getMessage()));
                }
            }
        }
        return failures;
    }
}

