/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.IOException;
import java.io.OutputStream;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyCodec;
import org.xerial.snappy.buffer.BufferAllocator;
import org.xerial.snappy.buffer.BufferAllocatorFactory;
import org.xerial.snappy.buffer.CachedBufferAllocator;

public class SnappyOutputStream
extends OutputStream {
    static final int MIN_BLOCK_SIZE = 1024;
    static final int DEFAULT_BLOCK_SIZE = 32768;
    protected final OutputStream out;
    private final int blockSize;
    private final BufferAllocator inputBufferAllocator;
    private final BufferAllocator outputBufferAllocator;
    protected byte[] inputBuffer;
    protected byte[] outputBuffer;
    private int inputCursor = 0;
    private int outputCursor = 0;
    private boolean closed;

    public SnappyOutputStream(OutputStream outputStream) {
        this(outputStream, 32768);
    }

    public SnappyOutputStream(OutputStream outputStream, int n2) {
        this(outputStream, n2, CachedBufferAllocator.getBufferAllocatorFactory());
    }

    public SnappyOutputStream(OutputStream outputStream, int n2, BufferAllocatorFactory bufferAllocatorFactory) {
        this.out = outputStream;
        this.blockSize = Math.max(1024, n2);
        int n3 = n2;
        int n4 = SnappyCodec.HEADER_SIZE + 4 + Snappy.maxCompressedLength(n2);
        this.inputBufferAllocator = bufferAllocatorFactory.getBufferAllocator(n3);
        this.outputBufferAllocator = bufferAllocatorFactory.getBufferAllocator(n4);
        this.inputBuffer = this.inputBufferAllocator.allocate(n3);
        this.outputBuffer = this.outputBufferAllocator.allocate(n4);
        this.outputCursor = SnappyCodec.currentHeader.writeHeader(this.outputBuffer, 0);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        for (int i2 = 0; i2 < n3; i2 += n4) {
            n4 = Math.min(n3 - i2, this.blockSize - this.inputCursor);
            if (n4 > 0) {
                System.arraycopy(byArray, n2 + i2, this.inputBuffer, this.inputCursor, n4);
                this.inputCursor += n4;
            }
            if (this.inputCursor < this.blockSize) {
                return;
            }
            this.compressInput();
        }
    }

    public void write(long[] lArray, int n2, int n3) throws IOException {
        this.rawWrite(lArray, n2 * 8, n3 * 8);
    }

    public void write(double[] dArray, int n2, int n3) throws IOException {
        this.rawWrite(dArray, n2 * 8, n3 * 8);
    }

    public void write(float[] fArray, int n2, int n3) throws IOException {
        this.rawWrite(fArray, n2 * 4, n3 * 4);
    }

    public void write(int[] nArray, int n2, int n3) throws IOException {
        this.rawWrite(nArray, n2 * 4, n3 * 4);
    }

    public void write(short[] sArray, int n2, int n3) throws IOException {
        this.rawWrite(sArray, n2 * 2, n3 * 2);
    }

    public void write(long[] lArray) throws IOException {
        this.write(lArray, 0, lArray.length);
    }

    public void write(double[] dArray) throws IOException {
        this.write(dArray, 0, dArray.length);
    }

    public void write(float[] fArray) throws IOException {
        this.write(fArray, 0, fArray.length);
    }

    public void write(int[] nArray) throws IOException {
        this.write(nArray, 0, nArray.length);
    }

    public void write(short[] sArray) throws IOException {
        this.write(sArray, 0, sArray.length);
    }

    private boolean hasSufficientOutputBufferFor(int n2) {
        int n3 = Snappy.maxCompressedLength(n2);
        return n3 < this.outputBuffer.length - this.outputCursor - 4;
    }

    public void rawWrite(Object object, int n2, int n3) throws IOException {
        int n4;
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        for (int i2 = 0; i2 < n3; i2 += n4) {
            n4 = Math.min(n3 - i2, this.blockSize - this.inputCursor);
            if (n4 > 0) {
                Snappy.arrayCopy(object, n2 + i2, n4, this.inputBuffer, this.inputCursor);
                this.inputCursor += n4;
            }
            if (this.inputCursor < this.blockSize) {
                return;
            }
            this.compressInput();
        }
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.inputCursor >= this.inputBuffer.length) {
            this.compressInput();
        }
        this.inputBuffer[this.inputCursor++] = (byte)n2;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.compressInput();
        this.dumpOutput();
        this.out.flush();
    }

    static void writeInt(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)(n3 >> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n3 >> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n3 >> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n3 >> 0 & 0xFF);
    }

    static int readInt(byte[] byArray, int n2) {
        int n3 = (byArray[n2] & 0xFF) << 24;
        int n4 = (byArray[n2 + 1] & 0xFF) << 16;
        int n5 = (byArray[n2 + 2] & 0xFF) << 8;
        int n6 = byArray[n2 + 3] & 0xFF;
        return n3 | n4 | n5 | n6;
    }

    protected void dumpOutput() throws IOException {
        if (this.outputCursor > 0) {
            this.out.write(this.outputBuffer, 0, this.outputCursor);
            this.outputCursor = 0;
        }
    }

    protected void compressInput() throws IOException {
        if (this.inputCursor <= 0) {
            return;
        }
        if (!this.hasSufficientOutputBufferFor(this.inputCursor)) {
            this.dumpOutput();
        }
        int n2 = Snappy.compress(this.inputBuffer, 0, this.inputCursor, this.outputBuffer, this.outputCursor + 4);
        SnappyOutputStream.writeInt(this.outputBuffer, this.outputCursor, n2);
        this.outputCursor += 4 + n2;
        this.inputCursor = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.flush();
            this.out.close();
        }
        finally {
            this.closed = true;
            this.inputBufferAllocator.release(this.inputBuffer);
            this.outputBufferAllocator.release(this.outputBuffer);
            this.inputBuffer = null;
            this.outputBuffer = null;
        }
    }
}

