/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant.New;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.readers.LineIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.variant.New.Variant;

public class VariantCodec
extends AsciiFeatureCodec<Variant> {
    private static Logger log = Logger.getLogger(VariantCodec.class);
    Genome genome;
    VCFHeader header;

    protected VariantCodec(Genome genome, ResourceLocator locator) throws IOException {
        super(Variant.class);
        this.genome = genome;
        BufferedReader reader = ParsingUtils.openBufferedReader(locator);
        this.header = this.parseHeader(reader);
    }

    @Override
    public Variant decode(String line) {
        String[] tokens = Globals.tabPattern.split(line);
        if (tokens.length > 7) {
            Variant variant = new Variant();
            variant.chr = this.genome == null ? tokens[0] : this.genome.getCanonicalChrName(tokens[0]);
            variant.pos = Integer.parseInt(tokens[1]) - 1;
            variant.names = tokens[2];
            variant.referenceBases = tokens[3];
            variant.alternateBases = tokens[4];
            variant.quality = Integer.parseInt(tokens[5]);
            variant.filter = tokens[6];
            variant.info = tokens[7];
            String[] altTokens = variant.alternateBases.split(",");
            variant.alleles = new String[altTokens.length + 1];
            variant.alleles[0] = variant.referenceBases;
            for (int i2 = 0; i2 < altTokens.length; ++i2) {
                variant.alleles[i2 + 1] = altTokens[i2];
            }
            VariantCodec.computeStart(variant);
            return variant;
        }
        return null;
    }

    private static void computeStart(Variant variant) {
        if (variant.alleles.length > 1) {
            variant.start = variant.pos;
            variant.end = 0;
            int refBasesLength = variant.alleles[0].length();
            for (int i2 = 1; i2 < variant.alleles.length; ++i2) {
                int e2;
                int s2;
                int altLength = variant.alleles[i2].length();
                if (altLength <= 0) continue;
                int diff = refBasesLength - altLength;
                if (diff > 0) {
                    s2 = variant.pos + altLength;
                    e2 = s2 + diff;
                } else if (diff < 0) {
                    s2 = variant.pos + refBasesLength;
                    e2 = s2 + 1;
                } else {
                    s2 = variant.pos;
                    e2 = s2 + altLength;
                }
                variant.start = Math.min(variant.start, s2);
                variant.end = Math.max(variant.end, e2);
            }
        } else {
            variant.start = variant.pos - 1;
            variant.end = variant.pos;
        }
    }

    @Override
    public Object readActualHeader(LineIterator lineIterator) {
        return null;
    }

    @Override
    public boolean canDecode(String s2) {
        return false;
    }

    private VCFHeader parseHeader(BufferedReader reader) throws IOException {
        VCFHeader header = new VCFHeader();
        String line = reader.readLine();
        if (line != null && line.startsWith("##fileformat")) {
            header.version = line.substring(13);
        } else {
            throw new Error("Invalid VCF file: missing fileformat line");
        }
        while ((line = reader.readLine()) != null && line.startsWith("#")) {
            if (line.startsWith("##")) {
                if (!line.startsWith("##INFO") && !line.startsWith("##FILTER") && !line.startsWith("##FORMAT")) continue;
                int ltIdx = line.indexOf("<");
                int gtIdx = line.lastIndexOf(">");
                if (ltIdx <= 2 || gtIdx <= 0) {
                    log.error("Malformed VCF header line: " + line);
                    continue;
                }
                String type = line.substring(2, ltIdx - 1);
                List<String> tokens = StringUtils.breakQuotedString(line.substring(ltIdx + 1, gtIdx - 1), ',');
                String id = null;
                HashMap<String, String> values = new HashMap<String, String>();
                for (String token : tokens) {
                    String[] kv = token.split("=");
                    if (kv.length <= 1) continue;
                    if ("ID".equals(kv[0])) {
                        id = kv[1];
                        continue;
                    }
                    values.put(kv[0], kv[1]);
                }
                if (id == null) continue;
                header.addMetaInfo(type, id, values);
                continue;
            }
            if (!line.startsWith("#CHROM")) continue;
            String[] tokens = line.split("\t");
            if (tokens.length <= 8) break;
            header.callSetNames = new HashMap<Integer, String>();
            for (int j2 = 9; j2 < tokens.length; ++j2) {
                header.callSetNames.put(j2, tokens[j2]);
            }
        }
        return header;
    }

    static class VCFHeader {
        String version;
        Map<String, Map<String, String>> infoFields = new HashMap<String, Map<String, String>>();
        Map<String, Map<String, String>> formatFields = new HashMap<String, Map<String, String>>();
        Map<String, Map<String, String>> filterFields = new HashMap<String, Map<String, String>>();
        Map<Integer, String> callSetNames;

        public void addMetaInfo(String type, String id, Map<String, String> info) {
            Map<String, Map<String, String>> dict;
            if ("##INFO".equals(type)) {
                dict = this.infoFields;
            } else if ("##FORMAT".equals(type)) {
                dict = this.formatFields;
            } else if ("##FILTER".equals(type)) {
                dict = this.filterFields;
            } else {
                return;
            }
            dict.put(type, info);
        }
    }
}

