/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import com.google.common.base.Objects;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.event.DataLoadedEvent;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.AbstractDataPanelTool;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.panel.ClickTaskScheduler;
import org.broad.igv.ui.panel.DataPanelContainer;
import org.broad.igv.ui.panel.DataPanelPainter;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.PanTool;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.RegionOfInterestPanel;
import org.broad.igv.ui.panel.RegionOfInterestTool;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.util.DataPanelTool;

public class DataPanel
extends JComponent
implements Paintable,
IGVEventObserver {
    private static Logger log = Logger.getLogger(DataPanel.class);
    private static final ExecutorService threadExecutor = Executors.newFixedThreadPool(5);
    private boolean isWaitingForToolTipText = false;
    private DataPanelTool defaultTool;
    private DataPanelTool currentTool;
    private ReferenceFrame frame;
    private DataPanelContainer parent;
    private DataPanelPainter painter;
    private String tooltipText = "";
    private boolean loadInProgress = false;
    static DecimalFormat locationFormatter = new DecimalFormat();

    public DataPanel(ReferenceFrame frame, DataPanelContainer parent) {
        this.init();
        this.currentTool = this.defaultTool = new PanTool(this);
        this.frame = frame;
        this.parent = parent;
        this.setFocusable(true);
        this.setAutoscrolls(true);
        this.setToolTipText("");
        this.painter = new DataPanelPainter();
        this.setBackground(PreferencesManager.getPreferences().getAsColor("BACKGROUND_COLOR"));
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void receiveEvent(Object event) {
        if (event instanceof DataLoadedEvent && ((DataLoadedEvent)event).referenceFrame == this.frame) {
            log.info("Data loaded repaint " + this.frame);
            this.repaint();
        }
    }

    public JScrollBar getVerticalScrollbar() {
        Container sp;
        for (sp = this.getParent(); sp != null && !(sp instanceof JScrollPane); sp = sp.getParent()) {
        }
        return sp == null ? null : ((JScrollPane)sp).getVerticalScrollBar();
    }

    public void setCurrentTool(AbstractDataPanelTool tool) {
        DataPanelTool dataPanelTool = this.currentTool = tool == null ? this.defaultTool : tool;
        if (this.currentTool != null) {
            this.setCursor(this.currentTool.getCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        RenderContext context = null;
        try {
            int startLoc;
            long t0 = System.currentTimeMillis();
            if (!this.allTracksLoaded()) {
                if (!this.loadInProgress) {
                    this.loadInProgress = true;
                    this.load();
                }
                if (!Globals.isBatch()) {
                    return;
                }
            }
            Rectangle clipBounds = g2.getClipBounds();
            Rectangle visibleRect = this.getVisibleRect();
            Rectangle damageRect = clipBounds == null ? visibleRect : clipBounds.intersection(visibleRect);
            Graphics2D graphics2D = (Graphics2D)g2;
            context = new RenderContext(this, graphics2D, this.frame, visibleRect);
            Collection<TrackGroup> groups = this.parent.getTrackGroups();
            int trackWidth = this.getWidth();
            this.computeMousableRegions(groups, trackWidth);
            this.painter.paint(groups, context, trackWidth, this.getBackground(), damageRect);
            if (this.currentTool instanceof RegionOfInterestTool && (startLoc = ((RegionOfInterestTool)this.currentTool).getRoiStart()) > 0) {
                int start = this.frame.getScreenPosition(startLoc);
                g2.setColor(Color.BLACK);
                graphics2D.drawLine(start, 0, start, this.getHeight());
            }
            this.drawAllRegions(g2);
            long dt = System.currentTimeMillis() - t0;
            PanTool.repaintTime(dt);
        }
        finally {
            if (context != null) {
                context.dispose();
            }
        }
    }

    public boolean allTracksLoaded() {
        return this.parent.getTrackGroups().stream().filter(TrackGroup::isVisible).flatMap(trackGroup -> trackGroup.getVisibleTracks().stream()).allMatch(track -> track.isReadyToPaint(this.frame));
    }

    public List<Track> visibleTracks() {
        return this.parent.getTrackGroups().stream().filter(TrackGroup::isVisible).flatMap(trackGroup -> trackGroup.getVisibleTracks().stream()).collect(Collectors.toList());
    }

    private void load() {
        ReferenceFrame frame = this.getFrame();
        List<Track> trackList = this.visibleTracks();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(trackList.size());
        boolean batchLoaded = false;
        for (Track track : trackList) {
            if (track.isReadyToPaint(frame)) continue;
            Runnable runnable = () -> track.load(frame);
            if (Globals.isBatch()) {
                runnable.run();
                batchLoaded = true;
                continue;
            }
            futures.add(CompletableFuture.runAsync(runnable, threadExecutor));
        }
        if (futures.size() > 0 || batchLoaded) {
            CompletableFuture[] futureArray = futures.toArray(new CompletableFuture[futures.size()]);
            WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
            ((CompletableFuture)CompletableFuture.allOf(futureArray).thenRun(() -> {
                this.loadInProgress = false;
                WaitCursorManager.removeWaitCursor(token);
                this.repaint();
            })).exceptionally(e2 -> {
                log.error("Error: ", (Throwable)e2);
                this.loadInProgress = false;
                WaitCursorManager.removeWaitCursor(token);
                return null;
            });
        }
    }

    private void computeMousableRegions(Collection<TrackGroup> groups, int width) {
        List<MouseableRegion> mouseableRegions = this.parent.getMouseRegions();
        mouseableRegions.clear();
        int trackX = 0;
        int trackY = 0;
        for (TrackGroup group : groups) {
            if (!group.isVisible()) continue;
            if (groups.size() > 1) {
                trackY += 10;
            }
            List<Track> trackList = group.getVisibleTracks();
            for (Track track : trackList) {
                if (track == null) continue;
                int trackHeight = track.getHeight();
                if (!track.isVisible()) continue;
                Rectangle rect = new Rectangle(trackX, trackY, width, trackHeight);
                if (mouseableRegions != null) {
                    mouseableRegions.add(new MouseableRegion(rect, track));
                }
                trackY += trackHeight;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintOffscreen(Graphics2D g2, Rectangle rect) {
        RenderContext context = null;
        try {
            context = new RenderContext(null, g2, this.frame, rect);
            ArrayList<TrackGroup> groups = new ArrayList<TrackGroup>(this.parent.getTrackGroups());
            int width = rect.width;
            this.painter.paint(groups, context, width, this.getBackground(), rect);
            this.drawAllRegions(g2);
            Color c2 = g2.getColor();
            g2.setColor(Color.darkGray);
            g2.drawRect(rect.x, rect.y, rect.width, rect.height);
            g2.setColor(c2);
        }
        finally {
            if (context != null) {
                context.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawAllRegions(Graphics g2) {
        Collection<RegionOfInterest> regions = IGV.getInstance().getSession().getRegionsOfInterest(this.frame.getChrName());
        if (regions == null || regions.isEmpty()) {
            return;
        }
        boolean drawBars = PreferencesManager.getPreferences().getAsBoolean("SHOW_REGION_BARS");
        Graphics2D graphics2D = (Graphics2D)g2.create();
        try {
            for (RegionOfInterest regionOfInterest : regions) {
                if (!drawBars && regionOfInterest != RegionOfInterestPanel.getSelectedRegion()) continue;
                this.drawRegion(graphics2D, regionOfInterest);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    private boolean drawRegion(Graphics2D graphics2D, RegionOfInterest regionOfInterest) {
        Integer regionStart = regionOfInterest.getStart();
        if (regionStart == null) {
            return true;
        }
        Integer regionEnd = regionOfInterest.getEnd();
        if (regionEnd == null) {
            regionEnd = regionStart;
        }
        ReferenceFrame referenceFrame = this.frame;
        int start = referenceFrame.getScreenPosition(regionStart.intValue());
        int end = referenceFrame.getScreenPosition(regionEnd.intValue());
        int height = this.getHeight();
        graphics2D.setColor(regionOfInterest.getForegroundColor());
        graphics2D.drawLine(start, 0, start, height);
        graphics2D.drawLine(end, 0, end, height);
        return false;
    }

    protected String generateTileKey(String chr, int t2, int zoomLevel) {
        String key = chr + "_z_" + zoomLevel + "_t_" + t2;
        return key;
    }

    public void debugDump(String trackName) {
        TrackPanel trackView = (TrackPanel)this.getParent();
        if (trackView == null) {
            return;
        }
        if (trackView.hasTracks()) {
            String name = this.parent.getTrackSetID().toString();
            System.out.println("\n\n" + name + " Track COUNT:" + trackView.getTracks().size());
            System.out.println("\t\t\t\t" + name + " scrollpane height     = " + trackView.getScrollPane().getHeight());
            System.out.println("\t\t\t\t" + name + " viewport height       = " + trackView.getViewportHeight());
            System.out.println("\t\t\t\t" + name + " TrackView min height  = " + trackView.getMinimumSize().getHeight());
            System.out.println("\t\t\t\t" + name + " TrackView pref height = " + trackView.getPreferredSize().getHeight());
            System.out.println("\t\t\t\t" + name + " TrackView height      = " + trackView.getSize().getHeight());
        }
    }

    public Track getTrack(int x2, int y) {
        for (MouseableRegion mouseRegion : this.parent.getMouseRegions()) {
            if (!mouseRegion.containsPoint(x2, y)) continue;
            return mouseRegion.getTracks().iterator().next();
        }
        return null;
    }

    @Override
    public void setToolTipText(String text) {
        if (!Objects.equal(this.tooltipText, text)) {
            IGV.getInstance().setStatusWindowText(text);
            this.tooltipText = text;
            this.putClientProperty("ToolTipText", text);
        }
    }

    @Override
    public final String getToolTipText() {
        if (this.currentTool instanceof RegionOfInterestTool) {
            return null;
        }
        return this.tooltipText;
    }

    public void updateTooltipText(int x2, int y) {
        if (!IGV.getInstance().isShowDetailsOnHover()) {
            this.setToolTipText(null);
            return;
        }
        double position = this.frame.getChromosomePosition(x2);
        Track track = null;
        List<MouseableRegion> regions = this.parent.getMouseRegions();
        StringBuffer popupTextBuffer = new StringBuffer();
        popupTextBuffer.append("<html>");
        for (MouseableRegion mouseRegion : regions) {
            String valueString;
            if (!mouseRegion.containsPoint(x2, y) || (track = mouseRegion.getTracks().iterator().next()) == null) continue;
            List<Track> overlays = IGV.getInstance().getOverlayTracks(track);
            boolean foundOverlaidFeature = false;
            if (overlays != null) {
                for (Track overlay : overlays) {
                    String valueString2;
                    if (overlay == track || overlay.getValueStringAt(this.frame.getChrName(), position, x2, y, this.frame) == null || (valueString2 = overlay.getValueStringAt(this.frame.getChrName(), position, x2, y, this.frame)) == null) continue;
                    popupTextBuffer.append(valueString2);
                    popupTextBuffer.append("<br>");
                    foundOverlaidFeature = true;
                    break;
                }
            }
            if (foundOverlaidFeature || (valueString = track.getValueStringAt(this.frame.getChrName(), position, x2, y, this.frame)) == null) continue;
            if (foundOverlaidFeature) {
                popupTextBuffer.append("---------------------<br>");
            }
            popupTextBuffer.append(valueString);
            popupTextBuffer.append("<br>");
            break;
        }
        if (popupTextBuffer.length() > 6) {
            String puText = popupTextBuffer.toString().trim();
            if (!puText.equals(this.tooltipText)) {
                this.setToolTipText(puText);
            }
        } else {
            this.setToolTipText(null);
        }
    }

    private void init() {
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setRequestFocusEnabled(false);
        KeyAdapter keyAdapter = new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e2) {
                int shiftOriginPixels = Integer.MIN_VALUE;
                int zoomIncr = Integer.MIN_VALUE;
                boolean showWaitCursor = false;
                if (e2.getKeyChar() == '+' || e2.getKeyCode() == 521) {
                    zoomIncr = 1;
                    showWaitCursor = true;
                } else if (e2.getKeyChar() == '-' || e2.getKeyCode() == 521) {
                    zoomIncr = -1;
                    showWaitCursor = true;
                } else if (e2.getKeyCode() == 39) {
                    shiftOriginPixels = 50;
                } else if (e2.getKeyCode() == 37) {
                    shiftOriginPixels = -50;
                } else if (e2.getKeyCode() == 36) {
                    shiftOriginPixels = -DataPanel.this.getWidth();
                    showWaitCursor = true;
                } else if (e2.getKeyCode() == 35) {
                    shiftOriginPixels = DataPanel.this.getWidth();
                    showWaitCursor = true;
                } else if (e2.getKeyCode() == 521 || e2.getKeyCode() == 45) {
                    // empty if block
                }
                WaitCursorManager.CursorToken token = null;
                if (showWaitCursor) {
                    token = WaitCursorManager.showWaitCursor();
                }
                try {
                    if (zoomIncr > Integer.MIN_VALUE) {
                        DataPanel.this.frame.doZoomIncrement(zoomIncr);
                    } else if (shiftOriginPixels > Integer.MIN_VALUE) {
                        DataPanel.this.frame.shiftOriginPixels(shiftOriginPixels);
                    } else {
                        return;
                    }
                    if (showWaitCursor) {
                        DataPanel.this.frame.recordHistory();
                    }
                }
                finally {
                    if (token != null) {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                }
            }
        };
        this.addKeyListener(keyAdapter);
        DataPanelMouseAdapter mouseAdapter = new DataPanelMouseAdapter();
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
        this.addMouseWheelListener(mouseAdapter);
    }

    protected void removeMousableRegions() {
        this.parent.getMouseRegions().clear();
    }

    public ReferenceFrame getFrame() {
        return this.frame;
    }

    public class PopupTextUpdater {
        private TimerTask currentClickTask;

        public void cancelClickTask() {
            if (this.currentClickTask != null) {
                this.currentClickTask.cancel();
                this.currentClickTask = null;
            }
        }

        public void scheduleUpdateTask(TimerTask task) {
            this.cancelClickTask();
            this.currentClickTask = task;
            new Timer().schedule(this.currentClickTask, UIConstants.getDoubleClickInterval());
        }
    }

    class DataPanelMouseAdapter
    extends MouseInputAdapter {
        private ClickTaskScheduler clickScheduler = new ClickTaskScheduler();
        long lastClickTime = 0L;

        DataPanelMouseAdapter() {
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            String position = null;
            if (!DataPanel.this.frame.getChrName().equals("All")) {
                int location = (int)DataPanel.this.frame.getChromosomePosition(e2.getX()) + 1;
                position = DataPanel.this.frame.getChrName() + ":" + locationFormatter.format(location);
                IGV.getInstance().setStatusBarMessag2(position);
            }
            DataPanel.this.updateTooltipText(e2.getX(), e2.getY());
            if (IGV.getInstance().isRulerEnabled()) {
                IGV.getInstance().revalidateTrackPanels();
            }
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (SwingUtilities.getWindowAncestor(DataPanel.this).isActive()) {
                DataPanel.this.requestFocus();
            }
            if (e2.isPopupTrigger()) {
                this.doPopupMenu(e2);
            } else if (DataPanel.this.currentTool != null) {
                DataPanel.this.currentTool.mousePressed(e2);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (e2.isPopupTrigger()) {
                this.doPopupMenu(e2);
            } else if (DataPanel.this.currentTool != null) {
                DataPanel.this.currentTool.mouseReleased(e2);
            }
        }

        private void doPopupMenu(MouseEvent e2) {
            IGV.getInstance().clearSelections();
            DataPanel.this.parent.selectTracks(e2);
            TrackClickEvent te = new TrackClickEvent(e2, DataPanel.this.frame);
            DataPanel.this.parent.openPopupMenu(te);
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            if (DataPanel.this.currentTool != null) {
                DataPanel.this.currentTool.mouseDragged(e2);
            }
        }

        @Override
        public void mouseClicked(final MouseEvent e2) {
            long clickTime = System.currentTimeMillis();
            if (Globals.IS_MAC && e2.isControlDown()) {
                return;
            }
            if (DataPanel.this.currentTool instanceof RegionOfInterestTool) {
                DataPanel.this.currentTool.mouseClicked(e2);
                e2.consume();
                return;
            }
            if (e2.isPopupTrigger()) {
                this.doPopupMenu(e2);
                e2.consume();
                return;
            }
            Object source = e2.getSource();
            if (source instanceof DataPanel && e2.getButton() == 1) {
                final Track track = ((DataPanel)e2.getSource()).getTrack(e2.getX(), e2.getY());
                if (e2.isShiftDown()) {
                    double locationClicked = DataPanel.this.frame.getChromosomePosition(e2.getX());
                    DataPanel.this.frame.doIncrementZoom(3, locationClicked);
                    e2.consume();
                } else if (e2.isAltDown()) {
                    double locationClicked = DataPanel.this.frame.getChromosomePosition(e2.getX());
                    DataPanel.this.frame.doIncrementZoom(-1, locationClicked);
                    e2.consume();
                } else if ((e2.isMetaDown() || e2.isControlDown()) && track != null) {
                    TrackClickEvent te = new TrackClickEvent(e2, DataPanel.this.frame);
                    if (track.handleDataClick(te)) {
                        e2.consume();
                        return;
                    }
                } else if (clickTime - this.lastClickTime < (long)UIConstants.getDoubleClickInterval()) {
                    this.clickScheduler.cancelClickTask();
                    double locationClicked = DataPanel.this.frame.getChromosomePosition(e2.getX());
                    DataPanel.this.frame.doIncrementZoom(1, locationClicked);
                } else {
                    this.lastClickTime = clickTime;
                    TimerTask clickTask = new TimerTask(){

                        @Override
                        public void run() {
                            Object source = e2.getSource();
                            if (source instanceof DataPanel && track != null) {
                                TrackClickEvent te = new TrackClickEvent(e2, DataPanel.this.frame);
                                List<Track> overlays = IGV.getInstance().getOverlayTracks(track);
                                boolean handled = false;
                                if (overlays != null) {
                                    for (Track overlay : overlays) {
                                        if (overlay.getFeatureAtMousePosition(te) == null) continue;
                                        overlay.handleDataClick(te);
                                        handled = true;
                                    }
                                }
                                if (!handled) {
                                    handled = track.handleDataClick(te);
                                }
                                if (handled) {
                                    return;
                                }
                                if (DataPanel.this.currentTool != null) {
                                    DataPanel.this.currentTool.mouseClicked(e2);
                                }
                            }
                        }
                    };
                    this.clickScheduler.scheduleClickTask(clickTask);
                }
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e2) {
            if (e2.isControlDown() || e2.isMetaDown()) {
                int wheelRotation = e2.getWheelRotation();
                int zoomIncr = -wheelRotation / 2;
                DataPanel.this.getFrame().doZoomIncrement(zoomIncr);
            } else {
                e2.getComponent().getParent().dispatchEvent(e2);
            }
        }
    }
}

