/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.lists.GeneList;
import org.broad.igv.lists.GeneListManager;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.renderer.ColorScaleFactory;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.MergedTracks;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.TrackFilter;
import org.broad.igv.ui.TrackFilterElement;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelScrollPane;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.FilterElement;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.collections.CollUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IGVSessionReader
implements SessionReader {
    private static Logger log = Logger.getLogger(IGVSessionReader.class);
    private static String INPUT_FILE_KEY = "INPUT_FILE_KEY";
    Collection<ResourceLocator> dataFiles;
    private Collection<ResourceLocator> missingDataFiles;
    private static Map<String, String> attributeSynonymMap = new HashMap<String, String>();
    private boolean panelElementPresent = false;
    private int version;
    private IGV igv;
    private static WeakReference<IGVSessionReader> currentReader;
    private static List<Class> registeredClasses;
    private final Map<String, List<Track>> leftoverTrackDictionary = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, List<Track>> allTracks = Collections.synchronizedMap(new LinkedHashMap());
    private String rootPath;
    Map<String, String> fullToRelPathMap = new HashMap<String, String>();
    private Track geneTrack = null;
    private Track seqTrack = null;
    private boolean hasTrackElments;
    protected static AbstractTrack nextTrack;
    private int panelCounter = 1;
    private static JAXBContext jc;

    public List<Track> getTracksById(String trackId) {
        return this.allTracks.get(trackId);
    }

    public IGVSessionReader(IGV igv) {
        this.igv = igv;
        currentReader = new WeakReference<IGVSessionReader>(this);
    }

    @Override
    public void loadSession(InputStream inputStream, Session session, String sessionPath) {
        log.debug("Load session");
        Document document = null;
        try {
            document = Utilities.createDOMDocumentFromXmlStream(inputStream);
        }
        catch (Exception e2) {
            log.error("Load session error", e2);
            throw new RuntimeException(e2);
        }
        NodeList tracks = document.getElementsByTagName("Track");
        this.hasTrackElments = tracks.getLength() > 0;
        HashMap<String, String> additionalInformation = new HashMap<String, String>();
        additionalInformation.put(INPUT_FILE_KEY, sessionPath);
        NodeList nodes = document.getElementsByTagName(SessionElement.SESSION.getText());
        if (nodes == null || nodes.getLength() == 0) {
            nodes = document.getElementsByTagName(SessionElement.GLOBAL.getText());
        }
        this.rootPath = sessionPath;
        this.processRootNode(session, nodes.item(0), additionalInformation, sessionPath);
        this.addLeftoverTracks(this.leftoverTrackDictionary.values());
        if (this.igv != null) {
            if (session.getGroupTracksBy() != null && session.getGroupTracksBy().length() > 0) {
                this.igv.setGroupByAttribute(session.getGroupTracksBy());
            }
            if (session.isRemoveEmptyPanels()) {
                this.igv.getMainPanel().removeEmptyDataPanels();
            }
            this.igv.resetOverlayTracks();
        }
    }

    private void processRootNode(Session session, Node node, HashMap additionalInformation, String rootPath) {
        String removeEmptyTracks;
        if (node == null || session == null) {
            MessageUtils.showMessage("Invalid session file: root node not found");
            return;
        }
        String nodeName = node.getNodeName();
        if (!nodeName.equalsIgnoreCase(SessionElement.GLOBAL.getText()) && !nodeName.equalsIgnoreCase(SessionElement.SESSION.getText())) {
            MessageUtils.showMessage("Session files must begin with a \"Global\" or \"Session\" element.  Found: " + nodeName);
            return;
        }
        Element element = (Element)node;
        String alternateRootPath = IGVSessionReader.getAttribute(element, SessionAttribute.PATH.getText());
        this.process(session, node, additionalInformation, rootPath, alternateRootPath);
        String versionString = IGVSessionReader.getAttribute(element, SessionAttribute.VERSION.getText());
        try {
            this.version = Integer.parseInt(versionString);
        }
        catch (NumberFormatException e2) {
            log.error("Non integer version number in session file: " + versionString);
        }
        String genomeId = IGVSessionReader.getAttribute(element, SessionAttribute.GENOME.getText());
        String hasGeneTrackStr = IGVSessionReader.getAttribute(element, SessionAttribute.HAS_GENE_TRACK.getText());
        boolean hasGeneTrack = true;
        if (hasGeneTrackStr != null) {
            hasGeneTrack = Boolean.parseBoolean(hasGeneTrackStr);
        }
        boolean hasSeqTrack = hasGeneTrack;
        String hasSeqTrackStr = IGVSessionReader.getAttribute(element, SessionAttribute.HAS_SEQ_TRACK.getText());
        if (hasSeqTrackStr != null) {
            hasSeqTrack = Boolean.parseBoolean(hasSeqTrackStr);
        }
        if (genomeId != null && genomeId.length() > 0) {
            if (genomeId.equals(GenomeManager.getInstance().getGenomeId())) {
                if (hasGeneTrack || hasSeqTrack) {
                    Genome genome = GenomeManager.getInstance().getCurrentGenome();
                    FeatureTrack geneTrack = hasGeneTrack ? genome.getGeneTrack() : null;
                    IGV.getInstance().setGenomeTracks(geneTrack);
                }
            } else {
                String sessionPath = session.getPath();
                try {
                    GenomeListItem item = GenomeListManager.getInstance().getGenomeListItem(genomeId);
                    if (item != null) {
                        GenomeManager.getInstance().loadGenome(item.getPath(), null);
                    } else {
                        String genomePath = genomeId;
                        if (!ParsingUtils.pathExists(genomePath)) {
                            genomePath = this.getAbsolutePath(genomeId, rootPath);
                        }
                        if (ParsingUtils.pathExists(genomePath)) {
                            GenomeManager.getInstance().loadGenome(genomePath, null);
                        } else {
                            MessageUtils.showMessage("Warning: Could not locate genome: " + genomeId);
                        }
                    }
                }
                catch (IOException e3) {
                    MessageUtils.showErrorMessage("Error loading genome: " + genomeId, e3);
                    log.error("Error loading genome: " + genomeId, e3);
                }
                session.setPath(sessionPath);
            }
        }
        if (!hasGeneTrack && this.igv.hasGeneTrack()) {
            this.igv.removeTracks(Arrays.asList(GenomeManager.getInstance().getCurrentGenome().getGeneTrack()));
            this.geneTrack = null;
        } else {
            this.geneTrack = GenomeManager.getInstance().getCurrentGenome().getGeneTrack();
            if (this.geneTrack != null) {
                this.allTracks.put(this.geneTrack.getId(), Arrays.asList(this.geneTrack));
            }
        }
        SequenceTrack tmpSeqTrack = this.igv.getSequenceTrack();
        if (hasSeqTrack && !this.igv.hasSequenceTrack()) {
            IGV.getInstance().setGenomeTracks(null);
        } else if (!hasSeqTrack && this.igv.hasSequenceTrack()) {
            this.igv.removeTracks(Arrays.asList(tmpSeqTrack));
            this.seqTrack = null;
        } else {
            this.seqTrack = tmpSeqTrack;
            if (this.seqTrack != null) {
                this.allTracks.put(this.seqTrack.getId(), Arrays.asList(this.seqTrack));
            }
        }
        session.setUcscId(IGVSessionReader.getAttribute(element, SessionAttribute.UCSC_ID.getText()));
        session.setLocus(IGVSessionReader.getAttribute(element, SessionAttribute.LOCUS.getText()));
        session.setGroupTracksBy(IGVSessionReader.getAttribute(element, SessionAttribute.GROUP_TRACKS_BY.getText()));
        String nextAutoscaleGroup = IGVSessionReader.getAttribute(element, SessionAttribute.NEXT_AUTOSCALE_GROUP.getText());
        if (nextAutoscaleGroup != null) {
            try {
                session.setNextAutoscaleGroup(Integer.parseInt(nextAutoscaleGroup));
            }
            catch (NumberFormatException e4) {
                log.error("Error setting next autoscale group", e4);
            }
        }
        if ((removeEmptyTracks = IGVSessionReader.getAttribute(element, "removeEmptyTracks")) != null) {
            try {
                Boolean b2 = Boolean.parseBoolean(removeEmptyTracks);
                session.setRemoveEmptyPanels(b2);
            }
            catch (Exception e5) {
                log.error("Error parsing removeEmptyTracks string: " + removeEmptyTracks, e5);
            }
        }
        session.setVersion(this.version);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation, rootPath, alternateRootPath);
    }

    private void addLeftoverTracks(Collection<List<Track>> tmp) {
        HashMap<String, TrackPanel> trackPanelCache = new HashMap<String, TrackPanel>();
        if (this.version < 3 || !this.panelElementPresent) {
            log.debug("Adding \"leftover\" tracks");
            List<Map<TrackPanelScrollPane, Integer>> trackPanelAttrs = null;
            if (IGV.hasInstance()) {
                trackPanelAttrs = IGV.getInstance().getTrackPanelAttrs();
            }
            for (List<Track> tracks : tmp) {
                for (Track track : tracks) {
                    if (track == this.geneTrack || track == this.seqTrack || track.getResourceLocator() == null) continue;
                    TrackPanel panel = (TrackPanel)trackPanelCache.get(track.getResourceLocator().getPath());
                    if (panel == null) {
                        panel = IGV.getInstance().getPanelFor(track.getResourceLocator());
                        trackPanelCache.put(track.getResourceLocator().getPath(), panel);
                    }
                    panel.addTrack(track);
                }
            }
            if (IGV.hasInstance()) {
                IGV.getInstance().resetPanelHeights(trackPanelAttrs.get(0), trackPanelAttrs.get(1));
            }
        }
    }

    private void process(Session session, Node element, HashMap additionalInformation, String rootPath, String alternateRootPath) {
        if (element == null || session == null) {
            return;
        }
        String nodeName = element.getNodeName();
        if (nodeName.equalsIgnoreCase(SessionElement.RESOURCES.getText()) || nodeName.equalsIgnoreCase(SessionElement.FILES.getText())) {
            this.processResources(session, (Element)element, additionalInformation, rootPath, alternateRootPath);
        } else if (nodeName.equalsIgnoreCase(SessionElement.RESOURCE.getText()) || nodeName.equalsIgnoreCase(SessionElement.DATA_FILE.getText())) {
            this.processResource(session, (Element)element, additionalInformation, rootPath, alternateRootPath);
        } else if (nodeName.equalsIgnoreCase(SessionElement.REGIONS.getText())) {
            this.processRegions(session, (Element)element, additionalInformation, rootPath, alternateRootPath);
        } else if (nodeName.equalsIgnoreCase(SessionElement.REGION.getText())) {
            this.processRegion(session, (Element)element, additionalInformation, rootPath, alternateRootPath);
        } else if (nodeName.equalsIgnoreCase(SessionElement.GENE_LIST.getText())) {
            this.processGeneList(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.FILTER.getText())) {
            this.processFilter(session, (Element)element, additionalInformation, rootPath, alternateRootPath);
        } else if (nodeName.equalsIgnoreCase(SessionElement.FILTER_ELEMENT.getText())) {
            this.processFilterElement(session, (Element)element, additionalInformation, rootPath, alternateRootPath);
        } else if (nodeName.equalsIgnoreCase(SessionElement.COLOR_SCALES.getText())) {
            this.processColorScales(session, (Element)element, additionalInformation, rootPath, alternateRootPath);
        } else if (nodeName.equalsIgnoreCase(SessionElement.COLOR_SCALE.getText())) {
            this.processColorScale(session, (Element)element, additionalInformation, rootPath, alternateRootPath);
        } else if (nodeName.equalsIgnoreCase(SessionElement.PREFERENCES.getText())) {
            this.processPreferences(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.DATA_TRACKS.getText()) || nodeName.equalsIgnoreCase(SessionElement.FEATURE_TRACKS.getText()) || nodeName.equalsIgnoreCase(SessionElement.PANEL.getText())) {
            this.processPanel(session, (Element)element, additionalInformation, rootPath, alternateRootPath);
        } else if (nodeName.equalsIgnoreCase(SessionElement.PANEL_LAYOUT.getText())) {
            this.processPanelLayout(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.HIDDEN_ATTRIBUTES.getText())) {
            this.processHiddenAttributes(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.VISIBLE_ATTRIBUTES.getText())) {
            this.processVisibleAttributes(session, (Element)element, additionalInformation);
        }
    }

    private void processResources(Session session, Element element, HashMap additionalInformation, String rootPath, String alternateRootPath) {
        this.dataFiles = new ArrayList<ResourceLocator>();
        this.missingDataFiles = new ArrayList<ResourceLocator>();
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation, rootPath, alternateRootPath);
        if (this.missingDataFiles.size() > 0) {
            StringBuffer message = new StringBuffer();
            message.append("<html>The following data file(s) could not be located.<ul>");
            for (ResourceLocator file : this.missingDataFiles) {
                if (file.getDBUrl() == null) {
                    message.append("<li>");
                    message.append(file.getPath());
                    message.append("</li>");
                    continue;
                }
                message.append("<li>Server: ");
                message.append(file.getDBUrl());
                message.append("  Path: ");
                message.append(file.getPath());
                message.append("</li>");
            }
            message.append("</ul>");
            message.append("Common reasons for this include: ");
            message.append("<ul><li>The session or data files have been moved.</li> ");
            message.append("<li>The data files are located on a drive that is not currently accessible.</li></ul>");
            message.append("</html>");
            MessageUtils.showMessage(message.toString());
        }
        if (this.dataFiles.size() > 0) {
            final ArrayList errors = new ArrayList();
            ArrayList<Thread> threads = new ArrayList<Thread>(this.dataFiles.size());
            long t0 = System.currentTimeMillis();
            int i2 = 0;
            ArrayList<1> synchronousLoads = new ArrayList<1>();
            for (final ResourceLocator resourceLocator : this.dataFiles) {
                boolean isAlignment;
                String suppliedPath = resourceLocator.getPath();
                String relPath = this.fullToRelPathMap.get(suppliedPath);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        List<Track> tracks = null;
                        try {
                            tracks = IGVSessionReader.this.igv.load(resourceLocator);
                            for (Track track : tracks) {
                                if (track == null) {
                                    log.info("Null track for resource " + resourceLocator.getPath());
                                    continue;
                                }
                                String id = track.getId();
                                if (id == null) {
                                    log.info("Null track id for resource " + resourceLocator.getPath());
                                    continue;
                                }
                                ArrayList<Track> trackList = (ArrayList<Track>)IGVSessionReader.this.leftoverTrackDictionary.get(id);
                                if (trackList == null) {
                                    trackList = new ArrayList<Track>();
                                    IGVSessionReader.this.leftoverTrackDictionary.put(id, trackList);
                                    IGVSessionReader.this.allTracks.put(id, trackList);
                                }
                                trackList.add(track);
                            }
                        }
                        catch (Exception e2) {
                            log.error("Error loading resource " + resourceLocator.getPath(), e2);
                            String ms = "<b>" + resourceLocator.getPath() + "</b><br>&nbsp;&nbsp;" + e2.toString() + "<br>";
                            errors.add(ms);
                        }
                    }
                };
                boolean bl = isAlignment = resourceLocator.getPath().endsWith(".bam") || resourceLocator.getPath().endsWith(".entries") || resourceLocator.getPath().endsWith(".sam");
                if (isAlignment || Globals.isBatch() || !this.hasTrackElments) {
                    synchronousLoads.add(runnable);
                } else {
                    Thread t2 = new Thread(runnable);
                    threads.add(t2);
                    t2.start();
                }
                ++i2;
            }
            for (Thread thread : threads) {
                try {
                    thread.join();
                }
                catch (InterruptedException suppliedPath) {}
            }
            for (Runnable runnable : synchronousLoads) {
                runnable.run();
            }
            long dt = System.currentTimeMillis() - t0;
            log.debug("Total load time = " + dt);
            if (errors.size() > 0) {
                StringBuffer buf = new StringBuffer();
                buf.append("<html>Errors were encountered loading the session:<br>");
                for (String msg : errors) {
                    buf.append(msg);
                }
                MessageUtils.showMessage(buf.toString());
            }
        }
        this.dataFiles = null;
    }

    void processResource(Session session, Element element, HashMap additionalInformation, String rootPath, String alternateRootPath) {
        String url;
        String nodeName = element.getNodeName();
        boolean oldSession = nodeName.equals(SessionElement.DATA_FILE.getText());
        String label = IGVSessionReader.getAttribute(element, SessionAttribute.LABEL.getText());
        String name = IGVSessionReader.getAttribute(element, SessionAttribute.NAME.getText());
        String sampleId = IGVSessionReader.getAttribute(element, SessionAttribute.SAMPLE_ID.getText());
        String description = IGVSessionReader.getAttribute(element, SessionAttribute.DESCRIPTION.getText());
        String type = IGVSessionReader.getAttribute(element, SessionAttribute.TYPE.getText());
        String coverage = IGVSessionReader.getAttribute(element, SessionAttribute.COVERAGE.getText());
        String mapping = IGVSessionReader.getAttribute(element, SessionAttribute.MAPPING.getText());
        String trackLine = IGVSessionReader.getAttribute(element, SessionAttribute.TRACK_LINE.getText());
        String colorString = IGVSessionReader.getAttribute(element, SessionAttribute.COLOR.getText());
        String index = IGVSessionReader.getAttribute(element, SessionAttribute.INDEX.getText());
        String serverURL = IGVSessionReader.getAttribute(element, SessionAttribute.SERVER_URL.getText());
        String path = IGVSessionReader.getAttribute(element, SessionAttribute.PATH.getText());
        if (oldSession && name != null) {
            path = name;
            int idx = name.lastIndexOf("/");
            if (idx > 0 && idx + 1 < name.length()) {
                name = name.substring(idx + 1);
            }
        }
        if (rootPath == null) {
            log.error("Null root path -- this is not expected");
            MessageUtils.showMessage("Unexpected error loading session: null root path");
            return;
        }
        String absolutePath = "ga4gh".equals(type) ? path : this.getAbsolutePath(path, rootPath);
        this.fullToRelPathMap.put(absolutePath, path);
        ResourceLocator resourceLocator = new ResourceLocator(serverURL, absolutePath);
        if (index != null) {
            resourceLocator.setIndexPath(index);
        }
        if (coverage != null) {
            String absoluteCoveragePath = coverage.equals(".") ? coverage : this.getAbsolutePath(coverage, rootPath);
            resourceLocator.setCoverage(absoluteCoveragePath);
        }
        if (mapping != null) {
            String absoluteMappingPath = mapping.equals(".") ? mapping : this.getAbsolutePath(mapping, rootPath);
            resourceLocator.setMappingPath(absoluteMappingPath);
        }
        if ((url = IGVSessionReader.getAttribute(element, SessionAttribute.URL.getText())) == null) {
            url = IGVSessionReader.getAttribute(element, SessionAttribute.FEATURE_URL.getText());
        }
        resourceLocator.setFeatureInfoURL(url);
        String infolink = IGVSessionReader.getAttribute(element, SessionAttribute.HYPERLINK.getText());
        if (infolink == null) {
            infolink = IGVSessionReader.getAttribute(element, SessionAttribute.INFOLINK.getText());
        }
        resourceLocator.setTrackInforURL(infolink);
        if (name != null) {
            resourceLocator.setName(name);
        } else {
            resourceLocator.setName(label);
        }
        resourceLocator.setSampleId(sampleId);
        resourceLocator.setDescription(description);
        if (type != null && !type.equals("local")) {
            resourceLocator.setType(type);
        }
        resourceLocator.setCoverage(coverage);
        resourceLocator.setTrackLine(trackLine);
        if (colorString != null) {
            try {
                Color c2 = ColorUtilities.stringToColor(colorString);
                resourceLocator.setColor(c2);
            }
            catch (Exception e2) {
                log.error("Error setting color: ", e2);
            }
        }
        this.dataFiles.add(resourceLocator);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation, rootPath, alternateRootPath);
    }

    private String getAbsolutePath(String path, String rootPath) {
        String absolutePath = FileUtils.getAbsolutePath(path, rootPath);
        return absolutePath;
    }

    private void processRegions(Session session, Element element, HashMap additionalInformation, String rootPath, String alternateRootPath) {
        session.clearRegionsOfInterest();
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation, rootPath, alternateRootPath);
    }

    private void processRegion(Session session, Element element, HashMap additionalInformation, String rootPath, String alternateRootPath) {
        String chromosome = IGVSessionReader.getAttribute(element, SessionAttribute.CHROMOSOME.getText());
        String start = IGVSessionReader.getAttribute(element, SessionAttribute.START_INDEX.getText());
        String end = IGVSessionReader.getAttribute(element, SessionAttribute.END_INDEX.getText());
        String description = IGVSessionReader.getAttribute(element, SessionAttribute.DESCRIPTION.getText());
        RegionOfInterest region = new RegionOfInterest(chromosome, new Integer(start), new Integer(end), description);
        IGV.getInstance().addRegionOfInterest(region);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation, rootPath, alternateRootPath);
    }

    private void processHiddenAttributes(Session session, Element element, HashMap additionalInformation) {
        NodeList elements = element.getChildNodes();
        if (elements.getLength() > 0) {
            HashSet<String> attributes = new HashSet<String>();
            for (int i2 = 0; i2 < elements.getLength(); ++i2) {
                Node childNode = elements.item(i2);
                if (!childNode.getNodeName().equals(SessionElement.ATTRIBUTE.getText())) continue;
                attributes.add(((Element)childNode).getAttribute(SessionAttribute.NAME.getText()));
            }
            session.setHiddenAttributes(attributes);
        }
    }

    private void processVisibleAttributes(Session session, Element element, HashMap additionalInformation) {
        NodeList elements = element.getChildNodes();
        if (elements.getLength() > 0) {
            HashSet<String> visibleAttributes = new HashSet<String>();
            for (int i2 = 0; i2 < elements.getLength(); ++i2) {
                Node childNode = elements.item(i2);
                if (!childNode.getNodeName().equals(SessionElement.VISIBLE_ATTRIBUTE.getText())) continue;
                visibleAttributes.add(((Element)childNode).getAttribute(SessionAttribute.NAME.getText()));
            }
            List<String> attributeNames = AttributeManager.getInstance().getAttributeNames();
            HashSet<String> hiddenAttributes = new HashSet<String>(attributeNames);
            hiddenAttributes.removeAll(visibleAttributes);
            session.setHiddenAttributes(hiddenAttributes);
        }
    }

    private void processGeneList(Session session, Element element, HashMap additionalInformation) {
        String name = IGVSessionReader.getAttribute(element, SessionAttribute.NAME.getText());
        String txt = element.getTextContent();
        String[] genes = txt.trim().split("\\s+");
        GeneList gl = new GeneList(name, Arrays.asList(genes));
        GeneListManager.getInstance().addGeneList(gl);
        session.setCurrentGeneList(gl);
        this.processFrames(element);
    }

    private void processFrames(Element element) {
        NodeList elements = element.getChildNodes();
        if (elements.getLength() > 0) {
            HashMap<String, ReferenceFrame> frames = new HashMap<String, ReferenceFrame>();
            for (ReferenceFrame f2 : FrameManager.getFrames()) {
                frames.put(f2.getName(), f2);
            }
            ArrayList<ReferenceFrame> reorderedFrames = new ArrayList<ReferenceFrame>();
            for (int i2 = 0; i2 < elements.getLength(); ++i2) {
                String frameName;
                ReferenceFrame f3;
                Node childNode = elements.item(i2);
                if (!childNode.getNodeName().equalsIgnoreCase(SessionElement.FRAME.getText()) || (f3 = (ReferenceFrame)frames.get(frameName = IGVSessionReader.getAttribute((Element)childNode, SessionAttribute.NAME.getText()))) == null) continue;
                reorderedFrames.add(f3);
                try {
                    String chr = IGVSessionReader.getAttribute((Element)childNode, SessionAttribute.CHR.getText());
                    String startString = IGVSessionReader.getAttribute((Element)childNode, SessionAttribute.START.getText()).replace(",", "");
                    String endString = IGVSessionReader.getAttribute((Element)childNode, SessionAttribute.END.getText()).replace(",", "");
                    int start = ParsingUtils.parseInt(startString);
                    int end = ParsingUtils.parseInt(endString);
                    Locus locus = new Locus(chr, start, end);
                    f3.jumpTo(locus);
                    continue;
                }
                catch (NumberFormatException e2) {
                    e2.printStackTrace();
                }
            }
            if (reorderedFrames.size() > 0) {
                FrameManager.setFrames(reorderedFrames);
            }
        }
        IGV.getInstance().resetFrames();
    }

    private void processFilter(Session session, Element element, HashMap additionalInformation, String rootPath, String alternateRootPath) {
        String match = IGVSessionReader.getAttribute(element, SessionAttribute.FILTER_MATCH.getText());
        String showAllTracks = IGVSessionReader.getAttribute(element, SessionAttribute.FILTER_SHOW_ALL_TRACKS.getText());
        String filterName = IGVSessionReader.getAttribute(element, SessionAttribute.NAME.getText());
        TrackFilter filter = new TrackFilter(filterName, null);
        additionalInformation.put(SessionElement.FILTER, filter);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation, rootPath, alternateRootPath);
        session.setFilter(filter);
        if ("all".equalsIgnoreCase(match)) {
            IGV.getInstance().setFilterMatchAll(true);
        } else if ("any".equalsIgnoreCase(match)) {
            IGV.getInstance().setFilterMatchAll(false);
        }
        if ("true".equalsIgnoreCase(showAllTracks)) {
            IGV.getInstance().setFilterShowAllTracks(true);
        } else {
            IGV.getInstance().setFilterShowAllTracks(false);
        }
    }

    private void processFilterElement(Session session, Element element, HashMap additionalInformation, String rootPath, String alternateRootPath) {
        TrackFilter filter = (TrackFilter)additionalInformation.get((Object)SessionElement.FILTER);
        String item = IGVSessionReader.getAttribute(element, SessionAttribute.ITEM.getText());
        String operator = IGVSessionReader.getAttribute(element, SessionAttribute.OPERATOR.getText());
        String value = IGVSessionReader.getAttribute(element, SessionAttribute.VALUE.getText());
        String booleanOperator = IGVSessionReader.getAttribute(element, SessionAttribute.BOOLEAN_OPERATOR.getText());
        FilterElement.Operator opEnum = CollUtils.findValueOf(FilterElement.Operator.class, operator);
        FilterElement.BooleanOperator boolEnum = FilterElement.BooleanOperator.valueOf(booleanOperator.toUpperCase());
        TrackFilterElement trackFilterElement = new TrackFilterElement(filter, item, opEnum, value, boolEnum);
        filter.add(trackFilterElement);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation, rootPath, alternateRootPath);
    }

    private static boolean nodeIsTrack(Node node) {
        return node.getNodeName() != null && (node.getNodeName().equalsIgnoreCase(SessionElement.DATA_TRACK.getText()) || node.getNodeName().equalsIgnoreCase(SessionElement.TRACK.getText()));
    }

    private void processPanel(Session session, Element element, HashMap additionalInformation, String rootPath, String alternateRootPath) {
        this.panelElementPresent = true;
        String panelName = element.getAttribute("name");
        if (panelName == null) {
            panelName = "Panel" + this.panelCounter++;
        }
        ArrayList<Track> panelTracks = new ArrayList<Track>();
        NodeList elements = element.getChildNodes();
        for (int i2 = 0; i2 < elements.getLength(); ++i2) {
            Node childNode = elements.item(i2);
            if (IGVSessionReader.nodeIsTrack(childNode)) {
                List<Track> tracks = this.processTrack(session, (Element)childNode, additionalInformation, rootPath, alternateRootPath);
                if (tracks == null) continue;
                panelTracks.addAll(tracks);
                continue;
            }
            this.process(session, childNode, additionalInformation, rootPath, alternateRootPath);
        }
        for (Track track : panelTracks) {
            if (track instanceof FeatureTrack) {
                FeatureTrack featureTrack = (FeatureTrack)track;
                featureTrack.updateTrackReferences(panelTracks);
                continue;
            }
            if (!(track instanceof DataSourceTrack)) continue;
            DataSourceTrack dataTrack = (DataSourceTrack)track;
            dataTrack.updateTrackReferences(panelTracks);
        }
        TrackPanel panel = IGV.getInstance().getTrackPanel(panelName);
        panel.addTracks(panelTracks);
    }

    private void processPanelLayout(Session session, Element element, HashMap additionalInformation) {
        String nodeName;
        String panelName = nodeName = element.getNodeName();
        NamedNodeMap tNodeMap = element.getAttributes();
        for (int i2 = 0; i2 < tNodeMap.getLength(); ++i2) {
            Node node = tNodeMap.item(i2);
            String name = node.getNodeName();
            if (!name.equals("dividerFractions")) continue;
            String value = node.getNodeValue();
            String[] tokens = value.split(",");
            double[] divs = new double[tokens.length];
            try {
                for (int j2 = 0; j2 < tokens.length; ++j2) {
                    divs[j2] = Double.parseDouble(tokens[j2]);
                }
                session.setDividerFractions(divs);
                continue;
            }
            catch (NumberFormatException e2) {
                log.error("Error parsing divider locations", e2);
            }
        }
    }

    private List<Track> processTrack(Session session, Element element, HashMap additionalInformation, String rootPath, String alternateRootPath) {
        List<Track> matchedTracks;
        block15: {
            String id = IGVSessionReader.getAttribute(element, SessionAttribute.ID.getText());
            matchedTracks = this.allTracks.get(id);
            if (matchedTracks == null) {
                matchedTracks = this.allTracks.get(this.getAbsolutePath(id, rootPath));
            }
            if (matchedTracks == null) {
                String className = IGVSessionReader.getAttribute(element, "clazz");
                try {
                    if (className == null || !element.hasChildNodes()) break block15;
                    Track track = null;
                    if (className.contains("FeatureTrack") || className.contains("DataSourceTrack")) {
                        Class<?> clazz = Class.forName(className);
                        Unmarshaller u2 = IGVSessionReader.getJAXBContext().createUnmarshaller();
                        track = this.unmarshalTrackElement(u2, element, null, clazz);
                        matchedTracks = new ArrayList<Track>(Arrays.asList(track));
                    } else if (className.contains("MergedTracks")) {
                        List<Track> childTracks = this.processChildTracks(session, element, additionalInformation, rootPath, alternateRootPath);
                        ArrayList<DataTrack> memberTracks = new ArrayList<DataTrack>(childTracks.size());
                        for (Track aTrack : childTracks) {
                            memberTracks.add((DataTrack)aTrack);
                        }
                        track = new MergedTracks(id, IGVSessionReader.getAttribute(element, SessionAttribute.NAME.getText()), memberTracks);
                        matchedTracks = Arrays.asList(track);
                    }
                    if (track != null) {
                        this.allTracks.put(track.getId(), matchedTracks);
                        break block15;
                    }
                    log.info("Warning.  No tracks were found with id: " + id + " in session file");
                }
                catch (JAXBException jAXBException) {
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                try {
                    Unmarshaller u3 = IGVSessionReader.getJAXBContext().createUnmarshaller();
                    for (Track track : matchedTracks) {
                        if (this.igv != null && this.version >= 4 && (track == this.geneTrack || track == this.seqTrack)) {
                            this.igv.removeTracks(Arrays.asList(track), false);
                        }
                        this.unmarshalTrackElement(u3, element, (AbstractTrack)track);
                    }
                }
                catch (JAXBException e2) {
                    throw new RuntimeException(e2);
                }
                this.leftoverTrackDictionary.remove(id);
            }
        }
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation, rootPath, alternateRootPath);
        return matchedTracks;
    }

    private List<Track> processChildTracks(Session session, Element element, HashMap additionalInformation, String rootPath, String alternateRootPath) {
        NodeList memberTrackNodes = element.getChildNodes();
        ArrayList<Track> memberTracks = new ArrayList<Track>(memberTrackNodes.getLength());
        for (int index = 0; index < memberTrackNodes.getLength(); ++index) {
            List<Track> addedTracks;
            Node memberNode = memberTrackNodes.item(index);
            if (!IGVSessionReader.nodeIsTrack(memberNode) || (addedTracks = this.processTrack(session, (Element)memberNode, additionalInformation, rootPath, alternateRootPath)) == null) continue;
            memberTracks.addAll(addedTracks);
        }
        return memberTracks;
    }

    private static void setNextTrack(AbstractTrack track) {
        nextTrack = track;
    }

    public static AbstractTrack getNextTrack() {
        return nextTrack;
    }

    protected Track unmarshalTrackElement(Unmarshaller u2, Element e2, AbstractTrack track) throws JAXBException {
        return this.unmarshalTrackElement(u2, e2, track, track.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Track unmarshalTrackElement(Unmarshaller u2, Element element, AbstractTrack track, Class trackClass) throws JAXBException {
        Class<IGVSessionReader> clazz = IGVSessionReader.class;
        synchronized (IGVSessionReader.class) {
            IGVSessionReader.setNextTrack(track);
            AbstractTrack ut = IGVSessionReader.unmarshalTrack(u2, element, trackClass, trackClass);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            ut.restorePersistentState(element, this.version);
            return ut;
        }
    }

    private void processColorScales(Session session, Element element, HashMap additionalInformation, String rootPath, String alternateRootPath) {
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation, rootPath, alternateRootPath);
    }

    private void processColorScale(Session session, Element element, HashMap additionalInformation, String rootPath, String alternateRootPath) {
        String trackType = IGVSessionReader.getAttribute(element, SessionAttribute.TYPE.getText());
        String value = IGVSessionReader.getAttribute(element, SessionAttribute.VALUE.getText());
        this.setColorScaleSet(session, trackType, value);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation, rootPath, alternateRootPath);
    }

    private void processPreferences(Session session, Element element, HashMap additionalInformation) {
        NodeList elements = element.getChildNodes();
        for (int i2 = 0; i2 < elements.getLength(); ++i2) {
            Node child = elements.item(i2);
            if (!child.getNodeName().equalsIgnoreCase(SessionElement.PROPERTY.getText())) continue;
            Element childNode = (Element)child;
            String name = IGVSessionReader.getAttribute(childNode, SessionAttribute.NAME.getText());
            String value = IGVSessionReader.getAttribute(childNode, SessionAttribute.VALUE.getText());
            session.setPreference(name, value);
        }
    }

    private void process(Session session, NodeList elements, HashMap additionalInformation, String rootPath, String alternateRootPath) {
        for (int i2 = 0; i2 < elements.getLength(); ++i2) {
            Node childNode = elements.item(i2);
            this.process(session, childNode, additionalInformation, rootPath, alternateRootPath);
        }
    }

    public void setColorScaleSet(Session session, String type, String value) {
        if (type == null | value == null) {
            return;
        }
        TrackType trackType = CollUtils.valueOf(TrackType.class, type.toUpperCase(), TrackType.OTHER);
        ColorScale colorScale = ColorScaleFactory.getScaleFromString(value);
        if (colorScale instanceof ContinuousColorScale) {
            session.setColorScale(trackType, (ContinuousColorScale)colorScale);
        }
    }

    private static String getAttribute(Element element, String key) {
        String value = element.getAttribute(key);
        if (value != null && value.trim().equals("")) {
            value = null;
        }
        return value;
    }

    public static synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((Class[])registeredClasses.toArray(new Class[0]), new HashMap());
        }
        return jc;
    }

    public static synchronized void registerClass(Class clazz) {
        registeredClasses.add(clazz);
        jc = null;
    }

    public static AbstractTrack unmarshalTrack(Unmarshaller u2, Node node, Class unmarshalClass, Class firstClass) throws JAXBException {
        JAXBElement el;
        if (unmarshalClass == null || unmarshalClass.equals(Object.class)) {
            throw new JAXBException(firstClass + " and none of its superclasses are known");
        }
        if (AbstractTrack.knownUnknownTrackClasses.contains(unmarshalClass)) {
            return IGVSessionReader.unmarshalTrack(u2, node, firstClass, unmarshalClass.getSuperclass());
        }
        try {
            el = u2.unmarshal(node, unmarshalClass);
        }
        catch (JAXBException e2) {
            AbstractTrack.knownUnknownTrackClasses.add(unmarshalClass);
            return IGVSessionReader.unmarshalTrack(u2, node, firstClass, unmarshalClass.getSuperclass());
        }
        return (AbstractTrack)el.getValue();
    }

    public static Track getMatchingTrack(String trackId, List<Track> allTracks) {
        List<Track> matchingTracks;
        IGVSessionReader reader = (IGVSessionReader)currentReader.get();
        if (reader != null) {
            matchingTracks = reader.getTracksById(trackId);
        } else {
            if (allTracks == null) {
                throw new IllegalStateException("No session reader and no tracks to search to resolve Track references");
            }
            matchingTracks = new ArrayList<Track>();
            for (Track track : allTracks) {
                if (!trackId.equals(track.getId())) continue;
                matchingTracks.add(track);
                break;
            }
        }
        if (matchingTracks == null || matchingTracks.size() == 0) {
            return null;
        }
        if (matchingTracks.size() >= 2) {
            log.debug("Found multiple tracks with id  " + trackId + ", using the first");
        }
        return matchingTracks.get(0);
    }

    static {
        registeredClasses = new ArrayList<Class>();
        attributeSynonymMap.put("DATA FILE", "DATA SET");
        attributeSynonymMap.put("TRACK NAME", "NAME");
        IGVSessionReader.registerClass(AbstractTrack.class);
        jc = null;
    }

    public static enum SessionAttribute {
        BOOLEAN_OPERATOR("booleanOperator"),
        COLOR("color"),
        ALT_COLOR("altColor"),
        COLOR_MODE("colorMode"),
        CHROMOSOME("chromosome"),
        END_INDEX("end"),
        EXPAND("expand"),
        SQUISH("squish"),
        DISPLAY_MODE("displayMode"),
        FILTER_MATCH("match"),
        FILTER_SHOW_ALL_TRACKS("showTracks"),
        GENOME("genome"),
        UCSC_ID("ucscID"),
        GROUP_TRACKS_BY("groupTracksBy"),
        NEXT_AUTOSCALE_GROUP("nextAutoscaleGroup"),
        HEIGHT("height"),
        ID("id"),
        ITEM("item"),
        LOCUS("locus"),
        NAME("name"),
        SAMPLE_ID("sampleID"),
        RESOURCE_TYPE("resourceType"),
        OPERATOR("operator"),
        RELATIVE_PATH("relativePath"),
        RENDERER("renderer"),
        SCALE("scale"),
        START_INDEX("start"),
        VALUE("value"),
        VERSION("version"),
        VISIBLE("visible"),
        WINDOW_FUNCTION("windowFunction"),
        RENDER_NAME("renderName"),
        GENOTYPE_HEIGHT("genotypeHeight"),
        VARIANT_HEIGHT("variantHeight"),
        PREVIOUS_HEIGHT("previousHeight"),
        FEATURE_WINDOW("featureVisibilityWindow"),
        DISPLAY_NAME("displayName"),
        COLOR_SCALE("colorScale"),
        HAS_GENE_TRACK("hasGeneTrack"),
        HAS_SEQ_TRACK("hasSequenceTrack"),
        PATH("path"),
        INDEX("index"),
        LABEL("label"),
        SERVER_URL("serverURL"),
        HYPERLINK("hyperlink"),
        INFOLINK("infolink"),
        URL("url"),
        FEATURE_URL("featureURL"),
        DESCRIPTION("description"),
        TYPE("type"),
        COVERAGE("coverage"),
        MAPPING("mapping"),
        TRACK_LINE("trackLine"),
        CHR("chr"),
        START("start"),
        END("end");

        private String name;

        private SessionAttribute(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public String toString() {
            return this.getText();
        }
    }

    public static enum SessionElement {
        PANEL("Panel"),
        PANEL_LAYOUT("PanelLayout"),
        TRACK("Track"),
        COLOR_SCALE("ColorScale"),
        COLOR_SCALES("ColorScales"),
        DATA_TRACK("DataTrack"),
        DATA_TRACKS("DataTracks"),
        FEATURE_TRACKS("FeatureTracks"),
        DATA_FILE("DataFile"),
        RESOURCE("Resource"),
        RESOURCES("Resources"),
        FILES("Files"),
        FILTER_ELEMENT("FilterElement"),
        FILTER("Filter"),
        SESSION("Session"),
        GLOBAL("Global"),
        REGION("Region"),
        REGIONS("Regions"),
        DATA_RANGE("DataRange"),
        PREFERENCES("Preferences"),
        PROPERTY("Property"),
        GENE_LIST("GeneList"),
        HIDDEN_ATTRIBUTES("HiddenAttributes"),
        VISIBLE_ATTRIBUTES("VisibleAttributes"),
        ATTRIBUTE("Attribute"),
        VISIBLE_ATTRIBUTE("VisibleAttribute"),
        FRAME("Frame");

        private String name;

        private SessionElement(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public String toString() {
            return this.getText();
        }

        public static SessionElement findEnum(String value) {
            if (value == null) {
                return null;
            }
            return SessionElement.valueOf(value);
        }
    }
}

