/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mutreview;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.ga4gh.OAuthUtils;
import org.broad.igv.sam.mutreview.VariantReviewMetadata;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;

public class GoogleCloudStorageHelper {
    private static Logger log = Logger.getLogger(GoogleCloudStorageHelper.class);
    static Map<String, String> genomeIdMap = new HashMap<String, String>();

    public static void upload(BufferedImage image, VariantReviewMetadata metadata) throws IOException {
        String filename = "test_" + metadata.userId + "_" + metadata.timestamp + "_" + metadata.score;
        String r1 = GoogleCloudStorageHelper.uploadJpeg(image, filename);
        log.info(r1);
        String json = new Gson().toJson(metadata);
        String r2 = GoogleCloudStorageHelper.uploadJson(json, filename);
        log.info(r2);
    }

    private static String uploadJpeg(BufferedImage image, String filename) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(2000000);
        ImageIO.write((RenderedImage)image, "jpg", stream);
        byte[] bytes = stream.toByteArray();
        return GoogleCloudStorageHelper.doPost(bytes, "image/jpeg", filename + ".jpeg");
    }

    private static String uploadJson(String json, String filename) throws IOException {
        return GoogleCloudStorageHelper.doPost(json.getBytes(), "text/plain", filename + ".json");
    }

    private static String doPost(byte[] bytes, String contentType, String filename) throws IOException {
        String token = OAuthUtils.getInstance().getAccessToken();
        String fullUrl = "https://www.googleapis.com/upload/storage/v1/b/igv-screenshots/o?uploadType=media&name=" + filename;
        URL url = new URL(fullUrl);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Length", "" + bytes.length);
            connection.setRequestProperty("Content-Type", contentType);
            if (token != null) {
                connection.setRequestProperty("Authorization", "Bearer " + token);
            }
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(bytes);
            outputStream.close();
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer sb = new StringBuffer();
            String str = br.readLine();
            while (str != null) {
                sb.append(str);
                str = br.readLine();
            }
            br.close();
            return sb.toString();
        }
        catch (Exception e2) {
            GoogleCloudStorageHelper.handleHttpException(url, connection, e2);
            return null;
        }
    }

    static void handleHttpException(URL url, HttpURLConnection connection, Exception e2) throws IOException {
        int rs = connection.getResponseCode();
        String sb = GoogleCloudStorageHelper.getErrorMessage(connection);
        if (sb != null && sb.length() > 0) {
            MessageUtils.showErrorMessage(sb, e2);
        } else if (rs == 404) {
            MessageUtils.showErrorMessage("The requested resource was not found<br>" + url, e2);
        } else if (rs == 401 || rs == 403) {
            GoogleCloudStorageHelper.displayAuthorizationDialog(url.getHost());
        } else {
            MessageUtils.showErrorMessage("Error accessing resource", e2);
            log.error("Error accessing resource", e2);
        }
    }

    private static String getErrorMessage(HttpURLConnection connection) throws IOException {
        JsonPrimitive msg;
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
        StringBuffer sb = new StringBuffer();
        String str = br.readLine();
        while (str != null) {
            sb.append(str);
            str = br.readLine();
        }
        br.close();
        JsonParser parser = new JsonParser();
        JsonObject obj = parser.parse(sb.toString()).getAsJsonObject();
        JsonObject errorObject = obj.getAsJsonObject("error");
        if (errorObject != null && (msg = errorObject.getAsJsonPrimitive("message")) != null) {
            return msg.getAsString();
        }
        return sb.toString();
    }

    static void displayAuthorizationDialog(String host) {
        String message = "The requested resource at '" + host + "' requires authorization.";
        Icon icon = null;
        int option = JOptionPane.showOptionDialog(IGV.getMainFrame(), message, "Error", 2, 3, icon, new String[]{"Cancel", "Authorize"}, 0);
        if (option == 1) {
            try {
                OAuthUtils.getInstance().openAuthorizationPage();
            }
            catch (Exception e2) {
                MessageUtils.showErrorMessage("Error fetching oAuth token", e2);
                log.error("Error fetching oAuth tokens", e2);
            }
        }
    }

    static {
        genomeIdMap = new HashMap<String, String>();
        genomeIdMap.put("Google 10473108253681171589", "hg19");
        genomeIdMap.put("Google 383928317087", "hg19");
        genomeIdMap.put("Google 461916304629", "hg19");
        genomeIdMap.put("Google 337315832689", "hg19");
    }
}

