/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.lite;

import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.util.ParsingUtils;

public class BAMIndex {
    static int BAI_MAGIC = 21578050;
    static int TABIX_MAGIC = 21578324;
    private static final int SHIFT_AMOUNT = 16;
    private static final int OFFSET_MASK = 65535;
    private static final long ADDRESS_MASK = 0xFFFFFFFFFFFFL;
    long firstAlignmentBlock;
    long lastAlignmentBlock;
    Map<Integer, RefIndexPair> refIndexes;
    Map<String, Integer> sequenceIndexMap;
    boolean tabix;

    public BAMIndex(Map<Integer, RefIndexPair> refIndexes, long blockMin, long blockMax, Map<String, Integer> sequenceIndexMap) {
        this.firstAlignmentBlock = blockMin;
        this.lastAlignmentBlock = blockMax;
        this.refIndexes = refIndexes;
        this.sequenceIndexMap = sequenceIndexMap;
        this.tabix = false;
    }

    public List<Chunk> chunksForRange(int refId, int min, int max) {
        RefIndexPair ba = this.refIndexes.get(refId);
        if (ba == null) {
            return Collections.EMPTY_LIST;
        }
        List<Integer> overlappingBins = this.reg2bins(min, max);
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (Integer bin : overlappingBins) {
            ArrayList<Chunk> binChunks = ba.binIndex.get(bin);
            if (binChunks == null) continue;
            chunks.addAll(binChunks);
        }
        int nintv = ba.linearIndex.size();
        VPointer lowest = null;
        int minLin = Math.min(min >> 14, nintv - 1);
        int maxLin = Math.min(max >> 14, nintv - 1);
        for (int i2 = minLin; i2 <= maxLin; ++i2) {
            VPointer vp = ba.linearIndex.get(i2);
            if (vp == null || lowest != null && !vp.isLessThan(lowest)) continue;
            lowest = vp;
        }
        return this.optimizeChunks(chunks, lowest);
    }

    List<Chunk> optimizeChunks(List<Chunk> chunks, VPointer lowest) {
        ArrayList<Chunk> mergedChunks = new ArrayList<Chunk>();
        Chunk lastChunk = null;
        if (chunks.size() == 0) {
            return chunks;
        }
        chunks.sort((c0, c1) -> {
            long dif = c0.start.block - c1.start.block;
            if (dif > 0L) {
                return 1;
            }
            if (dif < 0L) {
                return -1;
            }
            return c0.start.offset - c1.start.offset;
        });
        for (Chunk chunk : chunks) {
            if (!chunk.end.isGreaterThan(lowest)) continue;
            if (lastChunk == null) {
                mergedChunks.add(chunk);
                lastChunk = chunk;
                continue;
            }
            if (chunk.start.block - lastChunk.end.block < 65000L) {
                if (!chunk.end.isGreaterThan(lastChunk.end)) continue;
                lastChunk.end = chunk.end;
                continue;
            }
            mergedChunks.add(chunk);
            lastChunk = chunk;
        }
        return mergedChunks;
    }

    List<Integer> reg2bins(int beg, int end) {
        int k2;
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (end >= 0x20000000) {
            end = 0x20000000;
        }
        --end;
        list.add(0);
        for (k2 = 1 + (beg >> 26); k2 <= 1 + (end >> 26); ++k2) {
            list.add(k2);
        }
        for (k2 = 9 + (beg >> 23); k2 <= 9 + (end >> 23); ++k2) {
            list.add(k2);
        }
        for (k2 = 73 + (beg >> 20); k2 <= 73 + (end >> 20); ++k2) {
            list.add(k2);
        }
        for (k2 = 585 + (beg >> 17); k2 <= 585 + (end >> 17); ++k2) {
            list.add(k2);
        }
        for (k2 = 4681 + (beg >> 14); k2 <= 4681 + (end >> 14); ++k2) {
            list.add(k2);
        }
        return list;
    }

    static VPointer readVPointer(LittleEndianInputStream is) throws IOException {
        long vp = is.readLong();
        long block = vp >> 16 & 0xFFFFFFFFFFFFL;
        int offset = (int)(vp & 0xFFFFL);
        return new VPointer(block, offset);
    }

    public static BAMIndex loadIndex(String indexURL, Genome genome) throws IOException {
        boolean tabix = false;
        LittleEndianInputStream parser = new LittleEndianInputStream(new BufferedInputStream(ParsingUtils.openInputStream(indexURL)));
        long blockMin = Long.MAX_VALUE;
        long blockMax = 0L;
        HashMap<Integer, RefIndexPair> refIndexes = new HashMap<Integer, RefIndexPair>();
        HashMap<String, Integer> sequenceIndexMap = null;
        int magic = parser.readInt();
        if (magic == BAI_MAGIC || tabix && magic == TABIX_MAGIC) {
            int nref = parser.readInt();
            if (tabix) {
                int format = parser.readInt();
                int col_seq = parser.readInt();
                int col_beg = parser.readInt();
                int col_end = parser.readInt();
                int meta = parser.readInt();
                int skip = parser.readInt();
                int l_nm = parser.readInt();
                sequenceIndexMap = new HashMap<String, Integer>();
                for (int i2 = 0; i2 < nref; ++i2) {
                    String seq_name = parser.readString();
                    if (genome != null) {
                        seq_name = genome.getCanonicalChrName(seq_name);
                    }
                    sequenceIndexMap.put(seq_name, i2);
                }
            }
            for (int ref = 0; ref < nref; ++ref) {
                HashMap<Integer, ArrayList<Chunk>> binIndex = new HashMap<Integer, ArrayList<Chunk>>();
                ArrayList<VPointer> linearIndex = new ArrayList<VPointer>();
                int nbin = parser.readInt();
                for (int b2 = 0; b2 < nbin; ++b2) {
                    int binNumber = parser.readInt();
                    if (binNumber == 37450) {
                        int nchnk = parser.readInt();
                        BAMIndex.readVPointer(parser);
                        BAMIndex.readVPointer(parser);
                        long n_maped = parser.readLong();
                        long l2 = parser.readLong();
                        continue;
                    }
                    ArrayList<Chunk> chunks = new ArrayList<Chunk>();
                    binIndex.put(binNumber, chunks);
                    int nchnk = parser.readInt();
                    for (int i3 = 0; i3 < nchnk; ++i3) {
                        VPointer cs = BAMIndex.readVPointer(parser);
                        VPointer ce = BAMIndex.readVPointer(parser);
                        if (cs.block < blockMin) {
                            blockMin = cs.block;
                        }
                        if (ce.block > blockMax) {
                            blockMax = ce.block;
                        }
                        chunks.add(new Chunk(cs, ce));
                    }
                }
                int nintv = parser.readInt();
                for (int i4 = 0; i4 < nintv; ++i4) {
                    VPointer cs = BAMIndex.readVPointer(parser);
                    linearIndex.add(cs);
                }
                if (nbin <= 0) continue;
                refIndexes.put(ref, new RefIndexPair(binIndex, linearIndex));
            }
        } else {
            throw new RuntimeException(indexURL + " is not a " + (tabix ? "tabix" : "bai") + " file");
        }
        return new BAMIndex(refIndexes, blockMin, blockMax, sequenceIndexMap);
    }

    public static class RefIndexPair {
        public Map<Integer, ArrayList<Chunk>> binIndex;
        public ArrayList<VPointer> linearIndex;

        public RefIndexPair(Map<Integer, ArrayList<Chunk>> binIndex, ArrayList<VPointer> linearIndex) {
            this.binIndex = binIndex;
            this.linearIndex = linearIndex;
        }
    }

    public static class Chunk {
        public VPointer start;
        public VPointer end;

        public Chunk(VPointer start, VPointer end) {
            this.end = end;
            this.start = start;
        }
    }

    public static class VPointer {
        public long block;
        public int offset;

        public VPointer(long block, int offset) {
            this.block = block;
            this.offset = offset;
        }

        boolean isLessThan(VPointer vp) {
            return this.block < vp.block || this.block == vp.block && this.offset < vp.offset;
        }

        boolean isGreaterThan(VPointer vp) {
            return this.block > vp.block || this.block == vp.block && this.offset > vp.offset;
        }
    }
}

