/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.event.AlignmentTrackEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.lists.GeneList;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.ExperimentTypeChangeEvent;
import org.broad.igv.sam.InsertionManager;
import org.broad.igv.sam.InsertionMarker;
import org.broad.igv.sam.InsertionSelectionEvent;
import org.broad.igv.sam.LinkedAlignment;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PackedAlignments;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.Row;
import org.broad.igv.sam.SpliceJunctionTrack;
import org.broad.igv.sam.mutreview.VariantReviewAction;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.session.Session;
import org.broad.igv.tools.PFMExporter;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.InsertSizeSettingsDialog;
import org.broad.igv.ui.SashimiPlot;
import org.broad.igv.ui.color.ColorTable;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.Pair;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.blat.BlatClient;
import org.broad.igv.util.collections.CollUtils;
import org.broad.igv.util.extview.ExtendViewClient;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlType(factoryMethod="getNextTrack")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlSeeAlso(value={RenderOptions.class})
public class AlignmentTrack
extends AbstractTrack
implements IGVEventObserver {
    private static Logger log = Logger.getLogger(AlignmentTrack.class);
    public static final int GROUP_LABEL_HEIGHT = 10;
    static final int GROUP_MARGIN = 5;
    static final int TOP_MARGIN = 20;
    static final int DS_MARGIN_0 = 2;
    static final int DOWNAMPLED_ROW_HEIGHT = 3;
    static final int INSERTION_ROW_HEIGHT = 9;
    static final int DS_MARGIN_2 = 5;
    @XmlAttribute
    private ExperimentType experimentType;
    private final AlignmentRenderer renderer;
    private boolean removed = false;
    private RenderRollback renderRollback;
    private boolean showGroupLine;
    private Map<ReferenceFrame, List<InsertionInterval>> insertionIntervalsMap;
    private SequenceTrack sequenceTrack;
    private CoverageTrack coverageTrack;
    private SpliceJunctionTrack spliceJunctionTrack;
    RenderOptions renderOptions = new RenderOptions(ExperimentType.OTHER);
    private int expandedHeight = 14;
    private int collapsedHeight = 9;
    private int maxSquishedHeight;
    private int squishedHeight = this.maxSquishedHeight = 5;
    private int minHeight = 50;
    private AlignmentDataManager dataManager;
    public Rectangle alignmentsRect;
    private Rectangle downsampleRect;
    private Rectangle insertionRect;
    private ColorTable readNamePalette;
    private JComponent dataPanel;
    private HashMap<String, Color> selectedReadNames = new HashMap();
    private HashMap<Rectangle, String> groupNames = new HashMap();
    protected static final Map<BisulfiteContext, String> bisulfiteContextToPubString = new HashMap<BisulfiteContext, String>();
    protected static final Map<BisulfiteContext, Pair<byte[], byte[]>> bisulfiteContextToContextString;
    static final BisulfiteContext DEFAULT_BISULFITE_CONTEXT;

    public static void sortAlignmentTracks(SortOption option, String tag) {
        IGV.getInstance().sortAlignmentTracks(option, tag);
        Collection<IGVPreferences> allPrefs = PreferencesManager.getAllPreferences();
        for (IGVPreferences prefs : allPrefs) {
            prefs.put("SAM.SORT_OPTION", option.toString());
            prefs.put("SAM.SORT_BY_TAG", tag);
        }
        AlignmentTrack.refresh();
    }

    public AlignmentTrack(ResourceLocator locator, AlignmentDataManager dataManager, Genome genome) {
        super(locator);
        this.dataManager = dataManager;
        this.dataManager.subscribe(this);
        this.setRenderOptions(new RenderOptions());
        this.minimumHeight = 50;
        this.maximumHeight = Integer.MAX_VALUE;
        IGVPreferences prefs = this.getPreferences();
        this.renderer = new AlignmentRenderer(this);
        this.showGroupLine = this.getPreferences().getAsBoolean("SAM.SHOW_GROUP_SEPARATOR");
        this.setDisplayMode(Track.DisplayMode.EXPANDED);
        if (prefs.getAsBoolean("SAM.SHOW_REF_SEQ")) {
            this.sequenceTrack = new SequenceTrack("Reference sequence");
            this.sequenceTrack.setHeight(14);
        }
        if (this.renderOptions.colorOption == ColorOption.BISULFITE) {
            this.setExperimentType(ExperimentType.BISULFITE);
        }
        this.readNamePalette = new PaletteColorTable(ColorUtilities.getDefaultPalette());
        this.insertionIntervalsMap = Collections.synchronizedMap(new HashMap());
        IGVEventBus.getInstance().subscribe(FrameManager.ChangeEvent.class, this);
        IGVEventBus.getInstance().subscribe(ExperimentTypeChangeEvent.class, this);
        IGVEventBus.getInstance().subscribe(AlignmentTrackEvent.class, this);
    }

    @Override
    public void receiveEvent(Object event) {
        if (event instanceof FrameManager.ChangeEvent) {
            Map<ReferenceFrame, List<InsertionInterval>> newMap = Collections.synchronizedMap(new HashMap());
            for (ReferenceFrame frame : ((FrameManager.ChangeEvent)event).getFrames()) {
                if (!this.insertionIntervalsMap.containsKey(frame)) continue;
                newMap.put(frame, this.insertionIntervalsMap.get(frame));
            }
            this.insertionIntervalsMap = newMap;
        } else if (event instanceof ExperimentTypeChangeEvent) {
            if (this.experimentType == null) {
                log.info("Experiment type = " + (Object)((Object)((ExperimentTypeChangeEvent)event).type));
                this.setExperimentType(((ExperimentTypeChangeEvent)event).type);
            }
        } else if (event instanceof AlignmentTrackEvent) {
            AlignmentTrackEvent e2 = (AlignmentTrackEvent)event;
            AlignmentTrackEvent.Type eventType = e2.getType();
            switch (eventType) {
                case ALLELE_THRESHOLD: {
                    this.dataManager.alleleThresholdChanged();
                    break;
                }
                case RELOAD: {
                    this.clearCaches();
                }
                case REFRESH: {
                    this.renderOptions.refreshDefaults(this.getExperimentType());
                    AlignmentTrack.refresh();
                }
            }
        }
    }

    private void setExperimentType(ExperimentType type) {
        if (type != this.experimentType) {
            this.experimentType = type;
            this.renderOptions.refreshDefaults(type);
            boolean showJunction = AlignmentTrack.getPreferences(type).getAsBoolean("SAM.SHOW_JUNCTION_TRACK");
            if (showJunction != this.spliceJunctionTrack.isVisible()) {
                this.spliceJunctionTrack.setVisible(showJunction);
                IGV.getInstance().revalidateTrackPanels();
            }
        }
    }

    private ExperimentType getExperimentType() {
        return this.experimentType;
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            super.setVisible(visible);
            if (IGV.hasInstance()) {
                IGV.getInstance().getMainPanel().revalidate();
            }
        }
    }

    @XmlElement(name="RenderOptions")
    private void setRenderOptions(RenderOptions renderOptions) {
        this.renderOptions = renderOptions;
    }

    RenderOptions getRenderOptions() {
        return this.renderOptions;
    }

    public CoverageTrack getCoverageTrack() {
        return this.coverageTrack;
    }

    public void setSpliceJunctionTrack(SpliceJunctionTrack spliceJunctionTrack) {
        this.spliceJunctionTrack = spliceJunctionTrack;
    }

    public SpliceJunctionTrack getSpliceJunctionTrack() {
        return this.spliceJunctionTrack;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        return new PopupMenu(te);
    }

    @Override
    public void setHeight(int preferredHeight) {
        super.setHeight(preferredHeight);
        this.minimumHeight = preferredHeight;
    }

    @Override
    public int getHeight() {
        if (this.dataPanel != null && this.dataPanel instanceof DataPanel && ((DataPanel)this.dataPanel).getFrame().getScale() > this.dataManager.getMinVisibleScale()) {
            return this.minimumHeight;
        }
        int nGroups = this.dataManager.getMaxGroupCount();
        int h2 = Math.max(this.minHeight, this.getNLevels() * this.getRowHeight() + nGroups * 5 + 20 + 2 + 3 + 5);
        h2 += 11;
        h2 = Math.min(this.maximumHeight, h2);
        return h2;
    }

    private int getRowHeight() {
        if (this.getDisplayMode() == Track.DisplayMode.EXPANDED) {
            return this.expandedHeight;
        }
        if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            return this.collapsedHeight;
        }
        return this.squishedHeight;
    }

    private int getNLevels() {
        return this.dataManager.getNLevels();
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        if (frame.getChrName().equals("All") || frame.getScale() > this.dataManager.getMinVisibleScale()) {
            return true;
        }
        List<InsertionInterval> insertionIntervals = this.getInsertionIntervals(frame);
        insertionIntervals.clear();
        return this.dataManager.isLoaded(frame);
    }

    @Override
    public void load(ReferenceFrame referenceFrame) {
        this.dataManager.load(referenceFrame, this.renderOptions, true);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int seqHeight;
        Graphics2D g2 = context.getGraphics2D("LABEL");
        g2.setFont(FontManager.getFont(10));
        this.dataPanel = context.getPanel();
        int n2 = seqHeight = this.sequenceTrack == null ? 0 : this.sequenceTrack.getHeight();
        if (seqHeight > 0) {
            Rectangle seqRect = new Rectangle(rect);
            seqRect.height = seqHeight;
            this.sequenceTrack.render(context, seqRect);
        }
        rect.y += 2;
        if (context.getScale() > this.dataManager.getMinVisibleScale()) {
            Rectangle visibleRect = context.getVisibleRect().intersection(rect);
            Graphics2D g22 = context.getGraphic2DForColor(Color.gray);
            GraphicUtils.drawCenteredText("Zoom in to see alignments.", visibleRect, g22);
            return;
        }
        this.downsampleRect = new Rectangle(rect);
        this.downsampleRect.height = 3;
        this.renderDownsampledIntervals(context, this.downsampleRect);
        if (this.renderOptions.drawInsertionIntervals) {
            this.insertionRect = new Rectangle(rect);
            this.insertionRect.y += 5;
            this.insertionRect.height = 9;
            this.renderInsertionIntervals(context, this.insertionRect);
            rect.y = this.insertionRect.y + this.insertionRect.height;
        }
        this.alignmentsRect = new Rectangle(rect);
        this.alignmentsRect.y += 2;
        this.alignmentsRect.height -= this.alignmentsRect.y - rect.y;
        this.renderAlignments(context, this.alignmentsRect);
    }

    private void renderDownsampledIntervals(RenderContext context, Rectangle downsampleRect) {
        if (!context.getVisibleRect().intersects(downsampleRect)) {
            return;
        }
        AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(context.getReferenceFrame());
        if (loadedInterval == null) {
            return;
        }
        Graphics2D g2 = context.getGraphic2DForColor(Color.black);
        List<DownsampledInterval> intervals = loadedInterval.getDownsampledIntervals();
        for (DownsampledInterval interval : intervals) {
            double scale = context.getScale();
            double origin = context.getOrigin();
            int x0 = (int)(((double)interval.getStart() - origin) / scale);
            int x1 = (int)(((double)interval.getEnd() - origin) / scale);
            int w2 = Math.max(1, x1 - x0);
            if (w2 > 5) {
                --w2;
            }
            g2.fillRect(x0, downsampleRect.y, w2, downsampleRect.height);
        }
    }

    private List<InsertionInterval> getInsertionIntervals(ReferenceFrame frame) {
        List<InsertionInterval> insertionIntervals = this.insertionIntervalsMap.get(frame);
        if (insertionIntervals == null) {
            insertionIntervals = new ArrayList<InsertionInterval>();
            this.insertionIntervalsMap.put(frame, insertionIntervals);
        }
        return insertionIntervals;
    }

    private void renderInsertionIntervals(RenderContext context, Rectangle rect) {
        if (!context.getVisibleRect().intersects(rect)) {
            return;
        }
        List<InsertionMarker> intervals = context.getInsertionMarkers();
        if (intervals == null) {
            return;
        }
        InsertionMarker selected = InsertionManager.getInstance().getSelectedInsertion(context.getChr());
        int w2 = (int)(1.41 * (double)rect.height / 2.0);
        boolean hideSmallIndex = this.getPreferences().getAsBoolean("SAM.HIDE_SMALL_INDEL");
        int smallIndelThreshold = this.getPreferences().getAsInt("SAM.SMALL_INDEL_BP_THRESHOLD");
        List<InsertionInterval> insertionIntervals = this.getInsertionIntervals(context.getReferenceFrame());
        insertionIntervals.clear();
        for (InsertionMarker insertionMarker : intervals) {
            if (hideSmallIndex && insertionMarker.size < smallIndelThreshold) continue;
            double scale = context.getScale();
            double origin = context.getOrigin();
            int midpoint = (int)(((double)insertionMarker.position - origin) / scale);
            int x0 = midpoint - w2;
            int x1 = midpoint + w2;
            Rectangle iRect = new Rectangle(x0 + context.translateX, rect.y, 2 * w2, rect.height);
            insertionIntervals.add(new InsertionInterval(iRect, insertionMarker));
            Color c2 = selected != null && selected.position == insertionMarker.position ? new Color(200, 0, 0, 80) : AlignmentRenderer.purple;
            Graphics2D g2 = context.getGraphic2DForColor(c2);
            g2.fillPolygon(new Polygon(new int[]{x0, x1, midpoint}, new int[]{rect.y, rect.y, rect.y + rect.height}, 3));
        }
    }

    private void renderAlignments(RenderContext context, Rectangle inputRect) {
        double h2;
        Map<String, PEStats> peStats;
        this.groupNames.clear();
        RenderOptions renderOptions = PreferencesManager.forceDefaults ? new RenderOptions() : this.renderOptions;
        PackedAlignments groups = this.dataManager.getGroups(context, renderOptions);
        if (groups == null) {
            return;
        }
        if (renderOptions.colorOption == null && this.dataManager.hasYCTags()) {
            renderOptions.colorOption = ColorOption.YC_TAG;
        }
        if ((peStats = this.dataManager.getPEStats()) != null) {
            renderOptions.peStats = peStats;
        }
        Rectangle visibleRect = context.getVisibleRect();
        boolean leaveMargin = this.getDisplayMode() != Track.DisplayMode.SQUISHED;
        this.maximumHeight = Integer.MAX_VALUE;
        double y = inputRect.getY();
        if (this.getDisplayMode() == Track.DisplayMode.EXPANDED) {
            h2 = this.expandedHeight;
        } else if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            h2 = this.collapsedHeight;
        } else {
            int visHeight = visibleRect.height;
            int depth = this.dataManager.getNLevels();
            this.squishedHeight = depth == 0 ? Math.min(this.maxSquishedHeight, Math.max(1, this.expandedHeight)) : Math.min(this.maxSquishedHeight, Math.max(1, Math.min(this.expandedHeight, visHeight / depth)));
            h2 = this.squishedHeight;
        }
        Graphics2D groupBorderGraphics = context.getGraphic2DForColor(AlignmentRenderer.GROUP_DIVIDER_COLOR);
        int nGroups = groups.size();
        int groupNumber = 0;
        GroupOption groupOption = renderOptions.groupByOption;
        for (Map.Entry entry : groups.entrySet()) {
            ++groupNumber;
            double yGroup = y;
            List rows = (List)entry.getValue();
            for (Row row : rows) {
                if (visibleRect != null && y > visibleRect.getMaxY()) {
                    return;
                }
                if (y + h2 > visibleRect.getY()) {
                    Rectangle rowRectangle = new Rectangle(inputRect.x, (int)y, inputRect.width, (int)h2);
                    AlignmentCounts alignmentCounts = this.dataManager.getLoadedInterval(context.getReferenceFrame()).getCounts();
                    this.renderer.renderAlignments(row.alignments, context, rowRectangle, inputRect, renderOptions, leaveMargin, this.selectedReadNames, alignmentCounts, this.getPreferences());
                    row.y = y;
                    row.h = h2;
                }
                y += h2;
            }
            if (groupOption != GroupOption.NONE) {
                double groupHeight;
                if (this.showGroupLine && groupNumber < nGroups) {
                    int borderY = (int)y + 2;
                    GraphicUtils.drawDottedDashLine(groupBorderGraphics, inputRect.x, borderY, inputRect.width, borderY);
                }
                if ((groupHeight = (double)rows.size() * h2) > 12.0) {
                    String groupName = (String)entry.getKey();
                    Graphics2D g2 = context.getGraphics2D("LABEL");
                    FontMetrics fm = g2.getFontMetrics();
                    Rectangle2D stringBouds = fm.getStringBounds(groupName, g2);
                    Rectangle rect = new Rectangle(inputRect.x, (int)yGroup, (int)stringBouds.getWidth() + 10, (int)stringBouds.getHeight());
                    GraphicUtils.drawVerticallyCenteredText(groupName, 5, rect, context.getGraphics2D("LABEL"), false, true);
                    this.groupNames.put(new Rectangle(inputRect.x, (int)yGroup, inputRect.width, (int)(y - yGroup)), groupName);
                }
            }
            y += 5.0;
        }
        int bottom = inputRect.y + inputRect.height;
        groupBorderGraphics.drawLine(inputRect.x, bottom, inputRect.width, bottom);
    }

    public void renderExpandedInsertion(InsertionMarker insertionMarker, RenderContext context, Rectangle inputRect) {
        double h2;
        boolean leaveMargin = this.getDisplayMode() != Track.DisplayMode.SQUISHED;
        Graphics2D g2 = context.getGraphic2DForColor(Color.red);
        Rectangle iRect = new Rectangle(inputRect.x, this.insertionRect.y, inputRect.width, this.insertionRect.height);
        g2.fill(iRect);
        List<InsertionInterval> insertionIntervals = this.getInsertionIntervals(context.getReferenceFrame());
        iRect.x += context.translateX;
        insertionIntervals.add(new InsertionInterval(iRect, insertionMarker));
        inputRect.y += 21;
        PackedAlignments groups = this.dataManager.getGroups(context, this.renderOptions);
        if (groups == null) {
            return;
        }
        Rectangle visibleRect = context.getVisibleRect();
        this.maximumHeight = Integer.MAX_VALUE;
        double y = inputRect.getY();
        if (this.getDisplayMode() == Track.DisplayMode.EXPANDED) {
            h2 = this.expandedHeight;
        } else {
            int visHeight = visibleRect.height;
            int depth = this.dataManager.getNLevels();
            this.squishedHeight = depth == 0 ? Math.min(this.maxSquishedHeight, Math.max(1, this.expandedHeight)) : Math.min(this.maxSquishedHeight, Math.max(1, Math.min(this.expandedHeight, visHeight / depth)));
            h2 = this.squishedHeight;
        }
        for (Map.Entry entry : groups.entrySet()) {
            List rows = (List)entry.getValue();
            for (Row row : rows) {
                if (visibleRect != null && y > visibleRect.getMaxY()) {
                    return;
                }
                if (y + h2 > visibleRect.getY()) {
                    Rectangle rowRectangle = new Rectangle(inputRect.x, (int)y, inputRect.width, (int)h2);
                    this.renderer.renderExpandedInsertion(insertionMarker, row.alignments, context, rowRectangle, leaveMargin);
                    row.y = y;
                    row.h = h2;
                }
                y += h2;
            }
            y += 5.0;
        }
    }

    public boolean sortRows(SortOption option, ReferenceFrame referenceFrame, double location, String tag) {
        return this.dataManager.sortRows(option, referenceFrame, location, tag);
    }

    public void groupAlignments(GroupOption option, String tag, Range pos) {
        if (option == GroupOption.TAG && tag != null) {
            this.renderOptions.setGroupByTag(tag);
        }
        if (option == GroupOption.BASE_AT_POS && pos != null) {
            this.renderOptions.setGroupByPos(pos);
        }
        this.renderOptions.groupByOption = option == GroupOption.NONE ? null : option;
        this.dataManager.packAlignments(this.renderOptions);
    }

    public void packAlignments() {
        this.dataManager.packAlignments(this.renderOptions);
    }

    public void copyToClipboard(TrackClickEvent e2, Alignment alignment, double location, int mouseX) {
        if (alignment != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(alignment.getValueString(location, mouseX, null).replace("<br>", "\n"));
            buf.append("\n");
            buf.append("Alignment start position = " + alignment.getChr() + ":" + (alignment.getAlignmentStart() + 1));
            buf.append("\n");
            buf.append(alignment.getReadSequence());
            StringSelection stringSelection = new StringSelection(buf.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    public void gotoMate(TrackClickEvent te, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                this.setSelected(alignment);
                String chr = mate.getChr();
                int start = mate.start - 1;
                double range = te.getFrame().getEnd() - te.getFrame().getOrigin();
                int newStart = (int)Math.max(0.0, (double)(start + (alignment.getEnd() - alignment.getStart()) / 2) - range / 2.0);
                int newEnd = newStart + (int)range;
                te.getFrame().jumpTo(chr, newStart, newEnd);
                te.getFrame().recordHistory();
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    public void splitScreenMate(TrackClickEvent te, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                this.setSelected(alignment);
                String mateChr = mate.getChr();
                int mateStart = mate.start - 1;
                ReferenceFrame frame = te.getFrame();
                String locus1 = frame.getFormattedLocusString();
                Range range = frame.getCurrentRange();
                int length = range.getLength();
                int s2 = Math.max(0, mateStart - length / 2);
                int e2 = s2 + length;
                String startStr = NumberFormat.getInstance().format(s2);
                String endStr = NumberFormat.getInstance().format(e2);
                String mateLocus = mateChr + ":" + startStr + "-" + endStr;
                Session currentSession = IGV.getInstance().getSession();
                List<Object> loci = null;
                if (FrameManager.isGeneListMode()) {
                    loci = new ArrayList(FrameManager.getFrames().size());
                    for (ReferenceFrame referenceFrame : FrameManager.getFrames()) {
                        String string = referenceFrame.getName();
                        if (Locus.fromString(string) != null) {
                            loci.add(string);
                            continue;
                        }
                        loci.add(referenceFrame.getFormattedLocusString());
                    }
                    loci.add(mateLocus);
                } else {
                    loci = Arrays.asList(locus1, mateLocus);
                }
                StringBuffer listName = new StringBuffer();
                for (String string : loci) {
                    listName.append(string + "   ");
                }
                GeneList geneList = new GeneList(listName.toString(), loci, false);
                currentSession.setCurrentGeneList(geneList);
                Comparator<String> comparator = new Comparator<String>(){

                    @Override
                    public int compare(String n0, String n1) {
                        ReferenceFrame f0 = FrameManager.getFrame(n0);
                        ReferenceFrame f1 = FrameManager.getFrame(n1);
                        String chr0 = f0 == null ? "" : f0.getChrName();
                        String chr1 = f1 == null ? "" : f1.getChrName();
                        int s0 = f0 == null ? 0 : f0.getCurrentRange().getStart();
                        int s1 = f1 == null ? 0 : f1.getCurrentRange().getStart();
                        int chrComp = ChromosomeNameComparator.get().compare(chr0, chr1);
                        if (chrComp != 0) {
                            return chrComp;
                        }
                        return s0 - s1;
                    }
                };
                currentSession.sortGeneList(comparator);
                IGV.getInstance().resetFrames();
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    public AlignmentDataManager getDataManager() {
        return this.dataManager;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        if (this.downsampleRect != null && mouseY > this.downsampleRect.y && mouseY <= this.downsampleRect.y + this.downsampleRect.height) {
            AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(frame);
            if (loadedInterval == null) {
                return null;
            }
            List<DownsampledInterval> intervals = loadedInterval.getDownsampledIntervals();
            DownsampledInterval interval = FeatureUtils.getFeatureAt(position, 0, intervals);
            if (interval != null) {
                return interval.getValueString();
            }
            return null;
        }
        InsertionInterval insertionInterval = this.getInsertionInterval(frame, mouseX, mouseY);
        if (insertionInterval != null) {
            return "Insertions (" + insertionInterval.insertionMarker.size + " bases)";
        }
        Alignment feature = this.getAlignmentAt(position, mouseY, frame);
        if (feature != null) {
            return feature.getValueString(position, mouseX, this.getWindowFunction());
        }
        for (Map.Entry<Rectangle, String> groupNameEntry : this.groupNames.entrySet()) {
            Rectangle r2 = groupNameEntry.getKey();
            if (mouseY < r2.y || mouseY >= r2.y + r2.height) continue;
            return groupNameEntry.getValue();
        }
        return null;
    }

    private Alignment getAlignment(TrackClickEvent te) {
        MouseEvent e2 = te.getMouseEvent();
        ReferenceFrame frame = te.getFrame();
        if (frame == null) {
            return null;
        }
        double location = frame.getChromosomePosition(e2.getX());
        return this.getAlignmentAt(location, e2.getY(), frame);
    }

    private Alignment getAlignmentAt(double position, int y, ReferenceFrame frame) {
        if (this.alignmentsRect == null) {
            return null;
        }
        PackedAlignments groups = this.dataManager.getGroupedAlignmentsContaining(position, frame);
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        for (List rows : groups.values()) {
            for (Row row : rows) {
                if (!((double)y >= row.y) || !((double)y <= row.y + row.h)) continue;
                List<Alignment> features = row.alignments;
                int buffer = 0;
                return FeatureUtils.getFeatureAt(position, buffer, features);
            }
        }
        return null;
    }

    private Alignment getSpecficAlignment(TrackClickEvent te) {
        Alignment alignment = this.getAlignment(te);
        if (alignment != null) {
            ReferenceFrame frame = te.getFrame();
            MouseEvent e2 = te.getMouseEvent();
            double location = frame.getChromosomePosition(e2.getX());
            if (alignment instanceof LinkedAlignment) {
                Alignment sa = null;
                for (Alignment a2 : ((LinkedAlignment)alignment).alignments) {
                    if (!a2.contains(location) || sa != null && a2.getAlignmentEnd() - a2.getAlignmentStart() >= sa.getAlignmentEnd() - sa.getAlignmentStart()) continue;
                    sa = a2;
                }
                alignment = sa;
            } else if (alignment instanceof PairedAlignment) {
                Alignment sa = null;
                if (((PairedAlignment)alignment).firstAlignment.contains(location)) {
                    sa = ((PairedAlignment)alignment).firstAlignment;
                } else if (((PairedAlignment)alignment).secondAlignment.contains(location)) {
                    sa = ((PairedAlignment)alignment).secondAlignment;
                }
                alignment = sa;
            }
        }
        return alignment;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        ReferenceFrame frame;
        MouseEvent e2 = te.getMouseEvent();
        if ((Globals.IS_MAC && e2.isMetaDown() || !Globals.IS_MAC && e2.isControlDown()) && (frame = te.getFrame()) != null) {
            this.selectAlignment(e2, frame);
            if (this.dataPanel != null) {
                this.dataPanel.repaint();
            }
            return true;
        }
        InsertionInterval insertionInterval = this.getInsertionInterval(te.getFrame(), te.getMouseEvent().getX(), te.getMouseEvent().getY());
        if (insertionInterval != null) {
            String chrName = te.getFrame().getChrName();
            InsertionMarker currentSelection = InsertionManager.getInstance().getSelectedInsertion(chrName);
            if (currentSelection != null && currentSelection.position == insertionInterval.insertionMarker.position) {
                InsertionManager.getInstance().clearSelected();
            } else {
                InsertionManager.getInstance().setSelected(chrName, insertionInterval.insertionMarker.position);
            }
            IGVEventBus.getInstance().post(new InsertionSelectionEvent(insertionInterval.insertionMarker));
            return true;
        }
        if (IGV.getInstance().isShowDetailsOnClick()) {
            this.openTooltipWindow(te);
            return true;
        }
        return false;
    }

    private void selectAlignment(MouseEvent e2, ReferenceFrame frame) {
        double location = frame.getChromosomePosition(e2.getX());
        Alignment alignment = this.getAlignmentAt(location, e2.getY(), frame);
        if (alignment != null) {
            if (this.selectedReadNames.containsKey(alignment.getReadName())) {
                this.selectedReadNames.remove(alignment.getReadName());
            } else {
                this.setSelected(alignment);
            }
        }
    }

    private InsertionInterval getInsertionInterval(ReferenceFrame frame, int x2, int y) {
        List<InsertionInterval> insertionIntervals = this.getInsertionIntervals(frame);
        for (InsertionInterval i2 : insertionIntervals) {
            if (!i2.rect.contains(x2, y)) continue;
            return i2;
        }
        return null;
    }

    private void setSelected(Alignment alignment) {
        Color c2 = this.readNamePalette.get(alignment.getReadName());
        this.selectedReadNames.put(alignment.getReadName(), c2);
    }

    public void clearCaches() {
        if (this.dataManager != null) {
            this.dataManager.clear();
        }
        if (this.spliceJunctionTrack != null) {
            this.spliceJunctionTrack.clear();
        }
    }

    public static void refresh() {
        IGV.getInstance().getContentPane().getMainPanel().invalidate();
        IGV.getInstance().revalidateTrackPanels();
    }

    public static boolean isBisulfiteColorType(ColorOption o2) {
        return o2.equals((Object)ColorOption.BISULFITE) || o2.equals((Object)ColorOption.NOMESEQ);
    }

    public static String getBisulfiteContextPubStr(BisulfiteContext item) {
        return bisulfiteContextToPubString.get((Object)item);
    }

    public static byte[] getBisulfiteContextPreContext(BisulfiteContext item) {
        Pair<byte[], byte[]> pair = bisulfiteContextToContextString.get((Object)item);
        return pair.getFirst();
    }

    public static byte[] getBisulfiteContextPostContext(BisulfiteContext item) {
        Pair<byte[], byte[]> pair = bisulfiteContextToContextString.get((Object)item);
        return pair.getSecond();
    }

    @Override
    public void restorePersistentState(Node node, int version) throws JAXBException {
        super.restorePersistentState(node, version);
        boolean hasRenderSubTag = false;
        try {
            if (node.hasChildNodes()) {
                NodeList list = node.getChildNodes();
                for (int ii = 0; ii < list.getLength(); ++ii) {
                    Node item = list.item(ii);
                    if (!item.getNodeName().equals("RenderOptions")) continue;
                    hasRenderSubTag = true;
                    break;
                }
            }
            if (hasRenderSubTag) {
                this.renderOptions.setColorOption(this.renderOptions.colorOption);
                return;
            }
            RenderOptions ro = (RenderOptions)IGVSessionReader.getJAXBContext().createUnmarshaller().unmarshal(node, RenderOptions.class).getValue();
            ro.setColorOption(ro.colorOption);
            String shadeBasesKey = "shadeBases";
            String value = Utilities.getNullSafe(node.getAttributes(), shadeBasesKey);
            if (value != null) {
                if (value.equals("false")) {
                    ro.setShadeBasesOption(ShadeBasesOption.NONE);
                } else if (value.equals("true")) {
                    ro.setShadeBasesOption(ShadeBasesOption.QUALITY);
                }
            }
            this.setRenderOptions(ro);
        }
        catch (JAXBException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void setViewAsPairs(boolean vAP) {
        if (vAP && this.renderOptions.groupByOption == GroupOption.STRAND) {
            boolean ungroup = MessageUtils.confirm("\"View as pairs\" is incompatible with \"Group by strand\". Ungroup?");
            if (ungroup) {
                this.renderOptions.setGroupByOption(null);
            } else {
                return;
            }
        }
        this.dataManager.setViewAsPairs(vAP, this.renderOptions);
        AlignmentTrack.refresh();
    }

    public boolean isRemoved() {
        return this.removed;
    }

    IGVPreferences getPreferences() {
        return AlignmentTrack.getPreferences(this.experimentType);
    }

    private static IGVPreferences getPreferences(ExperimentType type) {
        if (Globals.VERSION.contains("2.4")) {
            return PreferencesManager.getPreferences("NULL");
        }
        String prefKey = "NULL";
        if (type == ExperimentType.THIRD_GEN) {
            prefKey = "THIRD_GEN";
        } else if (type == ExperimentType.RNA) {
            prefKey = "RNA";
        }
        return PreferencesManager.getPreferences(prefKey);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clearCaches();
        if (this.dataManager != null) {
            this.dataManager.unsubscribe(this);
        }
        this.dataManager = null;
        this.removed = true;
        this.setVisible(false);
    }

    public boolean isLinkedReads() {
        return this.renderOptions.isLinkedReads();
    }

    public void setLinkedReads(boolean linkedReads, String tag) {
        this.renderOptions.setLinkedReads(linkedReads);
        if (linkedReads) {
            if (this.renderRollback == null) {
                this.renderRollback = new RenderRollback(this.renderOptions, this.getDisplayMode());
            }
            this.renderOptions.setLinkByTag(tag);
            if ("READNAME".equals(tag)) {
                this.renderOptions.setColorOption(ColorOption.LINK_STRAND);
            } else {
                this.renderOptions.setColorOption(ColorOption.TAG);
                this.renderOptions.setColorByTag(tag);
                if (this.dataManager.isPhased()) {
                    this.renderOptions.setGroupByOption(GroupOption.TAG);
                    this.renderOptions.setGroupByTag("HP");
                }
                this.expandedHeight = 10;
                this.showGroupLine = false;
                this.setDisplayMode(Track.DisplayMode.SQUISHED);
            }
        } else if (this.renderRollback != null) {
            this.renderRollback.restore(this.renderOptions);
            this.renderRollback = null;
        }
        this.dataManager.packAlignments(this.renderOptions);
        AlignmentTrack.refresh();
    }

    private static AlignmentTrack getNextTrack() {
        return (AlignmentTrack)IGVSessionReader.getNextTrack();
    }

    private AlignmentBlock getInsertion(Alignment alignment, int pixelX) {
        if (alignment != null && alignment.getInsertions() != null) {
            for (AlignmentBlock block : alignment.getInsertions()) {
                if (!block.containsPixel(pixelX)) continue;
                return block;
            }
        }
        return null;
    }

    static {
        bisulfiteContextToPubString.put(BisulfiteContext.CG, "CG");
        bisulfiteContextToPubString.put(BisulfiteContext.CHH, "CHH");
        bisulfiteContextToPubString.put(BisulfiteContext.CHG, "CHG");
        bisulfiteContextToPubString.put(BisulfiteContext.HCG, "HCG");
        bisulfiteContextToPubString.put(BisulfiteContext.GCH, "GCH");
        bisulfiteContextToPubString.put(BisulfiteContext.WCG, "WCG");
        bisulfiteContextToPubString.put(BisulfiteContext.NONE, "None");
        bisulfiteContextToContextString = new HashMap<BisulfiteContext, Pair<byte[], byte[]>>();
        bisulfiteContextToContextString.put(BisulfiteContext.CG, new Pair<byte[], byte[]>(new byte[0], new byte[]{71}));
        bisulfiteContextToContextString.put(BisulfiteContext.CHH, new Pair<byte[], byte[]>(new byte[0], new byte[]{72, 72}));
        bisulfiteContextToContextString.put(BisulfiteContext.CHG, new Pair<byte[], byte[]>(new byte[0], new byte[]{72, 71}));
        bisulfiteContextToContextString.put(BisulfiteContext.HCG, new Pair<byte[], byte[]>(new byte[]{72}, new byte[]{71}));
        bisulfiteContextToContextString.put(BisulfiteContext.GCH, new Pair<byte[], byte[]>(new byte[]{71}, new byte[]{72}));
        bisulfiteContextToContextString.put(BisulfiteContext.WCG, new Pair<byte[], byte[]>(new byte[]{87}, new byte[]{71}));
        DEFAULT_BISULFITE_CONTEXT = BisulfiteContext.CG;
    }

    @XmlType(name="RenderOptions")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RenderOptions
    implements Cloneable {
        public static final String NAME = "RenderOptions";
        @XmlAttribute
        private ShadeBasesOption shadeBasesOption;
        @XmlAttribute
        private Boolean shadeCenters;
        @XmlAttribute
        private Boolean flagUnmappedPairs;
        @XmlAttribute
        private Boolean showAllBases;
        @XmlAttribute
        private Integer minInsertSize;
        @XmlAttribute
        private Integer maxInsertSize;
        @XmlAttribute
        private ColorOption colorOption;
        @XmlAttribute
        private GroupOption groupByOption;
        @XmlAttribute
        private Boolean viewPairs;
        @XmlAttribute
        private String colorByTag;
        @XmlAttribute
        private String groupByTag;
        @XmlAttribute
        private String sortByTag;
        @XmlAttribute
        private String linkByTag;
        @XmlAttribute
        private Boolean linkedReads;
        @XmlAttribute
        private Boolean quickConsensusMode;
        @XmlAttribute
        private Boolean showMismatches;
        @XmlAttribute
        private Boolean computeIsizes;
        @XmlAttribute
        private Double minInsertSizePercentile;
        @XmlAttribute
        private Double maxInsertSizePercentile;
        @XmlAttribute
        private Boolean pairedArcView;
        @XmlAttribute
        private Boolean flagZeroQualityAlignments;
        @XmlElement
        private Range groupByPos;
        BisulfiteContext bisulfiteContext = BisulfiteContext.CG;
        Map<String, PEStats> peStats;
        boolean drawInsertionIntervals = false;
        DefaultValues defaultValues;

        public RenderOptions() {
            this(ExperimentType.OTHER);
        }

        RenderOptions(ExperimentType experimentType) {
            IGVPreferences prefs = AlignmentTrack.getPreferences(experimentType);
            this.peStats = new HashMap<String, PEStats>();
            this.defaultValues = new DefaultValues(prefs);
        }

        private <T extends Enum<T>> T getFromMap(Map<String, String> attributes, String key, Class<T> clazz, T defaultValue) {
            String value = attributes.get(key);
            if (value == null) {
                return defaultValue;
            }
            return CollUtils.valueOf(clazz, value, defaultValue);
        }

        private String getFromMap(Map<String, String> attributes, String key, String defaultValue) {
            String value = attributes.get(key);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        public void setShowAllBases(boolean showAllBases) {
            this.showAllBases = showAllBases;
        }

        public void setShowMismatches(boolean showMismatches) {
            this.showMismatches = showMismatches;
        }

        public void setMinInsertSize(int minInsertSize) {
            this.minInsertSize = minInsertSize;
        }

        public void setViewPairs(boolean viewPairs) {
            this.viewPairs = viewPairs;
        }

        public void setComputeIsizes(boolean computeIsizes) {
            this.computeIsizes = computeIsizes;
        }

        public void setMaxInsertSizePercentile(double maxInsertSizePercentile) {
            this.maxInsertSizePercentile = maxInsertSizePercentile;
        }

        public void setMaxInsertSize(int maxInsertSize) {
            this.maxInsertSize = maxInsertSize;
        }

        public void setMinInsertSizePercentile(double minInsertSizePercentile) {
            this.minInsertSizePercentile = minInsertSizePercentile;
        }

        public void setColorByTag(String colorByTag) {
            this.colorByTag = colorByTag;
        }

        public void setColorOption(ColorOption colorOption) {
            this.colorOption = colorOption;
        }

        public void setSortByTag(String sortByTag) {
            this.sortByTag = sortByTag;
        }

        public void setGroupByTag(String groupByTag) {
            this.groupByTag = groupByTag;
        }

        public void setGroupByPos(Range groupByPos) {
            this.groupByPos = groupByPos;
        }

        public void setLinkByTag(String linkByTag) {
            this.linkByTag = linkByTag;
        }

        public void setQuickConsensusMode(boolean quickConsensusMode) {
            this.quickConsensusMode = quickConsensusMode;
        }

        public void setGroupByOption(GroupOption groupByOption) {
            this.groupByOption = groupByOption;
        }

        public void setShadeBasesOption(ShadeBasesOption shadeBasesOption) {
            this.shadeBasesOption = shadeBasesOption;
        }

        public void setLinkedReads(boolean linkedReads) {
            this.linkedReads = linkedReads;
        }

        public int getMinInsertSize() {
            return this.minInsertSize == null ? this.defaultValues.minInsertSize : this.minInsertSize;
        }

        public int getMaxInsertSize() {
            return this.maxInsertSize == null ? this.defaultValues.maxInsertSize : this.maxInsertSize;
        }

        public boolean isFlagUnmappedPairs() {
            return this.flagUnmappedPairs == null ? this.defaultValues.flagUnmappedPairs : this.flagUnmappedPairs;
        }

        public ShadeBasesOption getShadeBasesOption() {
            return this.shadeBasesOption == null ? this.defaultValues.shadeBasesOption : this.shadeBasesOption;
        }

        public boolean isShowMismatches() {
            return this.showMismatches == null ? this.defaultValues.showMismatches : this.showMismatches;
        }

        public boolean isShowAllBases() {
            return this.showAllBases == null ? this.defaultValues.showAllBases : this.showAllBases;
        }

        public boolean isShadeCenters() {
            return this.shadeCenters == null ? this.defaultValues.shadeCenters : this.shadeCenters;
        }

        public boolean isDrawInsertionIntervals() {
            return this.drawInsertionIntervals;
        }

        public boolean isFlagZeroQualityAlignments() {
            return this.flagZeroQualityAlignments == null ? this.defaultValues.flagZeroQualityAlignments : this.flagZeroQualityAlignments;
        }

        public boolean isViewPairs() {
            return this.viewPairs == null ? this.defaultValues.viewPairs : this.viewPairs;
        }

        public boolean isComputeIsizes() {
            return this.computeIsizes == null ? this.defaultValues.computeIsizes : this.computeIsizes;
        }

        public double getMinInsertSizePercentile() {
            return this.minInsertSizePercentile == null ? this.defaultValues.minInsertSizePercentile : this.minInsertSizePercentile;
        }

        public double getMaxInsertSizePercentile() {
            return this.maxInsertSizePercentile == null ? this.defaultValues.maxInsertSizePercentile : this.maxInsertSizePercentile;
        }

        public ColorOption getColorOption() {
            return this.colorOption == null ? this.defaultValues.colorOption : this.colorOption;
        }

        public String getColorByTag() {
            return this.colorByTag == null ? this.defaultValues.colorByTag : this.colorByTag;
        }

        public String getSortByTag() {
            return this.sortByTag == null ? this.defaultValues.sortByTag : this.sortByTag;
        }

        public String getGroupByTag() {
            return this.groupByTag == null ? this.defaultValues.groupByTag : this.groupByTag;
        }

        public Range getGroupByPos() {
            return this.groupByPos == null ? this.defaultValues.groupByPos : this.groupByPos;
        }

        public String getLinkByTag() {
            return this.linkByTag == null ? this.defaultValues.linkByTag : this.linkByTag;
        }

        public GroupOption getGroupByOption() {
            return this.groupByOption == null ? this.defaultValues.groupByOption : this.groupByOption;
        }

        public boolean isLinkedReads() {
            return this.linkedReads == null ? this.defaultValues.linkedReads : this.linkedReads;
        }

        public boolean isQuickConsensusMode() {
            return this.quickConsensusMode == null ? this.defaultValues.quickConsensusMode : this.quickConsensusMode;
        }

        public void refreshDefaults(ExperimentType experimentType) {
            this.defaultValues = new DefaultValues(AlignmentTrack.getPreferences(experimentType));
        }

        static class DefaultValues {
            public ShadeBasesOption shadeBasesOption;
            public boolean shadeCenters;
            public boolean flagUnmappedPairs;
            public boolean showAllBases;
            public int minInsertSize;
            public int maxInsertSize;
            public ColorOption colorOption;
            public GroupOption groupByOption;
            public boolean viewPairs;
            public String colorByTag;
            public String groupByTag;
            public String sortByTag;
            public String linkByTag;
            public boolean linkedReads;
            public boolean quickConsensusMode;
            public boolean showMismatches;
            public boolean computeIsizes;
            public double minInsertSizePercentile;
            public double maxInsertSizePercentile;
            public boolean pairedArcView;
            public boolean flagZeroQualityAlignments;
            public Range groupByPos;

            DefaultValues(IGVPreferences prefs) {
                String shadeOptionString = prefs.get("SAM.SHADE_BASE_QUALITY");
                this.shadeBasesOption = shadeOptionString.equals("false") ? ShadeBasesOption.NONE : (shadeOptionString.equals("true") ? ShadeBasesOption.QUALITY : ShadeBasesOption.valueOf(shadeOptionString));
                this.shadeCenters = prefs.getAsBoolean("SAM.SHADE_CENTER");
                this.flagUnmappedPairs = prefs.getAsBoolean("SAM.FLAG_UNMAPPED_PAIR");
                this.computeIsizes = prefs.getAsBoolean("SAM.COMPUTE_ISIZES");
                this.minInsertSize = prefs.getAsInt("SAM.MIN_INSERT_SIZE_THRESHOLD");
                this.maxInsertSize = prefs.getAsInt("SAM.INSERT_SIZE_THRESHOLD");
                this.minInsertSizePercentile = prefs.getAsFloat("SAM.MIN_ISIZE_MIN_PERCENTILE");
                this.maxInsertSizePercentile = prefs.getAsFloat("SAM.ISIZE_MAX_PERCENTILE");
                this.showAllBases = prefs.getAsBoolean("SAM.SHOW_ALL_BASES");
                this.quickConsensusMode = prefs.getAsBoolean("SAM.QUICK_CONSENSUS_MODE");
                this.colorOption = CollUtils.valueOf(ColorOption.class, prefs.get("SAM.COLOR_BY"), ColorOption.NONE);
                this.groupByOption = CollUtils.valueOf(GroupOption.class, prefs.get("SAM.GROUP_OPTION"), GroupOption.NONE);
                this.flagZeroQualityAlignments = prefs.getAsBoolean("SAM.FLAG_ZERO_QUALITY");
                this.showMismatches = prefs.getAsBoolean("SAM.SHOW_MISMATCHES");
                this.viewPairs = false;
                this.pairedArcView = false;
                this.colorByTag = prefs.get("SAM.COLOR_BY_TAG");
                this.sortByTag = prefs.get("SAM.SORT_BY_TAG");
                this.groupByTag = prefs.get("SAM.GROUP_BY_TAG");
                this.linkedReads = prefs.getAsBoolean("SAM.LINK_READS");
                this.linkByTag = prefs.get("SAM.LINK_TAG");
                String pos = prefs.get("SAM.GROUP_BY_POS");
                if (pos != null) {
                    String[] posParts = pos.split(" ");
                    if (posParts.length != 2) {
                        this.groupByPos = null;
                    } else {
                        int posChromStart = Integer.valueOf(posParts[1]);
                        this.groupByPos = new Range(posParts[0], posChromStart, posChromStart + 1);
                    }
                }
            }
        }
    }

    static class InsertionMenu
    extends IGVPopupMenu {
        AlignmentBlock insertion;

        InsertionMenu(AlignmentBlock insertion) {
            this.insertion = insertion;
            this.addCopySequenceItem();
            if (insertion.getBases() != null && insertion.getBases().length > 10) {
                this.addBlatItem();
            }
        }

        public void addCopySequenceItem() {
            JMenuItem item = new JMenuItem("Copy insert sequence");
            this.add(item);
            item.addActionListener(aEvt -> StringUtils.copyTextToClipboard(new String(this.insertion.getBases())));
        }

        public void addBlatItem() {
            JMenuItem item = new JMenuItem("Blat insert sequence");
            this.add(item);
            item.addActionListener(aEvt -> {
                String blatSeq = new String(this.insertion.getBases());
                BlatClient.doBlatQuery(blatSeq);
            });
        }

        @Override
        public boolean includeStandardItems() {
            return false;
        }
    }

    class PopupMenu
    extends IGVPopupMenu {
        PopupMenu(TrackClickEvent e2) {
            boolean showSashimi;
            MouseEvent me = e2.getMouseEvent();
            ReferenceFrame frame = e2.getFrame();
            Alignment clickedAlignment = null;
            if (frame != null) {
                double location = frame.getChromosomePosition(me.getX());
                clickedAlignment = frame == null ? null : AlignmentTrack.this.getAlignmentAt(location, me.getY(), frame);
            }
            ArrayList<Track> tracks = new ArrayList<Track>();
            tracks.add(AlignmentTrack.this);
            JLabel popupTitle = new JLabel("  " + AlignmentTrack.this.getName(), 0);
            Font newFont = this.getFont().deriveFont(1, 12.0f);
            popupTitle.setFont(newFont);
            if (popupTitle != null) {
                this.add(popupTitle);
            }
            this.addSeparator();
            this.add(TrackMenuUtils.getTrackRenameItem(tracks));
            this.addCopyToClipboardItem(e2, clickedAlignment);
            if (AlignmentTrack.this.dataManager.isTenX()) {
                this.addTenXItems();
            } else {
                this.addSupplItems();
            }
            this.addSeparator();
            this.addGroupMenuItem(e2);
            this.addSortMenuItem();
            this.addColorByMenuItem();
            this.addPackMenuItem();
            this.addSeparator();
            this.addShadeBaseByMenuItem();
            JMenuItem misMatchesItem = this.addShowMismatchesMenuItem();
            JMenuItem showAllItem = this.addShowAllBasesMenuItem();
            misMatchesItem.addActionListener(new Deselector(misMatchesItem, showAllItem));
            showAllItem.addActionListener(new Deselector(showAllItem, misMatchesItem));
            this.addQuickConsensusModeItem();
            this.addSeparator();
            this.addViewAsPairsMenuItem();
            if (clickedAlignment != null) {
                this.addGoToMate(e2, clickedAlignment);
                this.showMateRegion(e2, clickedAlignment);
            }
            this.addInsertSizeMenuItem();
            this.addSeparator();
            TrackMenuUtils.addDisplayModeItems(tracks, this);
            this.addSeparator();
            this.addSelectByNameItem();
            this.addClearSelectionsMenuItem();
            this.addSeparator();
            this.addCopySequenceItem(e2);
            this.addBlatItem(e2);
            this.addConsensusSequence(e2);
            AlignmentBlock insertion = AlignmentTrack.this.getInsertion(clickedAlignment, e2.getMouseEvent().getX());
            if (insertion != null) {
                this.addSeparator();
                this.addInsertionItems(insertion);
            }
            if (showSashimi = true) {
                this.addSeparator();
                JMenuItem sashimi = new JMenuItem("Sashimi Plot");
                sashimi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        SashimiPlot.getSashimiPlot(null);
                    }
                });
                this.add(sashimi);
            }
            this.addSeparator();
            this.addShowItems();
            if (AlignmentTrack.this.getPreferences().get("EXTVIEW_URL") != null) {
                this.addSeparator();
                this.addExtViewItem(e2);
            }
            if (PreferencesManager.getPreferences().getAsBoolean("SCORE_VARIANTS")) {
                this.addSeparator();
                JMenuItem mi = new JMenuItem("Score variant");
                mi.addActionListener(e13 -> VariantReviewAction.scoreMutationItem(AlignmentTrack.this.dataPanel, AlignmentTrack.this, e2));
                this.add(mi);
            }
        }

        public JMenuItem addExpandInsertions() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Expand insertions");
            Session session = IGV.getInstance().getSession();
            item.setSelected(session.expandInsertions);
            item.addActionListener(aEvt -> {
                session.expandInsertions = !session.expandInsertions;
                AlignmentTrack.refresh();
            });
            this.add(item);
            return item;
        }

        private void addConsensusSequence(TrackClickEvent e2) {
            JMenuItem item = new JMenuItem("Copy consensus sequence");
            final ReferenceFrame frame = e2.getFrame() == null && FrameManager.getFrames().size() == 1 ? FrameManager.getFrames().get(0) : e2.getFrame();
            item.setEnabled(frame != null);
            this.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (frame == null) {
                        MessageUtils.showMessage("Unknown region bounds, cannot export consensus");
                        return;
                    }
                    int start = (int)frame.getOrigin();
                    int end = (int)frame.getEnd();
                    if (end - start > 1000000) {
                        MessageUtils.showMessage("Cannot export region more than 1 Megabase");
                        return;
                    }
                    AlignmentInterval interval = AlignmentTrack.this.dataManager.getLoadedInterval(frame);
                    AlignmentCounts counts = interval.getCounts();
                    String text = PFMExporter.createPFMText(counts, frame.getChrName(), start, end);
                    StringUtils.copyTextToClipboard(text);
                }
            });
        }

        private JMenu getBisulfiteContextMenuItem(ButtonGroup group) {
            JMenu bisulfiteContextMenu = new JMenu("bisulfite mode");
            JRadioButtonMenuItem nomeESeqOption = null;
            boolean showNomeESeq = AlignmentTrack.this.getPreferences().getAsBoolean("SAM.NOMESEQ_ENABLED");
            if (showNomeESeq) {
                nomeESeqOption = new JRadioButtonMenuItem("NOMe-seq bisulfite mode");
                nomeESeqOption.setSelected(AlignmentTrack.this.renderOptions.getColorOption() == ColorOption.NOMESEQ);
                nomeESeqOption.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        PopupMenu.this.setColorOption(ColorOption.NOMESEQ);
                        AlignmentTrack.refresh();
                    }
                });
                group.add(nomeESeqOption);
            }
            for (final BisulfiteContext item : BisulfiteContext.values()) {
                String optionStr = AlignmentTrack.getBisulfiteContextPubStr(item);
                JRadioButtonMenuItem m1 = new JRadioButtonMenuItem(optionStr);
                m1.setSelected(AlignmentTrack.this.renderOptions.bisulfiteContext == item);
                m1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        PopupMenu.this.setColorOption(ColorOption.BISULFITE);
                        PopupMenu.this.setBisulfiteContext(item);
                        AlignmentTrack.refresh();
                    }
                });
                bisulfiteContextMenu.add(m1);
                group.add(m1);
            }
            if (nomeESeqOption != null) {
                bisulfiteContextMenu.add(nomeESeqOption);
            }
            return bisulfiteContextMenu;
        }

        public void addSelectByNameItem() {
            JMenuItem item = new JMenuItem("Select by name...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    String val = MessageUtils.showInputDialog("Enter read name: ");
                    if (val != null && val.trim().length() > 0) {
                        AlignmentTrack.this.selectedReadNames.put(val, AlignmentTrack.this.readNamePalette.get(val));
                        AlignmentTrack.refresh();
                    }
                }
            });
            this.add(item);
        }

        private JCheckBoxMenuItem getGroupMenuItem(String label, final GroupOption option) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(label);
            mi.setSelected(AlignmentTrack.this.renderOptions.getGroupByOption() == option);
            if (option == GroupOption.NONE) {
                mi.setSelected(AlignmentTrack.this.renderOptions.getGroupByOption() == null);
            }
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    IGV.getInstance().groupAlignmentTracks(option, null, null);
                    AlignmentTrack.refresh();
                }
            });
            return mi;
        }

        public void addGroupMenuItem(TrackClickEvent te) {
            MouseEvent me = te.getMouseEvent();
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                frame = FrameManager.getDefaultFrame();
            }
            Range range = frame.getCurrentRange();
            final String chrom = range.getChr();
            final int chromStart = (int)frame.getChromosomePosition(me.getX());
            JMenu groupMenu = new JMenu("Group alignments by");
            ButtonGroup group = new ButtonGroup();
            LinkedHashMap<String, GroupOption> mappings = new LinkedHashMap<String, GroupOption>();
            mappings.put("none", GroupOption.NONE);
            mappings.put("read strand", GroupOption.STRAND);
            mappings.put("first-in-pair strand", GroupOption.FIRST_OF_PAIR_STRAND);
            mappings.put("sample", GroupOption.SAMPLE);
            mappings.put("library", GroupOption.LIBRARY);
            mappings.put("read group", GroupOption.READ_GROUP);
            mappings.put("chromosome of mate", GroupOption.MATE_CHROMOSOME);
            mappings.put("pair orientation", GroupOption.PAIR_ORIENTATION);
            mappings.put("supplementary flag", GroupOption.SUPPLEMENTARY);
            for (Map.Entry el : mappings.entrySet()) {
                JCheckBoxMenuItem mi = this.getGroupMenuItem((String)el.getKey(), (GroupOption)((Object)el.getValue()));
                groupMenu.add(mi);
                group.add(mi);
            }
            JCheckBoxMenuItem tagOption = new JCheckBoxMenuItem("tag");
            tagOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    String tag = MessageUtils.showInputDialog("Enter tag", AlignmentTrack.this.renderOptions.getGroupByTag());
                    if (tag != null && tag.trim().length() > 0) {
                        IGV.getInstance().groupAlignmentTracks(GroupOption.TAG, tag, null);
                    }
                }
            });
            tagOption.setSelected(AlignmentTrack.this.renderOptions.getGroupByOption() == GroupOption.TAG);
            groupMenu.add(tagOption);
            group.add(tagOption);
            Range oldGroupByPos = AlignmentTrack.this.renderOptions.getGroupByPos();
            if (AlignmentTrack.this.renderOptions.getGroupByOption() == GroupOption.BASE_AT_POS) {
                JCheckBoxMenuItem oldGroupByPosOption = new JCheckBoxMenuItem("base at " + oldGroupByPos.getChr() + ":" + Globals.DECIMAL_FORMAT.format(1 + oldGroupByPos.getStart()));
                groupMenu.add(oldGroupByPosOption);
                oldGroupByPosOption.setSelected(true);
            }
            if (AlignmentTrack.this.renderOptions.getGroupByOption() != GroupOption.BASE_AT_POS || oldGroupByPos == null || !oldGroupByPos.getChr().equals(chrom) || oldGroupByPos.getStart() != chromStart) {
                JCheckBoxMenuItem newGroupByPosOption = new JCheckBoxMenuItem("base at " + chrom + ":" + Globals.DECIMAL_FORMAT.format(1 + chromStart));
                newGroupByPosOption.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        Range groupByPos = new Range(chrom, chromStart, chromStart + 1);
                        IGV.getInstance().groupAlignmentTracks(GroupOption.BASE_AT_POS, null, groupByPos);
                    }
                });
                groupMenu.add(newGroupByPosOption);
                group.add(newGroupByPosOption);
            }
            this.add(groupMenu);
        }

        private JMenuItem getSortMenuItem(String label, SortOption option) {
            JMenuItem mi = new JMenuItem(label);
            mi.addActionListener(aEvt -> AlignmentTrack.sortAlignmentTracks(option, null));
            return mi;
        }

        public void addSortMenuItem() {
            JMenu sortMenu = new JMenu("Sort alignments by");
            LinkedHashMap<String, SortOption> mappings = new LinkedHashMap<String, SortOption>();
            mappings.put("start location", SortOption.START);
            mappings.put("read strand", SortOption.STRAND);
            mappings.put("first-of-pair strand", SortOption.FIRST_OF_PAIR_STRAND);
            mappings.put("base", SortOption.NUCLEOTIDE);
            mappings.put("mapping quality", SortOption.QUALITY);
            mappings.put("sample", SortOption.SAMPLE);
            mappings.put("read group", SortOption.READ_GROUP);
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                mappings.put("insert size", SortOption.INSERT_SIZE);
                mappings.put("chromosome of mate", SortOption.MATE_CHR);
            }
            for (Map.Entry el : mappings.entrySet()) {
                sortMenu.add(this.getSortMenuItem((String)el.getKey(), (SortOption)((Object)el.getValue())));
            }
            JMenuItem tagOption = new JMenuItem("tag");
            tagOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    String tag = MessageUtils.showInputDialog("Enter tag", AlignmentTrack.this.renderOptions.getSortByTag());
                    if (tag != null && tag.trim().length() > 0) {
                        AlignmentTrack.this.renderOptions.setSortByTag(tag);
                        AlignmentTrack.sortAlignmentTracks(SortOption.TAG, tag);
                    }
                }
            });
            sortMenu.add(tagOption);
            this.add(sortMenu);
        }

        private void setBisulfiteContext(BisulfiteContext option) {
            AlignmentTrack.this.renderOptions.bisulfiteContext = option;
            AlignmentTrack.this.getPreferences().put("SAM.BISULFITE_CONTEXT", option.toString());
        }

        private void setColorOption(ColorOption option) {
            AlignmentTrack.this.renderOptions.setColorOption(option);
            AlignmentTrack.this.getPreferences().put("SAM.COLOR_BY", option.toString());
        }

        private JRadioButtonMenuItem getColorMenuItem(String label, ColorOption option) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(label);
            mi.setSelected(AlignmentTrack.this.renderOptions.getColorOption() == option);
            mi.addActionListener(aEvt -> {
                this.setColorOption(option);
                AlignmentTrack.refresh();
            });
            return mi;
        }

        public void addColorByMenuItem() {
            JMenu colorMenu = new JMenu("Color alignments by");
            ButtonGroup group = new ButtonGroup();
            LinkedHashMap<String, ColorOption> mappings = new LinkedHashMap<String, ColorOption>();
            mappings.put("no color", ColorOption.NONE);
            if (AlignmentTrack.this.dataManager.hasYCTags()) {
                mappings.put("YC tag", ColorOption.YC_TAG);
            }
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                mappings.put("insert size", ColorOption.INSERT_SIZE);
                mappings.put("pair orientation", ColorOption.PAIR_ORIENTATION);
                mappings.put("insert size and pair orientation", ColorOption.UNEXPECTED_PAIR);
            }
            mappings.put("read strand", ColorOption.READ_STRAND);
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                mappings.put("first-of-pair strand", ColorOption.FIRST_OF_PAIR_STRAND);
            }
            mappings.put("read group", ColorOption.READ_GROUP);
            mappings.put("sample", ColorOption.SAMPLE);
            mappings.put("library", ColorOption.LIBRARY);
            for (Map.Entry el : mappings.entrySet()) {
                JRadioButtonMenuItem mi = this.getColorMenuItem((String)el.getKey(), (ColorOption)((Object)el.getValue()));
                colorMenu.add(mi);
                group.add(mi);
            }
            JRadioButtonMenuItem tagOption = new JRadioButtonMenuItem("tag");
            tagOption.setSelected(AlignmentTrack.this.renderOptions.getColorOption() == ColorOption.TAG);
            tagOption.addActionListener(aEvt -> {
                this.setColorOption(ColorOption.TAG);
                String tag = MessageUtils.showInputDialog("Enter tag", AlignmentTrack.this.renderOptions.getColorByTag());
                if (tag != null && tag.trim().length() > 0) {
                    AlignmentTrack.this.renderOptions.setColorByTag(tag);
                    AlignmentTrack.getPreferences(AlignmentTrack.this.experimentType).put("SAM.COLOR_BY_TAG", tag);
                    AlignmentTrack.refresh();
                }
            });
            colorMenu.add(tagOption);
            group.add(tagOption);
            colorMenu.add(this.getBisulfiteContextMenuItem(group));
            this.add(colorMenu);
        }

        public void addPackMenuItem() {
            JMenuItem item = new JMenuItem("Re-pack alignments");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            IGV.getInstance().packAlignmentTracks();
                            AlignmentTrack.refresh();
                        }
                    });
                }
            });
            this.add(item);
        }

        public void addCopyToClipboardItem(final TrackClickEvent te, final Alignment alignment) {
            final MouseEvent me = te.getMouseEvent();
            JMenuItem item = new JMenuItem("Copy read details to clipboard");
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                final double location = frame.getChromosomePosition(me.getX());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.copyToClipboard(te, alignment, location, me.getX());
                    }
                });
                if (alignment == null) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        public void addViewAsPairsMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("View as pairs");
            item.setSelected(AlignmentTrack.this.renderOptions.isViewPairs());
            item.addActionListener(aEvt -> {
                boolean viewAsPairs = item.isSelected();
                AlignmentTrack.this.setViewAsPairs(viewAsPairs);
            });
            item.setEnabled(AlignmentTrack.this.dataManager.isPairedEnd());
            this.add(item);
        }

        public void addGoToMate(TrackClickEvent te, Alignment alignment) {
            JMenuItem item = new JMenuItem("Go to mate");
            MouseEvent e2 = te.getMouseEvent();
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                item.addActionListener(aEvt -> AlignmentTrack.this.gotoMate(te, alignment));
                if (alignment == null || !alignment.isPaired() || !alignment.getMate().isMapped()) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        public void showMateRegion(TrackClickEvent te, Alignment clickedAlignment) {
            JMenuItem item = new JMenuItem("View mate region in split screen");
            MouseEvent e2 = te.getMouseEvent();
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                double location = frame.getChromosomePosition(e2.getX());
                if (clickedAlignment instanceof PairedAlignment) {
                    Alignment first = ((PairedAlignment)clickedAlignment).getFirstAlignment();
                    Alignment second = ((PairedAlignment)clickedAlignment).getSecondAlignment();
                    clickedAlignment = first.contains(location) ? first : (second.contains(location) ? second : null);
                }
                Alignment alignment = clickedAlignment;
                item.addActionListener(aEvt -> AlignmentTrack.this.splitScreenMate(te, alignment));
                if (alignment == null || !alignment.isPaired() || !alignment.getMate().isMapped()) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        public void addClearSelectionsMenuItem() {
            JMenuItem item = new JMenuItem("Clear selections");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    AlignmentTrack.this.selectedReadNames.clear();
                    AlignmentTrack.refresh();
                }
            });
            this.add(item);
        }

        public JMenuItem addShowAllBasesMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show all bases");
            if (AlignmentTrack.this.renderOptions.getColorOption() != ColorOption.BISULFITE && AlignmentTrack.this.renderOptions.getColorOption() != ColorOption.NOMESEQ) {
                item.setSelected(AlignmentTrack.this.renderOptions.isShowAllBases());
            }
            item.addActionListener(aEvt -> {
                AlignmentTrack.this.renderOptions.setShowAllBases(item.isSelected());
                AlignmentTrack.refresh();
            });
            this.add(item);
            return item;
        }

        public JMenuItem addQuickConsensusModeItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Quick consensus mode");
            item.setSelected(AlignmentTrack.this.renderOptions.isQuickConsensusMode());
            item.addActionListener(aEvt -> {
                AlignmentTrack.this.renderOptions.setQuickConsensusMode(item.isSelected());
                AlignmentTrack.refresh();
            });
            this.add(item);
            return item;
        }

        public JMenuItem addShowMismatchesMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show mismatched bases");
            item.setSelected(AlignmentTrack.this.renderOptions.isShowMismatches());
            item.addActionListener(aEvt -> {
                AlignmentTrack.this.renderOptions.setShowMismatches(item.isSelected());
                AlignmentTrack.refresh();
            });
            this.add(item);
            return item;
        }

        public void addInsertSizeMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Set insert size options ...");
            item.addActionListener(aEvt -> {
                InsertSizeSettingsDialog dlg = new InsertSizeSettingsDialog(IGV.getMainFrame(), AlignmentTrack.this.renderOptions);
                dlg.setModal(true);
                dlg.setVisible(true);
                if (!dlg.isCanceled()) {
                    AlignmentTrack.this.renderOptions.setComputeIsizes(dlg.isComputeIsize());
                    AlignmentTrack.this.renderOptions.setMinInsertSizePercentile(dlg.getMinPercentile());
                    AlignmentTrack.this.renderOptions.setMaxInsertSizePercentile(dlg.getMaxPercentile());
                    if (AlignmentTrack.this.renderOptions.computeIsizes.booleanValue()) {
                        AlignmentTrack.this.dataManager.updatePEStats(AlignmentTrack.this.renderOptions);
                    }
                    AlignmentTrack.this.renderOptions.setMinInsertSize(dlg.getMinThreshold());
                    AlignmentTrack.this.renderOptions.setMaxInsertSize(dlg.getMaxThreshold());
                    AlignmentTrack.refresh();
                }
            });
            item.setEnabled(AlignmentTrack.this.dataManager.isPairedEnd());
            this.add(item);
        }

        public void addShadeBaseByMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Shade base by quality");
            item.setSelected(AlignmentTrack.this.renderOptions.getShadeBasesOption() == ShadeBasesOption.QUALITY);
            item.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
                if (item.isSelected()) {
                    AlignmentTrack.this.renderOptions.setShadeBasesOption(ShadeBasesOption.QUALITY);
                } else {
                    AlignmentTrack.this.renderOptions.setShadeBasesOption(ShadeBasesOption.NONE);
                }
                AlignmentTrack.refresh();
            }));
            this.add(item);
        }

        public void addShowItems() {
            JCheckBoxMenuItem item;
            if (AlignmentTrack.this.coverageTrack != null) {
                item = new JCheckBoxMenuItem("Show Coverage Track");
                item.setSelected(AlignmentTrack.this.coverageTrack.isVisible());
                item.setEnabled(!AlignmentTrack.this.coverageTrack.isRemoved());
                item.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
                    if (AlignmentTrack.this.getCoverageTrack() != null) {
                        AlignmentTrack.this.getCoverageTrack().setVisible(item.isSelected());
                        IGV.getInstance().getMainPanel().revalidate();
                    }
                }));
                this.add(item);
            }
            if (AlignmentTrack.this.spliceJunctionTrack != null) {
                item = new JCheckBoxMenuItem("Show Splice Junction Track");
                item.setSelected(AlignmentTrack.this.spliceJunctionTrack.isVisible());
                item.setEnabled(!AlignmentTrack.this.spliceJunctionTrack.isRemoved());
                item.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
                    if (AlignmentTrack.this.spliceJunctionTrack != null) {
                        AlignmentTrack.this.spliceJunctionTrack.setVisible(item.isSelected());
                    }
                }));
                this.add(item);
            }
            JMenuItem alignmentItem = new JMenuItem("Hide Alignment Track");
            alignmentItem.setEnabled(!AlignmentTrack.this.isRemoved());
            alignmentItem.addActionListener(e2 -> AlignmentTrack.this.setVisible(false));
            this.add(alignmentItem);
        }

        public void addCopySequenceItem(TrackClickEvent te) {
            JMenuItem item = new JMenuItem("Copy read sequence");
            this.add(item);
            Alignment alignment = AlignmentTrack.this.getAlignment(te);
            if (alignment == null) {
                item.setEnabled(false);
                return;
            }
            String seq = alignment.getReadSequence();
            if (seq == null) {
                item.setEnabled(false);
                return;
            }
            item.addActionListener(aEvt -> StringUtils.copyTextToClipboard(seq));
        }

        public void addBlatItem(TrackClickEvent te) {
            JMenuItem item = new JMenuItem("Blat read sequence");
            this.add(item);
            Alignment alignment = AlignmentTrack.this.getSpecficAlignment(te);
            if (alignment == null) {
                item.setEnabled(false);
                return;
            }
            String seq = alignment.getReadSequence();
            if (seq == null) {
                item.setEnabled(false);
                return;
            }
            item.addActionListener(aEvt -> {
                String blatSeq = alignment.getReadStrand() == Strand.NEGATIVE ? SequenceTrack.getReverseComplement(seq) : seq;
                BlatClient.doBlatQuery(blatSeq);
            });
        }

        public void addExtViewItem(TrackClickEvent te) {
            JMenuItem item = new JMenuItem("ExtView");
            this.add(item);
            final Alignment alignment = AlignmentTrack.this.getAlignment(te);
            if (alignment == null) {
                item.setEnabled(false);
                return;
            }
            String seq = alignment.getReadSequence();
            if (seq == null) {
                item.setEnabled(false);
                return;
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    ExtendViewClient.postExtendView(alignment);
                }
            });
        }

        public void addTenXItems() {
            this.addSeparator();
            final JCheckBoxMenuItem bxItem = new JCheckBoxMenuItem("View linked reads (BX)");
            final JCheckBoxMenuItem miItem = new JCheckBoxMenuItem("View linked reads (MI)");
            if (AlignmentTrack.this.isLinkedReads()) {
                bxItem.setSelected("BX".equals(AlignmentTrack.this.renderOptions.getLinkByTag()));
                miItem.setSelected("MI".equals(AlignmentTrack.this.renderOptions.getLinkByTag()));
            } else {
                bxItem.setSelected(false);
                miItem.setSelected(false);
            }
            bxItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    boolean linkedReads = bxItem.isSelected();
                    AlignmentTrack.this.setLinkedReads(linkedReads, "BX");
                }
            });
            this.add(bxItem);
            miItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    boolean linkedReads = miItem.isSelected();
                    AlignmentTrack.this.setLinkedReads(linkedReads, "MI");
                }
            });
            this.add(miItem);
        }

        public void addSupplItems() {
            this.addSeparator();
            final JCheckBoxMenuItem bxItem = new JCheckBoxMenuItem("Link supplementary alignments");
            if (AlignmentTrack.this.isLinkedReads()) {
                bxItem.setSelected("READNAME".equals(AlignmentTrack.this.renderOptions.getLinkByTag()));
            } else {
                bxItem.setSelected(false);
            }
            bxItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    boolean linkedReads = bxItem.isSelected();
                    AlignmentTrack.this.setLinkedReads(linkedReads, "READNAME");
                }
            });
            this.add(bxItem);
        }

        private void addInsertionItems(AlignmentBlock insertion) {
            JMenuItem item = new JMenuItem("Copy insert sequence");
            this.add(item);
            item.addActionListener(aEvt -> StringUtils.copyTextToClipboard(new String(insertion.getBases())));
            if (insertion.getBases() != null && insertion.getBases().length > 10) {
                JMenuItem blatItem = new JMenuItem("Blat insert sequence");
                this.add(blatItem);
                blatItem.addActionListener(aEvt -> {
                    String blatSeq = new String(insertion.getBases());
                    BlatClient.doBlatQuery(blatSeq);
                });
            }
        }
    }

    private static class InsertionInterval {
        Rectangle rect;
        InsertionMarker insertionMarker;

        public InsertionInterval(Rectangle rect, InsertionMarker insertionMarker) {
            this.rect = rect;
            this.insertionMarker = insertionMarker;
        }
    }

    private static class Deselector
    implements ActionListener {
        private JMenuItem toDeselect;
        private JMenuItem parent;

        Deselector(JMenuItem parent, JMenuItem toDeselect) {
            this.parent = parent;
            this.toDeselect = toDeselect;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (this.parent.isSelected()) {
                this.toDeselect.setSelected(false);
            }
        }
    }

    class RenderRollback {
        ColorOption colorOption;
        GroupOption groupByOption;
        String groupByTag;
        String colorByTag;
        String linkByTag;
        Track.DisplayMode displayMode;
        int expandedHeight;
        boolean showGroupLine;

        RenderRollback(RenderOptions renderOptions, Track.DisplayMode displayMode) {
            this.colorOption = renderOptions.colorOption;
            this.groupByOption = renderOptions.groupByOption;
            this.colorByTag = renderOptions.colorByTag;
            this.groupByTag = renderOptions.groupByTag;
            this.displayMode = displayMode;
            this.expandedHeight = AlignmentTrack.this.expandedHeight;
            this.showGroupLine = AlignmentTrack.this.showGroupLine;
            this.linkByTag = renderOptions.linkByTag;
        }

        void restore(RenderOptions renderOptions) {
            renderOptions.colorOption = this.colorOption;
            renderOptions.groupByOption = this.groupByOption;
            renderOptions.colorByTag = this.colorByTag;
            renderOptions.groupByTag = this.groupByTag;
            renderOptions.linkByTag = this.linkByTag;
            AlignmentTrack.this.expandedHeight = this.expandedHeight;
            AlignmentTrack.this.showGroupLine = this.showGroupLine;
            AlignmentTrack.this.setDisplayMode(this.displayMode);
        }
    }

    public static enum ExperimentType {
        OTHER,
        RNA,
        BISULFITE,
        THIRD_GEN;

    }

    static enum OrientationType {
        RR,
        LL,
        RL,
        LR,
        UNKNOWN;

    }

    public static enum BisulfiteContext {
        CG,
        CHH,
        CHG,
        HCG,
        GCH,
        WCG,
        NONE;

    }

    public static enum GroupOption {
        STRAND,
        SAMPLE,
        READ_GROUP,
        LIBRARY,
        FIRST_OF_PAIR_STRAND,
        TAG,
        PAIR_ORIENTATION,
        MATE_CHROMOSOME,
        NONE,
        SUPPLEMENTARY,
        BASE_AT_POS;

    }

    public static enum SortOption {
        START,
        STRAND,
        NUCLEOTIDE,
        QUALITY,
        SAMPLE,
        READ_GROUP,
        INSERT_SIZE,
        FIRST_OF_PAIR_STRAND,
        MATE_CHR,
        TAG,
        SUPPLEMENTARY,
        NONE;

    }

    static enum ColorOption {
        INSERT_SIZE,
        READ_STRAND,
        FIRST_OF_PAIR_STRAND,
        PAIR_ORIENTATION,
        SAMPLE,
        READ_GROUP,
        LIBRARY,
        BISULFITE,
        NOMESEQ,
        TAG,
        NONE,
        UNEXPECTED_PAIR,
        MAPPED_SIZE,
        LINK_STRAND,
        YC_TAG;

    }

    public static enum ShadeBasesOption {
        NONE,
        QUALITY;

    }
}

