/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.event.RefreshEvent;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTileLoader;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.ExperimentTypeChangeEvent;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PackedAlignments;
import org.broad.igv.sam.ReadStats;
import org.broad.igv.sam.Row;
import org.broad.igv.sam.SpliceJunctionHelper;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

public class AlignmentDataManager
implements IGVEventObserver {
    private static Logger log = Logger.getLogger(AlignmentDataManager.class);
    private List<AlignmentInterval> intervalCache;
    private ResourceLocator locator;
    private HashMap<String, String> chrMappings = new HashMap();
    private Set<Range> isLoading = new HashSet<Range>();
    private AlignmentTileLoader reader;
    private CoverageTrack coverageTrack;
    private Map<String, PEStats> peStats;
    private SpliceJunctionHelper.LoadOptions loadOptions;
    private Object loadLock = new Object();
    private AlignmentTrack.ExperimentType inferredExperimentType;
    private Set<Track> subscribedTracks;

    public AlignmentDataManager(ResourceLocator locator, Genome genome) throws IOException {
        this.locator = locator;
        this.reader = new AlignmentTileLoader(AlignmentReaderFactory.getReader(locator));
        this.peStats = new HashMap<String, PEStats>();
        this.initLoadOptions();
        this.initChrMap(genome);
        this.intervalCache = Collections.synchronizedList(new ArrayList());
        this.subscribedTracks = Collections.synchronizedSet(new HashSet());
        IGVEventBus.getInstance().subscribe(FrameManager.ChangeEvent.class, this);
        IGVEventBus.getInstance().subscribe(RefreshEvent.class, this);
    }

    @Override
    public void receiveEvent(Object event) {
        if (event instanceof FrameManager.ChangeEvent) {
            this.trimCache();
        } else if (event instanceof RefreshEvent) {
            this.clear();
        } else {
            log.info("Unknown event type: " + event.getClass());
        }
    }

    public void subscribe(Track track) {
        this.subscribedTracks.add(track);
    }

    public void unsubscribe(Track track) {
        this.subscribedTracks.remove(track);
        if (this.subscribedTracks.isEmpty()) {
            this.dumpAlignments();
            IGVEventBus.getInstance().unsubscribe(this);
        }
    }

    void initLoadOptions() {
        this.loadOptions = new SpliceJunctionHelper.LoadOptions();
    }

    private void initChrMap(Genome genome) throws IOException {
        List<String> seqNames;
        if (genome != null && (seqNames = this.reader.getSequenceNames()) != null) {
            for (String chr : seqNames) {
                String alias = genome.getCanonicalChrName(chr);
                this.chrMappings.put(alias, chr);
            }
        }
    }

    public AlignmentTileLoader getReader() {
        return this.reader;
    }

    public ResourceLocator getLocator() {
        return this.locator;
    }

    public Map<String, PEStats> getPEStats() {
        return this.peStats;
    }

    public boolean isPairedEnd() {
        return this.reader.isPairedEnd();
    }

    public boolean hasYCTags() {
        return this.reader.hasYCTags();
    }

    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    public void setInferredExperimentType(AlignmentTrack.ExperimentType inferredExperimentType) {
        if (inferredExperimentType != this.inferredExperimentType) {
            ExperimentTypeChangeEvent event = new ExperimentTypeChangeEvent(this, inferredExperimentType);
            this.inferredExperimentType = inferredExperimentType;
            IGVEventBus.getInstance().post(event);
        }
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    public CoverageTrack getCoverageTrack() {
        return this.coverageTrack;
    }

    public double getMinVisibleScale() {
        IGVPreferences prefs = PreferencesManager.getPreferences();
        float maxRange = prefs.getAsFloat("SAM.MAX_VISIBLE_RANGE");
        return maxRange * 1000.0f / 700.0f;
    }

    public List<String> getSequenceNames() throws IOException {
        return this.reader.getSequenceNames();
    }

    public AlignmentInterval getLoadedInterval(ReferenceFrame frame) {
        for (AlignmentInterval interval : this.intervalCache) {
            if (!interval.contains(frame.getCurrentRange())) continue;
            return interval;
        }
        return null;
    }

    public boolean sortRows(AlignmentTrack.SortOption option, ReferenceFrame frame, double location, String tag) {
        AlignmentInterval interval = this.getLoadedInterval(frame);
        if (interval == null) {
            return false;
        }
        PackedAlignments packedAlignments = interval.getPackedAlignments();
        if (packedAlignments == null) {
            return false;
        }
        for (List alignmentRows : packedAlignments.values()) {
            for (Row row : alignmentRows) {
                row.updateScore(option, location, interval, tag);
            }
            Collections.sort(alignmentRows);
        }
        return true;
    }

    public void setViewAsPairs(boolean option, AlignmentTrack.RenderOptions renderOptions) {
        if (option == renderOptions.isViewPairs()) {
            return;
        }
        renderOptions.setViewPairs(option);
        this.packAlignments(renderOptions);
    }

    void packAlignments(AlignmentTrack.RenderOptions renderOptions) {
        for (AlignmentInterval interval : this.intervalCache) {
            interval.packAlignments(renderOptions);
        }
    }

    public boolean isLoaded(ReferenceFrame frame) {
        return this.getLoadedInterval(frame) != null;
    }

    public boolean isLoading(ReferenceFrame frame) {
        Range range = frame.getCurrentRange();
        for (Range r2 : this.isLoading) {
            if (!r2.contains(range)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ReferenceFrame referenceFrame, AlignmentTrack.RenderOptions renderOptions, boolean expandEnds) {
        if (this.isLoaded(referenceFrame)) {
            return;
        }
        if (this.isLoading(referenceFrame)) {
            return;
        }
        Object object = this.loadLock;
        synchronized (object) {
            Range range = referenceFrame.getCurrentRange();
            this.isLoading.add(range);
            String chr = referenceFrame.getChrName();
            int start = range.getStart();
            int end = range.getEnd();
            int adjustedStart = start;
            int adjustedEnd = end;
            int windowSize = Math.min(4 * (end - start), PreferencesManager.getPreferences().getAsInt("SAM.MAX_VISIBLE_RANGE") * 1000);
            int center = (end + start) / 2;
            int expand = Math.max(end - start, windowSize / 2);
            if (expandEnds) {
                adjustedStart = Math.max(0, Math.min(start, center - expand));
                adjustedEnd = Math.max(end, center + expand);
            }
            log.debug("Loading alignments: " + chr + ":" + adjustedStart + "-" + adjustedEnd + " for " + this);
            AlignmentInterval loadedInterval = this.loadInterval(chr, adjustedStart, adjustedEnd, renderOptions);
            this.trimCache();
            this.intervalCache.add(loadedInterval);
            this.packAlignments(renderOptions);
            this.isLoading.remove(range);
        }
    }

    private synchronized void trimCache() {
        Iterator<AlignmentInterval> iter = this.intervalCache.iterator();
        while (iter.hasNext()) {
            AlignmentInterval interval = iter.next();
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                if (interval.contains(frame.getCurrentRange())) continue;
                iter.remove();
            }
        }
    }

    AlignmentInterval loadInterval(String chr, int start, int end, AlignmentTrack.RenderOptions renderOptions) {
        String sequence = this.chrMappings.containsKey(chr) ? this.chrMappings.get(chr) : chr;
        DownsampleOptions downsampleOptions = new DownsampleOptions();
        AlignmentTrack.BisulfiteContext bisulfiteContext = renderOptions != null ? renderOptions.bisulfiteContext : null;
        SpliceJunctionHelper spliceJunctionHelper = new SpliceJunctionHelper(this.loadOptions);
        ReadStats readStats = new ReadStats();
        AlignmentTileLoader.AlignmentTile t2 = this.reader.loadTile(sequence, start, end, spliceJunctionHelper, downsampleOptions, readStats, this.peStats, bisulfiteContext);
        if (this.inferredExperimentType == null && !Globals.VERSION.contains("2.4")) {
            readStats.compute();
            this.inferType(readStats);
        }
        List<Alignment> alignments = t2.getAlignments();
        List<DownsampledInterval> downsampledIntervals = t2.getDownsampledIntervals();
        return new AlignmentInterval(chr, start, end, alignments, t2.getCounts(), spliceJunctionHelper, downsampledIntervals);
    }

    private void inferType(ReadStats readStats) {
        if (readStats.readLengthStdDev > 100.0 || readStats.medianReadLength > 1000.0) {
            this.setInferredExperimentType(AlignmentTrack.ExperimentType.THIRD_GEN);
        } else if (readStats.medianRefToReadRatio > 10.0) {
            this.setInferredExperimentType(AlignmentTrack.ExperimentType.RNA);
        } else {
            this.setInferredExperimentType(AlignmentTrack.ExperimentType.OTHER);
        }
    }

    public synchronized PackedAlignments getGroups(RenderContext context, AlignmentTrack.RenderOptions renderOptions) {
        AlignmentInterval interval = this.getLoadedInterval(context.getReferenceFrame());
        if (interval != null) {
            return interval.getPackedAlignments();
        }
        return null;
    }

    public void clear() {
        this.intervalCache.clear();
    }

    public void dumpAlignments() {
        for (AlignmentInterval interval : this.intervalCache) {
            interval.dumpAlignments();
        }
    }

    public PackedAlignments getGroupedAlignmentsContaining(double position, ReferenceFrame referenceFrame) {
        String chr = referenceFrame.getChrName();
        int start = (int)position;
        int end = start + 1;
        AlignmentInterval interval = this.getLoadedInterval(referenceFrame);
        if (interval == null) {
            return null;
        }
        PackedAlignments packedAlignments = interval.getPackedAlignments();
        if (packedAlignments != null && packedAlignments.contains(chr, start, end)) {
            return packedAlignments;
        }
        return null;
    }

    public int getNLevels() {
        int nLevels = 0;
        for (AlignmentInterval interval : this.intervalCache) {
            PackedAlignments packedAlignments = interval.getPackedAlignments();
            if (packedAlignments == null) continue;
            int intervalNLevels = packedAlignments.getNLevels();
            nLevels = Math.max(nLevels, intervalNLevels);
        }
        return nLevels;
    }

    public int getMaxGroupCount() {
        int groupCount = 0;
        for (AlignmentInterval interval : this.intervalCache) {
            PackedAlignments packedAlignments;
            if (interval == null || (packedAlignments = interval.getPackedAlignments()) == null) continue;
            groupCount = Math.max(groupCount, packedAlignments.size());
        }
        return groupCount;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                log.error("Error closing AlignmentQueryReader. ", ex);
            }
        }
    }

    public void updatePEStats(AlignmentTrack.RenderOptions renderOptions) {
        if (this.peStats != null) {
            for (PEStats stats : this.peStats.values()) {
                stats.computeInsertSize(renderOptions.getMinInsertSizePercentile(), renderOptions.getMaxInsertSizePercentile());
            }
        }
    }

    public SpliceJunctionHelper.LoadOptions getSpliceJunctionLoadOptions() {
        return this.loadOptions;
    }

    public void setMinJunctionCoverage(int minJunctionCoverage) {
        this.loadOptions = new SpliceJunctionHelper.LoadOptions(minJunctionCoverage, this.loadOptions.minReadFlankingWidth);
        for (AlignmentInterval interval : this.intervalCache) {
            interval.getSpliceJunctionHelper().setLoadOptions(this.loadOptions);
        }
    }

    public void alleleThresholdChanged() {
        this.coverageTrack.setSnpThreshold(PreferencesManager.getPreferences().getAsFloat("SAM.ALLELE_THRESHOLD"));
    }

    public boolean isTenX() {
        return this.reader.isTenX();
    }

    public boolean isPhased() {
        return this.reader.isPhased();
    }

    public boolean isMoleculo() {
        return this.reader.isMoleculo();
    }

    public Collection<AlignmentInterval> getLoadedIntervals() {
        return this.intervalCache;
    }

    static class IntervalCache {
        private int maxSize;
        ArrayList<AlignmentInterval> intervals;

        public IntervalCache() {
            this(1);
        }

        public IntervalCache(int ms) {
            this.maxSize = Math.max(1, ms);
            this.intervals = new ArrayList(this.maxSize);
        }

        void setMaxSize(int ms, List<ReferenceFrame> frames) {
            this.maxSize = Math.max(1, ms);
            if (this.intervals.size() > this.maxSize) {
                if (frames.size() * this.intervals.size() < 25) {
                    ArrayList<AlignmentInterval> tmp = new ArrayList<AlignmentInterval>(this.maxSize);
                    block0: for (AlignmentInterval interval : this.intervals) {
                        if (tmp.size() == this.maxSize) break;
                        for (ReferenceFrame frame : frames) {
                            Range range = frame.getCurrentRange();
                            if (!interval.contains(range.getChr(), range.getStart(), range.getEnd())) continue;
                            tmp.add(interval);
                            continue block0;
                        }
                    }
                    this.intervals = tmp;
                } else {
                    this.intervals = new ArrayList<AlignmentInterval>(this.intervals.subList(0, this.maxSize));
                    this.intervals.trimToSize();
                }
            }
        }

        public void add(AlignmentInterval interval) {
            if (this.intervals.size() >= this.maxSize) {
                this.intervals.remove(0);
            }
            this.intervals.add(interval);
        }

        public AlignmentInterval getIntervalForRange(Range range) {
            for (AlignmentInterval interval : this.intervals) {
                if (!interval.contains(range.getChr(), range.getStart(), range.getEnd())) continue;
                return interval;
            }
            return null;
        }

        public Collection<AlignmentInterval> values() {
            return this.intervals;
        }

        public void clear() {
            this.intervals.clear();
        }
    }

    public static class DownsampleOptions {
        private boolean downsample;
        private int sampleWindowSize;
        private int maxReadCount;

        public DownsampleOptions() {
            IGVPreferences prefs = PreferencesManager.getPreferences();
            this.init(prefs.getAsBoolean("SAM.DOWNSAMPLE_READS"), prefs.getAsInt("SAM.SAMPLING_WINDOW"), prefs.getAsInt("SAM.MAX_LEVELS"));
        }

        DownsampleOptions(boolean downsample, int sampleWindowSize, int maxReadCount) {
            this.init(downsample, sampleWindowSize, maxReadCount);
        }

        private void init(boolean downsample, int sampleWindowSize, int maxReadCount) {
            this.downsample = downsample;
            this.sampleWindowSize = sampleWindowSize;
            this.maxReadCount = maxReadCount;
        }

        public boolean isDownsample() {
            return this.downsample;
        }

        public int getSampleWindowSize() {
            return this.sampleWindowSize;
        }

        public int getMaxReadCount() {
            return this.maxReadCount;
        }
    }
}

