/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.rnai.RNAIGeneScore;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;

public class HeatmapRenderer
extends DataRenderer {
    static Map<Integer, Color> lowConfColorCache = new Hashtable<Integer, Color>();

    public String getDisplayName() {
        return "Heatmap";
    }

    @Override
    public void renderScores(Track track, List<LocusScore> scores, RenderContext context, Rectangle rect) {
        ContinuousColorScale colorScale = track.getColorScale();
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Color bgColor = colorScale.getNoDataColor();
        context.getGraphic2DForColor(bgColor).fill(rect);
        boolean showAllFeatures = PreferencesManager.getPreferences().getAsBoolean("CHART.SHOW_ALL_HEATMAP");
        double maxX = rect.getMaxX();
        int minY = (int)rect.getMinY();
        int height = (int)rect.getHeight();
        int lastPEnd = 0;
        int lastPStart = 0;
        int lastW = 0;
        for (LocusScore score : scores) {
            if ((double)lastPStart > maxX) break;
            float fStart = (float)(((double)score.getStart() - origin) / locScale);
            float fEnd = (float)(((double)score.getEnd() - origin) / locScale);
            int pStart = (int)fStart;
            int pEnd = (int)fEnd;
            int min = showAllFeatures ? 1 : Math.min(pStart - lastPEnd, 1);
            int w2 = Math.max(min, pEnd - pStart);
            float dataY = track.logScaleData(score.getScore());
            Color graphColor = colorScale.getColor(dataY);
            if (pStart + w2 >= 0 && (double)lastPStart <= maxX) {
                if (track.getTrackType() == TrackType.DNA_METHYLATION) {
                    if (w2 < 6) {
                        int pMid = (pStart + pEnd) / 2;
                        pStart = pMid - 3;
                        w2 = 6;
                    }
                } else if (pStart < lastPEnd && w2 > 1 && lastW == 1) {
                    ++pStart;
                    --w2;
                }
                if (!Float.isNaN(dataY)) {
                    RNAIGeneScore rnaiScore;
                    if (score instanceof RNAIGeneScore && (rnaiScore = (RNAIGeneScore)score).getConfidence() < 2.0f) {
                        graphColor = HeatmapRenderer.getLowConfColor(context.getZoom());
                    }
                    Graphics2D g2D = context.getGraphic2DForColor(graphColor);
                    if ((double)pStart < maxX) {
                        int pLeft = Math.max(rect.x, pStart);
                        int pRight = Math.min(rect.x + rect.width, pStart + w2);
                        int adjustedW = pRight - pLeft;
                        g2D.fillRect(pLeft, minY, adjustedW, height);
                    }
                }
            }
            lastPStart = pStart;
            lastPEnd = pStart + w2;
            lastW = w2;
        }
    }

    private static Color getLowConfColor(int zoom) {
        Color lowConfColor = lowConfColorCache.get(zoom);
        if (lowConfColor == null) {
            int value = 225 - Math.min(70, zoom * 10);
            lowConfColor = new Color(value, value, value);
            lowConfColorCache.put(zoom, lowConfColor);
        }
        return lowConfColor;
    }
}

