/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.tools.sort.SAMSorter;
import org.broad.igv.tools.sort.Sorter;
import org.broad.igv.tools.sort.SorterFactory;
import org.broad.igv.util.ParsingUtils;

public class MAFtoSAM {
    public static final int READ_PAIRED_FLAG = 1;
    public static final int PROPER_PAIR_FLAG = 2;
    public static final int READ_UNMAPPED_FLAG = 4;
    public static final int MATE_UNMAPPED_FLAG = 8;
    public static final int READ_STRAND_FLAG = 16;
    public static final int MATE_STRAND_FLAG = 32;
    public static final int FIRST_OF_PAIR_FLAG = 64;
    public static final int SECOND_OF_PAIR_FLAG = 128;
    public static final int NOT_PRIMARY_ALIGNMENT_FLAG = 256;
    public static final int READ_FAILS_VENDOR_QUALITY_CHECK_FLAG = 512;
    public static final int DUPLICATE_READ_FLAG = 1024;
    public static final int SUPPLEMENTARY_FLAG = 2048;

    public static void main(String[] args) throws IOException {
        String inputPath = args[0];
        String outputPath = args.length > 1 ? args[1] : args[0] + ".sam";
        MAFtoSAM.convert(inputPath, outputPath, false);
    }

    public static void convert(String path, String outputPath, boolean noSATag) throws IOException {
        String line;
        File unsortedOutput = new File(outputPath + ".unsorted.sam");
        File outputFile = new File(outputPath);
        BufferedReader reader = ParsingUtils.openBufferedReader(path);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(unsortedOutput)));
        LinkedHashMap<String, Integer> sequenceDictionary = new LinkedHashMap<String, Integer>();
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("a ")) continue;
            MAFtoSAM.parseBlock(reader, out, sequenceDictionary);
        }
        out.flush();
        out.close();
        reader.close();
        MAFtoSAM.addSATags(unsortedOutput, outputFile, sequenceDictionary);
        unsortedOutput.deleteOnExit();
    }

    private static void addSATags(File inputFile, File outputFile, Map<String, Integer> sequenceDictionary) throws IOException {
        String line;
        String groupedOutput = inputFile.getAbsolutePath() + ".grouped.sam";
        Sorter sorter = SorterFactory.getSorter(inputFile, new File(groupedOutput));
        sorter.setComparator(SAMSorter.ReadNameComparator);
        sorter.run();
        BufferedReader reader = new BufferedReader(new FileReader(groupedOutput));
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        MAFtoSAM.outputHeader(sequenceDictionary, out);
        String[] lastRecord = null;
        ArrayList<String[]> chimericAlignments = new ArrayList<String[]>();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("@")) {
                out.println(line);
                continue;
            }
            String[] record = Globals.tabPattern.split(line);
            if (lastRecord == null || lastRecord[0].equals(record[0])) {
                chimericAlignments.add(record);
            } else {
                if (chimericAlignments.size() > 0) {
                    MAFtoSAM.printChimericAlignments(out, chimericAlignments);
                }
                chimericAlignments.clear();
                chimericAlignments.add(record);
            }
            lastRecord = record;
        }
        if (chimericAlignments.size() > 0) {
            MAFtoSAM.printChimericAlignments(out, chimericAlignments);
        }
        out.flush();
        out.close();
        new File(groupedOutput).deleteOnExit();
    }

    private static void printChimericAlignments(PrintWriter out, List<String[]> chimericAlignments) {
        if (chimericAlignments.size() == 1) {
            MAFtoSAM.printRecord(out, chimericAlignments.get(0));
            out.println();
        } else {
            String[] thisRecord;
            int i2;
            int primaryRecordIndex = 0;
            int longestSequence = chimericAlignments.get(0)[9].length();
            for (i2 = 1; i2 < chimericAlignments.size(); ++i2) {
                thisRecord = chimericAlignments.get(i2);
                int seqLength = thisRecord[9].length();
                if (seqLength <= longestSequence) continue;
                longestSequence = seqLength;
                primaryRecordIndex = i2;
            }
            for (i2 = 0; i2 < chimericAlignments.size(); ++i2) {
                if (i2 == primaryRecordIndex) continue;
                thisRecord = chimericAlignments.get(i2);
                thisRecord[1] = String.valueOf(Integer.parseInt(thisRecord[1]) | 0x100);
            }
            for (i2 = 0; i2 < chimericAlignments.size(); ++i2) {
                thisRecord = chimericAlignments.get(i2);
                StringBuffer saTag = new StringBuffer("SA:Z:");
                for (int j2 = 0; j2 < chimericAlignments.size(); ++j2) {
                    if (j2 == i2) continue;
                    String[] supRecord = chimericAlignments.get(j2);
                    String nmString = supRecord[11];
                    String nm = nmString.startsWith("NM:i:") ? nmString.substring(5) : "0";
                    boolean isNegativeStrand = (Integer.parseInt(supRecord[1]) & 0x10) != 0;
                    saTag.append(supRecord[2] + "," + supRecord[3] + "," + (isNegativeStrand ? "-," : "+,") + supRecord[5] + "," + supRecord[4] + "," + nm + ";");
                }
                if (i2 > 0) {
                    int flags = Integer.parseInt(thisRecord[1]) | 0x800;
                    thisRecord[1] = Integer.toString(flags);
                }
                MAFtoSAM.printRecord(out, thisRecord);
                out.print("\t" + saTag.toString());
                out.println();
            }
        }
    }

    private static void printRecord(PrintWriter out, String[] record) {
        out.print(record[0]);
        for (int i2 = 1; i2 < record.length; ++i2) {
            out.print("\t" + record[i2]);
        }
    }

    private static void parseBlock(BufferedReader reader, PrintWriter out, Map<String, Integer> sequenceDictionary) throws IOException {
        String line;
        SequenceLine referenceLine = null;
        byte[] refBytes = null;
        String chr = null;
        float score = -1.0f;
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() == 0) {
                return;
            }
            if (line.startsWith("a")) {
                String[] tokens;
                score = -1.0f;
                for (String token : tokens = Globals.whitespacePattern.split(line)) {
                    if (!token.startsWith("score=")) continue;
                    try {
                        score = Float.parseFloat(token.substring(6));
                    }
                    catch (NumberFormatException e2) {
                        System.err.println("Could not parse score: " + token);
                    }
                }
            }
            if (!line.startsWith("s ")) continue;
            if (null == referenceLine) {
                referenceLine = MAFtoSAM.parseSequenceLine(line);
                refBytes = referenceLine.text.getBytes();
                if (referenceLine.src.contains(".")) {
                    int idx = referenceLine.src.lastIndexOf(46) + 1;
                    chr = referenceLine.src.substring(idx);
                } else {
                    chr = referenceLine.src;
                }
                sequenceDictionary.put(chr, referenceLine.srcSize);
                continue;
            }
            SequenceLine queryLine = MAFtoSAM.parseSequenceLine(line);
            int flags = queryLine.strand == '+' ? 0 : 16;
            byte[] queryBytes = queryLine.text.getBytes();
            if (queryBytes.length != refBytes.length) {
                throw new RuntimeException("Query and ref sequence unequal length");
            }
            String cigarString = "";
            int nm = 0;
            boolean indel = false;
            for (int i2 = 0; i2 < queryBytes.length; ++i2) {
                byte q2 = queryBytes[i2];
                byte ref = refBytes[i2];
                if (q2 == 45) {
                    if (ref == 45) continue;
                    cigarString = cigarString + "D";
                    if (indel) continue;
                    indel = true;
                    ++nm;
                    continue;
                }
                if (ref == 45) {
                    cigarString = cigarString + "I";
                    if (indel) continue;
                    indel = true;
                    ++nm;
                    continue;
                }
                indel = false;
                cigarString = cigarString + "M";
                if (queryBytes[i2] == refBytes[i2]) continue;
                ++nm;
            }
            cigarString = MAFtoSAM.collapseCigar(cigarString);
            String readName = queryLine.src;
            String barcode = null;
            if (readName.contains("Barcode")) {
                int bcIdx = readName.indexOf("Barcode") + 8;
                int endIdx = readName.indexOf(58, bcIdx);
                barcode = readName.substring(bcIdx, endIdx);
            }
            int start = referenceLine.start + 1;
            int mapq = 30;
            String rnext = "*";
            int pnext = 0;
            int tlen = 0;
            String seq = MAFtoSAM.collapseSequence(queryLine.text);
            String qual = "*";
            out.print(readName + "\t" + flags + "\t" + chr + "\t" + start + "\t" + mapq + "\t" + cigarString + "\t" + rnext + "\t" + pnext + "\t" + tlen + "\t" + seq + "\t" + qual + "\tNM:i:" + nm);
            if (barcode != null) {
                out.print("\tBC:Z:" + barcode);
            }
            if (score > 0.0f) {
                out.print("\tsc:f:" + String.valueOf(score));
            }
            out.println();
        }
    }

    private static void outputHeader(Map<String, Integer> sequenceDictionary, PrintWriter out) {
        ArrayList<String> chrNames = new ArrayList<String>(sequenceDictionary.keySet());
        Collections.sort(chrNames, ChromosomeNameComparator.get());
        out.println("@HD\tVN:1.5");
        for (String chr : chrNames) {
            out.println("@SQ\tSN:" + chr + "\tLN:" + sequenceDictionary.get(chr));
        }
        out.println("@PG\tPN:MAFtoSAM\tID:MAFtoSAM");
    }

    private static String collapseCigar(String cigarString) {
        if (cigarString.length() == 0) {
            return "";
        }
        String collapsedCigar = "";
        char lastOperator = cigarString.charAt(0);
        int counter = 1;
        for (int i2 = 1; i2 < cigarString.length(); ++i2) {
            if (cigarString.charAt(i2) == lastOperator) {
                ++counter;
                continue;
            }
            collapsedCigar = collapsedCigar + "" + counter + lastOperator;
            lastOperator = cigarString.charAt(i2);
            counter = 1;
        }
        collapsedCigar = collapsedCigar + "" + counter + lastOperator;
        return collapsedCigar;
    }

    private static String collapseSequence(String text) {
        return text.replaceAll("-", "");
    }

    private static SequenceLine parseSequenceLine(String line) throws IOException {
        String[] tokens = Globals.whitespacePattern.split(line);
        SequenceLine sl = new SequenceLine();
        sl.src = tokens[1];
        sl.start = Integer.parseInt(tokens[2]);
        sl.size = Integer.parseInt(tokens[3]);
        sl.strand = tokens[4].charAt(0);
        sl.srcSize = Integer.parseInt(tokens[5]);
        sl.text = tokens[6];
        return sl;
    }

    static class SequenceLine {
        String src;
        int start;
        int size;
        char strand;
        int srcSize;
        String text;

        SequenceLine() {
        }
    }
}

