/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import htsjdk.tribble.Feature;
import java.awt.Color;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.event.GenomeChangeEvent;
import org.broad.igv.event.GenomeResetEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.CytoBandFileParser;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.EmblFeatureTableParser;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.GFFParser;
import org.broad.igv.feature.genome.ChromSizesParser;
import org.broad.igv.feature.genome.GenbankParser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeDescriptor;
import org.broad.igv.feature.genome.GenomeException;
import org.broad.igv.feature.genome.GenomeImporter;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeZipDescriptor;
import org.broad.igv.feature.genome.IGVSequence;
import org.broad.igv.feature.genome.InMemorySequence;
import org.broad.igv.feature.genome.SequenceWrapper;
import org.broad.igv.feature.genome.fasta.FastaBlockCompressedSequence;
import org.broad.igv.feature.genome.fasta.FastaDirectorySequence;
import org.broad.igv.feature.genome.fasta.FastaIndexedSequence;
import org.broad.igv.feature.genome.fasta.FastaUtils;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.GFFFeatureSource;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.ui.util.download.Downloader;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;

public class GenomeManager {
    static final String GENOME_ARCHIVE_VERSION_KEY = "version";
    static final String GENOME_ARCHIVE_PROPERTY_FILE_NAME = "property.txt";
    static final String GENOME_ARCHIVE_ID_KEY = "id";
    static final String GENOME_ARCHIVE_NAME_KEY = "name";
    static final String GENOME_ORDERED_KEY = "ordered";
    static final String GENOME_GENETRACK_NAME = "geneTrackName";
    static final String GENOME_URL_KEY = "url";
    static final String GENOME_ARCHIVE_CYTOBAND_FILE_KEY = "cytobandFile";
    static final String GENOME_ARCHIVE_GENE_FILE_KEY = "geneFile";
    static final String GENOME_ARCHIVE_SEQUENCE_FILE_LOCATION_KEY = "sequenceLocation";
    static final String COMPRESSED_SEQUENCE_PATH = "compressedSequencePath";
    public static final String GENOME_ARCHIVE_CUSTOM_SEQUENCE_LOCATION_KEY = "customSequenceLocation";
    public static final String GENOME_CHR_ALIAS_FILE_KEY = "chrAliasFile";
    public static final String SEQUENCE_MAP_FILE = "sequenceMap.txt";
    private static Logger log = Logger.getLogger(GenomeManager.class);
    private static final String ACT_USER_DEFINED_GENOME_LIST_FILE = "user-defined-genomes.txt";
    public static final String TEST_USER_DEFINED_GENOME_LIST_FILE = "test-user-defined-genomes.txt";
    public static final GenomeListItem DEFAULT_GENOME = new GenomeListItem("Human hg19", "http://s3.amazonaws.com/igv.broadinstitute.org/genomes/hg19.genome", "hg19");
    private GenomeListManager genomeListManager = GenomeListManager.getInstance();
    private static GenomeManager theInstance;
    private Genome currentGenome;
    private Map<String, File> localSequenceMap = this.loadSequenceMap();

    public static synchronized GenomeManager getInstance() {
        if (theInstance == null) {
            theInstance = new GenomeManager();
        }
        return theInstance;
    }

    private GenomeManager() {
    }

    public void setCurrentGenome(Genome genome) {
        if (genome != null) {
            PreferencesManager.getPreferences().setLastGenome(genome.getId());
        }
        this.currentGenome = genome;
        if (genome != null) {
            if (IGV.hasInstance()) {
                IGV.getInstance().getSession().clearHistory();
                FrameManager.getDefaultFrame().setChromosomeName(genome.getHomeChromosome(), true);
            }
            IGVEventBus.getInstance().post(new GenomeChangeEvent(genome));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGenomeById(String genomeId) throws IOException {
        Genome currentGenome = this.getCurrentGenome();
        if (currentGenome != null && genomeId.equals(currentGenome.getId())) {
            return;
        }
        if (ParsingUtils.pathExists(genomeId)) {
            this.loadGenome(genomeId, null);
        } else {
            ProgressMonitor[] monitor = new ProgressMonitor[]{new ProgressMonitor()};
            ProgressBar.ProgressDialog[] progressDialog = new ProgressBar.ProgressDialog[1];
            UIUtilities.invokeAndWaitOnEventThread(() -> {
                progressDialog[0] = ProgressBar.showProgressDialog(IGV.getMainFrame(), "Loading Genome...", monitor[0], false);
            });
            try {
                GenomeListItem item = this.genomeListManager.getGenomeListItem(genomeId);
                this.loadGenome(item.getPath(), monitor[0]);
            }
            finally {
                UIUtilities.invokeOnEventThread(() -> progressDialog[0].setVisible(false));
            }
        }
    }

    public Genome loadGenome(String genomePath, ProgressMonitor monitor) throws IOException {
        try {
            String altGenomePath;
            log.info("Loading genome: " + genomePath);
            Genome newGenome = null;
            if (monitor != null) {
                UIUtilities.invokeAndWaitOnEventThread(() -> monitor.fireProgress(25));
            }
            FeatureDB.clearFeatures();
            if (genomePath.endsWith(".genome")) {
                File archiveFile = this.getArchiveFile(genomePath);
                if (!archiveFile.exists()) {
                    return null;
                }
                altGenomePath = archiveFile.getAbsolutePath();
                newGenome = this.loadDotGenomeFile(archiveFile);
            } else if (genomePath.endsWith(".gbk") || genomePath.endsWith(".gb")) {
                altGenomePath = genomePath;
                newGenome = this.loadGenbankFile(genomePath);
            } else if (genomePath.endsWith(".chrom.sizes")) {
                altGenomePath = genomePath;
                newGenome = this.loadChromSizes(genomePath);
            } else if (genomePath.endsWith(".json")) {
                altGenomePath = genomePath;
                newGenome = this.loadJsonFile(genomePath);
            } else {
                altGenomePath = genomePath;
                if (genomePath.endsWith(".gz")) {
                    String gziPath = genomePath + ".gzi";
                    String faiPath = genomePath + ".fai";
                    if (!FileUtils.resourceExists(gziPath) || !FileUtils.resourceExists(faiPath)) {
                        throw new GenomeException("IGV cannot readed gzipped fasta files.");
                    }
                }
                if (!FileUtils.isRemote(genomePath) && !new File(genomePath).exists()) {
                    throw new GenomeException("Cannot locate genome: " + genomePath);
                }
                newGenome = this.loadFastaFile(genomePath);
            }
            String aliasPath = FileUtils.getParent(genomePath) + "/" + newGenome.getId() + "_alias.tab";
            Collection<Collection<String>> aliases = this.loadChrAliases(aliasPath);
            if (aliases != null) {
                newGenome.addChrAliases(aliases);
            }
            if ((aliases = this.loadChrAliases(aliasPath = new File(DirectoryManager.getGenomeCacheDirectory(), newGenome.getId() + "_alias.tab").getAbsolutePath())) != null) {
                newGenome.addChrAliases(aliases);
            }
            if (monitor != null) {
                monitor.fireProgress(25);
            }
            if (IGV.hasInstance()) {
                IGV.getInstance().resetSession(null);
            }
            GenomeListItem genomeListItem = new GenomeListItem(newGenome.getDisplayName(), altGenomePath, newGenome.getId());
            Set<String> serverGenomeIDs = this.genomeListManager.getServerGenomeIDs();
            boolean userDefined = !serverGenomeIDs.contains(newGenome.getId());
            this.genomeListManager.addGenomeItem(genomeListItem, userDefined);
            this.setCurrentGenome(newGenome);
            if (IGV.hasInstance()) {
                FeatureTrack geneFeatureTrack = newGenome.getGeneTrack();
                IGV.getInstance().setGenomeTracks(geneFeatureTrack);
                ArrayList<ResourceLocator> resources = newGenome.getAnnotationResources();
                if (resources != null) {
                    IGV.getInstance().loadResources(resources);
                }
            }
            log.info("Genome loaded.  id= " + newGenome.getId());
            return this.currentGenome;
        }
        catch (SocketException e2) {
            throw new RuntimeException("Server connection error", e2);
        }
    }

    private Genome loadChromSizes(String genomePath) throws IOException {
        int firstPeriodIdx = genomePath.indexOf(46);
        String genomeId = genomePath.substring(0, firstPeriodIdx);
        List<Chromosome> chromosomes = ChromSizesParser.parse(genomePath);
        Genome newGenome = new Genome(genomeId, chromosomes);
        this.setCurrentGenome(newGenome);
        return newGenome;
    }

    private Genome loadGenbankFile(String genomePath) throws IOException {
        GenbankParser genbankParser = new GenbankParser(genomePath);
        genbankParser.readFeatures(true);
        String name = genbankParser.getLocusName();
        String chr = genbankParser.getChr();
        if (!name.equals(chr)) {
            name = name + " (" + chr + ")";
        }
        byte[] seq = genbankParser.getSequence();
        InMemorySequence sequence = new InMemorySequence(chr, seq);
        Genome newGenome = new Genome(chr, name, sequence, true);
        String[] aliases = genbankParser.getAliases();
        if (aliases != null) {
            ArrayList<String> aliasList = new ArrayList<String>();
            aliasList.add(chr);
            for (String a2 : aliases) {
                aliasList.add(a2);
            }
            newGenome.addChrAliases(Arrays.asList(aliasList));
        }
        this.setCurrentGenome(newGenome);
        if (IGV.hasInstance() && !Globals.isHeadless()) {
            FeatureTrack geneFeatureTrack = this.createGeneTrack(newGenome, genbankParser.getFeatures());
            newGenome.setGeneTrack(geneFeatureTrack);
        }
        FeatureDB.addFeatures(genbankParser.getFeatures(), newGenome);
        return newGenome;
    }

    private Genome loadFastaFile(String genomePath) throws IOException {
        GenomeListItem item;
        String fastaPath = null;
        String fastaIndexPath = null;
        if (genomePath.endsWith(".fai")) {
            fastaPath = genomePath.substring(0, genomePath.length() - 4);
            fastaIndexPath = genomePath;
        } else {
            fastaPath = genomePath;
            fastaIndexPath = genomePath + ".fai";
        }
        if (!FileUtils.resourceExists(fastaIndexPath) && !FileUtils.isRemote(fastaPath)) {
            File archiveFile = this.getArchiveFile(fastaPath);
            fastaPath = archiveFile.getAbsolutePath();
            fastaIndexPath = fastaPath + ".fai";
            FastaUtils.createIndexFile(fastaPath, fastaIndexPath);
        }
        if ((item = GenomeListManager.buildItemFromPath(fastaPath)) == null) {
            throw new IOException(fastaPath + " does not exist, could not load genome");
        }
        FastaIndexedSequence fastaSequence = fastaPath.endsWith(".gz") ? new FastaBlockCompressedSequence(fastaPath) : new FastaIndexedSequence(fastaPath);
        SequenceWrapper sequence = new SequenceWrapper(fastaSequence);
        Genome newGenome = new Genome(item.getId(), item.getDisplayableName(), sequence, true);
        this.setCurrentGenome(newGenome);
        return newGenome;
    }

    private Genome loadJsonFile(String genomePath) throws IOException {
        Genome newGenome = null;
        BufferedReader reader = ParsingUtils.openBufferedReader(genomePath);
        JsonParser parser = new JsonParser();
        JsonObject json = parser.parse(reader).getAsJsonObject();
        String id = json.get(GENOME_ARCHIVE_ID_KEY).getAsString();
        String name = json.get(GENOME_ARCHIVE_NAME_KEY).getAsString();
        String fastaPath = json.get("fastaURL").getAsString();
        JsonElement indexPathObject = json.get("indexURL");
        String indexPath = indexPathObject == null ? null : indexPathObject.getAsString();
        FastaIndexedSequence sequence = fastaPath.endsWith(".gz") ? new FastaBlockCompressedSequence(fastaPath, indexPath) : new FastaIndexedSequence(fastaPath, indexPath);
        ArrayList<ResourceLocator> tracks = new ArrayList<ResourceLocator>();
        JsonArray annotations = json.getAsJsonArray("annotations");
        if (annotations != null) {
            annotations.forEach(jsonElement -> {
                JsonObject obj = jsonElement.getAsJsonObject();
                String trackPath = obj.get(GENOME_URL_KEY).getAsString();
                JsonElement trackName = obj.get(GENOME_ARCHIVE_NAME_KEY);
                JsonElement trackIndexPath = obj.get("indexURL");
                JsonElement indexed = obj.get("indexed");
                JsonElement aliasURL = obj.get("aliasURL");
                ResourceLocator res = new ResourceLocator(trackPath);
                if (trackName != null) {
                    res.setName(trackName.getAsString());
                }
                if (trackIndexPath != null) {
                    res.setIndexPath(trackIndexPath.getAsString());
                }
                if (indexed != null) {
                    res.setIndexed(indexed.getAsBoolean());
                }
                tracks.add(res);
            });
        }
        newGenome = new Genome(id, name, sequence, true);
        newGenome.setAnnotationResources(tracks);
        return newGenome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Collection<String>> loadChrAliases(String path) {
        File aliasFile = new File(path);
        if (aliasFile.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(aliasFile));
                Collection<Collection<String>> collection = GenomeManager.loadChrAliases(br);
                return collection;
            }
            catch (IOException e2) {
                log.error("Error loading chr alias table", e2);
                if (!Globals.isHeadless()) {
                    MessageUtils.showMessage("<html>Error loading chromosome alias table.  Aliases will not be avaliable<br>" + e2.toString());
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Genome loadDotGenomeFile(File archiveFile) throws IOException {
        Collection<Collection<String>> aliases;
        String sequencePath;
        GenomeDescriptor genomeDescriptor = GenomeManager.parseGenomeArchiveFile(archiveFile);
        String id = genomeDescriptor.getId();
        String displayName = genomeDescriptor.getName();
        boolean isFasta = genomeDescriptor.isFasta();
        String[] fastaFiles = genomeDescriptor.getFastaFileNames();
        LinkedHashMap<String, List<Cytoband>> cytobandMap = null;
        if (genomeDescriptor.hasCytobands()) {
            cytobandMap = this.loadCytobandFile(genomeDescriptor);
        }
        String string = sequencePath = this.localSequenceMap.containsKey(genomeDescriptor.getId()) ? this.loadSequenceMap().get(genomeDescriptor.getId()).getAbsolutePath() : genomeDescriptor.getSequencePath();
        if (genomeDescriptor.hasCustomSequenceLocation()) {
            String localPath = genomeDescriptor.getSequencePath();
            this.addLocalFasta(genomeDescriptor.getId(), new File(localPath));
        }
        SequenceWrapper sequence = null;
        boolean chromosOrdered = false;
        if (sequencePath == null) {
            sequence = null;
        } else if (!isFasta) {
            sequencePath = SequenceWrapper.checkSequenceURL(sequencePath);
            IGVSequence igvSequence = new IGVSequence(sequencePath);
            if (cytobandMap != null) {
                chromosOrdered = genomeDescriptor.isChromosomesAreOrdered();
                igvSequence.generateChromosomes(cytobandMap, chromosOrdered);
            }
            sequence = new SequenceWrapper(igvSequence);
        } else if (fastaFiles != null) {
            FastaDirectorySequence fastaDirectorySequence = new FastaDirectorySequence(sequencePath, fastaFiles);
            sequence = new SequenceWrapper(fastaDirectorySequence);
        } else {
            FastaIndexedSequence fastaSequence;
            if (sequencePath.endsWith(".gz")) {
                fastaSequence = new FastaBlockCompressedSequence(sequencePath);
                sequence = new SequenceWrapper(fastaSequence);
            } else {
                fastaSequence = new FastaIndexedSequence(sequencePath);
                sequence = new SequenceWrapper(fastaSequence);
            }
            chromosOrdered = true;
        }
        Genome newGenome = new Genome(id, displayName, sequence, chromosOrdered, genomeDescriptor);
        if (cytobandMap != null) {
            newGenome.setCytobands(cytobandMap);
        }
        if ((aliases = this.loadChrAliases(genomeDescriptor)) != null) {
            newGenome.addChrAliases(aliases);
        }
        InputStream geneStream = null;
        String geneFileName = genomeDescriptor.getGeneFileName();
        if (geneFileName != null) {
            try {
                geneStream = genomeDescriptor.getGeneStream();
                if (geneFileName.endsWith(".gbk")) {
                    GenbankParser genbankParser = new GenbankParser();
                    genbankParser.readFeatures(geneStream, false);
                    FeatureTrack geneFeatureTrack = this.createGeneTrack(newGenome, genbankParser.getFeatures());
                    newGenome.setGeneTrack(geneFeatureTrack);
                } else {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(geneStream));
                    FeatureTrack geneFeatureTrack = this.createGeneTrack(newGenome, reader, geneFileName, genomeDescriptor.getGeneTrackName(), genomeDescriptor.getUrl());
                    newGenome.setGeneTrack(geneFeatureTrack);
                }
            }
            finally {
                if (geneStream != null) {
                    geneStream.close();
                }
            }
        }
        genomeDescriptor.close();
        return newGenome;
    }

    private File getArchiveFile(String genomePath) throws MalformedURLException, UnsupportedEncodingException {
        File archiveFile;
        if (HttpUtils.isRemoteURL(genomePath.toLowerCase())) {
            URL genomeArchiveURL = new URL(genomePath);
            String tmp = URLDecoder.decode(new URL(genomePath).getFile(), "UTF-8");
            String cachedFilename = Utilities.getFileNameFromURL(tmp);
            if (!DirectoryManager.getGenomeCacheDirectory().exists()) {
                DirectoryManager.getGenomeCacheDirectory().mkdir();
            }
            archiveFile = new File(DirectoryManager.getGenomeCacheDirectory(), cachedFilename);
            this.refreshCache(archiveFile, genomeArchiveURL);
        } else {
            archiveFile = new File(genomePath);
        }
        return archiveFile;
    }

    private LinkedHashMap<String, List<Cytoband>> loadCytobandFile(GenomeDescriptor genomeDescriptor) {
        InputStream is = null;
        try {
            is = genomeDescriptor.getCytoBandStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            LinkedHashMap<String, List<Cytoband>> linkedHashMap = CytoBandFileParser.loadData(reader);
            return linkedHashMap;
        }
        catch (IOException ex) {
            log.warn("Error loading cytoband file", ex);
            throw new RuntimeException("Error loading cytoband file" + genomeDescriptor.cytoBandFileName);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing zip stream!", ex);
            }
        }
    }

    private static Collection<Collection<String>> loadChrAliases(BufferedReader br) throws IOException {
        String nextLine = "";
        ArrayList<Collection<String>> synonymList = new ArrayList<Collection<String>>();
        while ((nextLine = br.readLine()) != null) {
            String[] tokens = nextLine.split("\t");
            if (tokens.length <= 1) continue;
            ArrayList<String> synonyms = new ArrayList<String>();
            for (String t2 : tokens) {
                String syn = t2.trim();
                if (t2.length() <= 0) continue;
                synonyms.add(syn.trim());
            }
            synonymList.add(synonyms);
        }
        return synonymList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Collection<String>> loadChrAliases(GenomeDescriptor genomeDescriptor) {
        InputStream aliasStream = null;
        try {
            aliasStream = genomeDescriptor.getChrAliasStream();
            if (aliasStream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(aliasStream));
                Collection<Collection<String>> collection = GenomeManager.loadChrAliases(reader);
                return collection;
            }
            Collection<Collection<String>> reader = null;
            return reader;
        }
        catch (IOException e2) {
            log.error("Error loading chromosome alias table");
            Collection<Collection<String>> collection = null;
            return collection;
        }
        finally {
            try {
                if (aliasStream != null) {
                    aliasStream.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing zip stream!", ex);
            }
        }
    }

    public void refreshCache(File cachedFile, URL genomeArchiveURL) {
        try {
            if (cachedFile.exists()) {
                boolean forceUpdate;
                boolean remoteModfied = HttpUtils.getInstance().remoteIsNewer(cachedFile, genomeArchiveURL);
                boolean bl = forceUpdate = remoteModfied && PreferencesManager.getPreferences().getAsBoolean("AUTO_UPDATE_GENOMES");
                if (forceUpdate) {
                    log.info("Refreshing genome: " + genomeArchiveURL.toString());
                    Downloader.download(genomeArchiveURL, cachedFile, IGV.getMainFrame());
                }
            } else {
                Frame parent = IGV.hasInstance() ? IGV.getMainFrame() : null;
                Downloader.download(genomeArchiveURL, cachedFile, parent);
            }
        }
        catch (Exception e2) {
            MessageUtils.showErrorMessage("An error was encountered refreshing the genome cache: " + e2.getMessage(), e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GenomeDescriptor parseGenomeArchiveFile(File f2) throws IOException {
        if (!f2.exists()) {
            throw new FileNotFoundException("Genome file: " + f2.getAbsolutePath() + " does not exist.");
        }
        GenomeZipDescriptor genomeDescriptor = null;
        HashMap<String, ZipEntry> zipEntries = new HashMap<String, ZipEntry>();
        ZipFile zipFile = new ZipFile(f2);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(f2);
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String zipEntryName = zipEntry.getName();
                zipEntries.put(zipEntryName, zipEntry);
                if (zipEntryName.equalsIgnoreCase(GENOME_ARCHIVE_PROPERTY_FILE_NAME)) {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    String cytobandZipEntryName = properties.getProperty(GENOME_ARCHIVE_CYTOBAND_FILE_KEY);
                    String geneFileName = properties.getProperty(GENOME_ARCHIVE_GENE_FILE_KEY);
                    String chrAliasFileName = properties.getProperty(GENOME_CHR_ALIAS_FILE_KEY);
                    String sequencePath = properties.getProperty(GENOME_ARCHIVE_SEQUENCE_FILE_LOCATION_KEY);
                    String compressedSequencePath = properties.getProperty(COMPRESSED_SEQUENCE_PATH);
                    if (sequencePath != null && !HttpUtils.isRemoteURL(sequencePath)) {
                        sequencePath = GenomeManager.getFullPath(f2, sequencePath);
                    }
                    if (compressedSequencePath != null && !HttpUtils.isRemoteURL(compressedSequencePath)) {
                        compressedSequencePath = GenomeManager.getFullPath(f2, sequencePath);
                    }
                    boolean chrNamesAltered = GenomeManager.parseBooleanPropertySafe(properties, "filenamesAltered");
                    boolean fasta = GenomeManager.parseBooleanPropertySafe(properties, "fasta");
                    boolean fastaDirectory = GenomeManager.parseBooleanPropertySafe(properties, "fastaDirectory");
                    boolean chromosomesAreOrdered = GenomeManager.parseBooleanPropertySafe(properties, GENOME_ORDERED_KEY);
                    boolean hasCustomSequenceLocation = GenomeManager.parseBooleanPropertySafe(properties, GENOME_ARCHIVE_CUSTOM_SEQUENCE_LOCATION_KEY);
                    String fastaFileNameString = properties.getProperty("fastaFiles");
                    String url = properties.getProperty(GENOME_URL_KEY);
                    genomeDescriptor = new GenomeZipDescriptor(properties.getProperty(GENOME_ARCHIVE_NAME_KEY), properties.getProperty(GENOME_ARCHIVE_ID_KEY), cytobandZipEntryName, geneFileName, chrAliasFileName, properties.getProperty(GENOME_GENETRACK_NAME, "Gene"), sequencePath, hasCustomSequenceLocation, compressedSequencePath, zipFile, zipEntries, chromosomesAreOrdered, fasta, fastaFileNameString);
                    if (url != null) {
                        genomeDescriptor.setUrl(url);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing imported genome zip stream!", ex);
            }
        }
        return genomeDescriptor;
    }

    private static String getFullPath(File f2, String sequencePath) throws IOException {
        boolean isAbsolutePath;
        File sequenceFolder = null;
        sequenceFolder = new File(sequencePath);
        boolean bl = isAbsolutePath = sequenceFolder.isAbsolute() || sequencePath.startsWith("/") || sequencePath.startsWith("\\");
        if (!isAbsolutePath) {
            sequenceFolder = new File(f2.getParent(), sequencePath);
        }
        sequencePath = sequenceFolder.getCanonicalPath();
        sequencePath.replace('\\', '/');
        return sequencePath;
    }

    private static boolean parseBooleanPropertySafe(Properties properties, String key) {
        String propertyString = properties.getProperty(key);
        return Boolean.parseBoolean(propertyString);
    }

    public void clearGenomeCache() {
        File[] files;
        for (File file : files = DirectoryManager.getGenomeCacheDirectory().listFiles()) {
            if (!file.getName().toLowerCase().endsWith(".genome")) continue;
            file.delete();
        }
    }

    public GenomeListItem defineGenome(File genomeFile, String cytobandFileName, String refFlatFileName, String fastaFileName, String chrAliasFileName, String genomeDisplayName, String genomeId, javax.swing.ProgressMonitor monitor) throws IOException {
        File refFlatFile = null;
        File cytobandFile = null;
        File chrAliasFile = null;
        if (genomeFile != null) {
            PreferencesManager.getPreferences().setLastGenomeImportDirectory(genomeFile.getParentFile());
        }
        if (cytobandFileName != null && cytobandFileName.trim().length() != 0) {
            cytobandFile = new File(cytobandFileName);
        }
        if (refFlatFileName != null && refFlatFileName.trim().length() != 0) {
            refFlatFile = new File(refFlatFileName);
        }
        if (chrAliasFileName != null && chrAliasFileName.trim().length() != 0) {
            chrAliasFile = new File(chrAliasFileName);
        }
        if (monitor != null) {
            monitor.setProgress(25);
        }
        new GenomeImporter().createGenomeArchive(genomeFile, genomeId, genomeDisplayName, fastaFileName, refFlatFile, cytobandFile, chrAliasFile);
        if (monitor != null) {
            monitor.setProgress(75);
        }
        GenomeListItem newItem = new GenomeListItem(genomeDisplayName, genomeFile.getAbsolutePath(), genomeId);
        this.genomeListManager.addGenomeItem(newItem, true);
        if (monitor != null) {
            monitor.setProgress(100);
        }
        return newItem;
    }

    private String convertToS3(String path) {
        if (path.startsWith("http://igvdata") || path.startsWith("https://igvdata")) {
            return path.replaceFirst("igvdata", "igv");
        }
        return path;
    }

    public String getGenomeId() {
        return this.currentGenome == null ? null : this.currentGenome.getId();
    }

    public Genome getCurrentGenome() {
        return this.currentGenome;
    }

    public void generateGenomeList(File inDir, String rootPath, String outPath) {
        PrintWriter writer;
        File[] genomeFiles = inDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name == null) {
                    return false;
                }
                return name.toLowerCase().endsWith(".genome");
            }
        });
        try {
            writer = new PrintWriter(outPath);
        }
        catch (FileNotFoundException e2) {
            log.error("Error opening " + outPath);
            e2.printStackTrace();
            return;
        }
        for (File f2 : genomeFiles) {
            String curLine = "";
            try {
                GenomeDescriptor descriptor = GenomeManager.parseGenomeArchiveFile(f2);
                curLine = curLine + descriptor.getName();
                curLine = curLine + "\t" + rootPath + "/" + f2.getName();
                curLine = curLine + "\t" + descriptor.getId();
            }
            catch (IOException e3) {
                log.error("Error parsing genome file. Skipping " + f2.getAbsolutePath());
                log.error(e3);
                continue;
            }
            writer.println(curLine);
        }
        writer.close();
    }

    public FeatureTrack createGeneTrack(Genome genome, BufferedReader reader, String geneFileName, String geneTrackName, String annotationURL) {
        FeatureDB.clearFeatures();
        FeatureTrack geneFeatureTrack = null;
        if (reader != null) {
            FeatureParser parser = geneFileName.endsWith(".embl") ? new EmblFeatureTableParser() : (GFFFeatureSource.isGFF(geneFileName) ? new GFFParser() : AbstractFeatureParser.getInstanceFor(new ResourceLocator(geneFileName), genome));
            if (parser == null) {
                MessageUtils.showMessage("ERROR: Unrecognized annotation file format: " + geneFileName + "<br>Annotations for genome: " + genome.getId() + " will not be loaded.");
            } else {
                List<Feature> genes = parser.loadFeatures(reader, genome);
                String name = geneTrackName;
                if (name == null) {
                    name = "Genes";
                }
                String id = genome.getId() + "_genes";
                geneFeatureTrack = new FeatureTrack(id, name, (FeatureSource)new FeatureCollectionSource(genes, genome));
                geneFeatureTrack.setMinimumHeight(5);
                geneFeatureTrack.setHeight(35);
                geneFeatureTrack.setTrackType(TrackType.GENE);
                geneFeatureTrack.setColor(Color.BLUE.darker());
                TrackProperties props = parser.getTrackProperties();
                if (props != null) {
                    geneFeatureTrack.setProperties(parser.getTrackProperties());
                }
                geneFeatureTrack.setUrl(annotationURL);
            }
        }
        return geneFeatureTrack;
    }

    public FeatureTrack createGeneTrack(Genome genome, List<Feature> features) {
        FeatureDB.clearFeatures();
        FeatureTrack geneFeatureTrack = null;
        String name = "Annotations";
        String id = genome.getId() + "_genes";
        geneFeatureTrack = new FeatureTrack(id, name, (FeatureSource)new FeatureCollectionSource(features, genome));
        geneFeatureTrack.setMinimumHeight(5);
        geneFeatureTrack.setHeight(35);
        geneFeatureTrack.setColor(Color.BLUE.darker());
        return geneFeatureTrack;
    }

    public boolean downloadGenomes(GenomeListItem item, boolean downloadSequence) {
        boolean success = false;
        try {
            File archiveFile = this.getArchiveFile(item.getPath());
            if (downloadSequence && item.getPath().endsWith(".genome")) {
                GenomeDescriptor genomeDescriptor = GenomeManager.parseGenomeArchiveFile(archiveFile);
                if (genomeDescriptor.isFasta()) {
                    String fastaPath = genomeDescriptor.getSequencePath();
                    File localFile = this.downloadFasta(fastaPath);
                    if (localFile != null) {
                        this.addLocalFasta(item.getId(), localFile);
                    }
                } else {
                    MessageUtils.showMessage("Fasta file is not availble for: " + genomeDescriptor.getName());
                }
            }
            success = true;
        }
        catch (Exception e2) {
            success = false;
            MessageUtils.showErrorMessage("Error downloading genome", e2);
            log.error("Error downloading genome " + item.getDisplayableName());
        }
        if (success) {
            this.genomeListManager.addGenomeItem(item, false);
            IGVEventBus.getInstance().post(new GenomeResetEvent());
        }
        return success;
    }

    File downloadFasta(String fastaPath) throws IOException {
        String filename;
        File localFile;
        boolean downloaded;
        File defaultDir = DirectoryManager.getFastaCacheDirectory();
        File targetDir = defaultDir;
        if (targetDir == null) {
            targetDir = defaultDir;
        }
        if (downloaded = Downloader.download(new URL(fastaPath), localFile = new File(targetDir, filename = Utilities.getFileNameFromURL(fastaPath)), IGV.getMainFrame())) {
            URL indexUrl = new URL(fastaPath + ".fai");
            File localIndexFile = new File(targetDir, filename + ".fai");
            downloaded = Downloader.download(indexUrl, localIndexFile, IGV.getMainFrame());
        }
        if (downloaded && fastaPath.endsWith(".gz")) {
            URL gziUrl = new URL(fastaPath + ".gzi");
            File localGziPath = new File(targetDir, filename + ".gzi");
            downloaded = Downloader.download(gziUrl, localGziPath, IGV.getMainFrame());
        }
        return downloaded ? localFile : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, File> loadSequenceMap() {
        File sequenceFile = new File(DirectoryManager.getGenomeCacheDirectory(), SEQUENCE_MAP_FILE);
        this.localSequenceMap = new HashMap<String, File>();
        if (sequenceFile.exists()) {
            BufferedReader br = null;
            try {
                String nextLine;
                br = new BufferedReader(new FileReader(sequenceFile));
                while ((nextLine = br.readLine()) != null) {
                    String[] tokens = nextLine.split("\t");
                    if (tokens.length <= 1) continue;
                    File file = new File(tokens[1]);
                    if (file.exists()) {
                        this.localSequenceMap.put(tokens[0], file);
                        continue;
                    }
                    log.info("Sequence file not found: " + file.getAbsolutePath());
                }
            }
            catch (IOException e2) {
                log.error("Error loading sequence map file", e2);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e3) {
                        log.error("Error closing sequenceMap file", e3);
                    }
                }
            }
        }
        return this.localSequenceMap;
    }

    public File getLocalFasta(String id) {
        return this.localSequenceMap.get(id);
    }

    public void removeLocalFasta(String id) {
        this.localSequenceMap.remove(id);
        this.updateSequenceMapFile();
    }

    private void addLocalFasta(String id, File localFile) {
        this.localSequenceMap.put(id, localFile);
        this.updateSequenceMapFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSequenceMapFile() {
        try (PrintWriter pw = null;){
            File sequenceFile = new File(DirectoryManager.getGenomeCacheDirectory(), SEQUENCE_MAP_FILE);
            pw = new PrintWriter(new BufferedWriter(new FileWriter(sequenceFile)));
            for (Map.Entry<String, File> entry : this.localSequenceMap.entrySet()) {
                pw.println(entry.getKey() + "\t" + entry.getValue());
            }
        }
    }
}

