/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BBFileHeader;
import org.broad.igv.bbfile.BBTotalSummaryBlock;
import org.broad.igv.bbfile.BBZoomLevels;
import org.broad.igv.bbfile.BPTree;
import org.broad.igv.bbfile.BigBedIterator;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.ZoomLevelIterator;
import org.broad.igv.util.stream.IGVSeekableBufferedStream;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class BBFileReader {
    public static final long BBFILE_HEADER_OFFSET = 0L;
    private static Logger log = Logger.getLogger(BBFileReader.class);
    private SeekableStream fis;
    private long fileOffset;
    private BBFileHeader fileHeader;
    private boolean isLowToHigh;
    private int uncompressBufSize;
    private String autoSqlFormat;
    private int zoomLevelCount;
    private long zoomLevelOffset;
    private BBZoomLevels zoomLevels;
    private BBTotalSummaryBlock totalSummaryBlock;
    private long chromIDTreeOffset;
    private BPTree chromosomeIDTree;
    private long chromDataTreeOffset;
    private RPTree chromosomeDataTree;
    private String autoSql;

    public BBFileReader(String path) throws IOException {
        long autoSqlOffset;
        log.debug("Opening BBFile source  " + path);
        this.fis = new IGVSeekableBufferedStream(IGVSeekableStreamFactory.getInstance().getStreamFor(path), 128000);
        this.fileOffset = 0L;
        this.fileHeader = new BBFileHeader(path, this.fis, this.fileOffset);
        if (!this.fileHeader.isHeaderOK()) {
            log.error("BBFile header is unrecognized type, header magic = " + this.fileHeader.getMagic());
            throw new RuntimeException("Error reading BBFile header for: " + path);
        }
        this.isLowToHigh = this.fileHeader.isLowToHigh();
        this.uncompressBufSize = this.fileHeader.getUncompressBuffSize();
        this.fileOffset += 64L;
        this.zoomLevelCount = this.fileHeader.getZoomLevels();
        if (this.zoomLevelCount > 0) {
            this.zoomLevelOffset = this.fileOffset;
            this.zoomLevels = new BBZoomLevels(this.fis, this.zoomLevelOffset, this.zoomLevelCount, this.isLowToHigh, this.uncompressBufSize);
            this.fileOffset += (long)(this.zoomLevelCount * 24);
        }
        if ((autoSqlOffset = this.fileHeader.getAutoSqlOffset()) != 0L) {
            this.fis.seek(autoSqlOffset);
            this.autoSql = BBFileReader.readNullTerminatedString(this.fis);
        }
        this.fileOffset = this.fileHeader.getTotalSummaryOffset();
        if (this.fileHeader.getVersion() >= 2 && this.fileOffset > 0L) {
            this.totalSummaryBlock = new BBTotalSummaryBlock(this.fis, this.fileOffset, this.isLowToHigh);
            this.fileOffset += 40L;
        }
        this.chromIDTreeOffset = this.fileHeader.getChromosomeTreeOffset();
        if (this.chromIDTreeOffset != 0L) {
            this.fileOffset = this.chromIDTreeOffset;
            this.chromosomeIDTree = new BPTree(this.fis, this.fileOffset, this.isLowToHigh);
        }
        this.chromDataTreeOffset = this.fileHeader.getFullIndexOffset();
        if (this.chromDataTreeOffset != 0L) {
            this.fileOffset = this.chromDataTreeOffset;
            boolean forceDescend = false;
            this.chromosomeDataTree = new RPTree(this.fis, this.fileOffset, this.isLowToHigh, this.uncompressBufSize, forceDescend);
        }
        this.fileOffset = this.fileHeader.getFullDataOffset();
    }

    public void close() {
        try {
            this.fis.close();
        }
        catch (IOException e2) {
            log.error("Error closing bigwig stream", e2);
        }
    }

    public BBFileHeader getBBFileHeader() {
        return this.fileHeader;
    }

    public boolean isBigBedFile() {
        return this.fileHeader.isBigBed();
    }

    public boolean isBigWigFile() {
        return this.fileHeader.isBigWig();
    }

    public boolean isLowToHigh() {
        return this.isLowToHigh;
    }

    public BBTotalSummaryBlock getTotalSummaryBlock() {
        return this.totalSummaryBlock;
    }

    public BBZoomLevels getZoomLevels() {
        return this.zoomLevels;
    }

    public ArrayList<String> getChromosomeNames() {
        ArrayList<String> chromosomeList = this.chromosomeIDTree.getChromosomeNames();
        return chromosomeList;
    }

    public String getAutoSql() {
        return this.autoSql;
    }

    public synchronized BigBedIterator getBigBedIterator(String startChromosome, int startBase, String endChromosome, int endBase, boolean contained) {
        if (!this.isBigBedFile()) {
            return null;
        }
        RPChromosomeRegion selectionRegion = this.getChromosomeBounds(startChromosome, startBase, endChromosome, endBase);
        if (selectionRegion == null) {
            return new BigBedIterator();
        }
        BigBedIterator bedIterator = new BigBedIterator(this.fis, this.chromosomeIDTree, this.chromosomeDataTree, selectionRegion, contained);
        return bedIterator;
    }

    public synchronized BigWigIterator getBigWigIterator(String startChromosome, int startBase, String endChromosome, int endBase, boolean contained) {
        if (!this.isBigWigFile()) {
            return null;
        }
        RPChromosomeRegion selectionRegion = this.getChromosomeBounds(startChromosome, startBase, endChromosome, endBase);
        if (selectionRegion == null) {
            return new BigWigIterator();
        }
        BigWigIterator wigIterator = new BigWigIterator(this.fis, this.chromosomeIDTree, this.chromosomeDataTree, selectionRegion, contained);
        return wigIterator;
    }

    public synchronized ZoomLevelIterator getZoomLevelIterator(int zoomLevel, String startChromosome, int startBase, String endChromosome, int endBase, boolean contained) {
        if (zoomLevel < 1 || zoomLevel > this.zoomLevelCount) {
            throw new RuntimeException("Error: ZoomLevelIterator zoom level is out of range\n");
        }
        RPTree zoomDataTree = this.zoomLevels.getZoomLevelRPTree(zoomLevel);
        RPChromosomeRegion selectionRegion = this.getChromosomeBounds(startChromosome, startBase, endChromosome, endBase);
        if (selectionRegion == null) {
            return ZoomLevelIterator.EmptyIterator.theInstance;
        }
        ZoomLevelIterator zoomIterator = new ZoomLevelIterator(this.fis, this.chromosomeIDTree, zoomDataTree, zoomLevel, selectionRegion, contained);
        return zoomIterator;
    }

    public synchronized ZoomLevelIterator getZoomLevelIterator(int zoomLevel) {
        if (zoomLevel < 1 || zoomLevel > this.zoomLevelCount) {
            throw new RuntimeException("Error: ZoomLevelIterator zoom level is out of range\n");
        }
        RPTree zoomDataTree = this.zoomLevels.getZoomLevelRPTree(zoomLevel);
        RPChromosomeRegion selectionRegion = zoomDataTree.getChromosomeBounds();
        boolean contained = true;
        ZoomLevelIterator zoomIterator = new ZoomLevelIterator(this.fis, this.chromosomeIDTree, zoomDataTree, zoomLevel, selectionRegion, contained);
        return zoomIterator;
    }

    private RPChromosomeRegion getChromosomeBounds(String startChromosome, int startBase, String endChromosome, int endBase) {
        if (startChromosome.length() > this.chromosomeIDTree.getKeySize()) {
            return null;
        }
        String startChromKey = this.chromosomeIDTree.getChromosomeKey(startChromosome);
        int startChromID = this.chromosomeIDTree.getChromosomeID(startChromKey);
        if (startChromID < 0) {
            return null;
        }
        String endChromKey = this.chromosomeIDTree.getChromosomeKey(endChromosome);
        int endChromID = this.chromosomeIDTree.getChromosomeID(endChromKey);
        if (endChromID < 0) {
            return null;
        }
        RPChromosomeRegion chromBounds = new RPChromosomeRegion(startChromID, startBase, endChromID, endBase);
        return chromBounds;
    }

    private static String readNullTerminatedString(InputStream fis) throws IOException {
        byte b2;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(100);
        while ((b2 = (byte)fis.read()) != 0) {
            bos.write(b2);
        }
        return new String(bos.toByteArray());
    }

    public String getChromsomeFromId(int chromId) {
        return this.chromosomeIDTree.getChromosomeName(chromId);
    }
}

