/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractSVGItem;
import org.apache.batik.dom.svg.AbstractSVGList;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGPathSegConstants;
import org.apache.batik.parser.DefaultPathHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegArcRel;
import org.w3c.dom.svg.SVGPathSegClosePath;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothRel;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalRel;
import org.w3c.dom.svg.SVGPathSegLinetoRel;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalRel;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;

public abstract class AbstractSVGPathSegList
extends AbstractSVGList
implements SVGPathSegList,
SVGPathSegConstants {
    public static final String SVG_PATHSEG_LIST_SEPARATOR = " ";

    protected AbstractSVGPathSegList() {
    }

    protected String getItemSeparator() {
        return SVG_PATHSEG_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    public SVGPathSeg initialize(SVGPathSeg newItem) throws DOMException, SVGException {
        return (SVGPathSeg)((Object)this.initializeImpl(newItem));
    }

    public SVGPathSeg getItem(int index) throws DOMException {
        return (SVGPathSeg)((Object)this.getItemImpl(index));
    }

    public SVGPathSeg insertItemBefore(SVGPathSeg newItem, int index) throws DOMException, SVGException {
        return (SVGPathSeg)((Object)this.insertItemBeforeImpl(newItem, index));
    }

    public SVGPathSeg replaceItem(SVGPathSeg newItem, int index) throws DOMException, SVGException {
        return (SVGPathSeg)((Object)this.replaceItemImpl(newItem, index));
    }

    public SVGPathSeg removeItem(int index) throws DOMException {
        return (SVGPathSeg)((Object)this.removeItemImpl(index));
    }

    public SVGPathSeg appendItem(SVGPathSeg newItem) throws DOMException, SVGException {
        return (SVGPathSeg)((Object)this.appendItemImpl(newItem));
    }

    protected SVGItem createSVGItem(Object newItem) {
        SVGPathSeg pathSeg = (SVGPathSeg)newItem;
        return this.createPathSegItem(pathSeg);
    }

    protected void doParse(String value, ListHandler handler) throws ParseException {
        PathParser pathParser = new PathParser();
        PathSegListBuilder builder = new PathSegListBuilder(handler);
        pathParser.setPathHandler(builder);
        pathParser.parse(value);
    }

    protected void checkItemType(Object newItem) {
        if (!(newItem instanceof SVGPathSeg)) {
            this.createSVGException((short)0, "expected SVGPathSeg", null);
        }
    }

    protected SVGPathSegItem createPathSegItem(SVGPathSeg pathSeg) {
        SVGPathSegItem pathSegItem = null;
        short type = pathSeg.getPathSegType();
        switch (type) {
            case 10: 
            case 11: {
                pathSegItem = new SVGPathSegArcItem(pathSeg);
                break;
            }
            case 1: {
                pathSegItem = new SVGPathSegItem(pathSeg);
                break;
            }
            case 6: 
            case 7: {
                pathSegItem = new SVGPathSegCurvetoCubicItem(pathSeg);
                break;
            }
            case 16: 
            case 17: {
                pathSegItem = new SVGPathSegCurvetoCubicSmoothItem(pathSeg);
                break;
            }
            case 8: 
            case 9: {
                pathSegItem = new SVGPathSegCurvetoQuadraticItem(pathSeg);
                break;
            }
            case 18: 
            case 19: {
                pathSegItem = new SVGPathSegCurvetoQuadraticSmoothItem(pathSeg);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                pathSegItem = new SVGPathSegMovetoLinetoItem(pathSeg);
                break;
            }
            case 12: 
            case 13: {
                pathSegItem = new SVGPathSegLinetoHorizontalItem(pathSeg);
                break;
            }
            case 14: 
            case 15: {
                pathSegItem = new SVGPathSegLinetoVerticalItem(pathSeg);
                break;
            }
        }
        return pathSegItem;
    }

    protected class PathSegListBuilder
    extends DefaultPathHandler {
        protected ListHandler listHandler;

        public PathSegListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        public void startPath() throws ParseException {
            this.listHandler.startList();
        }

        public void endPath() throws ParseException {
            this.listHandler.endList();
        }

        public void movetoRel(float x2, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegMovetoLinetoItem(3, "m", x2, y));
        }

        public void movetoAbs(float x2, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegMovetoLinetoItem(2, "M", x2, y));
        }

        public void closePath() throws ParseException {
            this.listHandler.item(new SVGPathSegItem(1, "z"));
        }

        public void linetoRel(float x2, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegMovetoLinetoItem(5, "l", x2, y));
        }

        public void linetoAbs(float x2, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegMovetoLinetoItem(4, "L", x2, y));
        }

        public void linetoHorizontalRel(float x2) throws ParseException {
            this.listHandler.item(new SVGPathSegLinetoHorizontalItem(13, "h", x2));
        }

        public void linetoHorizontalAbs(float x2) throws ParseException {
            this.listHandler.item(new SVGPathSegLinetoHorizontalItem(12, "H", x2));
        }

        public void linetoVerticalRel(float y) throws ParseException {
            this.listHandler.item(new SVGPathSegLinetoVerticalItem(15, "v", y));
        }

        public void linetoVerticalAbs(float y) throws ParseException {
            this.listHandler.item(new SVGPathSegLinetoVerticalItem(14, "V", y));
        }

        public void curvetoCubicRel(float x1, float y1, float x2, float y2, float x3, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoCubicItem(7, "c", x1, y1, x2, y2, x3, y));
        }

        public void curvetoCubicAbs(float x1, float y1, float x2, float y2, float x3, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoCubicItem(6, "C", x1, y1, x2, y2, x3, y));
        }

        public void curvetoCubicSmoothRel(float x2, float y2, float x3, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoCubicSmoothItem(17, "s", x2, y2, x3, y));
        }

        public void curvetoCubicSmoothAbs(float x2, float y2, float x3, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoCubicSmoothItem(16, "S", x2, y2, x3, y));
        }

        public void curvetoQuadraticRel(float x1, float y1, float x2, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoQuadraticItem(9, "q", x1, y1, x2, y));
        }

        public void curvetoQuadraticAbs(float x1, float y1, float x2, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoQuadraticItem(8, "Q", x1, y1, x2, y));
        }

        public void curvetoQuadraticSmoothRel(float x2, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoQuadraticSmoothItem(19, "t", x2, y));
        }

        public void curvetoQuadraticSmoothAbs(float x2, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoQuadraticSmoothItem(18, "T", x2, y));
        }

        public void arcRel(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x2, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegArcItem(11, "a", rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x2, y));
        }

        public void arcAbs(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x2, float y) throws ParseException {
            this.listHandler.item(new SVGPathSegArcItem(10, "A", rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x2, y));
        }
    }

    public class SVGPathSegCurvetoQuadraticSmoothItem
    extends SVGPathSegItem
    implements SVGPathSegCurvetoQuadraticSmoothAbs,
    SVGPathSegCurvetoQuadraticSmoothRel {
        public SVGPathSegCurvetoQuadraticSmoothItem(short type, String letter, float x2, float y) {
            super(type, letter);
            this.x = x2;
            this.y = y;
        }

        public SVGPathSegCurvetoQuadraticSmoothItem(SVGPathSeg pathSeg) {
            this.type = pathSeg.getPathSegType();
            switch (this.type) {
                case 18: {
                    this.letter = "T";
                    this.x = ((SVGPathSegCurvetoQuadraticSmoothAbs)pathSeg).getX();
                    this.y = ((SVGPathSegCurvetoQuadraticSmoothAbs)pathSeg).getY();
                    break;
                }
                case 19: {
                    this.letter = "t";
                    this.x = ((SVGPathSegCurvetoQuadraticSmoothRel)pathSeg).getX();
                    this.y = ((SVGPathSegCurvetoQuadraticSmoothRel)pathSeg).getY();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float x2) {
            this.x = x2;
            this.resetAttribute();
        }

        public void setY(float y) {
            this.y = y;
            this.resetAttribute();
        }

        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.x) + ' ' + Float.toString(this.y);
        }
    }

    public class SVGPathSegCurvetoCubicSmoothItem
    extends SVGPathSegItem
    implements SVGPathSegCurvetoCubicSmoothAbs,
    SVGPathSegCurvetoCubicSmoothRel {
        public SVGPathSegCurvetoCubicSmoothItem(short type, String letter, float x2, float y2, float x3, float y) {
            super(type, letter);
            this.x = x3;
            this.y = y;
            this.x2 = x2;
            this.y2 = y2;
        }

        public SVGPathSegCurvetoCubicSmoothItem(SVGPathSeg pathSeg) {
            this.type = pathSeg.getPathSegType();
            switch (this.type) {
                case 16: {
                    this.letter = "S";
                    this.x = ((SVGPathSegCurvetoCubicSmoothAbs)pathSeg).getX();
                    this.y = ((SVGPathSegCurvetoCubicSmoothAbs)pathSeg).getY();
                    this.x2 = ((SVGPathSegCurvetoCubicSmoothAbs)pathSeg).getX2();
                    this.y2 = ((SVGPathSegCurvetoCubicSmoothAbs)pathSeg).getY2();
                    break;
                }
                case 17: {
                    this.letter = "s";
                    this.x = ((SVGPathSegCurvetoCubicSmoothRel)pathSeg).getX();
                    this.y = ((SVGPathSegCurvetoCubicSmoothRel)pathSeg).getY();
                    this.x2 = ((SVGPathSegCurvetoCubicSmoothRel)pathSeg).getX2();
                    this.y2 = ((SVGPathSegCurvetoCubicSmoothRel)pathSeg).getY2();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float x2) {
            this.x = x2;
            this.resetAttribute();
        }

        public void setY(float y) {
            this.y = y;
            this.resetAttribute();
        }

        public float getX2() {
            return this.x2;
        }

        public float getY2() {
            return this.y2;
        }

        public void setX2(float x2) {
            this.x2 = x2;
            this.resetAttribute();
        }

        public void setY2(float y2) {
            this.y2 = y2;
            this.resetAttribute();
        }

        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.x2) + ' ' + Float.toString(this.y2) + ' ' + Float.toString(this.x) + ' ' + Float.toString(this.y);
        }
    }

    public class SVGPathSegLinetoVerticalItem
    extends SVGPathSegItem
    implements SVGPathSegLinetoVerticalAbs,
    SVGPathSegLinetoVerticalRel {
        public SVGPathSegLinetoVerticalItem(short type, String letter, float value) {
            super(type, letter);
            this.y = value;
        }

        public SVGPathSegLinetoVerticalItem(SVGPathSeg pathSeg) {
            this.type = pathSeg.getPathSegType();
            switch (this.type) {
                case 14: {
                    this.letter = "V";
                    this.y = ((SVGPathSegLinetoVerticalAbs)pathSeg).getY();
                    break;
                }
                case 15: {
                    this.letter = "v";
                    this.y = ((SVGPathSegLinetoVerticalRel)pathSeg).getY();
                    break;
                }
            }
        }

        public float getY() {
            return this.y;
        }

        public void setY(float y) {
            this.y = y;
            this.resetAttribute();
        }

        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.y);
        }
    }

    public class SVGPathSegLinetoHorizontalItem
    extends SVGPathSegItem
    implements SVGPathSegLinetoHorizontalAbs,
    SVGPathSegLinetoHorizontalRel {
        public SVGPathSegLinetoHorizontalItem(short type, String letter, float value) {
            super(type, letter);
            this.x = value;
        }

        public SVGPathSegLinetoHorizontalItem(SVGPathSeg pathSeg) {
            this.type = pathSeg.getPathSegType();
            switch (this.type) {
                case 12: {
                    this.letter = "H";
                    this.x = ((SVGPathSegLinetoHorizontalAbs)pathSeg).getX();
                    break;
                }
                case 13: {
                    this.letter = "h";
                    this.x = ((SVGPathSegLinetoHorizontalRel)pathSeg).getX();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public void setX(float x2) {
            this.x = x2;
            this.resetAttribute();
        }

        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.x);
        }
    }

    public class SVGPathSegArcItem
    extends SVGPathSegItem
    implements SVGPathSegArcAbs,
    SVGPathSegArcRel {
        public SVGPathSegArcItem(short type, String letter, float r1, float r2, float angle, boolean largeArcFlag, boolean sweepFlag, float x2, float y) {
            super(type, letter);
            this.x = x2;
            this.y = y;
            this.r1 = r1;
            this.r2 = r2;
            this.angle = angle;
            this.largeArcFlag = largeArcFlag;
            this.sweepFlag = sweepFlag;
        }

        public SVGPathSegArcItem(SVGPathSeg pathSeg) {
            this.type = pathSeg.getPathSegType();
            switch (this.type) {
                case 10: {
                    this.letter = "A";
                    this.x = ((SVGPathSegArcAbs)pathSeg).getX();
                    this.y = ((SVGPathSegArcAbs)pathSeg).getY();
                    this.r1 = ((SVGPathSegArcAbs)pathSeg).getR1();
                    this.r2 = ((SVGPathSegArcAbs)pathSeg).getR2();
                    this.angle = ((SVGPathSegArcAbs)pathSeg).getAngle();
                    this.largeArcFlag = ((SVGPathSegArcAbs)pathSeg).getLargeArcFlag();
                    this.sweepFlag = ((SVGPathSegArcAbs)pathSeg).getSweepFlag();
                    break;
                }
                case 11: {
                    this.letter = "a";
                    this.x = ((SVGPathSegArcRel)pathSeg).getX();
                    this.y = ((SVGPathSegArcRel)pathSeg).getY();
                    this.r1 = ((SVGPathSegArcRel)pathSeg).getR1();
                    this.r2 = ((SVGPathSegArcRel)pathSeg).getR2();
                    this.angle = ((SVGPathSegArcRel)pathSeg).getAngle();
                    this.largeArcFlag = ((SVGPathSegArcRel)pathSeg).getLargeArcFlag();
                    this.sweepFlag = ((SVGPathSegArcRel)pathSeg).getSweepFlag();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float x2) {
            this.x = x2;
            this.resetAttribute();
        }

        public void setY(float y) {
            this.y = y;
            this.resetAttribute();
        }

        public float getR1() {
            return this.r1;
        }

        public float getR2() {
            return this.r2;
        }

        public void setR1(float r1) {
            this.r1 = r1;
            this.resetAttribute();
        }

        public void setR2(float r2) {
            this.r2 = r2;
            this.resetAttribute();
        }

        public float getAngle() {
            return this.angle;
        }

        public void setAngle(float angle) {
            this.angle = angle;
            this.resetAttribute();
        }

        public boolean getSweepFlag() {
            return this.sweepFlag;
        }

        public void setSweepFlag(boolean sweepFlag) {
            this.sweepFlag = sweepFlag;
            this.resetAttribute();
        }

        public boolean getLargeArcFlag() {
            return this.largeArcFlag;
        }

        public void setLargeArcFlag(boolean largeArcFlag) {
            this.largeArcFlag = largeArcFlag;
            this.resetAttribute();
        }

        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.r1) + ' ' + Float.toString(this.r2) + ' ' + Float.toString(this.angle) + ' ' + (this.largeArcFlag ? "1" : "0") + ' ' + (this.sweepFlag ? "1" : "0") + ' ' + Float.toString(this.x) + ' ' + Float.toString(this.y);
        }
    }

    public class SVGPathSegCurvetoQuadraticItem
    extends SVGPathSegItem
    implements SVGPathSegCurvetoQuadraticAbs,
    SVGPathSegCurvetoQuadraticRel {
        public SVGPathSegCurvetoQuadraticItem(short type, String letter, float x1, float y1, float x2, float y) {
            super(type, letter);
            this.x = x2;
            this.y = y;
            this.x1 = x1;
            this.y1 = y1;
        }

        public SVGPathSegCurvetoQuadraticItem(SVGPathSeg pathSeg) {
            this.type = pathSeg.getPathSegType();
            switch (this.type) {
                case 8: {
                    this.letter = "Q";
                    this.x = ((SVGPathSegCurvetoQuadraticAbs)pathSeg).getX();
                    this.y = ((SVGPathSegCurvetoQuadraticAbs)pathSeg).getY();
                    this.x1 = ((SVGPathSegCurvetoQuadraticAbs)pathSeg).getX1();
                    this.y1 = ((SVGPathSegCurvetoQuadraticAbs)pathSeg).getY1();
                    break;
                }
                case 9: {
                    this.letter = "q";
                    this.x = ((SVGPathSegCurvetoQuadraticRel)pathSeg).getX();
                    this.y = ((SVGPathSegCurvetoQuadraticRel)pathSeg).getY();
                    this.x1 = ((SVGPathSegCurvetoQuadraticRel)pathSeg).getX1();
                    this.y1 = ((SVGPathSegCurvetoQuadraticRel)pathSeg).getY1();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float x2) {
            this.x = x2;
            this.resetAttribute();
        }

        public void setY(float y) {
            this.y = y;
            this.resetAttribute();
        }

        public float getX1() {
            return this.x1;
        }

        public float getY1() {
            return this.y1;
        }

        public void setX1(float x1) {
            this.x1 = x1;
            this.resetAttribute();
        }

        public void setY1(float y1) {
            this.y1 = y1;
            this.resetAttribute();
        }

        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.x1) + ' ' + Float.toString(this.y1) + ' ' + Float.toString(this.x) + ' ' + Float.toString(this.y);
        }
    }

    public class SVGPathSegCurvetoCubicItem
    extends SVGPathSegItem
    implements SVGPathSegCurvetoCubicAbs,
    SVGPathSegCurvetoCubicRel {
        public SVGPathSegCurvetoCubicItem(short type, String letter, float x1, float y1, float x2, float y2, float x3, float y) {
            super(type, letter);
            this.x = x3;
            this.y = y;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public SVGPathSegCurvetoCubicItem(SVGPathSeg pathSeg) {
            this.type = pathSeg.getPathSegType();
            switch (this.type) {
                case 6: {
                    this.letter = "C";
                    this.x = ((SVGPathSegCurvetoCubicAbs)pathSeg).getX();
                    this.y = ((SVGPathSegCurvetoCubicAbs)pathSeg).getY();
                    this.x1 = ((SVGPathSegCurvetoCubicAbs)pathSeg).getX1();
                    this.y1 = ((SVGPathSegCurvetoCubicAbs)pathSeg).getY1();
                    this.x2 = ((SVGPathSegCurvetoCubicAbs)pathSeg).getX2();
                    this.y2 = ((SVGPathSegCurvetoCubicAbs)pathSeg).getY2();
                    break;
                }
                case 7: {
                    this.letter = "c";
                    this.x = ((SVGPathSegCurvetoCubicRel)pathSeg).getX();
                    this.y = ((SVGPathSegCurvetoCubicRel)pathSeg).getY();
                    this.x1 = ((SVGPathSegCurvetoCubicRel)pathSeg).getX1();
                    this.y1 = ((SVGPathSegCurvetoCubicRel)pathSeg).getY1();
                    this.x2 = ((SVGPathSegCurvetoCubicRel)pathSeg).getX2();
                    this.y2 = ((SVGPathSegCurvetoCubicRel)pathSeg).getY2();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float x2) {
            this.x = x2;
            this.resetAttribute();
        }

        public void setY(float y) {
            this.y = y;
            this.resetAttribute();
        }

        public float getX1() {
            return this.x1;
        }

        public float getY1() {
            return this.y1;
        }

        public void setX1(float x1) {
            this.x1 = x1;
            this.resetAttribute();
        }

        public void setY1(float y1) {
            this.y1 = y1;
            this.resetAttribute();
        }

        public float getX2() {
            return this.x2;
        }

        public float getY2() {
            return this.y2;
        }

        public void setX2(float x2) {
            this.x2 = x2;
            this.resetAttribute();
        }

        public void setY2(float y2) {
            this.y2 = y2;
            this.resetAttribute();
        }

        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.x1) + ' ' + Float.toString(this.y1) + ' ' + Float.toString(this.x2) + ' ' + Float.toString(this.y2) + ' ' + Float.toString(this.x) + ' ' + Float.toString(this.y);
        }
    }

    public class SVGPathSegMovetoLinetoItem
    extends SVGPathSegItem
    implements SVGPathSegMovetoAbs,
    SVGPathSegMovetoRel,
    SVGPathSegLinetoAbs,
    SVGPathSegLinetoRel {
        public SVGPathSegMovetoLinetoItem(short type, String letter, float x2, float y) {
            super(type, letter);
            this.x = x2;
            this.y = y;
        }

        public SVGPathSegMovetoLinetoItem(SVGPathSeg pathSeg) {
            this.type = pathSeg.getPathSegType();
            switch (this.type) {
                case 5: {
                    this.letter = "l";
                    this.x = ((SVGPathSegLinetoRel)pathSeg).getX();
                    this.y = ((SVGPathSegLinetoRel)pathSeg).getY();
                    break;
                }
                case 4: {
                    this.letter = "L";
                    this.x = ((SVGPathSegLinetoAbs)pathSeg).getX();
                    this.y = ((SVGPathSegLinetoAbs)pathSeg).getY();
                    break;
                }
                case 3: {
                    this.letter = "m";
                    this.x = ((SVGPathSegMovetoRel)pathSeg).getX();
                    this.y = ((SVGPathSegMovetoRel)pathSeg).getY();
                    break;
                }
                case 2: {
                    this.letter = "M";
                    this.x = ((SVGPathSegMovetoAbs)pathSeg).getX();
                    this.y = ((SVGPathSegMovetoAbs)pathSeg).getY();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float x2) {
            this.x = x2;
            this.resetAttribute();
        }

        public void setY(float y) {
            this.y = y;
            this.resetAttribute();
        }

        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.x) + ' ' + Float.toString(this.y);
        }
    }

    protected class SVGPathSegItem
    extends AbstractSVGItem
    implements SVGPathSeg,
    SVGPathSegClosePath {
        protected short type;
        protected String letter;
        protected float x;
        protected float y;
        protected float x1;
        protected float y1;
        protected float x2;
        protected float y2;
        protected float r1;
        protected float r2;
        protected float angle;
        protected boolean largeArcFlag;
        protected boolean sweepFlag;

        protected SVGPathSegItem() {
        }

        public SVGPathSegItem(short type, String letter) {
            this.type = type;
            this.letter = letter;
        }

        public SVGPathSegItem(SVGPathSeg pathSeg) {
            this.type = pathSeg.getPathSegType();
            switch (this.type) {
                case 1: {
                    this.letter = "z";
                    break;
                }
            }
        }

        protected String getStringValue() {
            return this.letter;
        }

        public short getPathSegType() {
            return this.type;
        }

        public String getPathSegTypeAsLetter() {
            return this.letter;
        }
    }
}

