/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.IndexingVariantContextWriter;
import htsjdk.variant.vcf.VCFEncoder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderVersion;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

class VCFWriter
extends IndexingVariantContextWriter {
    private static final String VERSION_LINE = "##" + VCFHeaderVersion.VCF4_2.getFormatString() + "=" + VCFHeaderVersion.VCF4_2.getVersionString();
    private VCFEncoder vcfEncoder = null;
    protected VCFHeader mHeader = null;
    private final boolean allowMissingFieldsInHeader;
    private final boolean doNotWriteGenotypes;
    private final boolean writeFullFormatField;
    private boolean outputHasBeenWritten;
    private static final int INITIAL_BUFFER_SIZE = 16384;
    private final ByteArrayOutputStream lineBuffer = new ByteArrayOutputStream(16384);
    private final Writer writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.lineBuffer, VCFEncoder.VCF_CHARSET));

    public VCFWriter(File location, OutputStream output, SAMSequenceDictionary refDict, boolean enableOnTheFlyIndexing, boolean doNotWriteGenotypes, boolean allowMissingFieldsInHeader, boolean writeFullFormatField) {
        super(VCFWriter.writerName(location, output), location, output, refDict, enableOnTheFlyIndexing);
        this.doNotWriteGenotypes = doNotWriteGenotypes;
        this.allowMissingFieldsInHeader = allowMissingFieldsInHeader;
        this.writeFullFormatField = writeFullFormatField;
    }

    public VCFWriter(File location, OutputStream output, SAMSequenceDictionary refDict, IndexCreator indexCreator, boolean enableOnTheFlyIndexing, boolean doNotWriteGenotypes, boolean allowMissingFieldsInHeader, boolean writeFullFormatField) {
        super(VCFWriter.writerName(location, output), location, output, refDict, enableOnTheFlyIndexing, indexCreator);
        this.doNotWriteGenotypes = doNotWriteGenotypes;
        this.allowMissingFieldsInHeader = allowMissingFieldsInHeader;
        this.writeFullFormatField = writeFullFormatField;
    }

    private void write(String s2) throws IOException {
        this.writer.write(s2);
    }

    private void writeAndResetBuffer() throws IOException {
        this.writer.flush();
        this.getOutputStream().write(this.lineBuffer.toByteArray());
        this.lineBuffer.reset();
    }

    @Override
    public void writeHeader(VCFHeader header) {
        this.setHeader(header);
        try {
            VCFWriter.writeHeader(this.mHeader, this.writer, VCFWriter.getVersionLine(), this.getStreamName());
            this.writeAndResetBuffer();
            this.outputHasBeenWritten = true;
        }
        catch (IOException e2) {
            throw new RuntimeIOException("Couldn't write file " + this.getStreamName(), e2);
        }
    }

    public static String getVersionLine() {
        return VERSION_LINE;
    }

    public static VCFHeader writeHeader(VCFHeader header, Writer writer, String versionLine, String streamNameForError) {
        try {
            writer.write(versionLine + "\n");
            for (VCFHeaderLine line : header.getMetaDataInSortedOrder()) {
                if (VCFHeaderVersion.isFormatString(line.getKey())) continue;
                writer.write("##");
                writer.write(line.toString());
                writer.write("\n");
            }
            writer.write("#");
            boolean isFirst = true;
            for (VCFHeader.HEADER_FIELDS field : header.getHeaderFields()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    writer.write("\t");
                }
                writer.write(field.toString());
            }
            if (header.hasGenotypingData()) {
                writer.write("\t");
                writer.write("FORMAT");
                for (String sample : header.getGenotypeSamples()) {
                    writer.write("\t");
                    writer.write(sample);
                }
            }
            writer.write("\n");
            writer.flush();
        }
        catch (IOException e2) {
            throw new RuntimeIOException("IOException writing the VCF header to " + streamNameForError, e2);
        }
        return header;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e2) {
            throw new RuntimeIOException("Unable to close " + this.getStreamName(), e2);
        }
        super.close();
    }

    @Override
    public void add(VariantContext context) {
        try {
            super.add(context);
            if (this.doNotWriteGenotypes) {
                this.write(this.vcfEncoder.encode(new VariantContextBuilder(context).noGenotypes().make()));
            } else {
                this.write(this.vcfEncoder.encode(context));
            }
            this.write("\n");
            this.writeAndResetBuffer();
            this.outputHasBeenWritten = true;
        }
        catch (IOException e2) {
            throw new RuntimeIOException("Unable to write the VCF object to " + this.getStreamName(), e2);
        }
    }

    @Override
    public void setHeader(VCFHeader header) {
        if (this.outputHasBeenWritten) {
            throw new IllegalStateException("The header cannot be modified after the header or variants have been written to the output stream.");
        }
        this.mHeader = this.doNotWriteGenotypes ? new VCFHeader(header.getMetaDataInSortedOrder()) : header;
        this.vcfEncoder = new VCFEncoder(this.mHeader, this.allowMissingFieldsInHeader, this.writeFullFormatField);
    }
}

