/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Sam2CramRecordFactory {
    private byte[] refBases;
    private final Version version;
    private final SAMFileHeader header;
    private static final Log log = Log.getInstance(Sam2CramRecordFactory.class);
    private final Map<String, Integer> readGroupMap = new HashMap<String, Integer>();
    public boolean captureAllTags = false;
    public boolean preserveReadNames = false;
    public final Set<String> captureTags = new TreeSet<String>();
    public final Set<String> ignoreTags = new TreeSet<String>();
    private final List<ReadTag> readTagList;
    private long baseCount;
    private long featureCount;

    public Sam2CramRecordFactory(byte[] refBases, SAMFileHeader samFileHeader, Version version) {
        this.ignoreTags.add(SAMTag.RG.name());
        this.readTagList = new ArrayList<ReadTag>();
        this.baseCount = 0L;
        this.featureCount = 0L;
        this.refBases = refBases;
        this.version = version;
        this.header = samFileHeader;
        List<SAMReadGroupRecord> readGroups = samFileHeader.getReadGroups();
        for (int i2 = 0; i2 < readGroups.size(); ++i2) {
            SAMReadGroupRecord readGroupRecord = readGroups.get(i2);
            this.readGroupMap.put(readGroupRecord.getId(), i2);
        }
    }

    public CramCompressionRecord createCramRecord(SAMRecord record) {
        if (null == record.getHeader()) {
            record.setHeader(this.header);
        }
        CramCompressionRecord cramRecord = new CramCompressionRecord();
        if (record.getReadPairedFlag()) {
            cramRecord.mateAlignmentStart = record.getMateAlignmentStart();
            cramRecord.setMateUnmapped(record.getMateUnmappedFlag());
            cramRecord.setMateNegativeStrand(record.getMateNegativeStrandFlag());
            cramRecord.mateSequenceID = record.getMateReferenceIndex();
        } else {
            cramRecord.mateSequenceID = -1;
        }
        cramRecord.sequenceId = record.getReferenceIndex();
        cramRecord.readName = record.getReadName();
        cramRecord.alignmentStart = record.getAlignmentStart();
        cramRecord.setMultiFragment(record.getReadPairedFlag());
        cramRecord.setProperPair(record.getReadPairedFlag() && record.getProperPairFlag());
        cramRecord.setSegmentUnmapped(record.getReadUnmappedFlag());
        cramRecord.setNegativeStrand(record.getReadNegativeStrandFlag());
        cramRecord.setFirstSegment(record.getReadPairedFlag() && record.getFirstOfPairFlag());
        cramRecord.setLastSegment(record.getReadPairedFlag() && record.getSecondOfPairFlag());
        cramRecord.setSecondaryAlignment(record.isSecondaryAlignment());
        cramRecord.setVendorFiltered(record.getReadFailsVendorQualityCheckFlag());
        cramRecord.setDuplicate(record.getDuplicateReadFlag());
        cramRecord.setSupplementary(record.getSupplementaryAlignmentFlag());
        cramRecord.readLength = record.getReadLength();
        cramRecord.mappingQuality = record.getMappingQuality();
        cramRecord.setDuplicate(record.getDuplicateReadFlag());
        cramRecord.templateSize = record.getInferredInsertSize();
        SAMReadGroupRecord readGroup = record.getReadGroup();
        cramRecord.readGroupID = readGroup != null ? this.readGroupMap.get(readGroup.getId()) : -1;
        if (!record.getReadPairedFlag()) {
            cramRecord.setLastSegment(false);
        } else if (record.getFirstOfPairFlag()) {
            cramRecord.setLastSegment(false);
        } else if (record.getSecondOfPairFlag()) {
            cramRecord.setLastSegment(true);
        }
        cramRecord.readFeatures = !record.getReadUnmappedFlag() && record.getAlignmentStart() != 0 ? this.checkedCreateVariations(cramRecord, record) : Collections.emptyList();
        cramRecord.readBases = record.getReadBases();
        cramRecord.readBases = SequenceUtil.toBamReadBasesInPlace(Arrays.copyOf(record.getReadBases(), record.getReadLength()));
        cramRecord.qualityScores = record.getBaseQualities();
        if (this.version.compatibleWith(CramVersions.CRAM_v3)) {
            cramRecord.setUnknownBases(record.getReadBases() == SAMRecord.NULL_SEQUENCE);
        }
        this.readTagList.clear();
        if (this.captureAllTags) {
            List<SAMRecord.SAMTagAndValue> attributes = record.getAttributes();
            for (SAMRecord.SAMTagAndValue tagAndValue : attributes) {
                if (this.ignoreTags.contains(tagAndValue.tag)) continue;
                this.readTagList.add(ReadTag.deriveTypeFromValue(tagAndValue.tag, tagAndValue.value));
            }
        } else if (!this.captureTags.isEmpty()) {
            List<SAMRecord.SAMTagAndValue> attributes = record.getAttributes();
            cramRecord.tags = new ReadTag[attributes.size()];
            for (SAMRecord.SAMTagAndValue tagAndValue : attributes) {
                if (!this.captureTags.contains(tagAndValue.tag)) continue;
                this.readTagList.add(ReadTag.deriveTypeFromValue(tagAndValue.tag, tagAndValue.value));
            }
        }
        cramRecord.tags = this.readTagList.toArray(new ReadTag[this.readTagList.size()]);
        cramRecord.setVendorFiltered(record.getReadFailsVendorQualityCheckFlag());
        if (this.preserveReadNames) {
            cramRecord.readName = record.getReadName();
        }
        return cramRecord;
    }

    private List<ReadFeature> checkedCreateVariations(CramCompressionRecord cramRecord, SAMRecord samRecord) {
        try {
            return this.createVariations(cramRecord, samRecord);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            log.error("Reference bases array length=" + this.refBases.length);
            log.error("Offensive CRAM record: " + cramRecord.toString());
            log.error("Offensive SAM record: " + samRecord.getSAMString());
            throw e2;
        }
    }

    private List<ReadFeature> createVariations(CramCompressionRecord cramRecord, SAMRecord samRecord) {
        LinkedList<ReadFeature> features = new LinkedList<ReadFeature>();
        int zeroBasedPositionInRead = 0;
        int alignmentStartOffset = 0;
        List<CigarElement> cigarElements = samRecord.getCigar().getCigarElements();
        int cigarLen = 0;
        for (CigarElement cigarElement : cigarElements) {
            if (!cigarElement.getOperator().consumesReadBases()) continue;
            cigarLen += cigarElement.getLength();
        }
        byte[] bases = samRecord.getReadBases();
        if (bases.length == 0) {
            bases = new byte[cigarLen];
            Arrays.fill(bases, (byte)78);
        }
        byte[] qualityScore = samRecord.getBaseQualities();
        for (CigarElement cigarElement : cigarElements) {
            int cigarElementLength = cigarElement.getLength();
            CigarOperator operator = cigarElement.getOperator();
            switch (operator) {
                case D: {
                    features.add(new Deletion(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case N: {
                    features.add(new RefSkip(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case P: {
                    features.add(new Padding(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case H: {
                    features.add(new HardClip(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case S: {
                    this.addSoftClip(features, zeroBasedPositionInRead, cigarElementLength, bases);
                    break;
                }
                case I: {
                    this.addInsertion(features, zeroBasedPositionInRead, cigarElementLength, bases);
                    break;
                }
                case M: 
                case X: 
                case EQ: {
                    this.addMismatchReadFeatures(cramRecord.alignmentStart, features, zeroBasedPositionInRead, alignmentStartOffset, cigarElementLength, bases, qualityScore);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported cigar operator: " + (Object)((Object)cigarElement.getOperator()));
                }
            }
            if (cigarElement.getOperator().consumesReadBases()) {
                zeroBasedPositionInRead += cigarElementLength;
            }
            if (!cigarElement.getOperator().consumesReferenceBases()) continue;
            alignmentStartOffset += cigarElementLength;
        }
        this.baseCount += (long)bases.length;
        this.featureCount += (long)features.size();
        return features;
    }

    private void addSoftClip(List<ReadFeature> features, int zeroBasedPositionInRead, int cigarElementLength, byte[] bases) {
        byte[] insertedBases = Arrays.copyOfRange(bases, zeroBasedPositionInRead, zeroBasedPositionInRead + cigarElementLength);
        SoftClip softClip = new SoftClip(zeroBasedPositionInRead + 1, insertedBases);
        features.add(softClip);
    }

    private void addHardClip(List<ReadFeature> features, int zeroBasedPositionInRead, int cigarElementLength, byte[] bases) {
        byte[] insertedBases = Arrays.copyOfRange(bases, zeroBasedPositionInRead, zeroBasedPositionInRead + cigarElementLength);
        HardClip hardClip = new HardClip(zeroBasedPositionInRead + 1, insertedBases.length);
        features.add(hardClip);
    }

    private void addInsertion(List<ReadFeature> features, int zeroBasedPositionInRead, int cigarElementLength, byte[] bases) {
        byte[] insertedBases = Arrays.copyOfRange(bases, zeroBasedPositionInRead, zeroBasedPositionInRead + cigarElementLength);
        for (int i2 = 0; i2 < insertedBases.length; ++i2) {
            InsertBase insertBase = new InsertBase();
            insertBase.setPosition(zeroBasedPositionInRead + 1 + i2);
            insertBase.setBase(insertedBases[i2]);
            features.add(insertBase);
        }
    }

    void addMismatchReadFeatures(int alignmentStart, List<ReadFeature> features, int fromPosInRead, int alignmentStartOffset, int nofReadBases, byte[] bases, byte[] qualityScore) {
        int oneBasedPositionInRead = fromPosInRead + 1;
        int refIndex = alignmentStart + alignmentStartOffset - 1;
        int i2 = 0;
        while (i2 < nofReadBases) {
            byte readBase = bases[i2 + fromPosInRead];
            byte refBase = refIndex >= this.refBases.length ? (byte)78 : this.refBases[refIndex];
            if (readBase != refBase) {
                boolean isSubstitution;
                boolean bl = isSubstitution = SequenceUtil.isUpperACGTN(readBase) && SequenceUtil.isUpperACGTN(refBase);
                if (isSubstitution) {
                    features.add(new Substitution(oneBasedPositionInRead, readBase, refBase));
                } else {
                    byte score = qualityScore[i2 + fromPosInRead];
                    features.add(new ReadBase(oneBasedPositionInRead, readBase, score));
                }
            }
            ++i2;
            ++oneBasedPositionInRead;
            ++refIndex;
        }
    }

    public byte[] getRefBases() {
        return this.refBases;
    }

    public void setRefBases(byte[] refBases) {
        this.refBases = refBases;
    }

    public Map<String, Integer> getReadGroupMap() {
        return this.readGroupMap;
    }

    public long getBaseCount() {
        return this.baseCount;
    }

    public long getFeatureCount() {
        return this.featureCount;
    }
}

