/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMValidationError;
import java.util.List;

public class SAMTestUtil {
    public void assertPairValid(SAMRecord firstEnd, SAMRecord secondEnd) throws SanityCheckFailedException {
        SAMTestUtil.assertEquals(firstEnd.getReadName(), secondEnd.getReadName());
        SAMTestUtil.assertTrue(firstEnd.getFirstOfPairFlag());
        SAMTestUtil.assertTrue(secondEnd.getSecondOfPairFlag());
        SAMTestUtil.assertFalse(secondEnd.getFirstOfPairFlag());
        SAMTestUtil.assertFalse(firstEnd.getSecondOfPairFlag());
        if (!firstEnd.getReadUnmappedFlag() && !secondEnd.getReadUnmappedFlag()) {
            SAMTestUtil.assertNotSame(firstEnd.getReadNegativeStrandFlag(), secondEnd.getReadNegativeStrandFlag());
        }
    }

    public static void assertReadValid(SAMRecord read) throws SanityCheckFailedException {
        if (read == null) {
            throw new IllegalArgumentException("SAMRecord is null");
        }
        List<SAMValidationError> errors = read.isValid(false);
        if (errors != null) {
            errors.forEach(v2 -> System.out.println(v2.toString()));
        }
        SAMTestUtil.assertTrue(errors.isEmpty());
    }

    private static <T> void assertEquals(T a2, T b2) {
        if (a2 == null ? b2 != null : !a2.equals(b2)) {
            throw new SanityCheckFailedException("\"" + a2 + "\" does not equal \"" + b2 + "\"");
        }
    }

    private static <T> void assertNotSame(T a2, T b2) {
        if (a2 != b2) {
            throw new SanityCheckFailedException("\"" + a2 + "\" and \"" + b2 + "\" are not the same object");
        }
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new SanityCheckFailedException("The condition is false");
        }
    }

    private static void assertFalse(boolean condition) {
        if (condition) {
            throw new SanityCheckFailedException("The condition is true");
        }
    }

    public static class SanityCheckFailedException
    extends RuntimeException {
        public SanityCheckFailedException(String message) {
            super(message);
        }
    }
}

