/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public class SAMRecordSetBuilder
implements Iterable<SAMRecord> {
    private static final String[] chroms = new String[]{"chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8", "chr9", "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21", "chr22", "chrX", "chrY", "chrM"};
    private static final byte[] BASES = new byte[]{65, 67, 71, 84};
    private static final String READ_GROUP_ID = "1";
    private static final String SAMPLE = "FREE_SAMPLE";
    private final Random random = new Random();
    private SAMFileHeader header;
    private final Collection<SAMRecord> records;
    private int readLength = 36;
    private SAMProgramRecord programRecord = null;
    private SAMReadGroupRecord readGroup = null;
    private boolean useNmFlag = false;
    private boolean unmappedHasBasesAndQualities = true;
    public static final int DEFAULT_CHROMOSOME_LENGTH = 200000000;
    public static final DuplicateScoringStrategy.ScoringStrategy DEFAULT_DUPLICATE_SCORING_STRATEGY = DuplicateScoringStrategy.ScoringStrategy.TOTAL_MAPPED_REFERENCE_LENGTH;

    public SAMRecordSetBuilder() {
        this(true, SAMFileHeader.SortOrder.coordinate);
    }

    public SAMRecordSetBuilder(boolean sortForMe, SAMFileHeader.SortOrder sortOrder) {
        this(sortForMe, sortOrder, true);
    }

    public SAMRecordSetBuilder(boolean sortForMe, SAMFileHeader.SortOrder sortOrder, boolean addReadGroup) {
        this(sortForMe, sortOrder, addReadGroup, 200000000);
    }

    public SAMRecordSetBuilder(boolean sortForMe, SAMFileHeader.SortOrder sortOrder, boolean addReadGroup, int defaultChromosomeLength) {
        this(sortForMe, sortOrder, addReadGroup, defaultChromosomeLength, DEFAULT_DUPLICATE_SCORING_STRATEGY);
    }

    public SAMRecordSetBuilder(boolean sortForMe, SAMFileHeader.SortOrder sortOrder, boolean addReadGroup, int defaultChromosomeLength, DuplicateScoringStrategy.ScoringStrategy duplicateScoringStrategy) {
        ArrayList<SAMSequenceRecord> sequences = new ArrayList<SAMSequenceRecord>();
        for (String chrom : chroms) {
            SAMSequenceRecord sequenceRecord = new SAMSequenceRecord(chrom, defaultChromosomeLength);
            sequences.add(sequenceRecord);
        }
        this.header = new SAMFileHeader();
        this.header.setSequenceDictionary(new SAMSequenceDictionary(sequences));
        this.header.setSortOrder(sortOrder);
        if (sortForMe) {
            SAMRecordComparator comparator = sortOrder == SAMFileHeader.SortOrder.queryname ? new SAMRecordQueryNameComparator() : new SAMRecordCoordinateComparator();
            this.records = new TreeSet<SAMRecord>(comparator);
        } else {
            this.records = new ArrayList<SAMRecord>();
        }
        if (addReadGroup) {
            SAMReadGroupRecord readGroupRecord = new SAMReadGroupRecord(READ_GROUP_ID);
            readGroupRecord.setSample(SAMPLE);
            readGroupRecord.setPlatform("ILLUMINA");
            ArrayList<SAMReadGroupRecord> readGroups = new ArrayList<SAMReadGroupRecord>();
            readGroups.add(readGroupRecord);
            this.header.setReadGroups(readGroups);
        }
    }

    public void setUnmappedHasBasesAndQualities(boolean value) {
        this.unmappedHasBasesAndQualities = value;
    }

    public int size() {
        return this.records.size();
    }

    public void setRandomSeed(long seed) {
        this.random.setSeed(seed);
    }

    public void setProgramRecord(SAMProgramRecord programRecord) {
        this.programRecord = programRecord;
        if (programRecord != null) {
            this.header.addProgramRecord(programRecord);
        }
    }

    public void setUseNmFlag(boolean useNmFlag) {
        this.useNmFlag = useNmFlag;
    }

    public void setReadGroup(SAMReadGroupRecord readGroup) {
        this.readGroup = readGroup;
        if (readGroup != null) {
            this.header.addReadGroup(readGroup);
        }
    }

    public Collection<SAMRecord> getRecords() {
        return this.records;
    }

    public void setHeader(SAMFileHeader header) {
        this.header = header.clone();
    }

    public void addRecord(SAMRecord record) {
        if (record.getReadPairedFlag() && !record.getMateUnmappedFlag() && null == record.getAttribute(SAMTagUtil.getSingleton().MC)) {
            throw new SAMException("Mate Cigar tag (MC) not found in: " + record.getReadName());
        }
        this.records.add(record);
    }

    @Override
    public CloseableIterator<SAMRecord> iterator() {
        return new CloseableIterator<SAMRecord>(){
            private final Iterator<SAMRecord> iterator;
            {
                this.iterator = SAMRecordSetBuilder.this.records.iterator();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public SAMRecord next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    private SAMRecord createReadNoFlag(String name, int contig, int start, boolean negativeStrand, boolean recordUnmapped, String cigar, String qualityString, int defaultQuality) throws SAMException {
        SAMRecord rec = new SAMRecord(this.header);
        rec.setReadName(name);
        if (this.header.getSequenceDictionary().size() <= contig) {
            throw new SAMException("Contig too big [" + this.header.getSequenceDictionary().size() + " < " + contig);
        }
        if (0 <= contig) {
            rec.setReferenceIndex(contig);
            rec.setAlignmentStart(start);
        }
        if (!recordUnmapped) {
            rec.setReadNegativeStrandFlag(negativeStrand);
            if (null != cigar) {
                rec.setCigarString(cigar);
            } else if (!rec.getReadUnmappedFlag()) {
                rec.setCigarString(this.readLength + "M");
            }
            rec.setMappingQuality(255);
        } else {
            rec.setReadUnmappedFlag(true);
        }
        rec.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.useNmFlag) {
            rec.setAttribute(SAMTag.NM.name(), (Object)SequenceUtil.calculateSamNmTagFromCigar(rec));
        }
        if (this.programRecord != null) {
            rec.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.readGroup != null) {
            rec.setAttribute(SAMTag.RG.name(), (Object)this.readGroup.getReadGroupId());
        }
        if (!recordUnmapped || this.unmappedHasBasesAndQualities) {
            this.fillInBasesAndQualities(rec, qualityString, defaultQuality);
        }
        return rec;
    }

    public SAMRecord addFrag(String name, int contig, int start, boolean negativeStrand) {
        return this.addFrag(name, contig, start, negativeStrand, false, null, null, -1);
    }

    public SAMRecord addFrag(String name, int contig, int start, boolean negativeStrand, boolean recordUnmapped, String cigar, String qualityString, int defaultQuality) throws SAMException {
        return this.addFrag(name, contig, start, negativeStrand, recordUnmapped, cigar, qualityString, defaultQuality, false);
    }

    public SAMRecord addFrag(String name, int contig, int start, boolean negativeStrand, boolean recordUnmapped, String cigar, String qualityString, int defaultQuality, boolean isSecondary) throws SAMException {
        SAMRecord rec = this.createReadNoFlag(name, contig, start, negativeStrand, recordUnmapped, cigar, qualityString, defaultQuality);
        if (isSecondary) {
            rec.setSecondaryAlignment(true);
        }
        this.records.add(rec);
        return rec;
    }

    public SAMRecord addFrag(String name, int contig, int start, boolean negativeStrand, boolean recordUnmapped, String cigar, String qualityString, int defaultQuality, boolean isSecondary, boolean isSupplementary) throws SAMException {
        SAMRecord rec = this.createReadNoFlag(name, contig, start, negativeStrand, recordUnmapped, cigar, qualityString, defaultQuality);
        if (isSecondary) {
            rec.setSecondaryAlignment(true);
        }
        if (isSupplementary) {
            rec.setSupplementaryAlignmentFlag(true);
        }
        this.records.add(rec);
        return rec;
    }

    private void fillInBasesAndQualities(SAMRecord rec, String qualityString, int defaultQuality) {
        if (null == qualityString) {
            this.fillInBasesAndQualities(rec, defaultQuality);
        } else {
            this.fillInBases(rec);
            rec.setBaseQualityString(qualityString);
        }
    }

    private void fillInBases(SAMRecord rec) {
        int length = this.readLength;
        byte[] bases = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            bases[i2] = BASES[this.random.nextInt(BASES.length)];
        }
        rec.setReadBases(bases);
    }

    public void addUnmappedFragment(String name) {
        this.addFrag(name, -1, -1, false, true, null, null, -1, false);
    }

    public void addPair(String name, int contig, int start1, int start2) {
        SAMRecord end1 = new SAMRecord(this.header);
        SAMRecord end2 = new SAMRecord(this.header);
        boolean end1IsFirstOfPair = this.random.nextBoolean();
        end1.setReadName(name);
        end1.setReferenceIndex(contig);
        end1.setAlignmentStart(start1);
        end1.setReadNegativeStrandFlag(false);
        end1.setCigarString(this.readLength + "M");
        if (this.useNmFlag) {
            end1.setAttribute(ReservedTagConstants.NM, (Object)0);
        }
        end1.setMappingQuality(255);
        end1.setReadPairedFlag(true);
        end1.setProperPairFlag(true);
        end1.setFirstOfPairFlag(end1IsFirstOfPair);
        end1.setSecondOfPairFlag(!end1IsFirstOfPair);
        end1.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            end1.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.readGroup != null) {
            end1.setAttribute(SAMTag.RG.name(), (Object)this.readGroup.getReadGroupId());
        }
        this.fillInBasesAndQualities(end1);
        end2.setReadName(name);
        end2.setReferenceIndex(contig);
        end2.setAlignmentStart(start2);
        end2.setReadNegativeStrandFlag(true);
        end2.setCigarString(this.readLength + "M");
        if (this.useNmFlag) {
            end2.setAttribute(ReservedTagConstants.NM, (Object)0);
        }
        end2.setMappingQuality(255);
        end2.setReadPairedFlag(true);
        end2.setProperPairFlag(true);
        end2.setFirstOfPairFlag(!end1IsFirstOfPair);
        end2.setSecondOfPairFlag(end1IsFirstOfPair);
        end2.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            end2.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.readGroup != null) {
            end2.setAttribute(SAMTag.RG.name(), (Object)this.readGroup.getReadGroupId());
        }
        this.fillInBasesAndQualities(end2);
        SamPairUtil.setMateInfo(end1, end2, true);
        this.records.add(end1);
        this.records.add(end2);
    }

    public List<SAMRecord> addPair(String name, int contig, int start1, int start2, boolean record1Unmapped, boolean record2Unmapped, String cigar1, String cigar2, boolean strand1, boolean strand2, int defaultQuality) {
        return this.addPair(name, contig, contig, start1, start2, record1Unmapped, record2Unmapped, cigar1, cigar2, strand1, strand2, false, false, defaultQuality);
    }

    public List<SAMRecord> addPair(String name, int contig1, int contig2, int start1, int start2, boolean record1Unmapped, boolean record2Unmapped, String cigar1, String cigar2, boolean strand1, boolean strand2, boolean record1NonPrimary, boolean record2NonPrimary, int defaultQuality) {
        LinkedList<SAMRecord> recordsList = new LinkedList<SAMRecord>();
        SAMRecord end1 = this.createReadNoFlag(name, contig1, start1, strand1, record1Unmapped, cigar1, null, defaultQuality);
        SAMRecord end2 = this.createReadNoFlag(name, contig2, start2, strand2, record2Unmapped, cigar2, null, defaultQuality);
        end1.setReadPairedFlag(true);
        end1.setFirstOfPairFlag(true);
        if (!record1Unmapped && !record2Unmapped) {
            end1.setProperPairFlag(true);
            end2.setProperPairFlag(true);
        }
        end2.setReadPairedFlag(true);
        end2.setSecondOfPairFlag(true);
        if (record1NonPrimary) {
            end1.setSecondaryAlignment(true);
        }
        if (record2NonPrimary) {
            end2.setSecondaryAlignment(true);
        }
        if (record1NonPrimary) {
            end1.setSecondaryAlignment(true);
        }
        if (record2NonPrimary) {
            end2.setSecondaryAlignment(true);
        }
        SamPairUtil.setMateInfo(end1, end2, true);
        recordsList.add(end1);
        recordsList.add(end2);
        this.records.add(end1);
        this.records.add(end2);
        return recordsList;
    }

    public List<SAMRecord> addPair(String name, int contig, int start1, int start2, boolean record1Unmapped, boolean record2Unmapped, String cigar1, String cigar2, boolean strand1, boolean strand2, boolean record1NonPrimary, boolean record2NonPrimary, int defaultQuality) {
        return this.addPair(name, contig, contig, start1, start2, record1Unmapped, record2Unmapped, cigar1, cigar2, strand1, strand2, record1NonPrimary, record2NonPrimary, defaultQuality);
    }

    public void addUnmappedPair(String name) {
        SAMRecord end1 = new SAMRecord(this.header);
        SAMRecord end2 = new SAMRecord(this.header);
        boolean end1IsFirstOfPair = this.random.nextBoolean();
        end1.setReadName(name);
        end1.setReadPairedFlag(true);
        end1.setReadUnmappedFlag(true);
        end1.setAttribute(SAMTag.MC.name(), null);
        end1.setProperPairFlag(false);
        end1.setFirstOfPairFlag(end1IsFirstOfPair);
        end1.setSecondOfPairFlag(!end1IsFirstOfPair);
        end1.setMateUnmappedFlag(true);
        end1.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            end1.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.unmappedHasBasesAndQualities) {
            this.fillInBasesAndQualities(end1);
        }
        end2.setReadName(name);
        end2.setReadPairedFlag(true);
        end2.setReadUnmappedFlag(true);
        end2.setAttribute(SAMTag.MC.name(), null);
        end2.setProperPairFlag(false);
        end2.setFirstOfPairFlag(!end1IsFirstOfPair);
        end2.setSecondOfPairFlag(end1IsFirstOfPair);
        end2.setMateUnmappedFlag(true);
        end2.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            end2.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.unmappedHasBasesAndQualities) {
            this.fillInBasesAndQualities(end2);
        }
        this.records.add(end1);
        this.records.add(end2);
    }

    private void fillInBasesAndQualities(SAMRecord rec) {
        this.fillInBasesAndQualities(rec, -1);
    }

    private void fillInBasesAndQualities(SAMRecord rec, int defaultQuality) {
        int length = this.readLength;
        byte[] quals = new byte[length];
        if (-1 != defaultQuality) {
            Arrays.fill(quals, (byte)defaultQuality);
        } else {
            for (int i2 = 0; i2 < length; ++i2) {
                quals[i2] = (byte)this.random.nextInt(50);
            }
        }
        rec.setBaseQualities(quals);
        this.fillInBases(rec);
    }

    public SamReader getSamReader() {
        File tempFile;
        try {
            tempFile = File.createTempFile("temp", ".sam");
        }
        catch (IOException e2) {
            throw new RuntimeIOException("problems creating tempfile", e2);
        }
        this.header.setAttribute("VN", "1.0");
        SAMFileWriter w2 = new SAMFileWriterFactory().makeBAMWriter(this.header, true, tempFile);
        for (SAMRecord r2 : this.getRecords()) {
            w2.addAlignment(r2);
        }
        w2.close();
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(tempFile);
        tempFile.deleteOnExit();
        return reader;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }

    public void setReadLength(int readLength) {
        this.readLength = readLength;
    }
}

