/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.util.CoordMath;
import java.util.ArrayList;
import java.util.Arrays;

public class QueryInterval
implements Comparable<QueryInterval> {
    public final int referenceIndex;
    public final int start;
    public final int end;
    private static final QueryInterval[] EMPTY_QUERY_INTERVAL_ARRAY = new QueryInterval[0];

    public QueryInterval(int referenceIndex, int start, int end) {
        if (referenceIndex < 0) {
            throw new IllegalArgumentException("Invalid reference index " + referenceIndex);
        }
        this.referenceIndex = referenceIndex;
        this.start = start;
        this.end = end;
    }

    @Override
    public int compareTo(QueryInterval other) {
        int comp = this.referenceIndex - other.referenceIndex;
        if (comp != 0) {
            return comp;
        }
        comp = this.start - other.start;
        if (comp != 0) {
            return comp;
        }
        if (this.end == other.end) {
            return 0;
        }
        if (this.end == 0) {
            return 1;
        }
        if (other.end == 0) {
            return -1;
        }
        return this.end - other.end;
    }

    public boolean endsAtStartOf(QueryInterval other) {
        return this.referenceIndex == other.referenceIndex && this.end + 1 == other.start;
    }

    public boolean overlaps(QueryInterval other) {
        if (this.referenceIndex != other.referenceIndex) {
            return false;
        }
        int thisEnd = this.end == 0 ? Integer.MAX_VALUE : this.end;
        int otherEnd = other.end == 0 ? Integer.MAX_VALUE : other.end;
        return CoordMath.overlaps(this.start, thisEnd, other.start, otherEnd);
    }

    public String toString() {
        return String.format("%d:%d-%d", this.referenceIndex, this.start, this.end);
    }

    public static QueryInterval[] optimizeIntervals(QueryInterval[] inputIntervals) {
        if (inputIntervals.length == 0) {
            return EMPTY_QUERY_INTERVAL_ARRAY;
        }
        Arrays.sort(inputIntervals);
        ArrayList<QueryInterval> unique = new ArrayList<QueryInterval>();
        QueryInterval previous = inputIntervals[0];
        for (int i2 = 1; i2 < inputIntervals.length; ++i2) {
            QueryInterval next = inputIntervals[i2];
            if (previous.endsAtStartOf(next) || previous.overlaps(next)) {
                int newEnd = previous.end == 0 || next.end == 0 ? 0 : Math.max(previous.end, next.end);
                previous = new QueryInterval(previous.referenceIndex, previous.start, newEnd);
                continue;
            }
            unique.add(previous);
            previous = next;
        }
        if (previous != null) {
            unique.add(previous);
        }
        return unique.toArray(EMPTY_QUERY_INTERVAL_ARRAY);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        QueryInterval that = (QueryInterval)o2;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        int result = this.referenceIndex;
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        return result;
    }
}

