/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.EdgeSetFactory;
import org.jgrapht.graph.IntrusiveEdge;
import org.jgrapht.util.ArrayUnenforcedSet;
import org.jgrapht.util.TypeUtil;

public abstract class AbstractBaseGraph<V, E>
extends AbstractGraph<V, E>
implements Graph<V, E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1263088497616142427L;
    private static final String LOOPS_NOT_ALLOWED = "loops not allowed";
    boolean allowingLoops;
    private EdgeFactory<V, E> edgeFactory;
    private EdgeSetFactory<V, E> edgeSetFactory;
    private Map<E, IntrusiveEdge> edgeMap;
    private transient Set<E> unmodifiableEdgeSet = null;
    private transient Set<V> unmodifiableVertexSet = null;
    private Specifics specifics;
    private boolean allowingMultipleEdges;
    private transient TypeUtil<V> vertexTypeDecl = null;

    public AbstractBaseGraph(EdgeFactory<V, E> edgeFactory, boolean bl, boolean bl2) {
        if (edgeFactory == null) {
            throw new NullPointerException();
        }
        this.edgeMap = new LinkedHashMap<E, IntrusiveEdge>();
        this.edgeFactory = edgeFactory;
        this.allowingLoops = bl2;
        this.allowingMultipleEdges = bl;
        this.specifics = this.createSpecifics();
        this.edgeSetFactory = new ArrayListFactory<V, E>();
    }

    @Override
    public Set<E> getAllEdges(V v2, V v3) {
        return this.specifics.getAllEdges(v2, v3);
    }

    public boolean isAllowingLoops() {
        return this.allowingLoops;
    }

    public boolean isAllowingMultipleEdges() {
        return this.allowingMultipleEdges;
    }

    @Override
    public E getEdge(V v2, V v3) {
        return this.specifics.getEdge(v2, v3);
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        return this.edgeFactory;
    }

    public void setEdgeSetFactory(EdgeSetFactory<V, E> edgeSetFactory) {
        this.edgeSetFactory = edgeSetFactory;
    }

    @Override
    public E addEdge(V v2, V v3) {
        this.assertVertexExist(v2);
        this.assertVertexExist(v3);
        if (!this.allowingMultipleEdges && this.containsEdge(v2, v3)) {
            return null;
        }
        if (!this.allowingLoops && v2.equals(v3)) {
            throw new IllegalArgumentException(LOOPS_NOT_ALLOWED);
        }
        E e2 = this.edgeFactory.createEdge(v2, v3);
        if (this.containsEdge(e2)) {
            return null;
        }
        IntrusiveEdge intrusiveEdge = this.createIntrusiveEdge(e2, v2, v3);
        this.edgeMap.put(e2, intrusiveEdge);
        this.specifics.addEdgeToTouchingVertices(e2);
        return e2;
    }

    @Override
    public boolean addEdge(V v2, V v3, E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (this.containsEdge(e2)) {
            return false;
        }
        this.assertVertexExist(v2);
        this.assertVertexExist(v3);
        if (!this.allowingMultipleEdges && this.containsEdge(v2, v3)) {
            return false;
        }
        if (!this.allowingLoops && v2.equals(v3)) {
            throw new IllegalArgumentException(LOOPS_NOT_ALLOWED);
        }
        IntrusiveEdge intrusiveEdge = this.createIntrusiveEdge(e2, v2, v3);
        this.edgeMap.put(e2, intrusiveEdge);
        this.specifics.addEdgeToTouchingVertices(e2);
        return true;
    }

    private IntrusiveEdge createIntrusiveEdge(E e2, V v2, V v3) {
        IntrusiveEdge intrusiveEdge = e2 instanceof IntrusiveEdge ? (IntrusiveEdge)e2 : new IntrusiveEdge();
        intrusiveEdge.source = v2;
        intrusiveEdge.target = v3;
        return intrusiveEdge;
    }

    @Override
    public boolean addVertex(V v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
        if (this.containsVertex(v2)) {
            return false;
        }
        this.specifics.addVertex(v2);
        return true;
    }

    @Override
    public V getEdgeSource(E e2) {
        return TypeUtil.uncheckedCast(this.getIntrusiveEdge(e2).source, this.vertexTypeDecl);
    }

    @Override
    public V getEdgeTarget(E e2) {
        return TypeUtil.uncheckedCast(this.getIntrusiveEdge(e2).target, this.vertexTypeDecl);
    }

    private IntrusiveEdge getIntrusiveEdge(E e2) {
        if (e2 instanceof IntrusiveEdge) {
            return (IntrusiveEdge)e2;
        }
        return this.edgeMap.get(e2);
    }

    public Object clone() {
        try {
            TypeUtil typeUtil = null;
            AbstractBaseGraph abstractBaseGraph = (AbstractBaseGraph)TypeUtil.uncheckedCast(super.clone(), typeUtil);
            abstractBaseGraph.edgeMap = new LinkedHashMap<E, IntrusiveEdge>();
            abstractBaseGraph.edgeFactory = this.edgeFactory;
            abstractBaseGraph.unmodifiableEdgeSet = null;
            abstractBaseGraph.unmodifiableVertexSet = null;
            abstractBaseGraph.specifics = abstractBaseGraph.createSpecifics();
            Graphs.addGraph(abstractBaseGraph, this);
            return abstractBaseGraph;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public boolean containsEdge(E e2) {
        return this.edgeMap.containsKey(e2);
    }

    @Override
    public boolean containsVertex(V v2) {
        return this.specifics.getVertexSet().contains(v2);
    }

    public int degreeOf(V v2) {
        return this.specifics.degreeOf(v2);
    }

    @Override
    public Set<E> edgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.edgeMap.keySet());
        }
        return this.unmodifiableEdgeSet;
    }

    @Override
    public Set<E> edgesOf(V v2) {
        return this.specifics.edgesOf(v2);
    }

    public int inDegreeOf(V v2) {
        return this.specifics.inDegreeOf(v2);
    }

    public Set<E> incomingEdgesOf(V v2) {
        return this.specifics.incomingEdgesOf(v2);
    }

    public int outDegreeOf(V v2) {
        return this.specifics.outDegreeOf(v2);
    }

    public Set<E> outgoingEdgesOf(V v2) {
        return this.specifics.outgoingEdgesOf(v2);
    }

    @Override
    public E removeEdge(V v2, V v3) {
        E e2 = this.getEdge(v2, v3);
        if (e2 != null) {
            this.specifics.removeEdgeFromTouchingVertices(e2);
            this.edgeMap.remove(e2);
        }
        return e2;
    }

    @Override
    public boolean removeEdge(E e2) {
        if (this.containsEdge(e2)) {
            this.specifics.removeEdgeFromTouchingVertices(e2);
            this.edgeMap.remove(e2);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeVertex(V v2) {
        if (this.containsVertex(v2)) {
            Set<E> set = this.edgesOf(v2);
            this.removeAllEdges(new ArrayList<E>(set));
            this.specifics.getVertexSet().remove(v2);
            return true;
        }
        return false;
    }

    @Override
    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.specifics.getVertexSet());
        }
        return this.unmodifiableVertexSet;
    }

    @Override
    public double getEdgeWeight(E e2) {
        if (e2 instanceof DefaultWeightedEdge) {
            return ((DefaultWeightedEdge)e2).getWeight();
        }
        return 1.0;
    }

    public void setEdgeWeight(E e2, double d2) {
        assert (e2 instanceof DefaultWeightedEdge) : e2.getClass();
        ((DefaultWeightedEdge)e2).weight = d2;
    }

    private Specifics createSpecifics() {
        if (this instanceof DirectedGraph) {
            return new DirectedSpecifics();
        }
        if (this instanceof UndirectedGraph) {
            return new UndirectedSpecifics();
        }
        throw new IllegalArgumentException("must be instance of either DirectedGraph or UndirectedGraph");
    }

    private class UndirectedSpecifics
    extends Specifics
    implements Serializable {
        private static final long serialVersionUID = 6494588405178655873L;
        private static final String NOT_IN_UNDIRECTED_GRAPH = "no such operation in an undirected graph";
        private Map<V, UndirectedEdgeContainer<V, E>> vertexMapUndirected;

        private UndirectedSpecifics() {
            this.vertexMapUndirected = new LinkedHashMap();
        }

        @Override
        public void addVertex(V v2) {
            this.vertexMapUndirected.put(v2, null);
        }

        @Override
        public Set<V> getVertexSet() {
            return this.vertexMapUndirected.keySet();
        }

        @Override
        public Set<E> getAllEdges(V v2, V v3) {
            ArrayUnenforcedSet arrayUnenforcedSet = null;
            if (AbstractBaseGraph.this.containsVertex(v2) && AbstractBaseGraph.this.containsVertex(v3)) {
                arrayUnenforcedSet = new ArrayUnenforcedSet();
                for (Object EE : this.getEdgeContainer(v2).vertexEdges) {
                    boolean bl;
                    boolean bl2 = v2.equals(AbstractBaseGraph.this.getEdgeSource(EE)) && v3.equals(AbstractBaseGraph.this.getEdgeTarget(EE));
                    boolean bl3 = bl = v2.equals(AbstractBaseGraph.this.getEdgeTarget(EE)) && v3.equals(AbstractBaseGraph.this.getEdgeSource(EE));
                    if (!bl2 && !bl) continue;
                    arrayUnenforcedSet.add(EE);
                }
            }
            return arrayUnenforcedSet;
        }

        @Override
        public E getEdge(V v2, V v3) {
            if (AbstractBaseGraph.this.containsVertex(v2) && AbstractBaseGraph.this.containsVertex(v3)) {
                for (Object EE : this.getEdgeContainer(v2).vertexEdges) {
                    boolean bl;
                    boolean bl2 = v2.equals(AbstractBaseGraph.this.getEdgeSource(EE)) && v3.equals(AbstractBaseGraph.this.getEdgeTarget(EE));
                    boolean bl3 = bl = v2.equals(AbstractBaseGraph.this.getEdgeTarget(EE)) && v3.equals(AbstractBaseGraph.this.getEdgeSource(EE));
                    if (!bl2 && !bl) continue;
                    return EE;
                }
            }
            return null;
        }

        @Override
        public void addEdgeToTouchingVertices(E e2) {
            Object v2 = AbstractBaseGraph.this.getEdgeSource(e2);
            Object v3 = AbstractBaseGraph.this.getEdgeTarget(e2);
            this.getEdgeContainer(v2).addEdge(e2);
            if (!v2.equals(v3)) {
                this.getEdgeContainer(v3).addEdge(e2);
            }
        }

        @Override
        public int degreeOf(V v2) {
            if (AbstractBaseGraph.this.allowingLoops) {
                int n2 = 0;
                Set set = this.getEdgeContainer(v2).vertexEdges;
                for (Object EE : set) {
                    if (AbstractBaseGraph.this.getEdgeSource(EE).equals(AbstractBaseGraph.this.getEdgeTarget(EE))) {
                        n2 += 2;
                        continue;
                    }
                    ++n2;
                }
                return n2;
            }
            return this.getEdgeContainer(v2).edgeCount();
        }

        @Override
        public Set<E> edgesOf(V v2) {
            return this.getEdgeContainer(v2).getUnmodifiableVertexEdges();
        }

        @Override
        public int inDegreeOf(V v2) {
            throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
        }

        @Override
        public Set<E> incomingEdgesOf(V v2) {
            throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
        }

        @Override
        public int outDegreeOf(V v2) {
            throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
        }

        @Override
        public Set<E> outgoingEdgesOf(V v2) {
            throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
        }

        @Override
        public void removeEdgeFromTouchingVertices(E e2) {
            Object v2 = AbstractBaseGraph.this.getEdgeSource(e2);
            Object v3 = AbstractBaseGraph.this.getEdgeTarget(e2);
            this.getEdgeContainer(v2).removeEdge(e2);
            if (!v2.equals(v3)) {
                this.getEdgeContainer(v3).removeEdge(e2);
            }
        }

        private UndirectedEdgeContainer<V, E> getEdgeContainer(V v2) {
            AbstractBaseGraph.this.assertVertexExist(v2);
            UndirectedEdgeContainer undirectedEdgeContainer = this.vertexMapUndirected.get(v2);
            if (undirectedEdgeContainer == null) {
                undirectedEdgeContainer = new UndirectedEdgeContainer(AbstractBaseGraph.this.edgeSetFactory, v2);
                this.vertexMapUndirected.put((UndirectedEdgeContainer)v2, (UndirectedEdgeContainer)undirectedEdgeContainer);
            }
            return undirectedEdgeContainer;
        }
    }

    private static class UndirectedEdgeContainer<VV, EE>
    implements Serializable {
        private static final long serialVersionUID = -6623207588411170010L;
        Set<EE> vertexEdges;
        private transient Set<EE> unmodifiableVertexEdges = null;

        UndirectedEdgeContainer(EdgeSetFactory<VV, EE> edgeSetFactory, VV VV) {
            this.vertexEdges = edgeSetFactory.createEdgeSet(VV);
        }

        public Set<EE> getUnmodifiableVertexEdges() {
            if (this.unmodifiableVertexEdges == null) {
                this.unmodifiableVertexEdges = Collections.unmodifiableSet(this.vertexEdges);
            }
            return this.unmodifiableVertexEdges;
        }

        public void addEdge(EE EE) {
            this.vertexEdges.add(EE);
        }

        public int edgeCount() {
            return this.vertexEdges.size();
        }

        public void removeEdge(EE EE) {
            this.vertexEdges.remove(EE);
        }
    }

    private class DirectedSpecifics
    extends Specifics
    implements Serializable {
        private static final long serialVersionUID = 8971725103718958232L;
        private static final String NOT_IN_DIRECTED_GRAPH = "no such operation in a directed graph";
        private Map<V, DirectedEdgeContainer<V, E>> vertexMapDirected;

        private DirectedSpecifics() {
            this.vertexMapDirected = new LinkedHashMap();
        }

        @Override
        public void addVertex(V v2) {
            this.vertexMapDirected.put(v2, null);
        }

        @Override
        public Set<V> getVertexSet() {
            return this.vertexMapDirected.keySet();
        }

        @Override
        public Set<E> getAllEdges(V v2, V v3) {
            ArrayUnenforcedSet arrayUnenforcedSet = null;
            if (AbstractBaseGraph.this.containsVertex(v2) && AbstractBaseGraph.this.containsVertex(v3)) {
                arrayUnenforcedSet = new ArrayUnenforcedSet();
                DirectedEdgeContainer directedEdgeContainer = this.getEdgeContainer(v2);
                for (Object EE : directedEdgeContainer.outgoing) {
                    if (!AbstractBaseGraph.this.getEdgeTarget(EE).equals(v3)) continue;
                    arrayUnenforcedSet.add(EE);
                }
            }
            return arrayUnenforcedSet;
        }

        @Override
        public E getEdge(V v2, V v3) {
            if (AbstractBaseGraph.this.containsVertex(v2) && AbstractBaseGraph.this.containsVertex(v3)) {
                DirectedEdgeContainer directedEdgeContainer = this.getEdgeContainer(v2);
                for (Object EE : directedEdgeContainer.outgoing) {
                    if (!AbstractBaseGraph.this.getEdgeTarget(EE).equals(v3)) continue;
                    return EE;
                }
            }
            return null;
        }

        @Override
        public void addEdgeToTouchingVertices(E e2) {
            Object v2 = AbstractBaseGraph.this.getEdgeSource(e2);
            Object v3 = AbstractBaseGraph.this.getEdgeTarget(e2);
            this.getEdgeContainer(v2).addOutgoingEdge(e2);
            this.getEdgeContainer(v3).addIncomingEdge(e2);
        }

        @Override
        public int degreeOf(V v2) {
            throw new UnsupportedOperationException(NOT_IN_DIRECTED_GRAPH);
        }

        @Override
        public Set<E> edgesOf(V v2) {
            ArrayUnenforcedSet arrayUnenforcedSet = new ArrayUnenforcedSet(this.getEdgeContainer(v2).incoming);
            arrayUnenforcedSet.addAll(this.getEdgeContainer(v2).outgoing);
            if (AbstractBaseGraph.this.allowingLoops) {
                Set set = this.getAllEdges(v2, v2);
                int n2 = 0;
                while (n2 < arrayUnenforcedSet.size()) {
                    Object e2 = arrayUnenforcedSet.get(n2);
                    if (set.contains(e2)) {
                        arrayUnenforcedSet.remove(n2);
                        set.remove(e2);
                        continue;
                    }
                    ++n2;
                }
            }
            return Collections.unmodifiableSet(arrayUnenforcedSet);
        }

        @Override
        public int inDegreeOf(V v2) {
            return this.getEdgeContainer(v2).incoming.size();
        }

        @Override
        public Set<E> incomingEdgesOf(V v2) {
            return this.getEdgeContainer(v2).getUnmodifiableIncomingEdges();
        }

        @Override
        public int outDegreeOf(V v2) {
            return this.getEdgeContainer(v2).outgoing.size();
        }

        @Override
        public Set<E> outgoingEdgesOf(V v2) {
            return this.getEdgeContainer(v2).getUnmodifiableOutgoingEdges();
        }

        @Override
        public void removeEdgeFromTouchingVertices(E e2) {
            Object v2 = AbstractBaseGraph.this.getEdgeSource(e2);
            Object v3 = AbstractBaseGraph.this.getEdgeTarget(e2);
            this.getEdgeContainer(v2).removeOutgoingEdge(e2);
            this.getEdgeContainer(v3).removeIncomingEdge(e2);
        }

        private DirectedEdgeContainer<V, E> getEdgeContainer(V v2) {
            AbstractBaseGraph.this.assertVertexExist(v2);
            DirectedEdgeContainer directedEdgeContainer = this.vertexMapDirected.get(v2);
            if (directedEdgeContainer == null) {
                directedEdgeContainer = new DirectedEdgeContainer(AbstractBaseGraph.this.edgeSetFactory, v2);
                this.vertexMapDirected.put((DirectedEdgeContainer)v2, (DirectedEdgeContainer)directedEdgeContainer);
            }
            return directedEdgeContainer;
        }
    }

    private static class DirectedEdgeContainer<VV, EE>
    implements Serializable {
        private static final long serialVersionUID = 7494242245729767106L;
        Set<EE> incoming;
        Set<EE> outgoing;
        private transient Set<EE> unmodifiableIncoming = null;
        private transient Set<EE> unmodifiableOutgoing = null;

        DirectedEdgeContainer(EdgeSetFactory<VV, EE> edgeSetFactory, VV VV) {
            this.incoming = edgeSetFactory.createEdgeSet(VV);
            this.outgoing = edgeSetFactory.createEdgeSet(VV);
        }

        public Set<EE> getUnmodifiableIncomingEdges() {
            if (this.unmodifiableIncoming == null) {
                this.unmodifiableIncoming = Collections.unmodifiableSet(this.incoming);
            }
            return this.unmodifiableIncoming;
        }

        public Set<EE> getUnmodifiableOutgoingEdges() {
            if (this.unmodifiableOutgoing == null) {
                this.unmodifiableOutgoing = Collections.unmodifiableSet(this.outgoing);
            }
            return this.unmodifiableOutgoing;
        }

        public void addIncomingEdge(EE EE) {
            this.incoming.add(EE);
        }

        public void addOutgoingEdge(EE EE) {
            this.outgoing.add(EE);
        }

        public void removeIncomingEdge(EE EE) {
            this.incoming.remove(EE);
        }

        public void removeOutgoingEdge(EE EE) {
            this.outgoing.remove(EE);
        }
    }

    private static class ArrayListFactory<VV, EE>
    implements EdgeSetFactory<VV, EE>,
    Serializable {
        private static final long serialVersionUID = 5936902837403445985L;

        private ArrayListFactory() {
        }

        @Override
        public Set<EE> createEdgeSet(VV VV) {
            return new ArrayUnenforcedSet(1);
        }
    }

    private abstract class Specifics
    implements Serializable {
        private static final long serialVersionUID = 785196247314761183L;

        private Specifics() {
        }

        public abstract void addVertex(V var1);

        public abstract Set<V> getVertexSet();

        public abstract Set<E> getAllEdges(V var1, V var2);

        public abstract E getEdge(V var1, V var2);

        public abstract void addEdgeToTouchingVertices(E var1);

        public abstract int degreeOf(V var1);

        public abstract Set<E> edgesOf(V var1);

        public abstract int inDegreeOf(V var1);

        public abstract Set<E> incomingEdgesOf(V var1);

        public abstract int outDegreeOf(V var1);

        public abstract Set<E> outgoingEdgesOf(V var1);

        public abstract void removeEdgeFromTouchingVertices(E var1);
    }
}

