/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.isomorphism;

import java.util.HashMap;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.GraphMapping;
import org.jgrapht.graph.DefaultGraphMapping;

public class IsomorphismRelation<V, E>
implements GraphMapping<V, E> {
    private List<V> vertexList1;
    private List<V> vertexList2;
    private GraphMapping<V, E> graphMapping = null;
    private Graph<V, E> graph1;
    private Graph<V, E> graph2;

    public IsomorphismRelation(List<V> list, List<V> list2, Graph<V, E> graph, Graph<V, E> graph2) {
        this.vertexList1 = list;
        this.vertexList2 = list2;
        this.graph1 = graph;
        this.graph2 = graph2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("vertexList1: ").append(this.vertexList1.toString());
        stringBuffer.append("\tvertexList2: ").append(this.vertexList2.toString());
        return stringBuffer.toString();
    }

    @Override
    public V getVertexCorrespondence(V v2, boolean bl) {
        if (this.graphMapping == null) {
            this.initGraphMapping();
        }
        return this.graphMapping.getVertexCorrespondence(v2, bl);
    }

    @Override
    public E getEdgeCorrespondence(E e2, boolean bl) {
        if (this.graphMapping == null) {
            this.initGraphMapping();
        }
        return this.graphMapping.getEdgeCorrespondence(e2, bl);
    }

    private void initGraphMapping() {
        int n2 = this.vertexList1.size();
        HashMap<V, V> hashMap = new HashMap<V, V>(n2);
        HashMap<V, V> hashMap2 = new HashMap<V, V>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            V v2 = this.vertexList1.get(i2);
            V v3 = this.vertexList2.get(i2);
            hashMap.put(v2, v3);
            hashMap2.put(v3, v2);
        }
        this.graphMapping = new DefaultGraphMapping(hashMap, hashMap2, this.graph1, this.graph2);
    }
}

