/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.codecs;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CGVarCodec
extends AsciiFeatureCodec<VariantContext> {
    private static final String REF_TYPE = "ref";
    private static final String SNP_TYPE = "snp";
    private static final String DELETION_TYPE = "del";
    private static final String INSERTION_TYPE = "ins";
    private static final String SUBSTITUTION_TYPE = "sub";
    private static final int minimumFeatureCount = 8;
    private static final Pattern DBSNP_PATTERN = Pattern.compile("^dbsnp\\.\\d+:(.*)");

    public CGVarCodec() {
        super(VariantContext.class);
    }

    @Override
    public VariantContext decode(String line) {
        long end;
        Allele ref;
        String[] array = line.split("\\s+");
        if (array.length < 8) {
            return null;
        }
        String type = array[6];
        long start = Long.valueOf(array[4]);
        Allele alt = null;
        if (type.equals(SNP_TYPE)) {
            ref = Allele.create(array[7], true);
            alt = Allele.create(array[8], false);
            end = start;
        } else if (type.equals(INSERTION_TYPE)) {
            ref = Allele.create("N", true);
            alt = Allele.create("N" + array[7], false);
            end = start;
        } else if (type.equals(DELETION_TYPE)) {
            ref = Allele.create("N" + array[7], true);
            alt = Allele.create("N", false);
            end = start + (long)ref.length();
        } else {
            return null;
        }
        HashSet<Allele> alleles = new HashSet<Allele>();
        alleles.add(ref);
        if (alt != null) {
            alleles.add(alt);
        }
        HashMap attrs = new HashMap();
        String id = array[array.length - 1];
        String RSID = ".";
        if (id.indexOf("dbsnp") != -1) {
            RSID = this.parseID(id);
        }
        return new VariantContextBuilder("CGI", array[3], start, end, alleles).id(RSID).attributes(attrs).make();
    }

    @Override
    public Object readActualHeader(LineIterator lineIterator) {
        return null;
    }

    private String parseID(String raw) {
        String[] ids;
        StringBuilder sb = null;
        for (String id : ids = raw.split(";")) {
            Matcher matcher = DBSNP_PATTERN.matcher(id);
            if (!matcher.matches()) continue;
            String rsID = matcher.group(1);
            if (sb == null) {
                sb = new StringBuilder(rsID);
                continue;
            }
            sb.append(";");
            sb.append(rsID);
        }
        return sb == null ? null : sb.toString();
    }
}

