/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnzipGenomes {
    public static void main(String[] args) throws IOException {
        File root = new File("/Users/jrobinso/projects/genomes");
        for (File f2 : root.listFiles()) {
            if (!f2.getName().endsWith(".genome")) continue;
            String dirName = f2.getName().replace(".genome", "");
            File dir = new File(root, dirName);
            dir.mkdir();
            UnzipGenomes.unzip(f2, dir);
        }
    }

    public static void unzip(File zipFile, File destDir) throws IOException {
        ZipEntry e2;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));
        ZipInputStream zin = new ZipInputStream(in);
        while ((e2 = zin.getNextEntry()) != null) {
            File f2 = new File(destDir, e2.getName());
            UnzipGenomes.unzip(zin, f2);
        }
        zin.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(ZipInputStream zin, File f2) throws IOException {
        System.out.println("unzipping " + f2.getAbsolutePath());
        try (FileOutputStream out = null;){
            out = new FileOutputStream(f2);
            byte[] b2 = new byte[512];
            int len = 0;
            while ((len = zin.read(b2)) != -1) {
                out.write(b2, 0, len);
            }
        }
    }
}

