/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util.download;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.HttpUtils;

public class Downloader
implements Runnable {
    private static final Logger log = Logger.getLogger(Downloader.class);
    private static final int MAX_BUFFER_SIZE = 1000000;
    private URL url;
    private File localFile;
    private String tmpName;
    private int downloaded;
    private boolean canceled;
    private final ProgressMonitor monitor;

    public Downloader(URL url, File file, ProgressMonitor monitor) {
        this.url = url;
        this.localFile = file;
        this.tmpName = file + ".download";
        this.monitor = monitor;
        this.canceled = false;
        this.downloaded = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream stream;
        RandomAccessFile file;
        block39: {
            file = null;
            stream = null;
            try {
                byte[] buffer;
                int read;
                long contentLength = HttpUtils.getInstance().getContentLength(this.url);
                if (contentLength < 1L) {
                    // empty if block
                }
                HashMap<String, String> requestProperties = new HashMap<String, String>();
                requestProperties.put("Range", "bytes=" + this.downloaded + "-" + this.downloaded + 1000000);
                HttpURLConnection connection = HttpUtils.getInstance().openConnection(this.url, null);
                connection.connect();
                if (connection.getResponseCode() / 100 != 2) {
                    // empty if block
                }
                file = new RandomAccessFile(this.tmpName, "rw");
                file.seek(this.downloaded);
                stream = connection.getInputStream();
                while ((long)this.downloaded < contentLength && (read = stream.read(buffer = contentLength - (long)this.downloaded > 1000000L ? new byte[1000000] : new byte[(int)(contentLength - (long)this.downloaded)])) != -1) {
                    file.write(buffer, 0, read);
                    this.downloaded += read;
                    int percent = (int)(100.0 * (double)this.downloaded / (double)contentLength);
                    if (this.monitor == null) continue;
                    if (this.monitor.isCanceled()) {
                        this.canceled = true;
                        break;
                    }
                    SwingUtilities.invokeLater(() -> {
                        this.monitor.setProgress(percent);
                        this.monitor.setNote("" + this.downloaded / 1000 + " of " + contentLength / 1000L + " kb");
                    });
                }
                if (this.monitor == null) break block39;
            }
            catch (Exception e22) {
                block40: {
                    try {
                        log.error("Error downloading " + this.url, e22);
                        if (this.monitor == null) break block40;
                    }
                    catch (Throwable throwable) {
                        if (this.monitor != null) {
                            SwingUtilities.invokeLater(() -> this.monitor.close());
                        }
                        if (file != null) {
                            try {
                                file.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (this.canceled) {
                            new File(this.tmpName).delete();
                        } else {
                            try {
                                Files.move(new File(this.tmpName).toPath(), this.localFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (IOException e3) {
                                log.error("Error renaming download file " + this.tmpName, e3);
                            }
                        }
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(() -> this.monitor.close());
                }
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                if (this.canceled) {
                    new File(this.tmpName).delete();
                } else {
                    try {
                        Files.move(new File(this.tmpName).toPath(), this.localFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e4) {
                        log.error("Error renaming download file " + this.tmpName, e4);
                    }
                }
            }
            SwingUtilities.invokeLater(() -> this.monitor.close());
        }
        if (file != null) {
            try {
                file.close();
            }
            catch (Exception contentLength) {
                // empty catch block
            }
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception contentLength) {
                // empty catch block
            }
        }
        if (this.canceled) {
            new File(this.tmpName).delete();
        } else {
            try {
                Files.move(new File(this.tmpName).toPath(), this.localFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e5) {
                log.error("Error renaming download file " + this.tmpName, e5);
            }
        }
    }

    public static boolean download(URL url, File localFile, Component frame) throws MalformedURLException {
        ProgressMonitor monitor;
        String message = "Downloading " + url.toString();
        int min = 0;
        int max = 100;
        if (IGV.hasInstance()) {
            monitor = new ProgressMonitor(frame, message, "", min, max);
            monitor.setMillisToDecideToPopup(100);
        } else {
            monitor = null;
        }
        Downloader downloader = new Downloader(url, localFile, monitor);
        downloader.run();
        return !downloader.canceled;
    }

    public static void main(String[] args) throws MalformedURLException {
        URL url = new URL(args[0]);
        String localFile = args[1];
        Component frame = null;
        String message = "Downloading " + url.toString();
        int min = 0;
        int max = 100;
        ProgressMonitor monitor = new ProgressMonitor(frame, message, "", min, max);
        monitor.setMillisToDecideToPopup(100);
        Downloader dl = new Downloader(url, new File(localFile), monitor);
        new Thread(dl).start();
    }
}

