/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import javax.imageio.ImageIO;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.log4j.Logger;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.util.SnapshotFileChooser;
import org.broad.igv.util.RuntimeUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SnapshotUtilities {
    private static Logger log = Logger.getLogger(SnapshotUtilities.class);
    private static String EPSClassName = "net.sf.epsgraphics.EpsGraphics";
    private static String EPSColorModeClassName = "net.sf.epsgraphics.ColorMode";
    public static int DEFAULT_MAX_PANEL_HEIGHT;
    private static int maxPanelHeight;

    public static int getMaxPanelHeight() {
        return maxPanelHeight;
    }

    public static void setMaxPanelHeight(int h2) {
        maxPanelHeight = h2;
    }

    private SnapshotUtilities() {
    }

    public static String doComponentSnapshot(Component component, File file, SnapshotFileChooser.SnapshotFileType type, boolean paintOffscreen) throws IOException {
        if (paintOffscreen && !(component instanceof Paintable)) {
            log.error("Component cannot be painted offscreen. Performing onscreen paint");
            paintOffscreen = false;
        }
        if (paintOffscreen) {
            Rectangle rect = component.getBounds();
            rect.height = component instanceof MainPanel ? ((MainPanel)component).getOffscreenImageHeight() : Math.min(component.getHeight(), SnapshotUtilities.getMaxPanelHeight());
            int dx = rect.x;
            int dy = rect.y;
            rect.x = 0;
            rect.y = 0;
            rect.width -= dx;
            rect.height -= dy;
            component.setBounds(rect);
        }
        int width = component.getWidth();
        int height = component.getHeight();
        String format = null;
        String[] exts = null;
        switch (type) {
            case SVG: {
                SnapshotUtilities.exportScreenshotSVG(component, file, width, height, paintOffscreen);
                break;
            }
            case JPEG: {
                format = "jpeg";
                exts = new String[]{".jpg", ".jpeg"};
                break;
            }
            case PNG: {
                format = "png";
                exts = new String[]{"." + format};
                break;
            }
            case EPS: {
                SnapshotUtilities.exportScreenshotEpsGraphics(component, file, width, height, paintOffscreen);
            }
        }
        if (format != null && exts != null) {
            SnapshotUtilities.exportScreenShotBufferedImage(component, file, width, height, exts, format, paintOffscreen);
        }
        return "OK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportScreenshotEpsGraphics(Component target, File selectedFile, int width, int height, boolean paintOffscreen) throws IOException {
        if (!SnapshotUtilities.canExportScreenshotEps()) {
            String msg = "ERROR: EPS output requires EPSGraphics library. See https://www.broadinstitute.org/software/igv/third_party_tools#epsgraphics";
            log.error(msg);
            return;
        }
        Graphics2D g2 = null;
        OutputStream fos = null;
        try {
            Class colorModeClass = RuntimeUtils.loadClassForName(EPSColorModeClassName, null);
            Class graphicsClass = RuntimeUtils.loadClassForName(EPSClassName, null);
            Constructor constructor = graphicsClass.getConstructor(String.class, OutputStream.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, colorModeClass);
            Object colorModeValue = Enum.valueOf(colorModeClass, "COLOR_RGB");
            fos = new FileOutputStream(selectedFile);
            g2 = (Graphics2D)constructor.newInstance("eps", fos, 0, 0, target.getWidth(), target.getHeight(), colorModeValue);
            SnapshotUtilities.choosePaint(target, g2, width, height, paintOffscreen);
            graphicsClass.getMethod("close", new Class[0]).invoke((Object)g2, new Object[0]);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), e2);
        }
        finally {
            if (fos != null) {
                fos.flush();
                ((FileOutputStream)fos).close();
            }
        }
    }

    public static boolean canExportScreenshotEps() {
        Constructor constr = null;
        try {
            Class colorModeClass = RuntimeUtils.loadClassForName(EPSColorModeClassName, null);
            Class graphicsClass = RuntimeUtils.loadClassForName(EPSClassName, null);
            constr = graphicsClass.getConstructor(String.class, OutputStream.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, colorModeClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return constr != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportScreenshotSVG(Component target, File selectedFile, int width, int height, boolean paintOffscreen) throws IOException {
        String format = "svg";
        selectedFile = SnapshotUtilities.fixFileExt(selectedFile, new String[]{format}, format);
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, format, null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        SnapshotUtilities.choosePaint(target, svgGenerator, width, height, paintOffscreen);
        Writer out = null;
        try {
            boolean useCSS = true;
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(selectedFile), "UTF-8"));
            svgGenerator.stream(out, useCSS);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e2) {
                    log.error("Error closing svg file", e2);
                }
            }
        }
    }

    private static void choosePaint(Component target, Graphics2D g2, int width, int height, boolean paintOffscreen) {
        log.debug("Painting to target " + target + " , offscreen " + paintOffscreen);
        if (paintOffscreen) {
            Rectangle rect = new Rectangle(0, 0, width, height);
            ((Paintable)((Object)target)).paintOffscreen(g2, rect);
        } else {
            target.paintAll(g2);
        }
    }

    private static void exportScreenShotBufferedImage(Component target, File selectedFile, int width, int height, String[] allowedExts, String format, boolean paintOffscreen) throws IOException {
        BufferedImage image = SnapshotUtilities.getDeviceCompatibleImage(width, height);
        Graphics2D g2 = image.createGraphics();
        SnapshotUtilities.choosePaint(target, g2, width, height, paintOffscreen);
        selectedFile = SnapshotUtilities.fixFileExt(selectedFile, allowedExts, format);
        if (selectedFile != null) {
            log.debug("Writing image to " + selectedFile.getAbsolutePath());
            ImageIO.write((RenderedImage)image, format, selectedFile);
        }
    }

    private static File fixFileExt(File selectedFile, String[] allowedExts, String defExtension) {
        boolean hasExt = false;
        if (selectedFile != null) {
            for (String ext : allowedExts) {
                if (!selectedFile.getName().toLowerCase().endsWith(ext)) continue;
                hasExt = true;
                break;
            }
            if (!hasExt) {
                String addExt = defExtension.startsWith(".") ? defExtension : "." + defExtension;
                String correctedFilename = selectedFile.getAbsolutePath() + addExt;
                selectedFile = new File(correctedFilename);
            }
        }
        return selectedFile;
    }

    public static BufferedImage getDeviceCompatibleImage(int width, int height) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice screenDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicConfiguration = screenDevice.getDefaultConfiguration();
        BufferedImage image = graphicConfiguration.createCompatibleImage(width, height);
        return image;
    }

    static {
        maxPanelHeight = DEFAULT_MAX_PANEL_HEIGHT = 1000;
    }
}

