/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.color;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.ui.color.ColorTable;
import org.broad.igv.ui.color.ColorUtilities;

public class HSLColorTable
implements ColorTable {
    int hueCenter;
    boolean greyscale = false;
    Map<String, Color> colorMap = new HashMap<String, Color>();

    public HSLColorTable(int hueCenter) {
        this.hueCenter = hueCenter;
    }

    @Override
    public Color get(String key) {
        Color c2 = this.colorMap.get(key);
        if (c2 == null) {
            if (this.greyscale) {
                int r2 = (int)(50.0 + Math.random() * 155.0);
                c2 = new Color(r2, r2, r2);
            } else {
                double hue = (double)(this.hueCenter - 30) + Math.random() * 60.0;
                double saturation = 0.4 + Math.random() * 0.6;
                double lightness = 0.2 + Math.random() * 0.4;
                int[] rgb = ColorUtilities.hslToRgb(hue, saturation, lightness);
                c2 = new Color(rgb[0], rgb[1], rgb[2]);
            }
            this.colorMap.put(key, c2);
        }
        return c2;
    }
}

