/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import htsjdk.tribble.readers.AsciiLineReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class ReadGroupFilter {
    private Set<String> filteredReadGroups;
    static Map<String, ReadGroupFilter> filterCache = new HashMap<String, ReadGroupFilter>();

    private ReadGroupFilter(Set<String> filteredReadGroups) {
        this.filteredReadGroups = filteredReadGroups;
    }

    public boolean filterAlignment(Alignment alignment) {
        return this.filteredReadGroups.contains(alignment.getReadGroup());
    }

    public static synchronized ReadGroupFilter getFilter() {
        IGVPreferences samPrefs = PreferencesManager.getPreferences();
        if (samPrefs.getAsBoolean("SAM.FILTER_ALIGNMENTS")) {
            ReadGroupFilter filter;
            String filterURL = samPrefs.get("SAM.FILTER_URL");
            ReadGroupFilter readGroupFilter = filter = filterURL == null ? null : filterCache.get(filterURL);
            if (filter == null && filterURL != null && filterURL.trim().length() > 0) {
                HashSet<String> readGroups = new HashSet<String>();
                AsciiLineReader reader = null;
                try {
                    String nextLine;
                    reader = ParsingUtils.openAsciiReader(new ResourceLocator(filterURL));
                    while ((nextLine = reader.readLine()) != null) {
                        readGroups.add(nextLine.trim());
                    }
                    filter = new ReadGroupFilter(readGroups);
                    filterCache.put(filterURL, filter);
                }
                catch (Exception e2) {
                    MessageUtils.showMessage("Error reading read filter list: " + e2.getMessage());
                }
            }
            return filter;
        }
        return null;
    }
}

