/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloseableIterator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.sam.EmptyAlignmentIterator;
import org.broad.igv.sam.PicardAlignment;
import org.broad.igv.sam.cram.IGVReferenceSource;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.sam.reader.WrappedIterator;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class BAMReader
implements AlignmentReader<PicardAlignment> {
    static Logger log = Logger.getLogger(BAMReader.class);
    private final ResourceLocator locator;
    SAMFileHeader header;
    SamReader reader;
    List<String> sequenceNames;
    private boolean indexed = false;

    public BAMReader(ResourceLocator locator, boolean requireIndex) throws IOException {
        this.locator = locator;
        this.reader = this.getSamReader(locator, requireIndex);
        this.header = this.reader.getFileHeader();
        this.validateSequenceLengths(this.header);
    }

    private void validateSequenceLengths(SAMFileHeader header) {
        SAMSequenceDictionary dict = header.getSequenceDictionary();
        for (SAMSequenceRecord seq : dict.getSequences()) {
            if (seq.getSequenceLength() <= 0x1FFFFFFF) continue;
            throw new RuntimeException("Sequence lengths > 2^29-1 are not supported");
        }
    }

    private SamReader getSamReader(ResourceLocator locator, boolean requireIndex) throws IOException {
        SamInputResource resource;
        boolean isLocal = locator.isLocal();
        SamReaderFactory factory = SamReaderFactory.makeDefault().referenceSource(new IGVReferenceSource()).validationStringency(ValidationStringency.SILENT);
        if (isLocal) {
            resource = SamInputResource.of(new File(locator.getPath()));
        } else {
            URL url = new URL(locator.getPath());
            resource = requireIndex ? SamInputResource.of(IGVSeekableStreamFactory.getInstance().getStreamFor(url)) : SamInputResource.of(new BufferedInputStream(HttpUtils.getInstance().openConnectionStream(url)));
        }
        if (requireIndex) {
            String indexPath = this.getExplicitIndexPath(locator);
            if (indexPath == null) {
                indexPath = this.getIndexPath(locator.getPath());
            }
            this.indexed = true;
            if (isLocal) {
                File indexFile = new File(indexPath);
                resource = resource.index(indexFile);
            } else {
                SeekableStream indexStream = IGVSeekableStreamFactory.getInstance().getStreamFor(new URL(indexPath));
                resource = resource.index(indexStream);
            }
        }
        return factory.open(resource);
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public SAMFileHeader getFileHeader() {
        if (this.header == null) {
            this.header = this.reader.getFileHeader();
        }
        return this.header;
    }

    @Override
    public boolean hasIndex() {
        return this.indexed;
    }

    @Override
    public Set<String> getPlatforms() {
        return AlignmentReaderFactory.getPlatforms(this.getFileHeader());
    }

    @Override
    public List<String> getSequenceNames() {
        if (this.sequenceNames == null) {
            SAMFileHeader header = this.getFileHeader();
            if (header == null) {
                return null;
            }
            this.sequenceNames = new ArrayList<String>();
            List<SAMSequenceRecord> records = header.getSequenceDictionary().getSequences();
            if (records.size() > 0) {
                for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                    String chr = rec.getSequenceName();
                    this.sequenceNames.add(chr);
                }
            }
        }
        return this.sequenceNames;
    }

    @Override
    public CloseableIterator<PicardAlignment> iterator() {
        return new WrappedIterator(this.reader.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIterator<PicardAlignment> query(String sequence, int start, int end, boolean contained) {
        SAMRecordIterator iter = null;
        try {
            SamReader samReader = this.reader;
            synchronized (samReader) {
                iter = this.reader.query(sequence, start + 1, end, contained);
            }
        }
        catch (IllegalArgumentException e2) {
            log.error("Error querying for sequence: " + sequence, e2);
            return new EmptyAlignmentIterator();
        }
        return new WrappedIterator(iter);
    }

    private String getExplicitIndexPath(ResourceLocator locator) {
        String p2 = locator.getPath().toLowerCase();
        String idx = locator.getIndexPath();
        if (idx == null && (p2.startsWith("http://") || p2.startsWith("https://"))) {
            try {
                Map<String, String> parameters;
                URL url = new URL(locator.getPath());
                String queryString = url.getQuery();
                if (queryString != null && (parameters = HttpUtils.parseQueryString(queryString)).containsKey("index")) {
                    idx = parameters.get("index");
                }
            }
            catch (MalformedURLException e2) {
                log.error("Error parsing url: " + locator.getPath());
            }
        }
        return idx;
    }

    private String getIndexPath(String pathOrURL) throws IOException {
        String defaultValue;
        String indexPath;
        ArrayList<String> pathsTried = new ArrayList<String>();
        if (FileUtils.isRemote(pathOrURL)) {
            indexPath = this.getIndexURL(pathOrURL, ".bai");
            pathsTried.add(indexPath);
            if (HttpUtils.getInstance().resourceAvailable(new URL(indexPath))) {
                return indexPath;
            }
            if (pathOrURL.endsWith(".bam")) {
                indexPath = this.getIndexURL(pathOrURL.substring(0, pathOrURL.length() - 4), ".bai");
                pathsTried.add(indexPath);
                if (HttpUtils.getInstance().resourceAvailable(new URL(indexPath))) {
                    return indexPath;
                }
            }
            if (pathOrURL.endsWith(".cram")) {
                indexPath = this.getIndexURL(pathOrURL, ".crai");
                if (FileUtils.resourceExists(indexPath)) {
                    pathsTried.add(indexPath);
                    return indexPath;
                }
                indexPath = pathOrURL.substring(0, pathOrURL.length() - 5) + ".crai";
                if (FileUtils.resourceExists(indexPath)) {
                    return indexPath;
                }
            }
        } else {
            indexPath = pathOrURL + ".bai";
            if (FileUtils.resourceExists(indexPath)) {
                return indexPath;
            }
            if (pathOrURL.endsWith(".cram")) {
                indexPath = pathOrURL + ".crai";
                if (FileUtils.resourceExists(indexPath)) {
                    return indexPath;
                }
                indexPath = pathOrURL.substring(0, pathOrURL.length() - 5) + ".crai";
                if (FileUtils.resourceExists(indexPath)) {
                    return indexPath;
                }
            }
            if (indexPath.contains(".bam.bai")) {
                indexPath = indexPath.replaceFirst(".bam.bai", ".bai");
                pathsTried.add(indexPath);
                if (FileUtils.resourceExists(indexPath)) {
                    return indexPath;
                }
            } else {
                indexPath = indexPath.replaceFirst(".bai", ".bam.bai");
                pathsTried.add(indexPath);
                if (FileUtils.resourceExists(indexPath)) {
                    return indexPath;
                }
            }
        }
        if ((indexPath = MessageUtils.showInputDialog("Index is required, but no index found.  Please enter path to index file:", defaultValue = pathOrURL + (pathOrURL.endsWith(".cram") ? ".crai" : ".bai"))) != null && FileUtils.resourceExists(indexPath)) {
            return indexPath;
        }
        String msg = "Index file not found.  Tried ";
        for (String p2 : pathsTried) {
            msg = msg + "<br>" + p2;
        }
        throw new DataLoadException(msg, indexPath);
    }

    private String getIndexURL(String urlString, String extension) {
        String indexPath = null;
        try {
            URL url = new URL(urlString);
            String queryString = url.getQuery();
            if (queryString == null) {
                indexPath = urlString + extension;
            } else {
                Map<String, String> parameters = HttpUtils.parseQueryString(queryString);
                if (parameters.containsKey("file")) {
                    String bamFile = parameters.get("file");
                    String bamIndexFile = bamFile + extension;
                    String newQueryString = queryString.replace(bamFile, bamIndexFile);
                    indexPath = urlString.replace(queryString, newQueryString);
                } else {
                    indexPath = urlString.replace(url.getPath(), url.getPath() + extension);
                }
            }
        }
        catch (MalformedURLException e2) {
            log.error(e2.getMessage(), e2);
        }
        return indexPath;
    }
}

