/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.lite;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class BGUnzip {
    public static final int BGZIP_HEADER_LENGTH = 18;

    public static byte[] blockUnzip(byte[] data) throws IOException {
        int bsize;
        Inflater inflater = new Inflater(true);
        int lim = data.length - 18;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        for (int ptr = 0; ptr < lim; ptr += bsize) {
            int inflatedBytes;
            int xlen = BGUnzip.unpackInt16(data, ptr + 10);
            byte si1 = data[ptr + 12];
            byte si2 = data[ptr + 13];
            int slen = BGUnzip.unpackInt16(data, 14);
            int start = 18 + ptr;
            int remainder = data.length - start;
            bsize = BGUnzip.unpackInt16(data, ptr + 16) + 1;
            if (remainder < bsize + 8) break;
            int uncLength = BGUnzip.unpackInt32(data, ptr + bsize - 4);
            inflater.reset();
            inflater.setInput(data, start, remainder);
            byte[] output = new byte[uncLength];
            try {
                inflatedBytes = inflater.inflate(output, 0, uncLength);
            }
            catch (DataFormatException e2) {
                break;
            }
            outputStream.write(output, 0, inflatedBytes);
        }
        return outputStream.toByteArray();
    }

    private static int unpackInt16(byte[] buffer, int offset) {
        return buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8;
    }

    private static int unpackInt32(byte[] buffer, int offset) {
        return buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24;
    }
}

