/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Collections;
import java.util.Set;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IExon;
import org.broad.igv.renderer.IGVFeatureRenderer;

public class SelectableFeatureRenderer
extends IGVFeatureRenderer {
    private static final Stroke lineStroke = new BasicStroke(2.0f);
    private static final Color selectedBorderColor = Color.blue;
    private Set<IExon> selectedExons = Collections.emptySet();

    public SelectableFeatureRenderer() {
        this.AA_COLOR_1 = new Color(this.AA_COLOR_1.getRed(), this.AA_COLOR_1.getGreen(), this.AA_COLOR_1.getBlue(), 120);
        this.AA_COLOR_2 = new Color(this.AA_COLOR_2.getRed(), this.AA_COLOR_2.getGreen(), this.AA_COLOR_2.getBlue(), 120);
    }

    @Override
    protected void drawExonRect(Graphics blockGraphics, Exon exon, int x2, int y, int width, int height) {
        boolean isSelected = this.selectedExons.contains(exon);
        for (IExon selEx : this.selectedExons) {
            if (!selEx.contains(exon.getStart()) && !selEx.contains(exon.getEnd())) continue;
            isSelected = true;
            break;
        }
        if (isSelected) {
            blockGraphics.clearRect(x2, y, width, height);
            Graphics2D borderGraphics = (Graphics2D)blockGraphics.create();
            borderGraphics.setColor(selectedBorderColor);
            borderGraphics.setStroke(lineStroke);
            borderGraphics.drawRect(x2, y, width, height);
        } else {
            super.drawExonRect(blockGraphics, exon, x2, y, width, height);
        }
    }

    public void setSelectedExons(Set<IExon> selectedExons) {
        this.selectedExons = selectedExons;
    }
}

