/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.renderer.FeatureRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;

public class MutationRenderer
extends FeatureRenderer {
    private static Logger log = Logger.getLogger(MutationRenderer.class);

    public String getDisplayName() {
        return "Mutation";
    }

    @Override
    public void render(List<IGVFeature> featureList, RenderContext context, Rectangle trackRectangle, Track track) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (featureList != null && featureList.size() > 0) {
            Rectangle lastRect = null;
            boolean colorOverlay = IGV.getInstance().getSession().getColorOverlay();
            for (IGVFeature feature : featureList) {
                double pixelStart = ((double)feature.getStart() - origin) / locScale;
                double pixelEnd = ((double)feature.getEnd() - origin) / locScale;
                if (!(pixelEnd >= trackRectangle.getX()) || !(pixelStart <= trackRectangle.getMaxX())) continue;
                Color color = feature.getColor();
                Graphics2D g2 = context.getGraphic2DForColor(color);
                g2.setFont(FontManager.getDefaultFont());
                int w2 = (int)(pixelEnd - pixelStart);
                if (w2 < 3) {
                    w2 = 3;
                    pixelStart -= 1.0;
                }
                int mutHeight = (int)Math.max(1.0, trackRectangle.getHeight() - 2.0);
                int mutY = (int)(trackRectangle.getY() + (trackRectangle.getHeight() - (double)mutHeight) / 2.0);
                Rectangle mutRect = new Rectangle((int)pixelStart, mutY, w2, mutHeight);
                Graphics2D gRect = colorOverlay ? g2 : context.getGraphic2DForColor(Color.BLACK);
                gRect.draw(mutRect);
                --mutRect.x;
                mutRect.width += 2;
                gRect.draw(mutRect);
                lastRect = mutRect;
            }
        }
    }
}

