/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.lists;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.lists.GeneList;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;

public class GeneListManager {
    private static Logger log = Logger.getLogger(GeneListManager.class);
    public static final List<String> DEFAULT_GENE_LISTS = Arrays.asList("examples.gmt", "reactome_cp.gmt", "kegg_cancer_cp.gmt");
    public static final String USER_GROUP = "My lists";
    private static final HashSet<String> fileTypes = new HashSet<String>(Arrays.asList("bed", "gmt", "grp"));
    private LinkedHashSet<String> groups = new LinkedHashSet();
    private HashMap<String, File> importedFiles = new HashMap();
    private LinkedHashMap<String, GeneList> geneLists = new LinkedHashMap();
    static GeneListManager theInstance;

    public static GeneListManager getInstance() {
        if (theInstance == null) {
            theInstance = new GeneListManager();
        }
        return theInstance;
    }

    private GeneListManager() {
        this.loadDefaultLists();
        this.loadUserLists();
    }

    public GeneList getGeneList(String listID) {
        return this.geneLists.get(listID);
    }

    public LinkedHashMap<String, GeneList> getGeneLists() {
        return this.geneLists;
    }

    public void addGeneList(GeneList genes) {
        this.geneLists.put(genes.getName(), genes);
        this.groups.add(genes.getGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultLists() {
        for (String geneListFile : DEFAULT_GENE_LISTS) {
            InputStream is = GeneListManager.class.getResourceAsStream(geneListFile);
            if (is == null) {
                log.info("Could not find gene list resource: " + geneListFile);
                return;
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(is));
                new BufferedReader(new InputStreamReader(is));
                List<GeneList> lists = this.loadGMTFile(reader);
                for (GeneList gl : lists) {
                    gl.setEditable(false);
                    this.addGeneList(gl);
                }
            }
            catch (IOException e2) {
                log.error("Error loading default gene lists", e2);
                MessageUtils.showMessage("<html>Error encountered loading gene lists (" + e2.toString() + ")<br/>See log for more details");
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void loadUserLists() {
        File dir = DirectoryManager.getGeneListDirectory();
        if (dir.exists()) {
            for (File f2 : dir.listFiles()) {
                try {
                    if (!fileTypes.contains(this.getFileType(f2.getPath()))) continue;
                    this.importFile(f2);
                }
                catch (IOException e2) {
                    log.error("Error loading user gene lists: ", e2);
                    MessageUtils.showMessage("<html>Error encountered loading user gene lists (" + e2.toString() + ")<br/>See log for more details");
                }
            }
        }
        if (!this.groups.contains(USER_GROUP)) {
            this.groups.add(USER_GROUP);
        }
    }

    private String getFileType(String path) {
        int idx;
        String tmp = path.toLowerCase();
        if (tmp.endsWith(".gz")) {
            tmp = tmp.substring(0, tmp.length() - 3);
        }
        return (idx = path.lastIndexOf(".")) < 0 ? path : path.substring(idx + 1);
    }

    public List<GeneList> importFile(File f2) throws IOException {
        List<GeneList> loadedLists;
        String path = f2.getPath();
        String name = f2.getName();
        File dir = DirectoryManager.getGeneListDirectory();
        if (!dir.equals(f2.getParentFile())) {
            File copy = new File(dir, f2.getName());
            FileUtils.copyFile(f2, copy);
        }
        if ((loadedLists = this.loadFile(path)).size() > 0) {
            this.importedFiles.put(name, f2);
            for (GeneList gl : loadedLists) {
                gl.setEditable(true);
            }
        }
        return loadedLists;
    }

    private List<GeneList> loadFile(String path) throws IOException {
        String type = this.getFileType(path);
        if (type.equals("bed")) {
            return this.loadBEDFile(path);
        }
        if (type.equals("gmt")) {
            return this.loadGMTFile(path);
        }
        if (type.equals("grp")) {
            return this.loadGRPFile(path);
        }
        throw new RuntimeException("Unrecognized file extension: " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GeneList> loadBEDFile(String path) throws IOException {
        String name = new File(path).getName();
        BufferedReader reader = null;
        try {
            List<GeneList> list;
            block14: {
                reader = ParsingUtils.openBufferedReader(path);
                try {
                    String nextLine;
                    ArrayList<String> loci = new ArrayList<String>(1000);
                    while ((nextLine = reader.readLine()) != null) {
                        if (nextLine.startsWith("#") || nextLine.startsWith("browser")) continue;
                        if (nextLine.startsWith("track")) {
                            TrackProperties tp = new TrackProperties();
                            ParsingUtils.parseTrackLine(nextLine, tp);
                            String tmp = tp.getName();
                            if (tmp == null) continue;
                            name = tmp;
                            continue;
                        }
                        String[] tokens = Globals.whitespacePattern.split(nextLine);
                        if (tokens.length <= 2) continue;
                        loci.add(tokens[0] + ":" + tokens[1] + "-" + tokens[2]);
                    }
                    GeneList geneList = new GeneList(name, loci);
                    geneList.setGroup(USER_GROUP);
                    geneList.setEditable(false);
                    this.addGeneList(geneList);
                    list = Arrays.asList(geneList);
                    if (reader == null) break block14;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                reader.close();
            }
            return list;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeneList> loadGMTFile(String path) throws IOException {
        try (BufferedReader reader = null;){
            reader = ParsingUtils.openBufferedReader(path);
            List<GeneList> list = this.loadGMTFile(reader);
            return list;
        }
    }

    private List<GeneList> loadGMTFile(BufferedReader reader) throws IOException {
        String nextLine;
        String group = USER_GROUP;
        ArrayList<GeneList> lists = new ArrayList<GeneList>();
        while ((nextLine = reader.readLine()) != null) {
            String[] tokens;
            if (nextLine.startsWith("#")) {
                if (!nextLine.startsWith("#group") && !nextLine.startsWith("#name") || (tokens = nextLine.split("=")).length <= 1) continue;
                group = tokens[1];
                continue;
            }
            tokens = nextLine.split("\t");
            if (tokens.length <= 2) continue;
            String name = tokens[0];
            String description = tokens[1].replaceFirst(">", "");
            ArrayList<String> genes = new ArrayList<String>();
            for (int i2 = 2; i2 < tokens.length; ++i2) {
                genes.add(tokens[i2]);
            }
            lists.add(new GeneList(name, description, group, genes));
        }
        for (GeneList gl : lists) {
            gl.setEditable(false);
            this.addGeneList(gl);
        }
        return lists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<GeneList> loadGRPFile(String path) throws IOException {
        String name = new File(path).getName();
        String group = USER_GROUP;
        String description = null;
        BufferedReader reader = null;
        try {
            String nextLine;
            ArrayList<String> genes = new ArrayList<String>();
            reader = ParsingUtils.openBufferedReader(path);
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens;
                if (nextLine.startsWith("#")) {
                    if (nextLine.startsWith("#name")) {
                        tokens = nextLine.split("=");
                        if (tokens.length <= 1) continue;
                        name = tokens[1];
                        continue;
                    }
                    if (!nextLine.startsWith("#description") || (tokens = nextLine.split("=")).length <= 1) continue;
                    description = tokens[1];
                    continue;
                }
                for (String s2 : tokens = nextLine.split("\\s+")) {
                    genes.add(s2);
                }
            }
            if (genes.size() > 0) {
                GeneList geneList = new GeneList(name, description, group, genes);
                geneList.setEditable(false);
                this.addGeneList(geneList);
                List<GeneList> list = Arrays.asList(geneList);
                return list;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportGMT(String group, File outputFile) throws IOException {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            List<GeneList> lists = this.getListsForGroup(group);
            if (lists.isEmpty()) {
                MessageUtils.showMessage("Nothing to export.");
                return;
            }
            pw.println("#name=" + group);
            for (GeneList gl : lists) {
                pw.print(gl.getName());
                for (String gene : gl.getLoci()) {
                    pw.print("\t");
                    pw.print(gene);
                }
                pw.println();
            }
        }
    }

    private List<GeneList> getListsForGroup(String group) {
        ArrayList<GeneList> list = new ArrayList<GeneList>();
        for (GeneList gl : this.geneLists.values()) {
            if (!gl.getGroup().equals(group)) continue;
            list.add(gl);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGeneList(GeneList geneList) {
        File file = null;
        try (PrintWriter pw = null;){
            String listName = geneList.getName();
            String description = geneList.getDescription();
            List<String> genes = geneList.getLoci();
            if (listName != null && genes != null) {
                file = new File(DirectoryManager.getGeneListDirectory(), GeneListManager.getLegalFilename(listName) + ".grp");
                pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                pw.println("#name=" + listName);
                if (description != null) {
                    pw.println("#description=" + description);
                }
                for (String s2 : genes) {
                    pw.println(s2);
                }
                pw.close();
                this.importedFiles.put(listName, file);
            }
        }
    }

    private static String getLegalFilename(String s2) {
        try {
            return URLEncoder.encode(s2, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            return s2;
        }
    }

    public boolean isImported(String groupName) {
        return this.importedFiles.containsKey(groupName);
    }

    public LinkedHashSet<String> getGroups() {
        return this.groups;
    }

    public void deleteGroup(String selectedGroup) {
        File f2 = this.importedFiles.get(selectedGroup);
        if (f2.exists()) {
            f2.delete();
        }
        this.groups.remove(selectedGroup);
        this.importedFiles.remove(selectedGroup);
        ArrayList<GeneList> tmp = new ArrayList<GeneList>(this.geneLists.values());
        for (GeneList gl : tmp) {
            if (!gl.getGroup().equals(selectedGroup)) continue;
            this.geneLists.remove(gl.getName());
        }
    }

    public boolean deleteList(String listName) {
        File f2 = this.importedFiles.get(listName);
        if (f2 != null && f2.exists()) {
            f2.delete();
        }
        this.importedFiles.remove(listName);
        if (this.geneLists.containsKey(listName)) {
            String group = this.geneLists.get(listName).getGroup();
            this.geneLists.remove(listName);
            if (!group.equals(USER_GROUP)) {
                for (GeneList gl : this.geneLists.values()) {
                    if (!gl.getGroup().equals(group)) continue;
                    return false;
                }
                this.groups.remove(group);
                return true;
            }
        }
        return false;
    }
}

