/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.dsi;

import htsjdk.tribble.Feature;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.broad.igv.feature.dsi.DSIFeature;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;

public class DSIRenderer
implements Renderer<Feature> {
    static final Color uColor = new Color(26, 204, 255);
    static final Color mColor = new Color(153, 253, 153);
    static final Color pColor = new Color(50, 200, 50);
    static final Color fColor = new Color(253, 102, 8);
    static final Color naColor = Color.lightGray;
    double max = 20.0;

    @Override
    public void render(List<Feature> featureList, RenderContext context, Rectangle trackRectangle, Track track) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (featureList != null && featureList.size() > 0) {
            for (Feature f2 : featureList) {
                if (!(f2 instanceof DSIFeature)) continue;
                DSIFeature feature = (DSIFeature)f2;
                double pixelStart = ((double)feature.getStart() - origin) / locScale;
                double pixelEnd = ((double)feature.getEnd() - origin) / locScale;
                if (!(pixelEnd >= trackRectangle.getX()) || !(pixelStart <= trackRectangle.getMaxX())) continue;
                int w2 = (int)(pixelEnd - pixelStart);
                if (w2 < 1) {
                    w2 = 1;
                } else if (w2 > 5) {
                    w2 -= 2;
                    pixelStart += 1.0;
                }
                int totalHeight = trackRectangle.height;
                int bottom = trackRectangle.y + trackRectangle.height;
                int top = trackRectangle.y;
                int x2 = (int)pixelStart;
                Color color = naColor;
                Graphics2D g2D = context.getGraphic2DForColor(color);
                g2D.fillRect(x2, top, w2, totalHeight);
                if (feature.u == Integer.MIN_VALUE) continue;
                double total = feature.total;
                g2D = context.getGraphic2DForColor(uColor);
                int uHeight = (int)Math.round((double)feature.u / total * (double)totalHeight);
                g2D.fillRect(x2, top, w2, uHeight);
                g2D = context.getGraphic2DForColor(mColor);
                int mHeight = (int)Math.round((double)feature.m / total * (double)totalHeight);
                g2D.fillRect(x2, top += uHeight, w2, mHeight);
                g2D = context.getGraphic2DForColor(pColor);
                int pHeight = (int)Math.round((double)feature.p / total * (double)totalHeight);
                g2D.fillRect(x2, top += mHeight, w2, pHeight);
                g2D = context.getGraphic2DForColor(fColor);
                int fHeight = totalHeight - (top += pHeight);
                g2D.fillRect(x2, top, w2, fHeight);
            }
        }
    }
}

