/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.basepair;

import java.awt.Rectangle;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.basepair.BasePairData;
import org.broad.igv.feature.basepair.BasePairFeature;
import org.broad.igv.feature.basepair.BasePairFileParser;
import org.broad.igv.feature.basepair.BasePairRenderer;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

public class BasePairTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(BasePairTrack.class);
    private BasePairRenderer basePairRenderer = new BasePairRenderer();
    private BasePairData basePairData;
    Genome genome;

    public BasePairTrack(ResourceLocator locator, String id, String name, Genome genome) {
        super(locator, id, name);
        this.genome = genome;
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        return this.basePairData != null;
    }

    @Override
    public void load(ReferenceFrame frame) {
        this.basePairData = BasePairFileParser.loadData(this.getResourceLocator(), this.genome);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        this.basePairRenderer.draw(this.basePairData, context, rect);
    }

    public void checkHeight(RenderContext context, Rectangle rect) {
        List<BasePairFeature> featureList = this.basePairData.getFeatures(context.getChr());
        if (featureList != null) {
            int maxL = 0;
            for (BasePairFeature feature : featureList) {
                maxL = Math.max(maxL, feature.getEndRight() - feature.getStartLeft());
            }
            int height = (int)((double)maxL / (2.0 * context.getScale()));
            this.setHeight(height, true);
        }
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    public int getDirection() {
        return this.basePairRenderer.getDirection();
    }

    public void setDirection(int d2) {
        this.basePairRenderer.setDirection(d2);
    }
}

