/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.FeatureEncoder;
import org.broad.igv.variant.VariantTrack;
import org.broad.igv.variant.vcf.VCFVariant;

public class VCFEncoder
implements FeatureEncoder<VCFVariant> {
    private VCFHeader header;

    @Override
    public void setInputs(List<String> commands, Map<Argument, Object> argumentMap, Argument argument) {
        assert (argument.getType() == Argument.InputType.VARIANT_TRACK);
        VariantTrack track = (VariantTrack)argumentMap.get(argument);
        this.header = (VCFHeader)track.getHeader();
    }

    @Override
    public Map<String, Object> encodeAll(OutputStream outputStream, Iterator<? extends VCFVariant> features) throws IOException {
        SAMSequenceDictionary seqDict = new SAMSequenceDictionary();
        EnumSet<Options> options = VariantContextWriterBuilder.DEFAULT_OPTIONS;
        options.add(Options.ALLOW_MISSING_FIELDS_IN_HEADER);
        options.remove((Object)Options.INDEX_ON_THE_FLY);
        VariantContextWriterBuilder builder = new VariantContextWriterBuilder().setReferenceDictionary(seqDict).setOption(Options.INDEX_ON_THE_FLY).setBuffer(8192);
        VariantContextWriter writer = builder.setOutputStream(outputStream).setOptions(options).build();
        writer.writeHeader(this.header);
        while (features.hasNext()) {
            writer.add(features.next().getVariantContext());
        }
        return null;
    }
}

