/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.batch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.broad.igv.util.ParsingUtils;

public class TestClient {
    private static String sessionURL = "http://www.broadinstitute.org/mmgp/textReader/IGV/mmrc_session.xml";
    private static String fileURL = "https://data.broadinstitute.org/igvdata/cshcourse/rwpe.washu.merged.bam";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Socket socket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            socket = new Socket("127.0.0.1", 60151);
            out = new PrintWriter(socket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            TestClient.testMultiLocus(out, in);
        }
        catch (UnknownHostException e2) {
            System.err.println("Unknown host exception: " + e2.getMessage());
            System.exit(1);
        }
        catch (IOException e3) {
            e3.printStackTrace();
            System.err.println("Couldn't get I/O for the connection to IGV");
            System.exit(1);
        }
        finally {
            in.close();
            out.close();
            socket.close();
        }
    }

    private static void runBatchFile(PrintWriter out, BufferedReader in, String inputFile) throws IOException {
        try (BufferedReader reader = null;){
            String inLine;
            reader = ParsingUtils.openBufferedReader(inputFile);
            while ((inLine = reader.readLine()) != null) {
                if (inLine.startsWith("#") || inLine.startsWith("//")) continue;
                System.out.println("Executing Command: " + inLine);
                out.println(inLine);
                String response = in.readLine();
                System.out.println("Response: " + response);
            }
        }
    }

    private static void testMultiLocus(PrintWriter out, BufferedReader in) throws IOException {
        String cmd = "load https://data.broadinstitute.org/igvdata/tcga/gbmsubtypes/Broad.080528.subtypes.seg.gz";
        out.println(cmd);
        String response = in.readLine();
        System.out.println(cmd + " " + response);
        cmd = "goto EGFR PTEN";
        out.println(cmd);
        response = in.readLine();
        System.out.println(cmd + " " + response);
    }
}

