/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.example;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class PrintVariantsExample {
    private static final Log log = Log.getInstance(PrintVariantsExample.class);

    private PrintVariantsExample() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: " + PrintVariantsExample.class.getCanonicalName() + " inFile [outFile]");
            System.exit(1);
        }
        File inputFile = new File(args[0]);
        File outputFile = args.length >= 2 ? new File(args[1]) : null;
        long start = System.currentTimeMillis();
        log.info("Start with args:" + Arrays.toString(args));
        PrintVariantsExample.printConfigurationInfo();
        try (VariantContextWriter writer = outputFile == null ? null : new VariantContextWriterBuilder().setOutputFile(outputFile).setOutputFileType(VariantContextWriterBuilder.OutputType.VCF).unsetOption(Options.INDEX_ON_THE_FLY).build();
             AbstractFeatureReader<VariantContext, LineIterator> reader = AbstractFeatureReader.getFeatureReader(inputFile.getAbsolutePath(), new VCFCodec(), false);){
            log.info(reader.getClass().getSimpleName() + " hasIndex " + reader.hasIndex());
            if (writer != null) {
                log.info(writer.getClass().getSimpleName());
                writer.writeHeader((VCFHeader)reader.getHeader());
            }
            ProgressLogger pl = new ProgressLogger(log, 1000000);
            for (VariantContext vc : reader.iterator()) {
                if (writer != null) {
                    writer.add(vc);
                }
                pl.record(vc.getContig(), vc.getStart());
            }
        }
        long end = System.currentTimeMillis();
        log.info(String.format("Done. Elapsed time %.3f seconds", (double)(end - start) / 1000.0));
    }

    private static void printConfigurationInfo() throws IOException {
        log.info("Executing as " + System.getProperty("user.name") + '@' + InetAddress.getLocalHost().getHostName() + " on " + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch") + "; " + System.getProperty("java.vm.name") + ' ' + System.getProperty("java.runtime.version"));
        log.info(Defaults.allDefaults().entrySet().stream().map(e2 -> (String)e2.getKey() + ':' + e2.getValue()).collect(Collectors.joining(" ")));
    }
}

